<?php
/************************************************************************/
/* DUNE by NPDS                                                         */
/* ===========================                                          */
/*                                                                      */
/* NPDS Copyright (c) 2002-2009 by Philippe Brunier                     */
/* IZ-Xinstall version : 1.1.1                                          */
/*                                                                      */
/* Auteurs : v.0.1.0 EBH                                                */
/*         : v.1.1.1 jpb, phr                                           */
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/

// Bloque le lancement de l'install si IZ-Xinstall.ok existe
if (file_exists("IZ-Xinstall.ok")) {
   include("admin/die.php");
}

#####################################################################
# Paramtres du CMS
#####################################################################

$cms_logo = "install/images/header.png";
$cms_name = "NPDS REvolution 10.02";
$previous_version = "NPDS Sable Evolution 8.06";
global $cms_logo,$cms_name,$previous_version;

#####################################################################
# Contrle des fichiers de base de IZ-Xinstall
#####################################################################

if(file_exists('grab_globals.php'))
include ('grab_globals.php');

if(file_exists('install/libraries/graphIZm.php'))
include ('install/libraries/graphIZm.php');

if(file_exists('install/libraries/lib-inc.php'))
include ('install/libraries/lib-inc.php');

if(!isset($stage)) { $stage = 0; }

#################################################################################
# install/etape_0.php
# Accueil :
#   => install/languages/english/welcome.txt
#   => install/languages/francais/accueil.txt
# Choix de la classe :
#   0 : nouvelle installation
#   1 : mise  jour
#################################################################################

if(($stage == 0) OR (!isset($classe)))
{
   $colorst1 = "#000000";
   $colorst2 = "#000000";
   $colorst3 = "#000000";
   $colorst4 = "#000000";
   $colorst5 = "#000000";
   $colorst6 = "#000000";
   $colorst7 = "#000000";
   $colorst8 = "#000000";
   $colorst9 = "#000000";
   entete();
   require("install/etape_0.php");
   bienvenue();
   pied_depage();
}

#################################################################################
# install/etape_1.php
# Choix de la langue :
#   => install/languages/*
#################################################################################

if(($stage == 1) AND ($classe == 0))
{
   $colorst1 = "#FF9900";
   $colorst2 = "#000000";
   $colorst3 = "#000000";
   $colorst4 = "#000000";
   $colorst5 = "#000000";
   $colorst6 = "#000000";
   $colorst7 = "#000000";
   $colorst8 = "#000000";
   $colorst9 = "#000000";
   entete();
   menu();
   require("install/etape_1.php");
   if(!isset($op)) { $op = "etape_1"; }
   switch($op)
   {
      case "etape_1":
      default:
         etape_1();
         break;
   }
   pied_depage();
}

#################################################################################
# install/etape_2.php
# Licence GNU GPL en fonction de la langue :
#   => install/languages/english/licence-eng.txt
#   => install/languages/francais/licence-fra.txt
#################################################################################

if(($stage == 2) AND ($classe == 0))
{
   $colorst1 = "#005f3a";
   $colorst2 = "#FF9900";
   $colorst3 = "#000000";
   $colorst4 = "#000000";
   $colorst5 = "#000000";
   $colorst6 = "#000000";
   $colorst7 = "#000000";
   $colorst8 = "#000000";
   $colorst9 = "#000000";
   entete();
   menu();
   require("install/etape_2.php");
   if(!isset($op)) { $op = "etape_2"; }
   switch($op)
   {
      case "etape_2":
      default:
         etape_2();
         break;
   }
   pied_depage();
}

#################################################################################
# install/etape_3.php
# Vrifications :
#   => install/libraries/lib-inc.php
#      fonctions : verif_php() (version de PHP, magic_quotes)
#                  verif_chmod (prsence et droits des fichiers de configuration)
#################################################################################

if(($stage == 3) AND ($classe == "0"))
{
   $colorst1 = "#005f3a";
   $colorst2 = "#005f3a";
   $colorst3 = "#FF9900";
   $colorst4 = "#000000";
   $colorst5 = "#000000";
   $colorst6 = "#000000";
   $colorst7 = "#000000";
   $colorst8 = "#000000";
   $colorst9 = "#000000";
   entete();
   menu();
   require("install/etape_3.php");
   if(!isset($op)) { $op = "etape_3"; }
   switch($op)
   {
      case "etape_3":
      default:
         etape_3();
         break;
   }
   pied_depage();
}

#################################################################################
# install/etape_4.php
# Dfinition des paramtres de connexion  la base de donnes (config.php)
#   => install/libraries/lib-inc.php
#      fonction : write_config()
#################################################################################

if(($stage == 4) AND ($classe == 0))
{
   $colorst1 = "#005f3a";
   $colorst2 = "#005f3a";
   $colorst3 = "#005f3a";
   $colorst4 = "#FF9900";
   $colorst5 = "#000000";
   $colorst6 = "#000000";
   $colorst7 = "#000000";
   $colorst8 = "#000000";
   $colorst9 = "#000000";
   entete();
   menu();
   require("install/etape_4.php");
   if(!isset($op)) { $op = "etape_4"; }
   switch($op)
   {
      case "write_parameters":
         global $stage, $classe, $langue, $stage4_ok;
         write_parameters($new_dbhost, $new_dbuname, $new_dbpass, $new_dbname, $new_NPDS_Prefix, $new_mysql_p, $new_system, $new_system_md5, $new_adminmail);
         echo "<table border=\"0\" cellpadding=\"2\" cellspacing=\"1\" width=\"100%\">
         <tr class=\"tableau_titre\">
            <td align=\"center\" class=\"headform\">".ins_translate("Paramtres de connexion")."</td>
            </tr>
            <tr>
            <td align=\"center\"><br />";
         if($stage4_ok == 1)
         {
            $msg = "Le fichier de configuration a t crit avec succs !";
         }
         elseif($stage4_ok == 0)
         {
            $msg = "Le fichier de configuration n'a pas pu tre modifi. Vrifiez les droits d'accs au fichier 'config.php', puis ressayez  nouveau.";
         }
            echo "<form name=\"submit\" method=\"post\" action=\"install.php\">
               <table border=\"0\" cellpadding=\"2\" cellspacing=\"1\">
               <tr>
               <td>".ins_translate($msg)."</td>
               </tr>
               </table><br /><br />";
            if($stage4_ok == 1)
            {
               echo "<div style=\"text-align: center\">
               <input type=\"hidden\" name=\"classe\" value=\"".$classe."\" />
               <input type=\"hidden\" name=\"langue\" value=\"".$langue."\" />
               <input type=\"hidden\" name=\"stage\" value=\"5\" />
               <input type=\"submit\" class=\"bouton_standard\" value=\"".ins_translate(" Etape suivante ")."\" />
               </div><br />";
            }
            echo "</form>
            </td></tr></table></table></table><br />";
         unset($stage4_ok);
         break;
      case "etape_4":
      default:
         etape_4();
         break;
   }
   pied_depage();
}

#################################################################################
# install/etape_5.php
# Dfinition d'autres paramtres (config.php)
#   => install/libraries/lib-inc.php
#      fonction : write_others()
#################################################################################

if(($stage == 5) AND ($classe == 0))
{
   $colorst1 = "#005f3a";
   $colorst2 = "#005f3a";
   $colorst3 = "#005f3a";
   $colorst4 = "#005f3a";
   $colorst5 = "#FF9900";
   $colorst6 = "#000000";
   $colorst7 = "#000000";
   $colorst8 = "#000000";
   $colorst9 = "#000000";
   entete();
   menu();
   require("install/etape_5.php");
   if(!isset($op)) { $op = "etape_5"; }
   switch($op)
   {
      case "write_others":
         global $stage, $classe, $langue, $stage5_ok;
         write_others($new_nuke_url, $new_sitename, $new_Titlesitename, $new_slogan, $new_Default_Theme, $new_startdate);
         echo "<table border=\"0\" cellpadding=\"2\" cellspacing=\"1\" width=\"100%\">
         <tr class=\"tableau_titre\">
         <td align=\"center\" class=\"headform\">".ins_translate("Fichier de configuration")."</td>
         </tr>
         <tr>
         <td align=\"center\"><br />";
         if($stage5_ok == 1)
         {
            $msg = "Le fichier de configuration a t crit avec succs !";
         }
         elseif($stage5_ok == 0)
         {
            $msg = "Le fichier de configuration n'a pas pu tre modifi. Vrifiez les droits d'accs au fichier 'config.php', puis ressayez  nouveau.";
         }
            echo "<form name=\"next\" method=\"post\" action=\"install.php\">
               <table border=\"0\" cellpadding=\"2\" cellspacing=\"1\">
               <tr>
               <td>".ins_translate($msg)."</td>
               </tr>
               </table><br /><br />";
            if($stage5_ok == 1)
            {
               echo "<div style=\"text-align: center\">
                  <input type=\"hidden\" name=\"classe\" value=\"".$classe."\" />
                  <input type=\"hidden\" name=\"langue\" value=\"".$langue."\" />
                  <input type=\"hidden\" name=\"stage\" value=\"6\" />
                  <input type=\"submit\" class=\"bouton_standard\" value=\"".ins_translate(" Etape suivante ")."\" />
                  </div><br />";
            }
            echo "</form>"
            ."</td></tr></table></table></table><br />";
         unset($stage5_ok);
         break;
      case "etape_5":
      default:
         etape_5();
         break;
   }
   pied_depage();
}

#################################################################################
# install/etape_6.php
# Cration/Mise  jour de la base de donnes
#################################################################################

if(($stage == 6) OR ($classe == 1))
{
   $colorst1 = "#005f3a";
   $colorst2 = "#005f3a";
   $colorst3 = "#005f3a";
   $colorst4 = "#005f3a";
   $colorst5 = "#005f3a";
   $colorst6 = "#FF9900";
   $colorst7 = "#000000";
   $colorst8 = "#000000";
   $colorst9 = "#000000";
   entete();
   menu();
   require("install/etape_6.php");
   if(!isset($op)) { $op = "etape_6"; }
   switch($op)
   {
      case "write_database":
         global $stage, $classe, $langue, $stage6_ok,$NPDS_Prefix,$pre_tab;
         if($classe == 0)
         {
            include("config.php");
            require("install/sql/build_sql-create.php");
            build_sql_create($NPDS_Prefix);
            mysql_connex();
            require("install/sql/sql-create.php");
            write_database();
            echo "<table border=\"0\" cellpadding=\"2\" cellspacing=\"1\" width=\"100%\">
               <tr class=\"tableau_titre\">
               <td align=\"center\" class=\"headform\">".ins_translate("Base de donnes")."</td>
               </tr>
               <tr>
               <td align=\"center\"><br />";
            if($stage6_ok == 1)
            {
               $msg = "La base de donnes a t cre avec succs !";
            }
            elseif($stage6_ok == 0)
            {
               $msg = "La base de donnes n'a pas pu tre cre. Vrifiez les paramtres ainsi que vos fichiers, puis ressayez  nouveau.";
            }
               echo "<form name=\"next\" method=\"post\" action=\"install.php\">
               <table border=\"0\" cellpadding=\"2\" cellspacing=\"1\">
                  <tr>
                  <td>".ins_translate($msg)."</td>
                  </tr>
                  </table><br /><br />";
               if($stage6_ok == 1)
               {
                  echo "<div style=\"text-align: center\">
                     <input type=\"hidden\" name=\"classe\" value=\"".$classe."\" />
                     <input type=\"hidden\" name=\"langue\" value=\"".$langue."\" />
                     <input type=\"hidden\" name=\"stage\" value=\"7\" />
                     <input type=\"submit\" class=\"bouton_standard\" value=\"".ins_translate(" Etape suivante ")."\" />
                     </div><br />";
               }
               echo "</form>
               </td></tr></table></table></table><br />";
            unset($stage6_ok);
         }
         break;
      case "update_database":
         global $stage, $classe, $langue, $stage6_ok,$NPDS_Prefix;
         if($classe == 1)
         {
            include("config.php");
            if($Version_Num == "08.06")
            {
             $replog = ins_translate("Copier le contenu de votre dossier logs dans le dossier /slogs puis supprimer le dossier /logs");
             mysql_connex();
               require("install/sql/sql-update.php");
               update_database();
               echo "<table border=\"0\" cellpadding=\"2\" cellspacing=\"1\" width=\"100%\">
               <tr class=\"tableau_titre\">
                  <td align=\"center\" class=\"headform\">".ins_translate("Base de donnes")."</td>
                  </tr>
                  <tr>
                  <td align=\"center\"><br />";
               if($stage6_ok == 1)
               {
                  $msg = "La base de donnes a t mise  jour avec succs !";
               }
               elseif($stage6_ok == 0)
               {
                  $msg = "La base de donnes n'a pas pu tre modifie. Vrifiez les paramtres ainsi que vos fichiers, puis ressayez  nouveau.";
               }
                  echo "<form name=\"next\" method=\"post\" action=\"install.php\">
                     <table border=\"0\" cellpadding=\"2\" cellspacing=\"1\">
                     <tr>
                     <td>".ins_translate($msg)."<br /><br /></td>
                     </tr>";
                  if($stage6_ok == 1)
                  {
                     echo "<tr>
                        <td>".ins_translate("Remarque : pour achever la mise  jour : dans l'interface d'administration valider les prfrences et les metatags")."<br />".$replog."</td>
                        </tr>
                        </table><br /><br />
                        <div style=\"text-align: center\">
                        <input type=\"hidden\" name=\"classe\" value=\"0\" />
                        <input type=\"hidden\" name=\"langue\" value=\"".$langue."\" />
                        <input type=\"hidden\" name=\"stage\" value=\"9\" />
                        <input type=\"submit\" class=\"bouton_standard\" value=\"".ins_translate(" Etape suivante ")."\" />
                        </div><br />";
                  }
                  else
                  {
                     echo "</table><br /><br />";
                  }
                  echo "</form>"
                  ."</td></tr></table>";
               unset($stage6_ok);
            }
            else
            {
               echo "<table border=\"0\" cellpadding=\"2\" cellspacing=\"1\" width=\"100%\">
               <tr class=\"tableau_titre\">
               <td align=\"center\" class=\"headform\">".ins_translate("Base de donnes")."</td>
               </tr>
               <tr>
               <td align=\"center\"><br />
               <div style=\"font-weight: bold; color: #ff0000\">".ins_translate("Votre version de NPDS est incorrecte, version requise")." : ".$previous_version."</div><br />
               </td></tr></table></table></table><br />";
            }
         }
         break;
      case "etape_6":
      default:
         etape_6();
         break;
   }
   pied_depage();
}

#################################################################################
# install/etape_7.php
# Dfinition du mot de passe administrateur et premier utilisateur
#################################################################################

if(($stage == 7) AND ($classe == 0))
{
   $colorst1 = "#005f3a";
   $colorst2 = "#005f3a";
   $colorst3 = "#005f3a";
   $colorst4 = "#005f3a";
   $colorst5 = "#005f3a";
   $colorst6 = "#005f3a";
   $colorst7 = "#FF9900";
   $colorst8 = "#000000";
   $colorst9 = "#000000";
   entete();
   menu();
   require("install/etape_7.php");
   if(!isset($op)) { $op = "etape_7"; }
   switch($op)
   {
      case "write_users":
         global $stage, $classe, $langue, $stage7_ok,$NPDS_Prefix;
         if(($adminpass1 != "") AND ($adminpass2 != ""))
         {
            include("config.php");
            mysql_connex();
            write_users($adminlogin, $adminpass1, $adminpass2, $NPDS_prefix);
            if($stage7_ok == 2)
            {
               echo "<script type=\"text/javascript\" language=\"javascript\">document.location.href='install.php?op=etape_7&amp;stage=7&amp;classe=0&amp;langue=$langue';
                  </script>";
            }
            else
            {
               echo "<table border=\"0\" cellpadding=\"2\" cellspacing=\"1\" width=\"100%\">
                  <tr class=\"tableau_titre\">
                  <td align=\"center\" class=\"headform\">".ins_translate("Compte Admin")."</td>
                  </tr>
                  <tr>
                  <td align=\"center\"><br />";
               if($stage7_ok == 1)
               {
                  $msg = "Le compte Admin a t modifi avec succs !";
               }
               elseif($stage7_ok == 0)
               {
                  $msg = "Le compte Admin n'a pas pu tre modifi. Vrifiez les paramtres ainsi que vos fichiers, puis ressayez  nouveau.";
               }
                  echo "<form name=\"next\" method=\"post\" action=\"install.php\">
                     <table border=\"0\" cellpadding=\"2\" cellspacing=\"1\">
                     <tr>
                     <td>".ins_translate($msg)."<br /><br /></td>
                     </tr>
                     </table><br /><br />";
                  if($stage7_ok == 1)
                  {
                     echo "<div style=\"text-align: center\">
                        <input type=\"hidden\" name=\"classe\" value=\"".$classe."\" />
                        <input type=\"hidden\" name=\"langue\" value=\"".$langue."\" />
                        <input type=\"hidden\" name=\"stage\" value=\"8\" />
                        <input type=\"submit\" class=\"bouton_standard\" value=\"".ins_translate(" Etape suivante ")."\" />
                        </div><br />";
                  }
                  echo "</form>
               </td></tr></table></table></table><br />";
               unset($stage7_ok);
            }
         }
         else
         {
            echo "<script type=\"text/javascript\" language=\"javascript\">
               document.location.href='install.php?op=etape_7&amp;stage=7&amp;classe=0&amp;langue=$langue';
               </script>";
         }
         break;
      case "etape_7":
      default:
         include("config.php");
         etape_7();
         break;
   }
   pied_depage();
}

#################################################################################
# install/etape_8.php
# Configuration du module Upload
#################################################################################

if(($stage == 8) AND ($classe == 0))
{
   $colorst1 = "#005f3a";
   $colorst2 = "#005f3a";
   $colorst3 = "#005f3a";
   $colorst4 = "#005f3a";
   $colorst5 = "#005f3a";
   $colorst6 = "#005f3a";
   $colorst7 = "#005f3a";
   $colorst8 = "#FF9900";
   $colorst9 = "#000000";
   entete();
   menu();
   require("install/etape_8.php");
   if(!isset($op)) { $op = "etape_8"; }
   switch($op)
   {
      case "write_upload":
         global $stage, $classe, $langue, $stage8_ok;
         include("config.php");
         mysql_connex();
         write_upload($new_max_size,$new_DOCUMENTROOT,$new_autorise_upload_p,$new_racine,$new_rep_upload,$new_rep_cache,$new_rep_log,$new_url_upload,$new_url_upload_css);
         echo "<table border=\"0\" cellpadding=\"2\" cellspacing=\"1\" width=\"100%\">
         <tr class=\"tableau_titre\">
            <td align=\"center\" class=\"headform\">".ins_translate("Configuration du module UPload")."</td>
            </tr>
            <tr>
            <td align=\"center\"><br />";
         if($stage8_ok == 1)
         {
            $msg = "Le fichier de configuration a t crit avec succs !";
         }
         elseif($stage8_ok == 0)
         {
            $msg = "Le fichier de configuration n'a pas pu tre modifi. Vrifiez les droits d'accs au fichier 'config.php', puis ressayez  nouveau.";
         }
            echo "<form name=\"next\" method=\"post\" action=\"install.php\">
               <table border=\"0\" cellpadding=\"2\" cellspacing=\"1\">
               <tr>
               <td>".ins_translate($msg)."</td>
               </tr>
               </td></tr></table></table></table><br />";
            if($stage8_ok == 1)
            {
               echo "<div style=\"text-align: center\">
                  <input type=\"hidden\" name=\"classe\" value=\"".$classe."\" />
                  <input type=\"hidden\" name=\"langue\" value=\"".$langue."\" />
                  <input type=\"hidden\" name=\"stage\" value=\"9\" />
                  <input type=\"submit\" class=\"bouton_standard\" value=\"".ins_translate(" Etape suivante ")."\" />
                  </div><br />";
            }
            echo "</form>
            </td></tr></table></table></table><br />";
         unset($stage8_ok);
         break;
      case "etape_8":
      default:
         etape_8();
         break;
   }
   pied_depage();
}

#################################################################################
# install/etape_9.php
# Fin
#################################################################################

if(($stage == 9) AND ($classe == 0))
{
   $colorst1 = "#005f3a";
   $colorst2 = "#005f3a";
   $colorst3 = "#005f3a";
   $colorst4 = "#005f3a";
   $colorst5 = "#005f3a";
   $colorst6 = "#005f3a";
   $colorst7 = "#005f3a";
   $colorst8 = "#005f3a";
   $colorst9 = "#FF9900";
   entete();
   menu();
   require("install/etape_9.php");
   if(!isset($op)) { $op = "etape_9"; }
   switch($op)
   {
      case "write_ok":
         $fp = fopen("IZ-Xinstall.ok", "w");
         fclose($fp);

         // La suppression de l'installation
         function icare_delete_Dir($rep) {
         $dir = opendir($rep);
         chdir($rep);
         while($nom = readdir($dir)) {
            if ($nom != "." && $nom != ".." && $nom != "") {
               if (is_dir($nom)) {
                  $archive[$nom] = icare_delete_Dir($nom);
                  rmdir($nom);
               } elseif(is_file($nom)) {
                  @unlink($nom);
              }
            }
         }
         chdir("..");
         closedir($dir);
         return $archive;
         }

         if (file_exists("IZ-Xinstall.ok")) {
            if (file_exists("install.php") OR is_dir("install")) {
               icare_delete_Dir('install');
               @rmdir ( 'install' );
               @unlink('install.php');
            }
         }
         echo "<script type=\"text/javascript\" language=\"javascript\">document.location.href='index.php';</script>";
         break;
      case "etape_9":
      default;
         etape_9();
         break;
   }
   pied_depage();
}
?>