<?PHP
/************************************************************************/
/* Upload / meta fonction and automation for NPDS                       */
/* This version name NPDS Copyright (c) 2001-2003 by Philippe Brunier   */
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/*                                                                      */
/* Copyright Snipe 2003                                                 */
/************************************************************************/

function verifsize ($size) {
   $width_max = 50;
   $height_max = 50;

   $width = $size[0];
   $height = $size[1];

   if($width > $width_max){
      $imageProp = ($width_max * 100) / $width;
      $height = ceil(($height * $imageProp) / 100);
      $width = $width_max;
   }
   if($height > $height_max){
      $imageProp = ($height_max * 100) / $height;
      $width = ceil(($width * $imageProp) / 100);
      $height = $height_max;
   }
   return ("width=\"$width\" height=\"$height\"");
}

function load_mimetypes () {
   global $mimetypes, $mimetype_default, $mime_dspinl, $mime_dspfmt, $mime_renderers, $att_icons, $att_icon_default, $att_icon_multiple;
   if (defined ('ATT_DSP_LINK')) {
      return;
   }

   if (file_exists("modules/upload/include/mimetypes.php") ) {
      include ("modules/upload/include/mimetypes.php");
   }
}

function getUserAttachmentsfile() {
   global $user, $rep_upload_minisite, $DOCUMENTROOT;
   if (file_exists("modules/upload/include/mimetypes.php") ) {
      include ("modules/upload/include/mimetypes.php");
   }
   if ($user) {
      # Find the path to upload directory
      # -------------------------------------------
      if (($rep_upload_minisite!="") and ($DOCUMENTROOT!="")) {
         $repertoire=$DOCUMENTROOT.$rep_upload_minisite;
         $handle=opendir($repertoire);
         $j=0;
         while ($file = readdir($handle)) {
            if (is_file($repertoire.$file) && $file != '.' && $file != '..'  && $file != '.htaccess') {
               $type = "";
               $suffix = strtoLower(substr(strrchr( $file, '.' ), 1 ));
               if (isset($mimetypes[$suffix]) ) {
                  $type = $mimetypes[$suffix];
               } elseif (($type=="") or ($type=='application/octet-stream') ) {
                  $type = $mimetype_default;
               }
               $filelist2[$j]['att_type'] = $type;
               $filelist2[$j]['att_size'] = filesize ($repertoire.$file);
               $filelist2[$j]['att_name'] = $file;
               $img_size=@getImageSize ($repertoire.$file);
               $filelist2[$j++]['att_img_size'] = verifsize($img_size);
            }
         }
         return $filelist2;
      } else {
         Access_Error();
      }
   } else {
      Access_Error();
   }
}
function getUserAttachmentsSize() {
   global $user, $rep_upload_minisite, $DOCUMENTROOT;
   if ($user) {
      # Find the path to upload directory
      # -------------------------------------------
      $repertoire=$DOCUMENTROOT.$rep_upload_minisite;
      if (is_dir($repertoire)) {
         $handle=opendir($repertoire);
      } else {
         Access_Error();
      }
      $filesize=0;
      while ($file = readdir($handle)) {
         if (is_file($repertoire.$file) && $file != '.' && $file != '..' && $file != '.htaccess' ){
            $filesize=$filesize+filesize ($repertoire.$file);
         }
      }
      return $filesize;
   } else {
      Access_Error();
   }
}

/************************************************************************/
/* Fonction permettant de cree une checkbox                             */
/************************************************************************/
function getCheckBox ($name, $value=1, $current, $text="") {
   $p =  sprintf ("<input type=\"checkbox\" name=\"%s\" value=\"%s\"%s />%s\n",
         $name,
         $value, ("$current"=="$value")? " checked" : "",
         (empty ($text)) ? "" : " $text" );
   return $p;
}
/************************************************************************/
/* Fonction permettant une liste de choix                               */
/************************************************************************/
function getListBox ($name, $items, $selected="", $multiple=0, $onChange="") {
   $oc = empty ($onChange) ? "" : " onchange=\"$onChange\"";
   $p = sprintf ("<select name=\"%s%s\"%s%s>\n", $name, ($multiple == 1)?"[]":"",
                ($multiple == 1)?" MULTIPLE":"", $oc);
   if (is_array($items)) {
      reset ($items);
      while (list($k, $v) = each($items)) {
         $p .= sprintf(" <option value=\"%s\"%s>%s\n", $k, strcmp($selected,$k)?"":" selected", $v);
      }
   }
   return $p . "</select>\n";
}

/*****************************************************/
/* Effacer les fichier joint demand                 */
/*****************************************************/
function deleteUserAttachmentsfile($del_att) {
   global $user, $DOCUMENTROOT, $rep_upload_minisite;

   if ($user) {
      if (($rep_upload_minisite!="") and ($DOCUMENTROOT!="")) {
         if (is_array($del_att) ) {
            for ($i=0;$i < count($del_att);$i++) {
               $file = $del_att[$i];
               @unlink($DOCUMENTROOT.$rep_upload_minisite.$del_att[$i]);
            }
         }
      } else {
         Access_Error();
      }
   } else {
      Access_Error();
   }
}
?>