<?PHP
/************************************************************************/
/* Upload / meta fonction and automation for NPDS V                     */
/* This version name NPDS Copyright (c) 2001-2003 by Philippe Brunier   */
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/
include ("../../grab_globals.php");

function getip() {
   if (isSet($_SERVER)) {
      if (isSet($_SERVER["HTTP_X_FORWARDED_FOR"])) {
         $realip = $_SERVER["HTTP_X_FORWARDED_FOR"];
      } elseif (isSet($_SERVER["HTTP_CLIENT_IP"])) {
         $realip = $_SERVER["HTTP_CLIENT_IP"];
      } else {
         $realip = $_SERVER["REMOTE_ADDR"];
      }
   } else {
      if ( getenv( 'HTTP_X_FORWARDED_FOR' ) ) {
         $realip = getenv( 'HTTP_X_FORWARDED_FOR' );
      } elseif ( getenv( 'HTTP_CLIENT_IP' ) ) {
         $realip = getenv( 'HTTP_CLIENT_IP' );
      } else {
         $realip = getenv( 'REMOTE_ADDR' );
      }
   }
   return ($realip);
}

   include_once("upload.conf.php");
   include_once("lang/upload.lang-$language.php");

   header("Pragma: no-cache");
   header("Expires: 0");
   echo "<html><body><head><title>NPDS - Tlchargements / Uploads</title></head>";
   echo "<table WIDTH=100% CELLSPACING=2 CELLPADDING=2 BORDER=0>";
   echo "<TR><TD>";
   // CSS externalisation
   if ($url_upload_css) {
      print ("<LINK REL=\"StyleSheet\" HREF=\"".$url_upload.$url_upload_css."\" TYPE=\"text/css\">\n");
      print ("<style type=\"text/css\">");
      print ("@import url(\"".$url_upload.$url_upload_css."\"); ");
      print ("</style>");
   }

   if ($DOCUMENTROOT!="") {
      $rep=$DOCUMENTROOT;
   } else {
      if ($DOCUMENT_ROOT) {
         $rep=$DOCUMENT_ROOT;
      } else {
         $rep=$_SERVER['DOCUMENT_ROOT'];
      }
   }

   if (empty($numero)) {$numero=0;}
   $erreur=false;
   if ($op=="upload") {
      include_once("clsUpload.php");
      $upload = new Upload();
      $upload->maxupload_size = $max_size;
      $field1_filename = trim($upload->getFileName("file1"));
      if (urldecode($ficname)==$field1_filename) {

         if ($user) {
            $userX = base64_decode($user);
            $cookie = explode(":", $userX);
            if (trim($cookie[1])!="") {
               $uname=$cookie[1];
               if ($autorise_upload_p) {
                  $rep_upload_dest=$rep.$racine."/users_private/".$uname."/";
                  if (!is_dir($rep_upload_dest)) {
                     $rep_upload_dest=$rep.$rep_upload;
                  }
               } else {
                  $rep_upload_dest=$rep.$rep_upload;
               }
            }
         } else {
            $rep_upload_dest=$rep.$rep_upload;
         }

         if ($upload->saveAs($field1_filename ,$rep_upload_dest, "file1",true)) {
            $numero++;
         } else {
            echo "<FONT CLASS=\"ROUGE\">".$upload->errors."</FONT><BR>";
            $erreur=true;
         }
      } else {
         echo "<FONT CLASS=\"ROUGE\">".upload_translate("Ce type de fichier n'est pas autoris")." : $field1_filename</FONT><BR>";
      }
   }

   $ibid=@array_unique(@file($rep.$rep_cache.$name_tmp.".tmp"));
   if ($ibid) {
      for ($i = 0; $i <= count($ibid)-1; $i++) {
         $fcontents[$i]=current($ibid);
         next($ibid);
      }
   }
   // Remove for security reasons
   $fcontents[$numero]=eregi_replace("/etc","",$fcontents[$numero]);
   $fcontents[$numero]=eregi_replace("\.\.","",$fcontents[$numero]);
   $fcontents[$numero]=eregi_replace("config.php","",$fcontents[$numero]);
   $fcontents[$numero]=eregi_replace("\">","",$fcontents[$numero]);
   // Gestion des type de fichier autoris
   if ($fcontents[$numero]!="") {
      $suffix = trim(strtoLower(substr(strrchr($fcontents[$numero],'.'),1)));
      if ($extension_autorise=="") {$extension_autorise="doc xls txt zip rar pdf gif jpg png";}
      if (!stristr($extension_autorise,$suffix)) {
         echo "<BR><CENTER><font CLASS=\"ROUGE\">".upload_translate("Ce type de fichier n'est pas autoris")."</font></CENTER>";
         $fcontents[$numero]="";
         $erreur=true;
      }
   }
   if ($fcontents[$numero]!="") {
      $ficname=trim(substr($fcontents[$numero],strrpos($fcontents[$numero],"/")+1));
      $fic =urldecode(str_replace("/","\\",$fcontents[$numero]));
      echo upload_translate("Slectionner le nom affich (chemin complet), copier le dans le champ [Fichier] et cliquez sur OK.")."<hr noshade>";
      echo "<b>".upload_translate("Pices jointes :")."</b> => $fic <br>
            <FORM name=fileU method=\"post\" enctype=\"multipart/form-data\">";
      echo upload_translate("Fichier :")." <input CLASS=\"TEXTBOX_STANDARD\" type=\"File\" name=\"file1\" size=\"50\" maxlength=\"255\">
            <input CLASS=\"TEXTBOX_STANDARD\" type=\"submit\" value=\"OK\">
            <input type=hidden name=\"MAX_FILE_SIZE\" value=\"$max_size\">
            <input type=hidden name=op value=upload>
            <input type=hidden name=numero value=\"$numero\">
            <input type=hidden name=ficname value=\"$ficname\">
            <input type=hidden name=name_tmp value=\"$name_tmp\">
            </FORM>";
   } else {
      if ($fp = @fopen($rep.$rep_cache.$name_tmp.".tmp", 'a')){
         fwrite($fp,"upload_OK");
         fclose($fp);
      }
      $logfile = $rep.$rep_log;
      $fp = fopen($logfile, 'a');
      flock($fp, 2);
      fseek($fp, filesize($logfile));
      $ibid = sprintf("%-10s %-60s %-10s\r\n",date("m/d/Y H:i:s",time()),getip()." => Upload File(s)",$name_tmp);
      fwrite($fp, $ibid);
      flock($fp, 3);
      fclose($fp);

      if (!$erreur) {
         echo "<SCRIPT type=\"text/javascript\" language=\"JavaScript\">
               <!--
               self.close();
               //-->
               </script>\n";
      }
   }
   echo "</TD><TR></TABLE>";
   echo "</body></html>";
?>
