<?PHP
/************************************************************************/
/* NPDS V  / Net Portal Dynamic System .                                */
/*                                                                      */
/* ARBO_DS / copyright P.Brunier 2004                                   */
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/
if (!eregi("arbo_ds.php", $PHP_SELF)) { die(); }

function arbo_autorise($dname, $file, $H_smb) {
   $auto_dir=false;
   if ($file=="") {
      $rep_fic=$dname."/".$H_smb."repertoire.conf.php";
   } else {
      $rep_fic=$dname."/".$file."/".$H_smb."repertoire.conf.php";
   }
   if (file_exists($rep_fic)) {
      include ($rep_fic);
      global $user, $admin;
      if (($autorise_arbo=="membre") and ($user)) {
         $auto_dir=true;
      } elseif (($autorise_arbo=="anonyme") and (!$user)) {
         $auto_dir=true;
      } elseif (($autorise_arbo=="admin") and ($admin)) {
         $auto_dir=true;
      } elseif (($autorise_arbo!="") and ($user)) {
         $tab_groupe=valid_group($user);
         for ($i=0; $i<=9; $i++) {
            $tab_auto=explode(",",$autorise_arbo);
            while (list(,$gp)=each($tab_auto)) {
               if ($tab_groupe[$i]==$gp) {
                  $auto_dir=true;
                  break;
               }
            }
         }
      } elseif ($autorise_arbo=="") {
         $auto_dir=true;
      }
   } else {
      $auto_dir=true;
   }
   return($auto_dir);
}

function scandossier($dname, $H_smb) {
   if (eregi("(^[A-Za-z0-9_\.-])",$dname) and !stristr($dname,".*://") and !stristr($dname,"..") and !stristr($dname,"../")) {
      if (is_dir($dname)) {
         $dh=opendir($dname);
      } else {
         Access_Error();
      }
      while (gettype($file=readdir($dh))!=boolean) {
         if (is_dir("$dname/$file") && ($file<>'.') && ($file<>'..')) {
            if (arbo_autorise($dname, $file, $H_smb)) {$tab_dir[$file]="";}
         } else {
            if ((substr($file, strlen($file)-1,1) <>'.') && (substr($file, strlen($file)-2,2) <>'..')) {
               $tab_dir[$dname][]=$file."!#!".filemtime("$dname/$file")."!#!".filesize("$dname/$file");
            }
         }
      }
      closedir($dh);
   }
   return($tab_dir);
}

function extend_ascii($ibid) {
   $tmp=urlencode($ibid);
   $tmp=str_replace("%82","",$tmp);
   $tmp=str_replace("%85","",$tmp);
   $tmp=str_replace("%87","",$tmp);
   $tmp=str_replace("%88","",$tmp);
   $tmp=str_replace("%97","",$tmp);
   $tmp=str_replace("%8A","",$tmp);
   $tmp=urldecode($tmp);
   return ($tmp);
}
function browse($ModPath, $root_arbo, $H_smb) {
   $root_arbo=$ModPath.(substr($root_arbo,strlen($ModPath)));
   if (!arbo_autorise($root_arbo, "", $H_smb)) {header("location: index.php");}
   $tab_dir=scandossier($root_arbo, $H_smb);
   if (is_array($tab_dir)) {
      global $language, $SuperCache;
      include ("modules/upload/lang/upload.lang-$language.php");
      include ("modules/upload/include/mimetypes.php");
      include ("lib/file.class.php");
      $Fichier = new File("");
      ksort($tab_dir);
      include ("header.php");
      // Include cache manager
      if ($SuperCache) {
         global $CACHE_TIMINGS, $CACHE_QUERYS;
         $CACHE_TIMINGS['arbo_ds.php'] = 3600;
         $CACHE_QUERYS['arbo_ds.php'] = "^";
         $cache_obj = new cacheManager();
         $cache_obj->startCachingPage();
      }
      if (($cache_obj->genereting_output==1) or ($cache_obj->genereting_output==-1) or (!$SuperCache)) {
         opentable();
         if ($ibid=theme_image("download/folder_open.gif")) {$imgof=$ibid;} else {$imgof="images/download/folder_open.gif";}
         if ($ibid=theme_image("download/folder.gif")) {$imgf=$ibid;} else {$imgf="images/download/folder.gif";}
         if ($ibid=theme_image("download/left.gif")) {$imgl=$ibid;} else {$imgl="images/download/left.gif";}

         if (file_exists($root_arbo."/".$H_smb."repertoire.pub.php") ) {
            include ($root_arbo."/".$H_smb."repertoire.pub.php");
         }

         echo "<table width=\"100%\" cellspacing=\"2\" cellpadding=\"2\" border=\"0\">\n";
         $rowcolor=tablos();
         echo "<tr $rowcolor><td colspan=\"3\"><img src=\"".$imgof."\" border=\"0\" alt=\"\">&nbsp;";
         if ($root_arbo!=$ModPath) {
            $root_arboP=substr($root_arbo,0,strrpos($root_arbo,"/"));
            $chemin=explode("/",$root_arboP);
            while (list(,$rep)=each($chemin)) {
               $arbo_rec.=$rep;
               echo "<a href=\"arbo_ds.php?ModPath=$ModPath&amp;root_arbo=".rawurlencode($arbo_rec)."\" class=\"NOIR\">".extend_ascii($rep)."</a>&nbsp;/&nbsp;";
               $arbo_rec.="/";
            }
            echo extend_ascii(basename($root_arbo));
         } else {
            echo $root_arbo;
         }
         echo "</td></tr>";
         while(list ($dir, $Afic) = each ($tab_dir)) {
            if ($dir!=$root_arbo) {
               echo "<tr><td colspan=\"3\" nowrap>&nbsp;&nbsp;&nbsp;<a href=\"arbo_ds.php?ModPath=$ModPath&amp;root_arbo=".rawurlencode($root_arbo)."/".rawurlencode($dir)."\" class=\"NOIR\"><img src=\"".$imgf."\" border=\"0\" alt=\"\">&nbsp;".extend_ascii($dir)."</a></td</tr>";
            }
            if ($Afic) {$fic=$Afic;}
         }
         if (file_exists($root_arbo."/".$H_smb."repertoire.conf.php")) {
            include ($root_arbo."/".$H_smb."repertoire.conf.php");
         }
         if (!$extension_arbo) {
            $extension_arbo="doc xls pps ppt sxw xls sxi sxd sxg stw pdf zip rar gif jpg png swf";
         }
         $allowed_extension_arbo = split(' ', $extension_arbo);
         if (is_array($fic)) {
            sort($fic);
            while(list ($id,$file) = each ($fic)) {
               $file=explode("!#!",$file);
               $suffix = strtoLower(substr(strrchr($file[0], '.'), 1));
               if (in_array($suffix,$allowed_extension_arbo)) {
                  $fic_taille=$Fichier->Pretty_Size($file[2]);
                  if ($fic_taille=="") {$fic_taille="0 o";}
                  echo "<tr><td nowrap width=\"50%\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
                  if (isset($att_icons[$suffix])) {echo $att_icons[$suffix];} else {echo $att_icon_default;}
                  echo "&nbsp;<a href=\"getfile.php?att_id=$ModPath&amp;apli=getfile&amp;att_name=".rawurlencode(substr($root_arbo,strlen($ModPath)+1)."/".$file[0])."\" class=\"NOIR\" target=\"_blank\">".extend_ascii($file[0])."</a></td>";
                  echo "<td align=\"right\" width=\"20%\">".$fic_taille."&nbsp;</td>";
                  echo "<td align=\"right\" width=\"30%\">".date("d-m-Y / H:i:s",$file[1])."&nbsp;</td>";
                  echo "</tr>";
               }
           }
        }
        echo "</table>";
        closetable();
      }
      if ($SuperCache) {
         $cache_obj->endCachingPage();
      }
      include ("footer.php");
   } else {
      header ("location: arbo_ds.php?ModPath=$ModPath&root_arbo=$root_arboP");
   }
}
?>