<?PHP
/************************************************************************/
/* AUTO-DOC for NPDS V  / Net Portal Dynamic System .                   */
/*                                                                      */
/* This version name NPDS Copyright (c) 2002-2005 by Philippe Brunier   */
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/*********************************************************************************************************************************/
/* AutoDoc permet de de lire le contenu d'un fichier php et d'extraire la documentation intgre (sous forme de commentaire php) */
/* Le format d'une ligne AutoDoc de documentation doit-tre :                                                                    */
/*    #autodoc La_documentation_de_la_fonction                                                                                   */
/*    par exemple : #autodoc !date! : Date du jour en Javascript (le : entre le nom du meta-mot ou de la fonction et             */
/*                  son explication est OBLIGATOIRE)                                                                             */
/*    mais aussi #autodoc: pour faire un saut de ligne HTML dans votre documentation (<BR>)                                      */
/*                                                                                                                               */
/* Autodoc assure aussi la selection d'un ensemble cohrent dans un fichier via #autodoc:<paragraphe> ... #autodoc:</paragraphe> */
/* Le mainfile.php est un bon exemple (extraction des fonctions de type BLOCS)                                                   */
/*                                                                                                                               */
/* Meta_Lang utilise ce formalisme et vous pouvez donc extraire la documentation de meta_lang.php via :                          */
/* autodoc.php?fichier=modules/meta-lang/meta_lang.php ou via un include ("autodoc.php") en spcifiant la variable $fichier      */
/*********************************************************************************************************************************/
if (!defined('NPDS_GRAB_GLOBALS_INCLUDED')) {include ("grab_globals.php");}

function Access_Error () {
  if (file_exists("meta/meta.php"))
     include ("meta/meta.php");
  echo "<title>NPDS</title></head><body bgcolor=\"white\"><br /><p align=\"center\"><span style=\"font-size: 14px; font-family: Arial; font-weight: bold; color: red;\">";
  echo "Access Denied / Acc&egrave;s Refus&eacute;";
  if (cur_charset=="utf-8") echo" / &#x901A;&#x5165;&#x88AB;&#x5426;&#x8BA4;";
  echo "</span>";
  echo "<br /><br /><span style=\"font-size: 12px; font-family: Arial; font-weight: bold; color: black;\">NPDS - Portal System";
  echo "</span></p></body></html>";
  die();
}

function autodoc($fichier, $paragraphe) {
   $fcontents = @file($fichier);
   if ($fcontents=="") {Access_Error();}
   echo "<table cellspacing=\"2\" cellpadding=\"2\" border=\"0\" width=\"100%\">";
   while ( list($line_num, $line)=each($fcontents) ) {
      if ($paragraphe!="") {
         if (strstr($line,"#autodoc:<$paragraphe>")) {
            $line="";
            $pasfin=true;
         }
         if (strstr($line,"#autodoc:</$paragraphe>")) {
            $line="";
            $pasfin=false;
         }
      } else {
         $pasfin=true;
      }
      if (!strstr($line,"#autodoc !votre_meta-mot!")) {
         $line=trim($line);
         if ((strstr($line,"#autodoc")) and ($pasfin)) {
            $posX=strpos($line,":");
            $morceau1=trim(substr($line,strpos($line,"#autodoc")+8,$posX-8));
            $morceau2=rtrim(substr($line,$posX+1));
            if ($morceau1=="" AND $morceau2=="") {$rowcolor="#FFFFFF";} else {$rowcolor="#F0F0F0";}
            if (cur_charset=="utf-8") { $morceau2=utf8_encode($morceau2); }
            echo "<tr bgcolor=\"$rowcolor\"><td nowrap=\"nowrap\" align=\"left\"><span style=\"font-size: 10px; font-family: Tahoma, Arial;\"><b>$morceau1</b></span>&nbsp;</td><td><span style=\"font-size: 10px; font-family: Tahoma, Arial;\">$morceau2</span>&nbsp;</td></tr>";
         } else if ((strstr($line,"# autodoc")) and ($pasfin)) {
            $posX=strpos($line,":");
            $morceau1=ltrim(substr($line,strpos($line,"# autodoc")+9,$posX-9));
            $morceau2=rtrim(substr($line,$posX+1));
            if ($morceau1=="" AND $morceau2=="") {$rowcolor="#FFFFFF";} else {$rowcolor="#F0F0F0";}
            if (cur_charset=="utf-8") { $morceau2=utf8_encode($morceau2); }
            echo "<tr bgcolor=\"$rowcolor\"><td nowrap=\"nowrap\" align=\"left\"><span style=\"font-size: 10px; font-family: Tahoma, Arial;\"><b>$morceau1</b></span>&nbsp;</td><td><span style=\"font-size: 10px; font-family: Tahoma, Arial;\">$morceau2</span>&nbsp;</td></tr>";
         }
      }
   }
   echo "</table><p align=\"right\" style=\"font-size: 10px; font-family: Tahoma, Arial;\">AutoDoc pour <a href=\"http://www.npds.org\">NPDS</a></p>";
}

if ($fichier!="") {
   if ( (strstr($fichier,"..") or strstr($fichier,"config.php")) and ($fichier!="../modules/meta-lang/meta_lang.php") and ($fichier!="../mainfile.php") and ($fichier!="../powerpack_f.php")) {
      Access_Error();
   } else {
      autodoc($fichier,$paragraphe);
   }
}
?>
