<?PHP
/************************************************************************/
/* NPDS V : Net Portal Dynamic System .                                 */
/* ===========================                                          */
/*                                                                      */
/* Original Copyright (c) 2001 by Francisco Burzi (fburzi@ncc.org.ve)   */
/* http://phpnuke.org                                                   */
/*                                                                      */
/* This version name NPDS Copyright (c) 2001-2005 by Philippe Brunier   */
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/
if (!function_exists("Mysql_Connexion")) {include ("mainfile.php");}

include("language/lang-adm-$language.php");
global $pdst;$pdst="0";

$filemanager=false;
if ($system==0) {
   if (file_exists(".filemanager.conf")) {
      include_once(".filemanager.conf");
   }
} else {
   if (file_exists("filemanager.conf")) {
      include_once("filemanager.conf");
   }
}

function html_header(){
    global $wdir, $lastaction;
    OpenTable();
    echo "<p align=\"center\"><b>".adm_translate("Gestionnaire de Fichiers")."</b><br /><br />".adm_translate("Le rpertoire courant est : ")." <b>$wdir</b><br />";
    echo "[ <a href=\"admin.php?op=root\" class=\"NOIR\">".adm_translate("Retour  la racine")."</a> | <a href=\"admin.php?op=FileManager&amp;wdir=$wdir\" class=\"NOIR\">".adm_translate("Rafrachir")."</a> ]<br /><br />$lastaction</p><br />";
}

function login() {
    global $pdst;
    $pdst="1";
    include ("header.php");
    echo "<table width=\"100%\" cellspacing=\"2\" cellpadding=\"2\" border=\"0\"><tr><td class=\"HEADER\">\n";
    echo adm_translate("Menu Administration");
    echo "</td></tr></table>\n";
    OpenTable();
    echo "<br /><form action=\"admin.php\" method=\"post\" name=\"adminlogin\"><table width=\"100%\" cellspacing=\"1\" cellpadding=\"2\" border=\"0\">";
    echo "<tr><td nowrap=\"nowrap\">".adm_translate("Administrateur ID")." : </td><td><input class=\"TEXTBOX_STANDARD\" type=\"text\" name=\"aid\" size=\"20\" maxlength=\"20\"></td><td width=\"40%\" align=\"left\">&nbsp;</td></tr>";
    echo "<tr><td nowrap=\"nowrap\">".adm_translate("Mot de Passe")." : </td><td><input class=\"TEXTBOX_STANDARD\" type=\"password\" name=\"pwd\" size=\"20\" maxlength=\"18\"></td>";
    echo "<td width=\"30%\" align=\"left\"><input type=\"hidden\" name=\"op\" value=\"login\"><input class=\"BOUTON_STANDARD\" type=\"submit\" value=\"".adm_translate("Valider")."\"></td></tr>";
    echo "</table></form>\n";
    echo "<script type=\"text/javascript\" language=\"JavaScript\">document.adminlogin.aid.focus();</script>";
    closeTable();
    include ("footer.php");
}

function adminmenu($url, $title="", $image="") {
    global $counter, $nb_option, $max_option, $admingraphic, $adminimg;

    if (($admingraphic==1) and ($url!="null")) {
       $img="<img src=\"$adminimg$image\" border=\"0\" alt=\"\" /></a><br />";
    } else {
       $img="";
    }
    if ($title==adm_translate("Articles")) {
       $newsubs=mysql_num_rows(mysql_query("select qid from queue"));
       if ($admingraphic==1) {
          $close = " ($newsubs)";
       } else {
          $close = "</a> ($newsubs)";
       }
    } else if ($title==adm_translate("Auto-Articles")) {
       $newsubs=mysql_num_rows(mysql_query("select anid from autonews"));
       if ($admingraphic==1) {
          $close = " ($newsubs)";
       } else {
          $close = "</a> ($newsubs)";
       }

    } else {
       if ($admingraphic == 1) {
          $close = "";
       } else {
          $close = "</a>";
       }
    }
    $count=true;
    switch($url) {
        case "space" :
           if ($nb_option>$max_option) {
               $max_option=$nb_option;
               $nb_option=0;
           }
           if ($counter>0) { while($counter < 4) $counter++; } else $count=false;
           break;
        case "no_url" :
           echo "<td align=\"center\" width=\"20%\">$img<i>$title</i>$close</td>";
           if ($nb_option<5) $nb_option++;
           break;
        case "center" :
           $tmp=($max_option-($max_option%2))/2;
           for($i = 1; $i <= $tmp; $i++) echo "<td>&nbsp;</td>";
           break;

        case "null" :
           if ($nb_option<5) $nb_option++;
           echo "<td align=\"center\" width=\"20%\">&nbsp;</td>";
           break;

        default :
           if ($nb_option<5) $nb_option++;
           echo "<td align=\"center\" width=\"20%\"><a href=\"admin.php?op=$url\" class=\"NOIR\">$img<b>$title</b>$close</td>";
    }
    if ($counter == 4) {
        echo "</tr><tr><td height=\"5\" colspan=\"5\"><hr width=\"100%\" class=\"ONGL\" noshade></td></tr><tr>";
        $counter = 0;
    } elseif ($count) {
        $counter++;
    }
}

function GraphicAdmin($hlpfile) {
    global $aid, $admingraphic, $adminimg, $language, $admin, $banners, $filemanager, $multi_langue;
    global $short_menu_admin, $admf_ext;
    $Q = mysql_query("SELECT * FROM authors WHERE aid='$aid' LIMIT 1");
    $Q = mysql_fetch_assoc($Q);

    echo "<script type=\"text/javascript\" language=\"JavaScript\">\n";
    echo "<!--\n";
    echo "function openwindow(){\n";
    echo " window.open (\"$hlpfile\",\"Help\",\"toolbar=no,location=no,directories=no,status=no,scrollbars=yes,resizable=no,copyhistory=no,width=600,height=400\");\n";
    echo "}\n";
    echo "//-->\n";
    echo "</script>\n";

    OpenTable();
     echo "<table cellSpacing=\"0\" cellPadding=\"0\" width=\"100%\" align=\"center\" border=\"0\"><tr><td class=\"TITBOXC\" align=\"center\">";
     echo "<a href=\"admin.php\" class=\"HEADA\">".adm_translate("Menu Administration")."</a>";
     if ($Q[radminsuper]==1) {
        echo"&nbsp|&nbsp<a href=\"admin.php?op=BannersAdmin\" class=\"HEADA\">".adm_translate("Administration des Bannires")."</a>";
        echo"&nbsp|&nbsp<a href=\"abla.php\" class=\"HEADA\">".adm_translate("Tableau de Bord")."</a>";
     }
     echo "&nbsp|&nbsp<a href=\"javascript:void(0);\" onClick=\"window.open('editeur/meta_lang.php','MetaLang','toolbar=no,location=no,directories=no,status=no,scrollbars=yes,resizable=no,copyhistory=no,width=600,height=400')\"; class=\"HEADA\">META-LANG</a>\n";

     if ($multi_langue)
        echo "&nbsp&nbsp;<span style=\"font-size: 10px;\" class=\"NOIR\">ML</span>\n";
     else
        echo "&nbsp&nbsp;<span style=\"font-size: 10px;\" class=\"ROUGE\">ML</span>\n";

     if ($hlpfile) {
        echo "&nbsp|&nbsp<a href=\"javascript: openwindow()\" class=\"HEADA\">".adm_translate("Manuel en ligne")."</a>";
     }
     echo "</tr></table>";

     if ($short_menu_admin!=false) {
        closetable();
        return;
     }
     echo"<div class=\"SEPAR\"></div><table border=\"0\" width=\"100%\" cellspacing=\"0\"><tr>";
     global $counter;
     $counter = 0;

     // Ligne 1
     if (($Q[radminsuper]==1) OR ($Q[radminarticle]==1)) {
        adminmenu("submissions", adm_translate("Articles"), "submissions.".$admf_ext);
        adminmenu("adminStory", adm_translate("Nouvel Article"), "postnew.".$admf_ext);
        adminmenu("autoStory", adm_translate("Auto-Articles"), "autonews.".$admf_ext);
     }
     if (($Q[radminsuper]==1) OR ($Q[radmintopic]==1)) adminmenu("topicsmanager", adm_translate("Gestion des Sujets"), "topicsman.".$admf_ext);
     if (($Q[radminsuper]==1) OR ($Q[radminsection]==1)) adminmenu("sections", adm_translate("Rubriques"), "sections.".$admf_ext);
     adminmenu("space","","");

     // Ligne 2
     if (($Q[radminsuper]==1) OR ($Q[radminleft]==1) OR ($Q[radminright]==1)) adminmenu("blocks", adm_translate("Blocs"), "block.".$admf_ext);
     if (($Q[radminsuper]==1) OR ($Q[radminmain]==1)) adminmenu("mblock", adm_translate("Bloc Principal"), "mainblock.".$admf_ext);
     adminmenu("null","","");
     if (($Q[radminsuper]==1) OR ($Q[radminuser]==1)) {
        adminmenu("mod_users", adm_translate("Edition des Utilisateurs"), "users.".$admf_ext);
        adminmenu("email_user", adm_translate("Diffusion d'un Message Interne"), "email_user.".$admf_ext);
     }
     adminmenu("space","","");

     // Ligne 3
     if (($Q[radminsuper]==1) OR ($Q[radminsurvey]==1)) adminmenu("create", adm_translate("Sondages"), "newpoll.".$admf_ext);
     if (($Q[radminsuper]==1) OR ($Q[radminlink]==1)) adminmenu("links", adm_translate("Liens Web"), "links.".$admf_ext);
     if (($Q[radminsuper]==1) OR ($Q[radminfaq]==1)) adminmenu("FaqAdmin", adm_translate("Faq"), "faq.".$admf_ext);
     if (($Q[radminsuper]==1) OR ($Q[radminsdv]==1)) adminmenu("groupes", adm_translate("Gestion des groupes"), "sdv.".$admf_ext);
     if (($Q[radminsuper]==1) OR ($Q[radmindownload]==1)) adminmenu("DownloadAdmin", adm_translate("Tlchargement"), "download.".$admf_ext);
     adminmenu("space","","");

     // Ligne 4
     if ($Q[radminsuper]==1) adminmenu("hreferer", adm_translate("Sites Rfrants"), "referer.".$admf_ext);
     if (($Q[radminsuper]==1) OR ($Q[radminhead]==1)) adminmenu("HeadlinesAdmin", adm_translate("Grands Titres de sites de News"), "headlines.".$admf_ext);
     if (($Q[radminsuper]==1) OR ($Q[radminephem]==1)) adminmenu("Ephemerids", adm_translate("Ephmrides"), "ephem.".$admf_ext);
     if (($Q[radminsuper]==1) OR ($Q[radminreviews]==1)) adminmenu("reviews", adm_translate("Critiques"), "reviews.".$admf_ext);
     if (($Q[radminsuper]==1) OR ($Q[radminarticle]==1)) adminmenu("Edito", adm_translate("Edito"), "filemanager.".$admf_ext);
     adminmenu("space","","");

     // Ligne 5
     if (($Q[radminsuper]==1) OR ($Q[radminforum]==1)) {
        adminmenu("ForumAdmin", adm_translate("Edition des Forums"), "forum.".$admf_ext);
        adminmenu("MaintForumAdmin", adm_translate("Maintenance des Forums"), "forum.".$admf_ext);
        adminmenu("ForumConfigAdmin", adm_translate("Configuration des Forums"), "forum.".$admf_ext);
     }
     if ($Q[radminsuper]==1) {
        adminmenu("MetaTagAdmin", adm_translate("MtaTAGs"), "metatags.".$admf_ext);
     }
     if (($Q[radminsuper]==1) OR ($Q[radminlnl]==1)) adminmenu("lnl", adm_translate("Petite Lettre D'information"), "lnl.".$admf_ext);
     if ($Q[radminsuper]==1) {
        adminmenu("space","","");
     }
     // Ligne 6
     if ($Q[radminsuper]==1) {
        adminmenu("Configure", adm_translate("Prfrences"), "preferences.".$admf_ext);
        adminmenu("ConfigFiles", adm_translate("Editer les fichiers de configuration"), "preferences.".$admf_ext);
        adminmenu("mod_authors", adm_translate("Editer les Administrateurs"), "authors.".$admf_ext);
        adminmenu("ablock", adm_translate("Bloc Administration"), "adminblock.".$admf_ext);
        adminmenu("Modules", adm_translate("Gestion, Installation Modules"), "optimysql.".$admf_ext);
        adminmenu("space","","");
     }

     // Ligne 7
     if ($Q[radminsuper]==1) {
        adminmenu("OptimySQL", adm_translate("OptimySQL"), "optimysql.".$admf_ext);
        adminmenu("SavemySQL", adm_translate("SavemySQL"), "savemysql.".$admf_ext);
     }
     if (($Q[radminsuper]==1) OR ($Q[radminfilem]==1)) {
        if ($filemanager==1) {
           adminmenu("FileManager", adm_translate("Gestionnaire de Fichiers"), "filemanager.".$admf_ext);
        } else {
           adminmenu("no_url", adm_translate("Gestionnaire de Fichiers"), "filemanager.".$admf_ext);
        }
     }
     adminmenu("supercache", adm_translate("SuperCache"), "overload.".$admf_ext);
     adminmenu("Extend-Admin-Module", adm_translate("Admin-Plugins"), "optimysql.".$admf_ext);
     adminmenu("space","","");

     // Ligne 8
     adminmenu("center","","");
     adminmenu("logout", adm_translate("Dconnexion"), "exit.".$admf_ext);
     echo"</tr></table>";
    CloseTable();
    return ($Q[radminsuper]);
}

function adminMain($deja_affiches) {
   global $language, $admart, $hlpfile, $aid;
   $hlpfile = "manuels/$language/admin.html";
   include("header.php");
   global $short_menu_admin;
   $short_menu_admin=false;
   $radminsuper=GraphicAdmin($hlpfile);
   OpenTable();

   echo "<br /><table width=\"100%\" cellspacing=\"2\" cellpadding=\"2\" border=\"0\"><tr><td class=\"HEADER\">\n";
   echo adm_translate("Derniers")." $admart ".adm_translate("Articles");
   echo "</td></tr></table>\n";

   $resul=mysql_query("select sid from stories");
   $nbre_articles=mysql_num_rows($resul);
   settype($deja_affiches,"integer");
   settype($admart,"integer");
   $result = mysql_query("select sid, title, hometext, topic, informant, time, archive from stories order by time desc LIMIT $deja_affiches,$admart");

   if ($nbre_articles) {
      echo "<table width=\"100%\" cellspacing=\"0\" cellpadding=\"2\" border=\"0\">";
      $i=0;
      while( (list($sid, $title, $hometext, $topic, $informant, $time, $archive) = mysql_fetch_row($result)) and ($i<$admart) ) {
         $affiche=false;
         $result2=mysql_query("select topicadmin, topictext from topics where topicid='$topic'");
         list ($topicadmin, $topictext)=mysql_fetch_row($result2);
         if ($radminsuper) {
            $affiche=true;
         } else {
            $topicadminX=explode(",",$topicadmin);
            for ($iX = 0; $iX < count($topicadminX); $iX++) {
               if (trim($topicadminX[$iX])==$aid) $affiche=true;
            }
         }
         $rowcolor = tablos();
         echo "<tr $rowcolor><td align=\"left\">$sid</td><td align=\"left\" width=\"80%\">";

         $title=aff_langue($title);
         if ($archive) {
            echo "$title <i>(archive)</i>";
         } else {
            if ($affiche) {
               echo "<a href=\"article.php?sid=$sid\" class=\"HEADA\">$title</a>";
            } else {
               echo "<i>$title</i>";
            }
         }
         if ($topictext=="") {
            echo "</td><td align=\"left\">&nbsp;";
         } else {
            echo "</td><td align=\"left\" nowrap=\"nowrap\">".aff_langue($topictext);
         }
         if ($affiche) {
            echo "</td><td align=\"left\" nowrap=\"nowrap\"><a href=\"admin.php?op=EditStory&amp;sid=$sid\" class=\"NOIR\">".adm_translate("Editer")."</a> | <a href=\"admin.php?op=RemoveStory&amp;sid=$sid\" class=\"ROUGE\">".adm_translate("Effacer")."</a>";
         } else {
            echo "</td><td width=\"15%\" align=\"left\" nowrap=\"nowrap\">&nbsp;";
         }
         echo "</td></tr>";
         $i++;
      }
      echo "</table><p align=\"center\"><br />";
      echo $nbre_articles." Articles | <a href=\"admin.php?op=suite_articles&amp;deja_affiches=0\" class=\"NOIR\">".adm_translate("Les plus rcents")."</a>";
      if ($deja_affiches>=$admart) echo " | <a href=\"admin.php?op=suite_articles&amp;deja_affiches=".($deja_affiches-$admart)."\" class=\"NOIR\">".adm_translate("Prcdent")."</a>";
      if (($deja_affiches + $i) < $nbre_articles) {
         $deja_affiches+=$admart;
         echo " | <a href=\"admin.php?op=suite_articles&amp;deja_affiches=".$deja_affiches."\" class=\"NOIR\">".adm_translate("Suivant")."</a>";
      }
      echo "<form action=\"admin.php\" method=\"post\">
      ".adm_translate("ID Article:")." <input class=\"TEXTBOX_STANDARD\" type=\"text\" name=\"sid\" size=\"10\">
      <select class=\"TEXTBOX_STANDARD\" name=\"op\">
      <option value=\"EditStory\" selected>".adm_translate(" Editer un Article ")."</option>
      <option value=\"RemoveStory\">".adm_translate(" Effacer l'Article")."</option>
      </select>
      <input class=\"BOUTON_STANDARD\" type=\"submit\" value=\"".adm_translate("Ok")."\">
      </form></p>";
   }
   CloseTable();
   include("footer.php");
}

/*********************************************************/
/* File Manager Functions                                */
/*********************************************************/
function display_size($file){
    $file_size = filesize($file);
    if($file_size >= 1073741824)
         {
        $file_size = round($file_size / 1073741824 * 100) / 100 . "g";
        }
    elseif($file_size >= 1048576)
        {
        $file_size = round($file_size / 1048576 * 100) / 100 . "m";
        }
    elseif($file_size >= 1024)
        {
        $file_size = round($file_size / 1024 * 100) / 100 . "k";
        }
    else{
        $file_size = $file_size . "b";
        }
    return $file_size;
}

function getPerms($filename){
  $perms = fileperms($filename);
  $perms = $perms & 0777; 
  $mask = 0700;
  $Fdroits = "";
  for ($i = 0;$i<3;$i++) {
     $droits = $perms & $mask;
     if ($i == 0) {
        $droits = $droits >> 6;
     } else if ($i == 1) {
        $droits = $droits >> 3;
     }
     $Fdroits.=$droits;
     $mask = $mask >> 3;
  } 
  return $Fdroits;
}

function displaydir($action) {
  global $basedir, $wdir, $udir, $lastaction, $filemanager;
  // Security Fix
  global $admintest;
  if (($admintest and $filemanager) or ($admintest and $action=="no_maj")) {
    $lastaction = adm_translate("Liste du rpertoire");
    echo "<table border=\"0\" cellspacing=\"1\" cellpadding=\"1\" width=\"100%\">";
    echo "<tr>";
    echo "<td style=\"background-color:#CCCCCC;\" align=\"center\">".adm_translate("Type")."</td>";
    echo "<td style=\"background-color:#CCCCCC;\" align=\"center\">".adm_translate("Nom")."</td>";
    echo "<td style=\"background-color:#CCCCCC;\" align=\"center\" width=\"10\">".adm_translate("Droits")."</td>";
    echo "<td style=\"background-color:#CCCCCC;\" align=\"center\">".adm_translate("Taille")."</td>";
    echo "<td style=\"background-color:#CCCCCC;\" align=\"center\">".adm_translate("Modifi")."</td>";
    echo "<td style=\"background-color:#CCCCCC;\">".adm_translate("Action")."</td>";
    echo "</tr>";
    chdir($basedir . $wdir);
    $handle=opendir(".");
    while ($file = readdir($handle)) {
        if(is_dir($file)) $dirlist[] = $file;
        if(is_file($file)) $filelist[] = $file;
    }
    closedir($handle);
    if ($action=="no_maj") {$display="Display";} else {$display="";}
    if ($dirlist) {
        asort($dirlist);
        while (list ($key, $file) = each ($dirlist)) {
            if (!($file == ".")) {
                $filename=$basedir.$wdir.$file;
                $fileurl=rawurlencode($wdir.$file);
                $lastchanged = filectime($filename);
                $changeddate = date("d-m-Y H:i:s", $lastchanged);
                $rowcolor=tablos();
                echo "<tr $rowcolor>";
                if ($file == "..") {
                    $downdir = dirname("$wdir");
                    echo "<td align=\"center\" nobreak=\"nobreak\"><a href=\"admin.php?op=chdr$display&amp;file=$downdir\"><img src=\"";
                    if ($ibid=theme_image("admin/filemanager/parent.gif")) {
                       $imgtmp=$ibid;
                    } else {
                       $imgtmp="images/admin/filemanager/parent.gif";
                    }
                    echo "$imgtmp\" alt=\"".adm_translate("Rpertoire parent")."\" border=\"0\" /></a></td>\n";
                    echo "<td>&nbsp;</td>\n";
                    echo "<td>&nbsp;</td>\n";
                    echo "<td align=\"right\" nobreak=\"nobreak\">".display_size($filename)."</td>";
                    echo "<td>&nbsp;</td>\n";
                    echo "<td nobreak=\"nobreak\"><a href=\"admin.php?op=chdr$display&amp;file=$downdir\"><img src=\"$imgtmp\" alt=\"".adm_translate("Rpertoire parent")."\" border=\"0\" /></a></td>";
                } else {
                    $lastchanged = filectime($filename);
                    if ($ibid=theme_image("admin/filemanager/folder.gif")) {
                       $imgtmp=$ibid;
                    } else {
                       $imgtmp="images/admin/filemanager/folder.gif";
                    }
                    echo "<td align=\"center\" nobreak=\"nobreak\"><a href=\"admin.php?op=chdr$display&amp;file=$fileurl\"><img src=\"";
                    echo "$imgtmp\" alt=\"".adm_translate("Changer le rpertoire de travail vers")." $file\" border=\"0\" /></a></td>\n";
                    echo "<td nobreak=\"nobreak\">".htmlspecialchars($file)."</td>\n";
                    echo "<td align=\"middle\" nobreak=\"nobreak\" class=\"ROUGE\" style=\"font-size: 10px;\">".getPerms($filename)."</td>\n";

                    echo "<td align=\"right\" nobreak=\"nobreak\">".display_size($filename)."</td>";
                    echo "<td align=\"middle\" nobreak=\"nobreak\">".$changeddate."</td>";
                    if ($action=="maj") {
                       echo "<td nobreak=\"nobreak\"><a href=\"admin.php?op=move&amp;wdir=$wdir&amp;file=$fileurl\"><img src=\"";
                       if ($ibid=theme_image("admin/filemanager/move.gif")) {
                          $imgtmp=$ibid;
                       } else {
                          $imgtmp="images/admin/filemanager/move.gif";
                       }
                       echo "$imgtmp\" alt=\"".adm_translate("Dplacer, Copier ou Renommer")." $file\" border=\"0\" /></a> ";
                       echo " <a href=\"admin.php?op=touch&amp;wdir=$wdir&amp;touchfile=$fileurl\"><img src=\"";
                       if ($ibid=theme_image("admin/filemanager/touch.gif")) {
                          $imgtmp=$ibid;
                       } else {
                          $imgtmp="images/admin/filemanager/touch.gif";
                       }
                       echo "$imgtmp\" alt=\"".adm_translate("Crer")." $file\" border=\"0\" /></a> ";
                       echo "<a href=\"admin.php?op=del&amp;wdir=$wdir&amp;file=$fileurl\"><img src=\"";
                       if ($ibid=theme_image("admin/filemanager/delete.gif")) {
                          $imgtmp=$ibid;
                       } else {
                          $imgtmp="images/admin/filemanager/delete.gif";
                       }
                       echo "$imgtmp\" alt=\"".adm_translate("Effacer")." $file\" border=\"0\" /></a></td>";
                    } else {
                       echo "<td>&nbsp;</td>\n";
                    }
                }
                echo "</tr>";
            }
        }
    }
    echo "<tr><td colspan=\"6\"><hr noshade class=\"ONGL\"></td></tr>";
    if ($filelist) {
        asort($filelist);
        while (list ($key, $file) = each ($filelist)) {
            if (ereg(".gif|.jpg",$file)) {
                if ($ibid=theme_image("admin/filemanager/image.gif")) {
                   $icon = "<img src=\"$ibid\" alt=\"Image\" border=\"0\" />";
                } else {
                   $icon = "<img src=\"images/admin/filemanager/image.gif\" alt=\"Image\" border=\"0\" />";
                }
                $type_html=false;
                $browse = "1";
                $raw = "0";
                $image = "1";
                $security="0";
            } elseif (ereg(".txt",$file)) {
                if ($ibid=theme_image("admin/filemanager/text.gif")) {
                   $icon = "<img src=\"$ibid\" alt=\"Texte / Text\" border=\"0\" />";
                } else {
                   $icon = "<img src=\"images/admin/filemanager/text.gif\" alt=\"Texte / Text\" border=\"0\" />";
                }
                $type_html=true;
                $browse = "1";
                $raw = "1";
                $image = "0";
                $security="0";
            } elseif (ereg(".wav|.mp2|.mp3|.mp4|.vqf|.midi",$file)) {
                if ($ibid=theme_image("admin/filemanager/audio.gif")) {
                   $icon = "<img src=\"$ibid\" alt=\"Audio\" border=\"0\" />";
                } else {
                   $icon = "<img src=\"images/admin/filemanager/audio.gif\" alt=\"Audio\" border=\"0\" />";
                }
                $type_html=false;
                $browse = "1";
                $raw = "0";
                $image = "0";
                $security="0";
            } elseif (ereg(".phps|.php|.php2|.php3|.php4|.asp|.asa|.cgi|.pl|.shtml",$file)) {
                if ($ibid=theme_image("admin/filemanager/webscript.gif")) {
                   $icon = "<img src=\"$ibid\" alt=\"Script Web / Web program\" border=\"0\" />";
                } else {
                   $icon = "<img src=\"images/admin/filemanager/webscript.gif\" alt=\"Script Web / Web program\" border=\"0\" />";
                }
                $type_html=false;
                $browse = "1";
                $raw = "1";
                $image = "0";
                $security="0";
            } elseif (ereg(".htaccess",$file)) {
                if ($ibid=theme_image("admin/filemanager/security.gif")) {
                   $icon = "<img src=\"$ibid\" alt=\"Fichier Apache de scurit / Apache security settings\" border=\"0\" />";
                } else {
                   $icon = "<img src=\"images/admin/filemanager/security.gif\" alt=\"Fichier Apache de scurit / Apache security settings\" border=\"0\" />" ;
                }
                $type_html=false;
                $browse = "0";
                $raw = "1";
                $image = "0";
                $security="1";
            } elseif (ereg(".filemanager.conf",$file) or ereg("filemanager.conf",$file)) {
                if ($ibid=theme_image("admin/filemanager/security.gif")) {
                   $icon = "<img src=\"$ibid\" alt=\"Fichier de scurit de NPDS / NPDS security settings\" border=\"0\" />";
                } else {
                   $icon = "<img src=\"images/admin/filemanager/security.gif\" alt=\"Fichier de scurit de NPDS / NPDS security settings\" border=\"0\" />" ;
                }
                $type_html=false;
                $browse = "0";
                $raw = "1";
                $image = "0";
                $security="1";
            } elseif (ereg(".html|.htm",$file))        {
                if ($ibid=theme_image("admin/filemanager/webpage.gif")) {
                   $icon = "<img src=\"$ibid\" alt=\"Page Web / Web page\" border=\"0\" />";
                } else {
                   $icon = "<img src=\"images/admin/filemanager/webpage.gif\" alt=\"Page Web / Web page\" border=\"0\" />";
                }
                $type_html=true;
                $browse = "1";
                $raw = "1";
                $image = "0";
                $security="0";
            } else {
                if ($ibid=theme_image("admin/filemanager/text.gif")) {
                   $icon = "<img src=\"$ibid\" alt=\"Type commun / Unknown filetype\" border=\"0\" />";
                } else {
                   $icon = "<img src=\"images/admin/filemanager/text.gif\" alt=\"Type commun / Unknown filetype\" border=\"0\" />";
                }
                $type_html=false;
                $browse = "1";
                $raw = "1";
                $image = "0";
                $security="0";
            }
            $filename=$basedir.$wdir.$file;
            $fileurl=rawurlencode($wdir.$file);
            $fileurl2=rawurlencode($udir.$wdir.$file);
            $lastchanged = filectime($filename);
            $changeddate = date("d-m-Y H:i:s", $lastchanged);
            echo "<tr>";
            echo "<td align=\"center\" nobreak=\"nobreak\">";
            if ($action=="maj") {
               if ($raw == "1") {
                  echo "<a href=\"admin.php?op=show&amp;wdir=$wdir&amp;file=$fileurl\" class=\"NOIR\">";
               }
               if ($image == "1") {
                  echo "<a href=\"admin.php?op=show&amp;wdir=$wdir&amp;file=$fileurl2&amp;image=$image\" class=\"NOIR\">";
               }
            }
            echo "$icon</td>\n";
            echo "<td nobreak=\"nobreak\">".htmlspecialchars($file)."</td>\n";
            echo "<td align=\"middle\" nobreak=\"nobreak\">".getPerms($filename)."</td>\n";
            echo "<td align=\"right\" nobreak=\"nobreak\">".display_size($filename)."</td>";
            echo "<td align=\"middle\" nobreak=\"nobreak\">".$changeddate;
            echo "</td><td nobreak=\"nobreak\">";
            if (($security != "1") and ($action=="maj")) {
               echo " <a href=\"admin.php?op=move&amp;wdir=$wdir&amp;file=$fileurl\"><img src=\"";
               if ($ibid=theme_image("admin/filemanager/move.gif")) {
                  $imgtmp="$ibid";
               } else {
                  $imgtmp="images/admin/filemanager/move.gif";
               }
               echo "$imgtmp\" alt=\"".adm_translate("Dplacer, Copier ou Renommer")." $file\" border=\"0\" /></a> ";
               echo " <a href=\"admin.php?op=touch&amp;wdir=$wdir&amp;touchfile=$fileurl\"><img src=\"";
               if ($ibid=theme_image("admin/filemanager/touch.gif")) {
                  $imgtmp="$ibid";
               } else {
                  $imgtmp="images/admin/filemanager/touch.gif";
               }
               echo "$imgtmp\" alt=\"".adm_translate("Crer")." $file\" border=\"0\" /></a> ";
               echo "<a href=\"admin.php?op=del&amp;wdir=$wdir&amp;file=$fileurl\"><img src=\"";
               if ($ibid=theme_image("admin/filemanager/delete.gif")) {
                  $imgtmp="$ibid";
               } else {
                  $imgtmp="images/admin/filemanager/delete.gif";
               }
               echo "$imgtmp\" alt=\"".adm_translate("Effacer")." $file\" border=\"0\" /></a> ";
               if ($browse == "1") {
                   echo " <a href=\"$udir$wdir$file\" class=\"NOIR\"><img src=\"";
                   if ($ibid=theme_image("admin/filemanager/browse.gif")) {
                      $imgtmp="$ibid";
                   } else {
                      $imgtmp="images/admin/filemanager/browse.gif";
                   }
                   echo "$imgtmp\" alt=\"".adm_translate("Visualiser")." $file\" border=\"0\" /></a> ";
               }
               if ($raw =="1") {
                   echo " <a href=\"admin.php?op=edit&amp;wdir=$wdir&amp;file=$fileurl&amp;type_html=$type_html\" class=\"NOIR\"><img src=\"";
                   if ($ibid=theme_image("admin/filemanager/edit.gif")) {$imgtmp="$ibid";} else {$imgtmp="images/admin/filemanager/edit.gif";}
                   echo "$imgtmp\" alt=\"".adm_translate("Editer")." $file\" border=\"0\" /></a>";
                   if ($type_html) {
                      echo " <a href=\"admin.php?op=editwg&amp;wdir=$wdir&amp;file=$fileurl&amp;type_html=$type_html\" class=\"NOIR\"><img src=\"";
                      if ($ibid=theme_image("admin/filemanager/editwg.gif")) {$imgtmp="$ibid";} else {$imgtmp="images/admin/filemanager/editwg.gif";}
                      echo "$imgtmp\" alt=\"".adm_translate("Editer")." wysiwyg : $file\" border=\"0\" /></a>";
                   }
               }
            }
            if ($action=="no_maj") {
               echo "&nbsp;&nbsp;[&nbsp;<A href=\"#\" \"javascript:\" onClick=\"Javascript:window.opener.document.adminForm.durl.value='".substr(urldecode($fileurl),1)."'; window.opener.document.adminForm.dfilename.value='$file';\" class=\"NOIR\">".adm_translate("Copier")."</a>&nbsp;]";
            }
            echo "</td></tr>";
        }
    }
    echo "</table>";
    if ($action=="maj") {
       echo "<table border=\"0\" width=\"100%\">";
       echo "<tr><td colspan=\"2\"><hr noshade class=\"ONGL\"></td>";
       echo "<tr><td valign=\"top\">".adm_translate("Tlcharg vers le serveur")."</td><td>";
       echo "<form enctype=\"multipart/form-data\" method=\"post\" action=\"admin.php\">";
       echo "<input type=\"hidden\" name=\"wdir\" value=\"$wdir\">";
       echo "<input class=\"TEXTBOX_STANDARD\" name=\"userfile\" type=\"file\" size=\"35\"> - ";
       echo "<input class=\"BOUTON_STANDARD\" type=\"submit\" name=\"upload\" value=\"Ok\"></form></td></tr>";
       echo "<form method=\"post\" action=\"admin.php\">";
       echo "<tr><td valign=\"top\">".adm_translate("Crer le rpertoire")."</td><td>";
       echo "<input class=\"TEXTBOX_STANDARD\" type=\"text\" name=\"mkdirfile\" size=\"35\"> - ";
       echo "<input type=\"hidden\" name=\"op\" value=\"mkdir\">";
       echo "<input type=\"hidden\" name=\"wdir\" value=\"$wdir\">";
       echo "<input class=\"BOUTON_STANDARD\" type=\"submit\" name=\"mkdir\"  value=\"Ok\"></form></td></tr>";
       echo "<form method=\"post\" action=\"admin.php\">";
       echo "<tr><td valign=\"top\">".adm_translate("Crer le fichier")."</td><td>";
       echo "<input class=\"TEXTBOX_STANDARD\" type=\"text\" name=\"file\" size=\"35\"> - ";
       echo "<input type=\"hidden\" name=\"op\" value=\"createfile\"> ";
       echo "<input type=\"checkbox\" name=\"html\" value=\"yes\">&nbsp;(html template) ";
       echo "<input type=\"hidden\" name=\"wdir\" value=\"$wdir\">";
       echo "<input class=\"BOUTON_STANDARD\" type=\"submit\" name=\"createfile\" value=\"Ok\">";
       echo "</form></td></tr>";
       echo "</table>";
       echo "<table border=\"0\" cellspacing=\"0\" cellpadding=\"1\" width=\"100%\">";
       echo "<tr>";
       echo "<th style=\"font-size: 10px; background-color:#CCCCCC;\">NPDS File Manager is Based on <a href=\"http://www.suneworld.com\" class=\"NOIR\">WebExplorer</a> and has been integrated with the author permission.</th>";
       echo "</tr></table>";
    }
  }
}

// Initialisation Filemanager
if ($admintest) {
   $basedir = dirname($SCRIPT_FILENAME);
   $textrows = 20;
   $textcols = 85;
   $udir = dirname($PHP_SELF);
   if ($udir=="/") { $udir=""; }
   if (!$wdir) $wdir="/";
}
// Initialisation Filemanager
if ($admintest and $filemanager) {
    if ($cancel) $op="FileManager";
    if ($upload) {
       include_once("modules/upload/upload.conf.php");
       if ($userfile!="none") {
          global $language;
          include_once("modules/upload/lang/upload.lang-$language.php");
          include_once("modules/upload/clsUpload.php");
          $upload = new Upload();
          $upload->maxupload_size=$max_size*100;
          $field1_filename = trim($upload->getFileName("userfile"));
          if ($field1_filename) {
             $upload->saveAs($field1_filename,$basedir.$wdir, "userfile",true);
          }
       }
       $lastaction = adm_translate("Tlcharg vers le serveur")." $field1_filename =>> $wdir";
       include("header.php");
       GraphicAdmin($hlpfile);
       html_header();
       displaydir("maj");
       closetable();
       $wdir2="/";
       chdir($basedir . $wdir2);
       include("footer.php");
       exit;
    }
}

if ($admintest) {
   switch($op) {
        case "GraphicAdmin":
             GraphicAdmin($hlpfile);
             break;

        case "logout":
             setcookie("admin");
             unset($admin);
             Header("Location: index.php");
             break;

        case "FileManager":
            if ($admintest and $filemanager) {
               $lastaction = adm_translate("Liste du rpertoire");
               $hlpfile = "manuels/$language/filemanager.html";
               include("header.php");
               GraphicAdmin($hlpfile);
               html_header();
               displaydir("maj");
               $wdir2="/";
               chdir($basedir . $wdir2);
               closetable();
               include("footer.php");
            }
            break;

        case "chdrDisplay":
            if ($admintest) {
               if ($file=="/") {
                  $wdir=$file;
               } else {
                  $wdir=$file."/";
               }
               $wdir = ereg_replace("\.\./", "", $wdir);
            }
        case "FileManagerDisplay":
            if ($admintest) {
               $meta_op=true;
               include("meta/meta.php");
               $Xthing.=$l_meta;
               include("modules/upload/upload.conf.php");
               if ($url_upload_css) {
                  $url_upload_cssX=str_replace("style.css","$language-style.css",$url_upload_css);
                  if (is_readable($url_upload.$url_upload_cssX))
                     $url_upload_css=$url_upload_cssX;
                  $Xthing.="<link href=\"".$url_upload.$url_upload_css."\" title=\"default\" rel=\"stylesheet\" type=\"text/css\" media=\"all\" />\n";
               }
               $Xthing.="<title>".adm_translate("Gestionnaire de Fichiers")."</title>";
               $Xthing.="</head>\n<body topmargin=\"2\" bottommargin=\"2\" leftmargin=\"2\" rightmargin=\"2\">";
               echo $Xthing;
               displaydir("no_maj");
               echo "</body></html>";
               $wdir2="/";
               chdir($basedir . $wdir2);
            }
            break;

        case "root":
            if ($admintest and $filemanager) {
               $wdir="/";
               $lastaction = adm_translate("Changement de rpertoire vers la racine");
               $hlpfile = "manuels/$language/filemanager.html";
               include("header.php");
               GraphicAdmin($hlpfile);
               html_header();
               displaydir("maj");
               closetable();
               include("footer.php");
            }
            break;

        case "chdr":
            if ($admintest and $filemanager) {
               if ($file=="/") {
                  $wdir=$file;
               } else {
                  $wdir=$file."/";
               }
               $wdir = ereg_replace("\.\./", "", $wdir);
               $lastaction = adm_translate("Changement de rpertoire vers")." : $wdir";
               $hlpfile = "manuels/$language/filemanager.html";
               include("header.php");
               GraphicAdmin($hlpfile);
               html_header();
               displaydir("maj");
               closetable();
               $wdir2="/";
               chdir($basedir . $wdir2);
               include("footer.php");
            }
            break;

        case "touch":
            if ($admintest and $filemanager) {
               @touch($basedir.$touchfile);
               $lastaction = adm_translate("Cr")." : $touchfile";
               $hlpfile = "manuels/$language/filemanager.html";
               include("header.php");
               GraphicAdmin($hlpfile);
               html_header();
               displaydir("maj");
               closetable();
               $wdir2="/";
               chdir($basedir . $wdir2);
               include("footer.php");
            }
            break;

        case "del":
            if ($admintest and $filemanager) {
               if ($confirm) {
                  if ($admintest and $filemanager) {
                     if (is_dir($basedir.$file)) {
                        @rmdir($basedir.$file);
                     } else {
                        @unlink($basedir.$file);
                     }
                     $lastaction = adm_translate("Effac")." : $file";
                     $hlpfile = "manuels/$language/filemanager.html";
                     include("header.php");
                     GraphicAdmin($hlpfile);
                     html_header();
                     displaydir("maj");
                     closetable();
                  }
               } else {
                  $lastaction = "<span class=\"ROUGE\">".adm_translate("Etes-vous sr de vouloir EFFACER")."</span> : $file ?";
                  $hlpfile = "manuels/$language/filemanager.html";
                  include("header.php");
                  GraphicAdmin($hlpfile);
                  html_header();
                  echo "<p align=\"center\">[ <a href=\"admin.php?op=del&amp;wdir=$wdir&amp;file=$file&amp;confirm=1\" class=\"ROUGE\">".adm_translate("Oui")."</a> | ";
                  echo "<a href=\"admin.php?op=FileManager&amp;wdir=$wdir\" class=\"NOIR\">".adm_translate("Non")."</a> ]<br /></p>";
                  closetable();
               }
               $wdir2="/";
               chdir($basedir . $wdir2);
               include("footer.php");
            }
            break;

        case "move":
            if ($admintest and $filemanager) {
               if ($confirm && $newfile) {
                  if ($admintest and $filemanager) {
                     if (file_exists($basedir.$newfile)) {
                        $lastaction = adm_translate("Le fichier de destination existe dj. Opration annule.");
                     } else {
                        if ($do == copy) {
                           copy($basedir.$file,$basedir.$newfile);
                           $lastaction = adm_translate("Copi")."\n$file =>> $newfile";
                        } else {
                           rename($basedir.$file,$basedir.$newfile);
                           $lastaction = adm_translate("Dplac/renomm")."\n$file =>> $newfile";
                        }
                     }
                     $hlpfile = "manuels/$language/filemanager.html";
                     include("header.php");
                     GraphicAdmin($hlpfile);
                     html_header();
                     displaydir("maj");
                     closetable();
                     $wdir2="/";
                     chdir($basedir . $wdir2);
                     include("footer.php");
                  }
               } else {
                  $lastaction = adm_translate("Dplacement/Chgt.nom ou Copie")." : $file";
                  $hlpfile = "manuels/$language/filemanager.html";
                  include("header.php");
                  GraphicAdmin($hlpfile);
                  html_header();
                  echo "<form method=\"post\" action=\"admin.php\">\n";
                  echo "<select class=\"TEXTBOX_STANDARD\" name=\"do\">";
                  echo "<option value=\"copy\">".adm_translate("Copier");
                  echo "<option value=\"move\">".adm_translate("Dplacer/Renommer");
                  echo "</select> ";
                  echo " <b>$file</b> => ";
                  echo "<input class=\"TEXTBOX_STANDARD\" type=\"text\" name=\"newfile\" value=\"$file\" size=\"40\">\n";
                  echo "<input type=\"hidden\" name=\"wdir\" value=\"$wdir\">\n";
                  echo "<input type=\"hidden\" name=\"op\" value=\"move\">\n";
                  echo "<input type=\"hidden\" name=\"file\" value=\"$file\">\n";
                  echo "<br /><br />";
                  echo "<input class=\"BOUTON_STANDARD\" type=\"submit\" name=\"confirm\" value=\"Ok\"> - \n";
                  echo "<input class=\"BOUTON_STANDARD\" type=\"submit\" name=\"cancel\" value=\"".adm_translate("Abandonner")."\">\n";
                  echo "</form>";
                  closetable();
                  $wdir2="/";
                  chdir($basedir . $wdir2);
                  include("footer.php");
               }
            }
            break;

        case "edit":
        case "editwg":
            if ($admintest and $filemanager) {
               if ($confirm && $file) {
                  if ($admintest and $filemanager) {
                     $lastaction = "".adm_translate("Edit")." $file";
                     $hlpfile = "manuels/$language/filemanager.html";
                     include("header.php");
                     GraphicAdmin($hlpfile);
                     html_header();
                     $fp=@fopen($basedir.$file,"w");
                        @fputs($fp,stripslashes($content));
                     @fclose($fp);
                     displaydir("maj");
                     closetable();
                  }
               } else {
                  $lastaction = adm_translate("Edition")." : $file";
                  $hlpfile = "manuels/$language/filemanager.html";
                  include("header.php");
                  GraphicAdmin($hlpfile);
                  html_header();
                  echo "<p align=\"center\"><form method=\"post\" action=\"admin.php\" name=\"adminForm\">\n";
                  echo "<input type=\"hidden\" name=\"file\" value=\"$file\">\n";
                  echo "<input type=\"hidden\" name=\"op\" value=\"edit\">\n";
                  echo "<input type=\"hidden\" name=\"wdir\" value=\"$wdir\">\n";
                  $fp=@fopen($basedir.$file,"r");
                  if (filesize($basedir.$file)>0)
                     $contents=fread($fp,filesize($basedir.$file));
                  @fclose($fp);
                  if ($op=="editwg") {
                     if ($type_html) {
                        echo aff_editeur("content", "false");
                     }
                  }
                  echo "<textarea name=\"content\" class=\"textbox\" rows=\"$textrows\" cols=\"$textcols\" style=\"width: 100%;\">\n";
                  echo htmlspecialchars($contents);
                  echo "</textarea><br /><br />\n";
                  echo "<input class=\"BOUTON_STANDARD\" type=\"submit\" name=\"confirm\" value=\"".adm_translate("Enregistrer")."\"> - \n";
                  echo "<input class=\"BOUTON_STANDARD\" type=\"submit\" name=\"cancel\" value=\"".adm_translate("Abandonner")."\">\n";
                  echo "</form></p>\n";
                  closetable();
               }
               $wdir2="/";
               chdir($basedir . $wdir2);
               include("footer.php");
            }
            break;

        case "show":
            if ($admintest and $filemanager) {
               $filelocation = $wdir.$file;
               $lastaction = adm_translate("Affichage")." : $file";
               $hlpfile = "manuels/$language/filemanager.html";
               include("header.php");
               GraphicAdmin($hlpfile);
               html_header();
               if ($image == "1") {
                  echo "<p align=\"center\"><img src=\"$file\" alt=\"\" border=\"\" /></p>";
               } else {
                  show_source($basedir.$file);
               }
               closetable();
               include("footer.php");
            }
            break;

        case "mkdir":
            if ($admintest and $filemanager) {
               if (file_exists($basedir.$wdir.$mkdirfile)) {
                  $lastaction = adm_translate("Le rpertoire")." $wdir$mkdirfile ".adm_translate("existe dj.");
                  $hlpfile = "manuels/$language/filemanager.html";
                  include("header.php");
                  GraphicAdmin($hlpfile);
                  html_header();
               } else {
                  if ($admintest and $filemanager) {
                     $lastaction = adm_translate("Crer le rpertoire")." : $wdir$mkdirfile";
                     $hlpfile = "manuels/$language/filemanager.html";
                     include("header.php");
                     GraphicAdmin($hlpfile);
                     html_header();
                     @umask("0000");
                     @mkdir($basedir.$wdir.$mkdirfile,0777);
                  }
               }
               displaydir("maj");
               closetable();
               $wdir2="/";
               chdir($basedir . $wdir2);
               include("footer.php");
            }
            break;

        case "createfile":
            if ($admintest and $filemanager) {
               $filelocation = $wdir.$file;
               if ($done == "1") {
                  $lastaction = adm_translate("Cr")." : $file";
                  $hlpfile = "manuels/$language/filemanager.html";
                  include("header.php");
                  GraphicAdmin($hlpfile);
                  html_header();
                  $fp=@fopen($basedir.$filelocation,"w");
                     @fputs($fp,stripslashes($code));
                  @fclose($fp);
                  displaydir("maj");
               } else {
                  if (file_exists($basedir.$filelocation)) {
                     $lastaction = "$file ".adm_translate("existe dj.");
                     $hlpfile = "manuels/$language/filemanager.html";
                     include("header.php");
                     GraphicAdmin($hlpfile);
                     html_header();
                     displaydir("maj");
                  } else {
                     $lastaction = adm_translate("Cration")." : $file";
                     $hlpfile = "manuels/$language/filemanager.html";
                     include("header.php");
                     GraphicAdmin($hlpfile);
                     html_header();
                     echo "<p align=\"center\"><form method=\"post\" action=\"admin.php\">\n";
                     echo "<input type=\"hidden\" name=\"file\" value=\"$file\">\n";
                     echo "<input type=\"hidden\" name=\"op\" value=\"createfile\">\n";
                     echo "<input type=\"hidden\" name=\"wdir\" value=\"$wdir\">\n";
                     echo "<input type=\"hidden\" name=\"done\" value=\"1\">\n";
                     echo "<textarea name=\"code\" class=\"textbox\" rows=\"$textrows\" cols=\"$textcols\">\n";
                     if (isset($html)) {
                        include("meta/meta.php");
                        echo "<title>".adm_translate("Sans titre")."</title>\n";
                        echo "</head>\n";
                        echo "<body>\n\n\n\n";
                        echo "</body>\n";
                        echo "</html>";
                     }
                     echo "</textarea><br /><br />\n";
                     echo "<input class=\"BOUTON_STANDARD\" type=\"submit\" name=\"confirm\" value=\"".adm_translate("Enregistrer")."\"> - \n";
                     echo "<input class=\"BOUTON_STANDARD\" type=\"submit\" name=\"cancel\" value=\"".adm_translate("Abandonner")."\">\n";
                     echo "</form></p>";
                  }
               }
               closetable();
               $wdir2="/";
               chdir($basedir . $wdir2);
               include("footer.php");
            }
            break;

        // CRITIQUES
        case "reviews":
        case "mod_main":
        case "add_review":
             include("admin/reviews.php");
             break;
        case "deleteNotice":
             mysql_query("delete from reviews_add WHERE id='$id'");
             Header("Location: admin.php?op=$op_back");
             break;
        // CRITIQUES

        // FORUMS
        case "ForumConfigAdmin":
             include ("admin/phpbbconfig.php");
             ForumConfigAdmin();
             break;
        case "ForumConfigChange":
             include ("admin/phpbbconfig.php");
             ForumConfigChange($allow_html,$allow_bbcode,$allow_sig,$posts_per_page,$hot_threshold,$topics_per_page,$allow_upload_forum,$allow_forum_hide,$rank1,$rank2,$rank3,$rank4,$rank5,$anti_flood,$solved);
             break;

        case "MaintForumAdmin":
             include ("admin/phpbbmaint.php");
             ForumMaintAdmin();
             break;
        case "MaintForumMarkTopics":
             include ("admin/phpbbmaint.php");
             ForumMaintMarkTopics();
             break;
        case "MaintForumTopics":
             include ("admin/phpbbmaint.php");
             ForumMaintTopics($before, $forum_name);
             break;
        case "MaintForumTopicDetail":
             include ("admin/phpbbmaint.php");
             ForumMaintTopicDetail($topic, $topic_title);
             break;
        case "SynchroForum":
             include ("admin/phpbbmaint.php");
             SynchroForum();
             break;
        case "ForumMaintTopicSup":
             include ("admin/phpbbmaint.php");
             ForumMaintTopicSup($topic);
             break;
        case "ForumMaintTopicMassiveSup":
             include ("admin/phpbbmaint.php");
             ForumMaintTopicMassiveSup($topics);
             break;
        case "MergeForum":
             include ("admin/phpbbmaint.php");
             MergeForum();
             break;
        case "MergeForumAction":
             include ("admin/phpbbmaint.php");
             MergeForumAction($oriforum,$destforum);
             break;

        case "ForumGoAdd":
             include ("admin/phpbbforum.php");
             ForumGoAdd($forum_name, $forum_desc, $forum_access, $forum_mod, $cat_id, $forum_type, $forum_pass, $arbre, $attachement, $forum_index, $ctg);
             break;
        case "ForumGoSave":
             include ("admin/phpbbforum.php");
             ForumGoSave($forum_id, $forum_name, $forum_desc, $forum_access, $forum_mod, $cat_id, $forum_type, $forum_pass, $arbre, $attachement, $forum_index, $ctg);
             break;
        case "ForumCatDel":
             include ("admin/phpbbforum.php");
             ForumCatDel($cat_id, $ok);
             break;
        case "ForumGoDel":
             include ("admin/phpbbforum.php");
             ForumGoDel($forum_id, $ok);
             break;
        case "ForumCatSave":
             include ("admin/phpbbforum.php");
             ForumCatSave($old_cat_id, $cat_id, $cat_title);
             break;
        case "ForumCatEdit":
             include ("admin/phpbbforum.php");
             ForumCatEdit($cat_id);
             break;
        case "ForumGoEdit":
             include ("admin/phpbbforum.php");
             ForumGoEdit($forum_id,$ctg);
             break;
        case "ForumGo":
             include ("admin/phpbbforum.php");
             ForumGo($cat_id);
             break;
        case "ForumCatAdd":
             include ("admin/phpbbforum.php");
             ForumCatAdd($catagories);
             break;
        case "ForumAdmin":
             include ("admin/phpbbforum.php");
             ForumAdmin();
             break;
        // FORUMS

        // DOWNLOADS
        case "DownloadDel":
             include ("admin/download.php");
             DownloadDel($did, $ok);
             break;
        case "DownloadAdd":
             include ("admin/download.php");
             DownloadAdd($dcounter, $durl, $dfilename, $dfilesize, $dweb, $duser, $dver, $dcategory, $sdcategory, $xtext, $privs, $Mprivs);
             break;
        case "DownloadSave":
             include ("admin/download.php");
             DownloadSave($did, $dcounter, $durl, $dfilename, $dfilesize, $dweb, $duser, $ddate, $dver, $dcategory, $sdcategory, $xtext, $privs, $Mprivs);
             break;
        case "DownloadAdmin":
             include ("admin/download.php");
             DownloadAdmin();
             break;
        case "DownloadEdit":
             include ("admin/download.php");
             DownloadEdit($did);
             break;
        // DOWNLOADS

        // FAQ
        case "FaqCatSave":
             include ("admin/adminfaq.php");
             FaqCatSave($old_id_cat, $id_cat, $categories);
             break;
        case "FaqCatGoSave":
             include ("admin/adminfaq.php");
             FaqCatGoSave($id, $question, $answer);
             break;
        case "FaqCatAdd":
             include ("admin/adminfaq.php");
             FaqCatAdd($categories);
             break;
        case "FaqCatGoAdd":
             include ("admin/adminfaq.php");
             FaqCatGoAdd($id_cat, $question, $answer);
             break;
        case "FaqCatEdit":
             include ("admin/adminfaq.php");
             FaqCatEdit($id_cat);
             break;
        case "FaqCatGoEdit":
             include ("admin/adminfaq.php");
             FaqCatGoEdit($id);
             break;
        case "FaqCatDel":
             include ("admin/adminfaq.php");
             FaqCatDel($id_cat, $ok);
             break;
        case "FaqCatGoDel":
             include ("admin/adminfaq.php");
             FaqCatGoDel($id, $ok);
             break;
        case "FaqAdmin":
             include ("admin/adminfaq.php");
             FaqAdmin();
             break;
        case "FaqCatGo":
             include ("admin/adminfaq.php");
             FaqCatGo($id_cat);
             break;
        // FAQ

        // AUTOMATED
        case "autoStory":
        case "autoEdit":
        case "autoDelete":
        case "autoSaveEdit":
             include("admin/automated.php");
             break;
        // AUTOMATED

        // NEWS
        case "submissions":
             include("admin/submissions.php");
             break;
        // NEWS

        // REFERANTS
        case "HeadlinesDel":
        case "HeadlinesAdd":
        case "HeadlinesSave":
        case "HeadlinesAdmin":
        case "HeadlinesEdit":
             include("admin/headlines.php");
             break;
        // REFERANTS

        // PREFERENCES
        case "Configure":
        case "ConfigSave":
            include("admin/settings.php");
            break;
        // PREFERENCES

        // EPHEMERIDS
        case "Ephemeridsedit":
        case "Ephemeridschange":
        case "Ephemeridsdel":
        case "Ephemeridsmaintenance":
        case "Ephemeridsadd":
        case "Ephemerids":
            include("admin/ephemerids.php");
            break;
        // EPHEMERIDS

        // LINKS
        case "links":
        case "LinksDelNew":
        case "LinksAddCat":
        case "LinksAddSubCat":
        case "LinksAddLink":
        case "LinksAddEditorial":
        case "LinksModEditorial":
        case "LinksDelEditorial":
        case "LinksCleanVotes":
        case "LinksListBrokenLinks":
        case "LinksDelBrokenLinks":
        case "LinksIgnoreBrokenLinks":
        case "LinksListModRequests":
        case "LinksChangeModRequests":
        case "LinksChangeIgnoreRequests":
        case "LinksDelCat":
        case "LinksModCat":
        case "LinksModCatS":
        case "LinksModLink":
        case "LinksModLinkS":
        case "LinksDelLink":
        case "LinksDelVote":
        case "LinksDelComment":
        case "suite_links":
            include("admin/links.php");
            break;
        // LINKS

        // BANNERS
        case "BannersAdmin":
        case "BannersAdd":
        case "BannerAddClient":
        case "BannerFinishDelete":
        case "BannerDelete":
        case "BannerEdit":
        case "BannerChange":
        case "BannerClientDelete":
        case "BannerClientEdit":
        case "BannerClientChange":
             include("admin/banners.php");
             break;
        // BANNERS

        // HTTP Referer
        case "hreferer":
        case "delreferer":
        case "archreferer":
             include("admin/referers.php");
             break;
        // HTTP Referer

        // TOPIC Manager
        case "topicsmanager":
        case "topicedit":
        case "topicmake":
        case "topicdelete":
        case "topicchange":
        case "relatedsave":
        case "relatededit":
        case "relateddelete":
             include("admin/topics.php");
             break;
        // TOPIC Manager

        // SECTIONS - RUBRIQUES
        case "new_rub_section":
        case "sections":
        case "sectionedit":
        case "sectionmake":
        case "sectiondelete":
        case "sectionchange":
        case "rubriquedit":
        case "rubriquemake":
        case "rubriquedelete":
        case "rubriquechange":
        case "secarticleadd":
        case "secartedit":
        case "secartchange":
        case "secartchangeup":
        case "secartdelete":
        case "secartpublish":
        case "secartupdate":
        case "secartdelete2":
        case "ordremodule":
        case "ordrechapitre":
        case "ordrecours":
        case "majmodule":
        case "majchapitre":
        case "majcours":
        case "publishcompat":
        case "updatecompat":
        case "droitauteurs":
        case "updatedroitauteurs":
        case "menu_dyn":
             include("admin/sections.php");
             break;
        // SECTIONS - RUBRIQUES

        // BLOCKS
        case "blocks":
              include("admin/blocks.php");
              break;

             case "makerblock":
             case "deleterblock":
             case "changerblock":
             case "gaucherblock":
                  include("admin/rightblocks.php");
                  break;

             case "makelblock":
             case "deletelblock":
             case "changelblock":
             case "droitelblock":
                  include("admin/leftblocks.php");
                  break;

        case "ablock":
        case "changeablock":
             include("admin/adminblock.php");
             break;

        case "mblock":
        case "changemblock":
              include("admin/mainblock.php");
              break;
        // BLOCKS

        // COMMENT
        case "RemoveComment":
        case "RemovePollComment":
              include("admin/comments.php");
              break;
        // COMMENT

        // STORIES
        case "DisplayStory":
        case "PreviewAgain":
        case "PostStory":
        case "DeleteStory":
        case "EditStory":
        case "ChangeStory":
        case "RemoveStory":
        case "adminStory":
        case "PreviewAdminStory":
        // CATEGORIES des NEWS
        case "EditCategory":
        case "DelCategory":
        case "YesDelCategory":
        case "NoMoveCategory":
        case "SaveEditCategory":
        case "AddCategory":
        case "SaveCategory":
             include("admin/stories.php");
             break;
        // CATEGORIES des NEWS
        // STORIES

        // AUTHORS
        case "mod_authors":
        case "modifyadmin":
        case "UpdateAuthor":
        case "AddAuthor":
        case "deladmin":
        case "deladminconf":
             include("admin/authors.php");
             break;
        // AUTHORS

        // USERS
        case "mod_users":
        case "modifyUser":
        case "updateUser":
        case "delUser":
        case "delUserConf":
        case "addUser":
        case "extractUserCSV":
        case "unsubUser":
             include("admin/users.php");
             break;
        // USERS

        // SONDAGES
        case "create":
        case "createPosted":
        case "remove":
        case "removePosted":
        case "editpoll":
        case "editpollPosted":
        case "SendEditPoll":
             include("admin/polls.php");
             break;
        // SONDAGES

        // DIFFUSION MI ADMIN
        case "email_user":
        case "send_email_to_user":
             include("admin/email_user.php");
             break;
        // DIFFUSION MI ADMIN

        // LNL
        case "lnl":
            include("admin/lnl.php");
            break;
            case "lnl_Sup_Header":
               $op="Sup_Header";
               include("admin/lnl.php");
               break;
            case "lnl_Sup_Body":
               $op="Sup_Body";
               include("admin/lnl.php");
               break;
            case "lnl_Sup_Footer":
               $op="Sup_Footer";
               include("admin/lnl.php");
               break;
            case "lnl_Sup_HeaderOK":
               $op="Sup_HeaderOK";
               include("admin/lnl.php");
               break;
            case "lnl_Sup_BodyOK":
               $op="Sup_BodyOK";
               include("admin/lnl.php");
               break;
            case "lnl_Sup_FooterOK":
               $op="Sup_FooterOK";
               include("admin/lnl.php");
               break;
            case "lnl_Shw_Header":
               $op="Shw_Header";
               include("admin/lnl.php");
               break;
            case "lnl_Shw_Body":
               $op="Shw_Body";
               include("admin/lnl.php");
               break;
            case "lnl_Shw_Footer":
               $op="Shw_Footer";
               include("admin/lnl.php");
               break;
            case "lnl_Add_Header":
               $op="Add_Header";
               include("admin/lnl.php");
               break;
               case "lnl_Add_Header_Submit":
                  $op="Add_Header_Submit";
                  include("admin/lnl.php");
                  break;
               case "lnl_Add_Header_Mod":
                  $op="Add_Header_Mod";
                  include("admin/lnl.php");
                  break;
            case "lnl_Add_Body":
               $op="Add_Body";
               include("admin/lnl.php");
               break;
               case "lnl_Add_Body_Submit":
                  $op="Add_Body_Submit";
                  include("admin/lnl.php");
                  break;
               case "lnl_Add_Body_Mod":
                  $op="Add_Body_Mod";
                  include("admin/lnl.php");
                  break;
            case "lnl_Add_Footer":
               $op="Add_Footer";
               include("admin/lnl.php");
               break;
               case "lnl_Add_Footer_Submit":
                  $op="Add_Footer_Submit";
                  include("admin/lnl.php");
                  break;
               case "lnl_Add_Footer_Mod":
                  $op="Add_Footer_Mod";
                  include("admin/lnl.php");
                  break;
            case "lnl_Test":
               $op="Test";
               include("admin/lnl.php");
               break;
            case "lnl_Send":
               $op="Send";
               include("admin/lnl.php");
               break;
            case "lnl_List":
               $op="List";
               include("admin/lnl.php");
               break;
            case "lnl_User_List":
               $op="User_List";
               include("admin/lnl.php");
               break;
            case "lnl_Sup_User":
               $op="Sup_User";
               include("admin/lnl.php");
               break;
        // LNL

        // SUPERCACHE
        case "supercache":
        case "supercache_save":
        case "supercache_empty":
             include("admin/overload.php");
             break;
        // SUPERCACHE

        // OPTIMYSQL
        case "OptimySQL":
             include("admin/optimysql.php");
             break;
        // OPTIMYSQL

        // SAVEMYSQL
        case "SavemySQL":
             include("admin/savemysql.php");
             break;
        // SAVEMYSQL

        // EDITO
        case "Edito":
        case "Edito_save":
        case "Edito_load":
             include("admin/adminedito.php");
             break;
        // EDITO

        // METATAGS
        case "MetaTagAdmin":
        case "MetaTagSave":
             include("admin/metatags.php");
             break;
        // METATAGS

        // ConfigFiles
        case "ConfigFiles":
        case "ConfigFiles_load":
        case "ConfigFiles_save":
        case "ConfigFiles_create":
        case "delete_configfile":
        case "ConfigFiles_delete":
             include("admin/configfiles.php");
             break;
        // ConfigFiles

        // NPDS-Admin-Plugins
        case "Extend-Admin-Module":
        case "Extend-Admin-SubModule":
             include("admin/plugins.php");
             break;
        // NPDS-Admin-Plugins

        // NPDS-Admin-Groupe
        case "groupes";
        case "groupe_edit":
        case "groupe_maj":
        case "groupe_add":
        case "groupe_add_finish":
        case "retiredugroupe":
        case "membre_add":
        case "membre_add_finish":
             include("admin/groupes.php");
             break;
        // NPDS-Admin-Groupe

        // NPDS-Instal-Modules
        case "Modules":
          include("admin/modules.php");
             break;
        case "Module-Install":
          include("admin/module-install.php");
             break;
        // NPDS-Instal-Modules

        // NPDS-Admin-Main
        case "suite_articles":
             adminMain($deja_affiches);
             break;

        case "adminMain":
        default:
             adminMain(0);
             break;
        // NPDS-Admin-Main
   }
} else {
   login();
}
?>