<?PHP
/************************************************************************/
/* DUNE by NPDS                                                         */
/* ===========================                                          */
/*                                                                      */
/* NPDS Copyright (c) 2002-2007 by Philippe Brunier                     */
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/
include ("../../grab_globals.php");
include ("../../config.php");

function getip_uploadphp() {
   if (isSet($_SERVER)) {
      if (isSet($_SERVER["HTTP_X_FORWARDED_FOR"])) {
         $realip = $_SERVER["HTTP_X_FORWARDED_FOR"];
      } elseif (isSet($_SERVER["HTTP_CLIENT_IP"])) {
         $realip = $_SERVER["HTTP_CLIENT_IP"];
      } else {
         $realip = $_SERVER["REMOTE_ADDR"];
      }
   } else {
      if ( getenv( 'HTTP_X_FORWARDED_FOR' ) ) {
         $realip = getenv( 'HTTP_X_FORWARDED_FOR' );
      } elseif ( getenv( 'HTTP_CLIENT_IP' ) ) {
         $realip = getenv( 'HTTP_CLIENT_IP' );
      } else {
         $realip = getenv( 'REMOTE_ADDR' );
      }
   }
   return ($realip);
}
function upload_s($fcontents) {
   // Remove for security reasons
   $fcontents=eregi_replace("/etc","",$fcontents);
   $fcontents=eregi_replace("\.\.","",$fcontents);
   $fcontents=eregi_replace("config.php","",$fcontents);
   $fcontents=eregi_replace("\">","",$fcontents);
   // Gestion des type de fichier autoris
   if ($fcontents!="") {
      $suffix = trim(strtoLower(substr(strrchr($fcontents,'.'),1)));
      if ($extension_autorise=="") {$extension_autorise="doc xls txt zip rar pdf gif jpg png";}
      if (!stristr($extension_autorise,$suffix)) {
         echo "<br /><p align=\"center\" class=\"rouge\">".upload_translate("Ce type de fichier n'est pas autoris")."</p>";
         $fcontents="";
         die();
      }
   }
   return( $fcontents);
}
   include_once("upload.conf.php");
   $module_mark=true;
   include_once("../../lib/multi-langue.php");
   include_once("lang/upload.lang-$language.php");

   $Titlesitename="NPDS - ".upload_translate("Tlcharg.");
   include("../../meta/meta.php");
   // CSS externalisation
   if ($url_upload_css) {
      $url_upload_cssX=str_replace("style.css","$language-style.css",$url_upload_css);
      if (is_readable($url_upload.$url_upload_cssX))
         $url_upload_css=$url_upload_cssX;
      print ("<link href=\"".$url_upload.$url_upload_css."\" title=\"default\" rel=\"stylesheet\" type=\"text/css\" media=\"all\" />\n");
   }
   echo "</head>\n<body>";
   echo "<table width=\"100%\" cellspacing=\"2\" cellpadding=\"2\" border=\"0\">";
   echo "<tr><td>";

   if ($DOCUMENTROOT!="") {
      $rep=$DOCUMENTROOT;
   } else {
      if ($DOCUMENT_ROOT) {
         $rep=$DOCUMENT_ROOT;
      } else {
         $rep=$_SERVER['DOCUMENT_ROOT'];
      }
   }

   if (empty($numero)) {$numero=0;}
   $erreur=false;
   if ($op=="upload") {
      include_once("clsUpload.php");
      $upload = new Upload();
      $upload->maxupload_size = $max_size;
      $field1_filename = trim($upload->getFileName("file1"));
      $field1_filename = upload_s($field1_filename);
      if (urldecode($ficname)==$field1_filename) {
         if ($user) {
            $userX = base64_decode($user);
            $cookie = explode(":", $userX);
            if (trim($cookie[1])!="") {
               $uname=$cookie[1];
               if ($autorise_upload_p) {
                  $rep_upload_dest=$rep.$racine."/users_private/".$uname."/";
                  if (!is_dir($rep_upload_dest)) {
                     $rep_upload_dest=$rep.$rep_upload;
                  }
               } else {
                  $rep_upload_dest=$rep.$rep_upload;
               }
            }
         } else {
            $rep_upload_dest=$rep.$rep_upload;
         }

         if ($upload->saveAs($field1_filename ,$rep_upload_dest, "file1",true)) {
            $numero++;
         } else {
            echo "<span class=\"rouge\">".$upload->errors."</span><br />";
            $erreur=true;
         }
      } else {
         echo "<span class=\"rouge\">".upload_translate("Ce type de fichier n'est pas autoris")." : $field1_filename</span><br />";
      }
   }

   $ibid=@array_unique(@file($rep.$rep_cache.$name_tmp.".tmp"));
   if ($ibid) {
      for ($i = 0; $i <= count($ibid)-1; $i++) {
         $fcontents[$i]=current($ibid);
         next($ibid);
      }
   }

   $fcontents[$numero]=upload_s($fcontents[$numero]);
   if ($fcontents[$numero]!="") {
      if (strrpos($fcontents[$numero],"/"))
         $ficname=trim(substr($fcontents[$numero],strrpos($fcontents[$numero],"/")+1));
      elseif (strrpos($fcontents[$numero],"\\"))
         $ficname=trim(substr($fcontents[$numero],strrpos($fcontents[$numero],"\\")+1));
      else
         $ficname=trim(substr($fcontents[$numero],strrpos($fcontents[$numero],"%5C")+3));

      $fic =urldecode(str_replace("/","\\",$fcontents[$numero]));
      echo upload_translate("Slectionner le nom affich (chemin complet), copier le dans le champ [Fichier] et cliquez sur OK.")."<hr noshade>";
      echo "<b>".upload_translate("Pices jointes :")."</b> => $fic <br /><br />
            <form name=\"fileU\" method=\"post\" enctype=\"multipart/form-data\" action=\"".$url_upload.$racine."/modules/upload/upload.php\">";
      echo upload_translate("Fichier :")." <input class=\"textbox_standard\" type=\"file\" name=\"file1\" size=\"50\" maxlength=\"255\">
            <input class=\"textbox_standard\" type=\"submit\" value=\"OK\">
            <input type=\"hidden\" name=\"MAX_FILE_SIZE\" value=\"$max_size\">
            <input type=\"hidden\" name=\"op\" value=\"upload\">
            <input type=\"hidden\" name=\"numero\" value=\"$numero\">
            <input type=\"hidden\" name=\"ficname\" value=\"$ficname\">
            <input type=\"hidden\" name=\"name_tmp\" value=\"$name_tmp\">
            </form>";
   } else {
      if ($fp = @fopen($rep.$rep_cache.$name_tmp.".tmp", 'a')){
         fwrite($fp,"upload_OK");
         fclose($fp);
      }
      $logfile = $rep.$rep_log;
      $fp = fopen($logfile, 'a');
      flock($fp, 2);
      fseek($fp, filesize($logfile));
      $ibid = sprintf("%-10s %-60s %-10s\r\n",date("m/d/Y H:i:s",time()),basename($GLOBALS[PHP_SELF])."=>"."Upload File(s) : ".getip_uploadphp(),strip_tags(urldecode($name_tmp)));
      fwrite($fp, $ibid);
      flock($fp, 3);
      fclose($fp);

      if (!$erreur) {
         echo "<script type=\"text/javascript\" language=\"JavaScript\">
               <!--
               self.close();
               //-->
               </script>\n";
      }
   }
   echo "</td></tr></table>";
   echo "</body></html>";
?>