<?php
/************************************************************************/
/* DUNE by NPDS                                                         */
/* ===========================                                          */
/*                                                                      */
/* NPDS Copyright (c) 2002-2011 by Philippe Brunier                     */
/* IZ-Xmaj version : 1.1.3                                              */
/*                                                                      */
/* Auteurs : v.0.1.0 EBH                                                */
/*         : v.1.1.2 jpb, phr                                           */
/*         : v.1.1.3 jpb, Dev                                           */
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/

// Bloque le lancement de l'install si IZ-Xinstall.ok existe
if (file_exists("IZ-Xinstall.ok")) {
   // Car c'est une MAJ d'une version potentiellement installe avec IZX
   @unlink("IZ-Xinstall.ok");
   // include("admin/die.php");
}

#####################################################################
# Paramtres du CMS
#####################################################################

$cms_logo = "install/images/header.png";
$cms_name = "NPDS REvolution 11";
$previous_version = "NPDS REvolution 10.02";
global $cms_logo,$cms_name,$previous_version;

#####################################################################
# Contrle des fichiers de base de IZ-Xmaj
#####################################################################

if (file_exists('grab_globals.php'))
   include ('grab_globals.php');

if (file_exists('install/libraries/graphIZm.php'))
   include ('install/libraries/graphIZm.php');

if (file_exists('install/libraries/lib-inc.php'))
   include ('install/libraries/lib-inc.php');

if(!isset($stage)) { $stage = 0; }

#################################################################################
# install/etape_0.php
# Accueil :
#   => install/languages/english/welcome.txt
#   => install/languages/francais/accueil.txt
# Choix de la classe :
#   0 : mise  jour manuelle
#   1 : mise  jour semi automatique
#################################################################################

if(($stage == 0) OR (!isset($classe)))
{
   $colorst1 = "#000000";
   $colorst2 = "#000000";
   $colorst3 = "#000000";
   $colorst4 = "#000000";
   $colorst5 = "#000000";
   $colorst6 = "#000000";
   $colorst7 = "#000000";
   $colorst8 = "#000000";
   $colorst9 = "#000000";
   entete();
   require("install/etape_0.php");
   bienvenue();
   pied_depage();
}

#################################################################################
# install/etape_6.php
# Cration/Mise  jour de la base de donnes
#################################################################################

if(($stage == 6) OR ($classe == 1))
{
   $colorst1 = "#005f3a";
   $colorst2 = "#005f3a";
   $colorst3 = "#005f3a";
   $colorst4 = "#005f3a";
   $colorst5 = "#005f3a";
   $colorst6 = "#FF9900";
   $colorst7 = "#000000";
   $colorst8 = "#000000";
   $colorst9 = "#000000";
   entete();
   menu();
   require("install/etape_6.php");
   if (!isset($op)) { $op = "etape_6"; }

   // Pour gnrer les ordres SQL PHP de MAJ
   //$op="write_database";
   //$classe=0;

   switch($op) {
     case "write_database":
       global $stage, $classe, $langue, $stage6_ok,$NPDS_Prefix,$pre_tab;
       if ($classe == 0) {
          include("config.php");
          require("install/sql/build_sql-create.php");
          build_sql_create($NPDS_Prefix);
          mysql_connex();
          require("install/sql/sql-create.php");
          write_database();
          echo "<table border=\"0\" cellpadding=\"2\" cellspacing=\"1\" width=\"100%\">
          <tr class=\"tableau_titre\">
          <td align=\"center\" class=\"headform\">".ins_translate("Base de donnes")."</td>
          </tr>
          <tr>
          <td align=\"center\"><br />";
          if ($stage6_ok == 1) {
             $msg = "La base de donnes a t cre avec succs !";
          } elseif($stage6_ok == 0) {
             $msg = "La base de donnes n'a pas pu tre cre. Vrifiez les paramtres ainsi que vos fichiers, puis ressayez  nouveau.";
          }
          echo "<form name=\"next\" method=\"post\" action=\"install.php\">
             <table border=\"0\" cellpadding=\"2\" cellspacing=\"1\">
             <tr>
              <td>".ins_translate($msg)."</td>
             </tr>
             </table><br /><br />";
          if ($stage6_ok == 1) {
             echo "<div style=\"text-align: center\">
                <input type=\"hidden\" name=\"classe\" value=\"".$classe."\" />
                <input type=\"hidden\" name=\"langue\" value=\"".$langue."\" />
                <input type=\"hidden\" name=\"stage\" value=\"7\" />
                <input type=\"submit\" class=\"bouton_standard\" value=\"".ins_translate(" Etape suivante ")."\" />
                </div><br />";
          }
          echo "</form>
                </td></tr></table></table></table><br />";
          unset($stage6_ok);
       }
       break;
     case "update_database":
         global $stage, $classe, $langue, $stage6_ok,$NPDS_Prefix;
         if ($classe == 1) {
            include("config.php");
            if ($Version_Num=="10.02") {
               mysql_connex();
               require("install/sql/sql-update.php");
               update_database();
               echo "<table border=\"0\" cellpadding=\"2\" cellspacing=\"1\" width=\"100%\">
               <tr class=\"tableau_titre\">
               <td align=\"center\" class=\"headform\">".ins_translate("Base de donnes")."</td>
               </tr>
               <tr>
               <td align=\"center\"><br />";
               if ($stage6_ok == 1) {
                  $msg = "La base de donnes a t mise  jour avec succs !";
               } elseif ($stage6_ok == 0) {
                  $msg = "La base de donnes n'a pas pu tre modifie. Vrifiez les paramtres ainsi que vos fichiers, puis ressayez  nouveau.";
               }
               echo "<form name=\"next\" method=\"post\" action=\"install.php\">
                  <table border=\"0\" cellpadding=\"2\" cellspacing=\"1\">
                  <tr>
                  <td>".ins_translate($msg)."<br /><br /></td>
                  </tr>";
               if ($stage6_ok == 1) {
                  $Xinst_log = date('d/m/y  H:j:s').'Mise  jour d\'une '.$previous_version.' vers '.$cms_name;
                  $file = fopen("slogs/install.log", "w");
                  fwrite($file, $Xinst_log);
                  fclose($file);
                  echo "<tr>
                     <td>".ins_translate("Remarque : pour achever la mise  jour : dans l'interface d'administration valider les prfrences et les metatags")."<br />".$replog."</td>
                     </tr>
                     </table><br /><br />
                     <div style=\"text-align: center\">
                     <input type=\"hidden\" name=\"classe\" value=\"0\" />
                     <input type=\"hidden\" name=\"langue\" value=\"".$langue."\" />
                     <input type=\"hidden\" name=\"stage\" value=\"9\" />
                     <input type=\"submit\" class=\"bouton_standard\" value=\"".ins_translate(" Etape suivante ")."\" />
                     </div><br />";
               } else {
                  echo "</table><br /><br />";
               }
               echo "</form>
                     </td></tr></table></table></table><br />";
               unset($stage6_ok);
            } else {
               echo "<table border=\"0\" cellpadding=\"2\" cellspacing=\"1\" width=\"100%\">
                 <tr class=\"tableau_titre\">
                 <td align=\"center\" class=\"headform\">".ins_translate("Base de donnes")."</td>
                 </tr>
                 <tr>
                 <td align=\"center\"><br />
                 <div style=\"font-weight: bold; color: #ff0000\">".ins_translate("Votre version de NPDS est incorrecte, version requise")." : ".$previous_version."</div><br />
                 </td></tr></table></table></table><br />";
            }
         }
         break;
     case "etape_6":
     default:
         etape_6();
         break;
   }
   pied_depage();
}
#################################################################################
# install/etape_9.php
# suppression du fichier install.php et du dossier install et redirection sur index.php
# Fin
#################################################################################

if(($stage == 9) AND ($classe == 0))
{
   $colorst1 = "#005f3a";
   $colorst2 = "#005f3a";
   $colorst3 = "#005f3a";
   $colorst4 = "#005f3a";
   $colorst5 = "#005f3a";
   $colorst6 = "#005f3a";
   $colorst7 = "#005f3a";
   $colorst8 = "#005f3a";
   $colorst9 = "#FF9900";
   entete();
   menu();
   require("install/etape_9.php");
   if(!isset($op)) { $op = "etape_9"; }
   switch($op)
   {
      case "write_ok":
         $fp = fopen("IZ-Xinstall.ok", "w");
         fclose($fp);

         // La suppression de l'installation
         function icare_delete_Dir($rep) {
            $dir = opendir($rep);
            chdir($rep);
            while(false!==($nom = readdir($dir))) {
               if ($nom != "." && $nom != ".." && $nom != "") {
                  if (is_dir($nom)) {
                     $archive[$nom] = icare_delete_Dir($nom);
                     @rmdir($nom);
                  } elseif(is_file($nom)) {
                     @unlink($nom);
                  }
               }
            }
            chdir("..");
            closedir($dir);
            return $archive;
         }

         if (file_exists("IZ-Xinstall.ok")) {
            if (file_exists("install.php") OR is_dir("install")) {
               // Suppression de l'installation
               icare_delete_Dir('install');
               @rmdir ('install');
               @unlink('install.php');

               // Suppression de l'ancien editeur
               chdir('editeur');
                  icare_delete_Dir('editor_images');
                  @rmdir ('editor_images');
                  icare_delete_Dir('plugins');
                  @rmdir ('plugins');
                  chdir('tiny_mce/plugins/media');
                     icare_delete_Dir('img');
                     @rmdir ('img');
                     @unlink('css/content.css');
               chdir("../../../..");
               @unlink('editeur/editor.htm');
               @unlink('editeur/editor.php');
               @unlink('editeur/editor_plugins.php');
               @unlink('editeur/meta_lang.php');
               @unlink('editeur/pd_edit.htm');

               @unlink('language/editor-chinese.php');
               @unlink('language/editor-english.php');
               @unlink('language/editor-french.php');
               @unlink('language/editor-spanish.php');

               // Suppression autres fichiers
               @unlink('sample.robots.txt');
               @unlink('push.conf.php');
               @unlink('push.js');
               @unlink('push.php');

               @unlink('admin/docu.php');
               @unlink('admin/powerpack_f.php');
               @unlink('admin/static.php');

               chdir('images');
                  icare_delete_Dir('reviews');
                  @rmdir ('reviews');
                  chdir("..");
               @unlink('images/header.jpg');
               @unlink('images/help.jpg');
               @unlink('images/pic-manager.txt');
               @unlink('images/pushlogo.gif');
               @unlink('images/stats/netscape.gif');

               @unlink('language/lang-install-chinese.php');
               @unlink('language/lang-install-english.php');
               @unlink('language/lang-install-french.php');
               @unlink('language/lang-install-spanish.php');
               @unlink('language/pp-lang-chinese.php');
               @unlink('language/pp-lang-english.php');
               @unlink('language/pp-lang-french.php');
               @unlink('language/pp-lang-spanish.php');
               @unlink('language/push-lang-chinese.php');
               @unlink('language/push-lang-english.php');
               @unlink('language/push-lang-french.php');
               @unlink('language/push-lang-spanish.php');

               @unlink('modules/upload/upload.php');
               @unlink('modules/upload/upload_f.php');

               chdir('modules/sform');
                  icare_delete_Dir('documentations');
                  @rmdir ('documentations');
                  chdir("../..");

               @unlink('users_private/user/art.gif');
               @unlink('users_private/user/art.jpg');
               @unlink('users_private/user/bgcode.gif');
            }
         }
         echo "<script type=\"text/javascript\">\n//<![CDATA[\ndocument.location.href='index.php';\n//]]>\n</script>";
         break;
      case "etape_9":
      default;
         etape_9();
         break;
   }
   pied_depage();
}
?>