<?php
/************************************************************************/
/* DUNE by NPDS                                                         */
/* ===========================                                          */
/*                                                                      */
/* BIG mod by JPB for NPDS-WS                                           */
/*                                                                      */
/* NPDS Copyright (c) 2002-2013 by Philippe Brunier                     */
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/
function Access_Error () {
  include("admin/die.php");
}
if (!stristr($_SERVER['PHP_SELF'],"admin.php")) { Access_Error(); }
global $language,$adminimg, $admf_ext;
$hlpfile = "manuels/$language/groupes.html";
$result = sql_query("select radminsdv, radminsuper from ".$NPDS_Prefix."authors where aid='$aid'");
list($radminsdv, $radminsuper) = sql_fetch_row($result);
if (($radminsdv!=1) AND ($radminsuper!=1)) {
   Access_Error();
}

if (file_exists($adminimg.'groupes.'.$admf_ext)) {
   $img_adm ='<img src="'.$adminimg.'groupes.'.$admf_ext.'" class="vam" border="0" alt="'.adm_translate("Gestion des groupes").'" />';
} else
   $img_adm="";

$entete_gr='<h2 style="padding-top:6px;padding-bottom:6px;padding-left:3px;"><a href="admin.php?op=groupes">'.$img_adm.'&nbsp;'.adm_translate("Gestion des groupes").'</a></h2>';

if ($al) {
   if (preg_match ('#^mod#',$al)) {
      $al=explode ('_',$al);
      $mes=adm_translate("Vous ne pouvez pas exclure").' '.$al[1].' '.adm_translate("car il est modrateur unique de forum. Oter ses droits de modration puis retirer le du groupe.");
   }
}

function group_liste() {
   global $hlpfile, $NPDS_Prefix, $entete_gr, $al, $mes;

   include ('header.php');
   GraphicAdmin($hlpfile);
   $result = sql_query("select uid, groupe from ".$NPDS_Prefix."users_status where groupe!='' order by uid ASC");
   $one_gp=false;
   while(list($uid, $groupe) = sql_fetch_row($result)) {
      $one_gp=true;
      $tab_groupe=explode(",",$groupe);
      if ($tab_groupe) {
         foreach($tab_groupe as $groupevalue) {
            if ($groupevalue!="") {
               $tab_groupeII[$groupevalue].=$uid." ";
               $tab_groupeIII[$groupevalue]=$groupevalue;
            }
         }
      }
   }
   echo $entete_gr;
   echo '<script type="text/javascript">
   //<![CDATA[
   //==> choix moderateur
   function choisir_mod_forum(gp,gn,ar_user,ar_uid) {
      var user_json = ar_user.split(",");
      var uid_json = ar_uid.split(",");
      var choix_mod = prompt("'.adm_translate("Choisir un modrateur").' : \n"+user_json);
      if (choix_mod) {
         for (i=0; i<user_json.length; i++) {
            if (user_json[i] == choix_mod) {var ind_uid=i;}
         }
         var xhr_object = null;
         if (window.XMLHttpRequest) // FF
            xhr_object = new XMLHttpRequest();
         else if(window.ActiveXObject) // IE
            xhr_object = new ActiveXObject("Microsoft.XMLHTTP");
         xhr_object.open("GET", "admin.php?op=forum_groupe_create&groupe_id="+gp+"&groupe_name="+gn+"&moder="+uid_json[ind_uid], false);
         xhr_object.send(null);
         document.location.href="admin.php?op=groupes";
      }
   } 
   //<== choix moderateur

   //==> confirmation suppression tous les membres du groupe (done in xhr)
   function delete_AllMembersGroup(grp,ugp) {
      var xhr_object = null;
      if (window.XMLHttpRequest) // FF
         xhr_object = new XMLHttpRequest();
      else if(window.ActiveXObject) // IE
         xhr_object = new ActiveXObject("Microsoft.XMLHTTP");
      if (confirm("'.adm_translate("Vous allez exclure TOUS les membres du groupe").' "+grp+" !")) {
         xhr_object.open("GET", location.href="admin.php?op=retiredugroupe_all&groupe_id="+grp+"&tab_groupe="+ugp, false);
         //xhr_object.send(null); used only if POST method
      }
   }
   //<== confirmation suppression tous les membres du groupe (done in xhr)

   //==> confirmation suppression groupe (done in xhr)
   function confirm_deleteGroup(gr) {
      var xhr_object = null;
      if (window.XMLHttpRequest) // FF
         xhr_object = new XMLHttpRequest();
      else if(window.ActiveXObject) // IE
         xhr_object = new ActiveXObject("Microsoft.XMLHTTP");
      if (confirm("'.adm_translate("Vous allez supprimer le groupe").' "+gr)) {
         xhr_object.open("GET", location.href="admin.php?op=groupe_maj&groupe_id="+gr+"&sub_op='.adm_translate("Supprimer").'", false);
         //xhr_object.send(null); used only if POST method
     }
   }
   //<== confirmation suppression groupe (done in xhr)
   //]]>
   </script>';

   opentable();
   echo '<div class="header" style="font-size:100%; font-weight:bold; padding:3px;" width="100%" >';
   echo '<form action="admin.php" method="post">
   <input type="hidden" name="op" value="groupe_add" />
   <input type="image" src="images/admin/ws/groupe_add.gif" title="'.adm_translate("Ajouter un groupe").'" style="background:none;vertical-align:middle;" border="0" alt="'.adm_translate("Ajouter un groupe").'" />
   </form>';
   echo adm_translate("Liste des groupes");
   echo '<span id="hide_lst_gr" title="'.adm_translate("Replier la liste").'"><img src="images/admin/ws/toggle_minus.gif" class="vam" alt="'.adm_translate("Replier la liste").'" /></span>';
   echo '</div>';
   echo '<table id="lst_gr" width="100%" cellspacing="0" cellpadding="2" border="0">'."\n".'<thead>'."\n";
   echo '<tr>'."\n".'<td align="left" width="5%" class="ongl">'.adm_translate("ID").'</td>'."\n".'<td width="20%" class="ongl">'.adm_translate("Nom").'</td>'."\n".'<td width="50%" class="ongl">'.adm_translate("Liste des membres").'</td>'."\n".'<td align="right" width="25%" class="ongl">';
   echo "\n".'</td>'."\n".'</tr>'."\n".'</thead>'."\n".'<tbody id="gr_dat">'."\n";
   if ($one_gp) {
      sort($tab_groupeIII);
      while (list($bidon,$gp)=each($tab_groupeIII)) {
         $rowcolor = tablos();
         $lst_user_json='';
         $result=sql_fetch_assoc(sql_query("select groupe_id, groupe_name, groupe_description, groupe_forum, groupe_mns, groupe_chat, groupe_blocnote, groupe_pad from ".$NPDS_Prefix."groupes where groupe_id='$gp'"));
         echo '<tr id="bloc_gr_'.$gp.'"'.$rowcolor.'>'."\n".'<td valign="top" align="left" width="5%">'.$gp.'</td>'."\n".'<td valign="top" align="left" width="20%"><img id="gr_'.$gp.'" class="ic_gr" src="images/admin/ws/groupe.gif" class="vam" alt="'.adm_translate("Groupe").'" /><br /><br /><b>'.aff_langue($result['groupe_name']).'</b><p>'.aff_langue($result['groupe_description']);
         if (file_exists ('users_private/groupe/'.$gp.'/groupe.png'))
            echo'<br /><br /><img src="users_private/groupe/'.$gp.'/groupe.png" width="80" height="80" alt="logo_groupe" />';
         echo '</p></td>'."\n".'<td valign="top">';
         $tab_groupe=explode(" ",ltrim($tab_groupeII[$gp]));
         $nb_mb=(count($tab_groupe))-1;
         echo '<img id="mbgr_'.$gp.'" class="ic_mb" src="images/admin/ws/user.gif" style="vertical-align:bottom;" alt="'.adm_translate('membres').'" /> &nbsp;['.$nb_mb.']&nbsp;&nbsp;';
         echo '<span id="show_lst_mb_'.$gp.'" title="'.adm_translate("Dplier la liste").'"><img src="images/admin/ws/toggle_plus.gif" style="vertical-align:bottom;" alt="'.adm_translate("Dplier la liste").'" /></span>&nbsp;&nbsp;';

         $lst_uid_json='';
         $lst_uidna_json='';
         //==> liste membres du groupe
         echo '<ul id="lst_mb_gr_'.$gp.'" style ="display:none; padding-left:10px;">';
         while (list($bidon,$uidX)=each($tab_groupe)) {
            if ($uidX) {
               list($uname,$user_avatar)=sql_fetch_row(sql_query("select uname, user_avatar from ".$NPDS_Prefix."users where uid='$uidX'"));
               $lst_user_json.= $uname.',';
               $lst_uid_json.= $uidX.',';
               $lst_gr_json.='\'mbgr_'.$gp.'\': { gp: \''.$gp.'\'},';
               if (!$user_avatar) {
                  $imgtmp="images/forum/avatar/blank.gif";
               } else if (stristr($user_avatar,"users_private")) {
                  $imgtmp=$user_avatar;
               } else {
                  if ($ibid=theme_image("forum/avatar/$user_avatar")) {$imgtmp=$ibid;} else {$imgtmp="images/forum/avatar/$user_avatar";}
                  if (!file_exists($imgtmp)) {$imgtmp="images/forum/avatar/blank.gif";}
               }
               echo "
               <li id=\"".$uname.$uidX."_".$gp."\" style=\"list-style-type:none\">
               <div style=\"width:100px; float:left;\">
               <a href=\"admin.php?chng_uid=$uidX&amp;op=modifyUser\" class=\"tooltip\">$uname<em style=\"width:80px\"><img src=\"".$imgtmp."\"  height=\"80\" width=\"80\" alt=\"avatar\"/></em></a>
               </div>
               <div><a href=\"admin.php?chng_uid=$uidX&amp;op=modifyUser\" class=\"noir\"><img src=\"images/admin/ws/user_edit.gif\" class=\"vam\" border=\"0\" alt=\"".adm_translate("Editer")."\" title=\"".adm_translate("Editer les informations concernant")." ".$uname."\" /></a>&nbsp;<a href=\"admin.php?op=retiredugroupe&amp;uid=$uidX&amp;uname=$uname&amp;groupe_id=$gp\" ><img src=\"images/admin/ws/user_remove.gif\" class=\"vam\" border=\"0\" alt=\"".adm_translate("Exclure")."\" title=\"".adm_translate("Exclure")." ".$uname." ".adm_translate("du groupe")." ".$gp."\" /></a>&nbsp;";
               //=>traitement moderateur
               if ($result['groupe_forum']==1) {
                  echo'&nbsp;<img src="images/admin/ws/document_user.gif" class="vam" border="0" alt="'.adm_translate("Modrateur").'" title="'.adm_translate("Modrateur").'" />';
                  $pat='#\b'.$uidX.'\b#';
                  $res=sql_query("select f.forum_id, f.forum_name, f.forum_moderator from ".$NPDS_Prefix."forums f where f.forum_pass='$gp'");
                  while ($row = sql_fetch_row($res)) {
                     $ar_moder = explode(',',$row[2]);
                     $tmp_moder=$ar_moder;
                     if (preg_match($pat, $row[2])) {
                        unset($tmp_moder[array_search($uidX, $tmp_moder)]);
                        $new_moder=implode ( ',',$tmp_moder );
                        if (count($tmp_moder)!= 0) {
                           echo'<a href="admin.php?op=moderateur_update&amp;forum_id='.$row[0].'&amp;forum_moderator='.$new_moder.'"><img src="images/admin/ws/modifier_subtract.gif" class="vam" border="0" alt="'.adm_translate("").'" title="'.adm_translate("Oter").' '.$uname.' '.adm_translate("des modrateurs du forum").' '.$row[0].'" /></a>';
                        } else {
                           echo'&nbsp;&nbsp;<img src="images/admin/ws/lock.gif" style="vertical-align:bottom;" border="0" width="16" height="16" alt="" title="'.adm_translate("Ce modrateur")." (".$uname.") ".adm_translate("n'est pas modifiable tant qu'un autre n'est pas nomm pour ce forum").' '.$row[0].'" />';
                        }
                     } else {
                        $tmp_moder[]=$uidX;
                        asort ( $tmp_moder );
                        $new_moder=implode (',',$tmp_moder);
                        echo'&nbsp;&nbsp;<a href="admin.php?op=moderateur_update&amp;forum_id='.$row[0].'&amp;forum_moderator='.$new_moder.'"><img src="images/admin/ws/modifier_add.gif" class="vam" border="0" alt="'.adm_translate("").'" title="'.adm_translate("Nommer").' '.$uname.' '.adm_translate("comme modrateur du forum").' '.$row[1].' ('.$row[0].')" /></a>';
                     }
                  }
               }
               echo "</div>\n</li>\n";
            }
         }
         echo "\n</ul>\n";
         $lst_user_json=rtrim($lst_user_json,',');
         $lst_uid_json=rtrim($lst_uid_json,',');

         //==> pliage repliage listes membres groupes
         echo"\n
         <script type=\"text/javascript\">
         //<![CDATA[
         YUI().use('transition', 'node-event-delegate', 'dd-drop', 'dd-constrain', function (Y) {
            Y.delegate('click', function(e) {
               var buttonID = e.currentTarget.get('id'),
               lst_mb_gr = Y.one('#lst_mb_gr_".$gp."');
               btn_show=Y.one('#show_lst_mb_".$gp."');
               btn_hide=Y.one('#hide_lst_mb_".$gp."');
               if (buttonID === 'show_lst_mb_".$gp."') {
                  lst_mb_gr.show(true);
                  btn_show.set('id','hide_lst_mb_".$gp."');
                  btn_show.set('title','".adm_translate("Replier la liste")."');
                  btn_show.setContent('<img src=\"images/admin/ws/toggle_minus.gif\" style=\"vertical-align:bottom;\" alt=\"".adm_translate("Replier la liste")."\" />');
               } else if (buttonID == 'hide_lst_mb_".$gp."') {
                  lst_mb_gr.transition({
                    duration: 0.2,
                    easing: 'ease-out',
                    opacity: 0
                  });
                  btn_hide=Y.one('#hide_lst_mb_".$gp."');
                  lst_mb_gr.hide(true);
                  btn_hide.set('id','show_lst_mb_".$gp."');
                  btn_hide.set('title','".adm_translate("Dplier la liste")."');
                  btn_hide.setContent('<img src=\"images/admin/ws/toggle_plus.gif\" style=\"vertical-align:bottom;\" alt=\"".adm_translate("Dplier la liste")."\" />');
               }
            }, document, 'span');
         });
         //]]>
         </script>\n";
         //<== pliage repliage listes membres groupes
         echo '<img src="images/admin/ws/user_remove.gif" onclick="delete_AllMembersGroup(\''.$gp.'\',\''.$lst_uid_json.'\');" style="vertical-align:bottom;" title="'.adm_translate('Exclure TOUS les membres du groupe').' '.$gp.'" alt="'.adm_translate('Exclure TOUS les membres du groupe').' '.$gp.'" /> &nbsp;&nbsp;';
         //<== liste membres du groupe

         //==> menu groupe
         echo '</td>'."\n".'<td valign="top" align="right" nowrap="nowrap">';
         echo'<a href="admin.php?op=groupe_edit&amp;groupe_id='.$gp.'" ><img src="images/admin/ws/pencil.gif" class="vam" border="0" alt="'.adm_translate("Editer").'" title="'.adm_translate("Editer groupe").' '.$gp.'" /></a>';
         echo'<a href="javascript:void(0);" onclick="alert(\''.adm_translate("Avant de supprimer le groupe").' '.$gp.' '.adm_translate("vous devez supprimer TOUS ses membres !").'\');"><img src="images/admin/ws/trash.gif" class="vam" border="0" alt="'.adm_translate("Supprimer groupe").'" title="'.adm_translate("Supprimer groupe").' '.$gp.'" /></a>';
         echo'<a href="admin.php?op=membre_add&amp;groupe_id='.$gp.'"><img src="images/admin/ws/user_add.gif" class="vam" border="0" alt="'.adm_translate("Ajouter un ou des membres au groupe").'" title="'.adm_translate("Ajouter un ou des membres au groupe").' '.$gp.'" /></a>';
         echo'<a href="admin.php?op=bloc_groupe_create&amp;groupe_id='.$gp.'"><img src="images/admin/ws/wrench.gif" class="vam" border="0" alt="'.adm_translate("Crer le bloc WS").'" title="'.adm_translate("Crer le bloc WS").' ('.$gp.')" /></a>';
         echo '&nbsp;|&nbsp;';

         if ($result['groupe_pad']==1) {
            echo'<a href="admin.php?op=pad_remove&amp;groupe_id='.$gp.'"><img src="images/admin/ws/album_remove.gif" class="vam" border="0" alt="'.adm_translate("Dsactiver PAD du groupe").' '.$gp.'" title="'.adm_translate("Dsactiver PAD du groupe").' '.$gp.'" /></a>&nbsp;';
         } else {
            echo'<a href="admin.php?op=pad_create&amp;groupe_id='.$gp.'" ><img src="images/admin/ws/album_add.gif" class="vam" border="0" alt="'.adm_translate("Activer PAD du groupe").' '.$gp.'" title="'.adm_translate("Activer PAD du groupe").' '.$gp.'" /></a>&nbsp;';         
         }
         if ($result['groupe_blocnote']==1) {
            echo'<a href="admin.php?op=note_remove&amp;groupe_id='.$gp.'"><img src="images/admin/ws/note_remove.gif" class="vam" border="0" alt="'.adm_translate("Dsactiver bloc-note du groupe").' '.$gp.'" title="'.adm_translate("Dsactiver bloc-note du groupe").' '.$gp.'" /></a>&nbsp;';
         } else {
            echo'<a href="admin.php?op=note_create&amp;groupe_id='.$gp.'" ><img src="images/admin/ws/note_add.gif" class="vam" border="0" alt="'.adm_translate("Activer bloc-note du groupe").' '.$gp.'" title="'.adm_translate("Activer bloc-note du groupe").' '.$gp.'" /></a>&nbsp;';         
         }
         
         if (file_exists('modules/f-manager/users/groupe_'.$gp.'.conf.php')) {
            echo'<a href="admin.php?op=workspace_archive&amp;groupe_id='.$gp.'"><img src="images/admin/ws/folder_remove.gif" class="vam" border="0" alt="'.adm_translate("Dsactiver gestionnaire de fichiers du groupe").' '.$gp.'" title="'.adm_translate("Dsactiver gestionnaire de fichiers du groupe").' '.$gp.'" /></a>&nbsp;';
         } else {
            echo'<a href="admin.php?op=workspace_create&amp;groupe_id='.$gp.'" ><img src="images/admin/ws/folder_folder.gif" class="vam" border="0" alt="'.adm_translate("Activer gestionnaire de fichiers du groupe").' '.$gp.'" title="'.adm_translate("Activer gestionnaire de fichiers du groupe").' '.$gp.'" /></a>&nbsp;';
         }
         if ($result['groupe_forum']==1) {
            echo'<a href="admin.php?op=forum_groupe_delete&amp;groupe_id='.$gp.'"><img src="images/admin/ws/document_remove.gif" class="vam" border="0" alt="'.adm_translate("Supprimer forum du groupe").'" title="'.adm_translate("Supprimer forum du groupe").' '.$gp.'" /></a>&nbsp;';
         } else {
            echo'<a href="javascript:void(0);" onclick="javascript:choisir_mod_forum(\''.$gp.'\',\''.$result['groupe_name'].'\',\''.$lst_user_json.'\',\''.$lst_uid_json.'\');" ><img src="images/admin/ws/document_add.gif" class="vam" border="0" alt="'.adm_translate("Crer forum du groupe").' '.$gp.'" title="'.adm_translate("Crer forum du groupe").' '.$gp.'" /></a>&nbsp;';
         }
         if ($result['groupe_mns']==1) {
            echo'<a href="admin.php?op=groupe_mns_delete&amp;groupe_id='.$gp.'"><img src="images/admin/ws/application_remove.gif" class="vam" border="0" alt="'.adm_translate("Supprimer MiniSite du groupe").'" title="'.adm_translate("Supprimer MiniSite du groupe").' '.$gp.'" /></a>&nbsp;';
         } else {
            echo'<a href="admin.php?op=groupe_mns_create&amp;groupe_id='.$gp.'"><img src="images/admin/ws/application_add.gif" class="vam" border="0" alt="'.adm_translate("Crer MiniSite du groupe").' '.$gp.'" title="'.adm_translate("Crer MiniSite du groupe").' '.$gp.'" /></a>&nbsp;';
         }
         if ($result['groupe_chat']==0) {
            echo'<a href="admin.php?op=groupe_chat_create&amp;groupe_id='.$gp.'"><img src="images/admin/ws/comment_add.gif" class="vam" border="0" alt="'.adm_translate("Activer chat du groupe").'" title="'.adm_translate("Activer chat du groupe").' '.$gp.'" /></a>&nbsp;';
         } else {
            echo'<a href="admin.php?op=groupe_chat_delete&amp;groupe_id='.$gp.'"><img src="images/admin/ws/comment_remove.gif" class="vam" border="0" alt="'.adm_translate("Dsactiver chat du groupe").'" title="'.adm_translate("Dsactiver chat du groupe").' '.$gp.'" /></a>&nbsp;';
         }
         echo "</td>\n</tr>";
         //<== menu groupe
      }
   }

   // groupes sans membre
   $result=sql_query("select groupe_id, groupe_name, groupe_description from ".$NPDS_Prefix."groupes order by groupe_id ASC");
   while (list($gp, $gp_name, $gp_description)=sql_fetch_row($result)) {
      $gpA=true;
      if ($tab_groupeIII) {
         reset ($tab_groupeIII);
         while (list($bidon,$gpU)=each($tab_groupeIII)) {
            if ($gp==$gpU) {$gpA=false;}
         }
      }
      if ($gpA) {
         $lst_gr_json.='\'mbgr_'.$gp.'\': { gp: \''.$gp.'\'},';
         $rowcolor = tablos();
         echo '<tr id="bloc_gr_'.$gp.'" '.$rowcolor.'><td align="left" valign="top" width="5%"><span class="rouge">'.$gp.'</span></td><td valign="top" align="left" width="20%">';
         echo '<img id="gr_'.$gp.'" src="images/admin/ws/groupe.gif" class="ic_gr" class="vam"  alt="'.adm_translate("Groupe").'" /><br /><br />'.aff_langue($gp_name).'<p>'.aff_langue($gp_description);
         if (file_exists ('users_private/groupe/'.$gp.'/groupe.png'))
            echo'<br /><br /><img src="users_private/groupe/'.$gp.'/groupe.png" width="80" height="80" />';
         echo '</p>';
         echo '</td>'."\n".'<td valign="top"><img src="images/admin/ws/user.gif" style="vertical-align:bottom;" class="ic_mb" /> &nbsp;[0]&nbsp;</td><td valign="top" align="right" nowrap="nowrap">';
         echo '<a href="admin.php?op=groupe_edit&amp;groupe_id='.$gp.'" ><img src="images/admin/ws/pencil.gif" class="vam" border="0" alt="'.adm_translate("Editer").'" title="'.adm_translate("Editer groupe").' '.$gp.'" /></a>';
         echo '<a href="#" onclick="confirm_deleteGroup(\''.$gp.'\');"><img src="images/admin/ws/trash.gif" class="vam" border="0" alt="'.adm_translate("Supprimer groupe").'" title="'.adm_translate("Supprimer groupe").' '.$gp.'" /></a>';
         echo '<a href="admin.php?op=membre_add&amp;groupe_id='.$gp.'"><img src="images/admin/ws/user_add.gif" class="vam" border="0" alt="'.adm_translate("Ajouter un ou des membres au groupe").'" title="'.adm_translate("Ajouter un ou des membres au groupe").' '.$gp.'" /></a><br />';
         echo "</td>\n</tr>\n";
      }
   }
   $lst_gr_json=rtrim ($lst_gr_json,',');
         
   //==> interface graphique groupes :pliage repliage, add member
   echo "<script type=\"text/javascript\">
   //<![CDATA[
   YUI().use('transition', 'node-event-delegate', 'dd-drop', 'dd-constrain', function (Y) {
      //==> pliage repliage du tableau des groupes
      Y.delegate('click', function(e) {
         var buttonID = e.currentTarget.get('id'),
         lst_mb_gr = Y.one('#lst_gr');
         btn_hide=Y.one('#hide_lst_gr');
         if (buttonID == 'hide_lst_gr') {
            lst_mb_gr.transition({
              duration: 0.2,
              easing: 'ease-out',
              opacity: 0
            });
            lst_mb_gr.hide(true);
            btn_hide.set('id','show_lst_gr');
            btn_hide.set('title','".adm_translate("Dplier la liste")."');
            btn_show=Y.one('#show_lst_gr');
            btn_show.setContent('<img src=\"images/admin/ws/toggle_plus.gif\" class=\"vam\" alt=\"".adm_translate("Dplier la liste")."\" />');
         } else
            if (buttonID === 'show_lst_gr') {
               lst_mb_gr.show(true);
               btn_show=Y.one('#show_lst_gr');
               btn_show.set('id','hide_lst_gr');
               btn_show.set('title','".adm_translate("Replier la liste")."');
               btn_show.setContent('<img src=\"images/admin/ws/toggle_minus.gif\" class=\"vam\" alt=\"".adm_translate("Replier la liste")."\" />');
            }
         }, document, 'span');
         //<== pliage repliage du tableau des groupes

         //==> moteur interface graphique add member
         var data_gr = {
            ".$lst_gr_json."
         };
         var drags_gr = Y.Node.all('#lst_gr .ic_mb');
         drags_gr.each(function(v, k) {
            var thisData = {};
            Y.mix(thisData, data_gr[v.get('id')]);
            var dd = new Y.DD.Drag({
               node: v,
               dragMode: 'intersect',
               data: thisData
            }).plug(Y.Plugin.DDConstrained, {
                constrain2node: '#gr_dat'
            });
            dd.on('drag:end', function(e) {
                e.preventDefault();
            });
         });

         var drops = Y.one('#lst_gr').all('.ic_gr');
         Y.each(drops, function(v, k) {
         var id = v.get('id');
         id=id.substring(id.lastIndexOf('_'));
         id=id.substr(1,3);
         var drop_gr = new Y.DD.Drop({
            node: v,
         });
         drop_gr.on('drop:hit', function(e) {
            location.href='admin.php?op=membre_add&groupe_id='+id; 
         });
      });
      //<== moteur interface graphique add member
   });";
   if ($al) echo'
      alert("'.$mes.'");';
   echo "
   //]]>
   </script>";
   echo "</tbody>\n</table>";
   echo "<br />";
   closetable();
   include ('footer.php');
}

// MEMBRE
function membre_add($gp) {
   global $hlpfile,$entete_gr;

   include ('header.php');
   GraphicAdmin($hlpfile);
   echo $entete_gr;
   opentable();
   echo '<div class="header" style="font-size:100%; padding:3px;">';
   echo adm_translate("Ajouter des membres").' / '.adm_translate("Groupe").' : '.$gp.'</div>';
   echo '<form id="form_ad_mb_gr" class="admform" action="admin.php" method="post">'."\n".'<fieldset>'."\n".'<legend class="admform"><img src="images/admin/ws/groupe.gif" class="vam" border="0" alt="'.adm_translate("Groupe").'" /></legend>'."\n";
   echo '<label class="admform" for="luname_input">'.adm_translate("Liste des membres").' : </label><div id="add_member" class="yui3-skin-sam"><input type="text" class="admform" id="luname_input" name="luname" size="65" maxlength="255" value="" />&nbsp;';
   echo '<input type="hidden" name="op" value="membre_add_finish" />';
   echo '<input type="hidden" name="groupe_id" value="'.$gp.'" />';
   echo '<input class="bouton_standard" type="submit" name="sub_op" value="'.adm_translate("Sauver les modifications").'" />';
   echo "\n".'</div></fieldset>'."\n".'</form>';
   closetable();
   echo auto_complete_multi ('membre','uname','users','luname_input','inner join users_status on users.uid=users_status.uid where users.uid<>1 and groupe not regexp \'[[:<:]]'.$gp.'[[:>:]]\'');
   include ('footer.php');
}
function membre_add_finish($groupe_id, $luname) {
   global $NPDS_Prefix;
   include('powerpack_f.php');

   $luname=rtrim ( $luname ,", ");
   $luname=str_replace(' ','',$luname);
   $list_membres=explode(",",$luname);
   $nbremembres=count($list_membres);
   $subject=adm_translate('Nouvelles du groupe');
   $message=adm_translate('Vous faites dsormais partie des membres du groupe').' '.$groupe_id.'.';
   $copie='';
   $from_userid=1;

   for ($j=0;$j<$nbremembres;$j++) {
      $uname=$list_membres[$j];
      $result1 = sql_query("select uid from ".$NPDS_Prefix."users where uname='$uname'");
      $ibid=sql_fetch_assoc($result1);
      if ($ibid['uid']) {
         $to_userid=$uname;
         $result2 = sql_query("select groupe from ".$NPDS_Prefix."users_status where uid='".$ibid['uid']."'");
         $ibid2=sql_fetch_assoc($result2);
         $lesgroupes=explode(",",$ibid2['groupe']);
         $nbregroupes=count($lesgroupes);

         $groupeexistedeja=false;
         for ($i=0; $i<$nbregroupes;$i++) {
            if ($lesgroupes[$i]==$groupe_id) { $groupeexistedeja=true; break; }
         }
         if (!$groupeexistedeja) {
            if ($ibid2['groupe']) $groupesmodif=$ibid2['groupe'].",".$groupe_id;
            else $groupesmodif=$groupe_id;
            $resultat = sql_query("update ".$NPDS_Prefix."users_status set groupe='$groupesmodif' where uid='".$ibid['uid']."'");
         }
         writeDB_private_message($to_userid,$image,$subject,$from_userid,$message, $copie);
      }
   }
   global $aid; Ecr_Log("security", "AddMemberToGroup($groupe_id, $luname) by AID : $aid", "");
   Header("Location: admin.php?op=groupes");
}
function retiredugroupe($groupe_id, $uid, $uname) {
   global $NPDS_Prefix;
   include('powerpack_f.php');

   $pat='#^\b'.$uid.'\b$#';
   $mes_sys='';
   $q='';
   $ok=0;
   $res=sql_query("select f.forum_id, f.forum_name, f.forum_moderator from ".$NPDS_Prefix."forums f where f.forum_pass='$groupe_id' and cat_id='-1'");
   while ($row = sql_fetch_row($res)) {
      if (preg_match($pat, $row[2])) {
         $mes_sys='mod_'.$uname;
         $q='&al='.$mes_sys;
         $ok=1;
      }
   }

   if ($ok==0) {
      $pat='#\b'.$uid.'\b#';
      $res=sql_query("select f.forum_id, f.forum_name, f.forum_moderator from ".$NPDS_Prefix."forums f where f.forum_pass='$groupe_id' and cat_id='-1'");
      while ($r = sql_fetch_row($res)) {
         $new_moder=preg_replace('#,,#',',',trim(preg_replace ($pat,'',$r[2]),','));
         sql_query("update ".$NPDS_Prefix."forums set forum_moderator='$new_moder' where forum_id='$r[0]'");
      };
   
      $resultat=sql_query("select groupe from ".$NPDS_Prefix."users_status where uid='$uid'");
      $subject=adm_translate('Nouvelles du groupe');
      $message=adm_translate('Vous ne faites plus partie des membres du groupe').' '.$groupe_id.'.';
      $copie='';
      $from_userid=1;
      $to_userid=$uname;
      $valeurs=sql_fetch_assoc($resultat);
      $lesgroupes=explode(",",$valeurs['groupe']);
      $nbregroupes=count($lesgroupes);
      $groupesmodif="";
      for ($i=0; $i<$nbregroupes;$i++) {
         if ($lesgroupes[$i]!=$groupe_id) {
            if ($groupesmodif=="") $groupesmodif.=$lesgroupes[$i];
            else $groupesmodif.=",".$lesgroupes[$i];
         }
      }
      $resultat = sql_query("update ".$NPDS_Prefix."users_status set groupe='$groupesmodif' where uid='$uid'");
      writeDB_private_message($to_userid,$image,$subject,$from_userid,$message, $copie);
      global $aid; Ecr_Log("security", "DeleteMemberToGroup($groupe_id, $uname) by AID : $aid", "");
   }
   Header("Location: admin.php?op=groupes".$q);
}
function retiredugroupe_all($groupe_id,$tab_groupe) {
   global $NPDS_Prefix;
   $tab_groupe=explode ( ',', $tab_groupe );
   while (list($bidon,$uidZ)=each($tab_groupe)) {
      if ($uidZ) {
         // a rajouter enlever modrateur forum
         $resultat=sql_query("select groupe from ".$NPDS_Prefix."users_status where uid='$uidZ'");
         $valeurs=sql_fetch_assoc($resultat);
         $lesgroupes=explode(",",$valeurs['groupe']);
         $nbregroupes=count($lesgroupes);
         $groupesmodif="";
         for ($i=0; $i<$nbregroupes;$i++) {
            if ($lesgroupes[$i]!=$groupe_id) {
               if ($groupesmodif=="") $groupesmodif.=$lesgroupes[$i];
               else $groupesmodif.=",".$lesgroupes[$i];
            }
         }
         $resultat = sql_query("update ".$NPDS_Prefix."users_status set groupe='$groupesmodif' where uid='$uidZ'");
         global $aid; Ecr_Log("security", "DeleteAllMemberToGroup($groupe_id, $uidZ) by AID : $aid", "");
      }
   }
   Header("Location: admin.php?op=groupes");
}

// GROUPES
function groupe_edit($groupe_id) {
   global $hlpfile, $NPDS_Prefix, $entete_gr;
   include ('header.php');
   GraphicAdmin($hlpfile);
   echo "\n".$entete_gr."\n";
   opentable();
   $result=sql_fetch_assoc(sql_query("select groupe_name, groupe_description from ".$NPDS_Prefix."groupes where groupe_id='$groupe_id'"));
   echo '<div class="header" style="font-size:100%; padding:3px;">';
   if ($groupe_id!="groupe_add")
      echo adm_translate("Modifier le groupe")." : $groupe_id";
   else
      echo adm_translate("Crer un groupe.");
   echo '</div>'."\n";
   echo '<form class="admform" id="form_aded_gr" action="admin.php" method="post">'."\n".'<fieldset class="admform">'."\n".'<legend class="admform"><img src="images/admin/ws/groupe.gif" class="vam" border="0" alt="'.adm_translate("Groupe").'" /></legend>'."\n";
   if ($groupe_id!="groupe_add")
      echo '<input type="hidden" name="groupe_id" value="'.$groupe_id.'" />';
   else
      echo '<label for="inp_gr_id" class="admform">ID : </label>'."\n".'<input id="inp_gr_id" type="text" class="textbox_standard" name="groupe_id" size="4" maxlength="3" value="" />&nbsp;(2...126)&nbsp;&nbsp;<br />';
      
   echo '<label class="admform" for="inp_gr_na">'.adm_translate("Nom").' : </label>'."\n".'<input id="inp_gr_na" type="text" class="textbox_standard"  name="groupe_name" size="31" value="'.$result['groupe_name'].'" /><br /><br />'.adm_translate("Description:").'<br /><textarea class="textbox_standard" name="groupe_description" cols="70" rows="15">'.$result['groupe_description'].'</textarea><br /><br />'."\n";
   if ($groupe_id!="groupe_add")
      echo '<input type="hidden" name="op" value="groupe_maj" />';
   else
      echo "<input type=\"hidden\" name=\"op\" value=\"groupe_add_finish\" />";
   echo "<input class=\"bouton_standard\" type=\"submit\" name=\"sub_op\" value=\"".adm_translate("Sauver les modifications")."\" />";
   echo "\n".'</fieldset>'."\n".'</form>';
   closetable();
   include ('footer.php');
}
function groupe_maj() {
   global $hlpfile, $NPDS_Prefix;
   global $groupe_id, $groupe_name, $groupe_description, $sub_op;

   if ($sub_op==adm_translate("Sauver les modifications")) {
      sql_query("update ".$NPDS_Prefix."groupes set groupe_name='$groupe_name', groupe_description='$groupe_description' where groupe_id='$groupe_id'");
      global $aid; Ecr_Log("security", "UpdateGroup($groupe_id) by AID : $aid", "");
   }
   if ($sub_op==adm_translate("Supprimer")) {
      $result = sql_query("select uid, groupe from ".$NPDS_Prefix."users_status where groupe!='' order by uid ASC");
      $maj_ok=true;
      while (list($to_userid, $groupeX) = sql_fetch_row($result)) {
         $tab_groupe=explode(",",$groupeX);
         if ($tab_groupe) {
            foreach($tab_groupe as $groupevalue) {
               if ($groupevalue==$groupe_id) {
                  $maj_ok=false;
                  break;
               }
            }
         }
      }
      if ($maj_ok) {
         groupe_delete($groupe_id);
      }
   }
   Header("Location: admin.php?op=groupes");
}
function groupe_delete($groupe_id) {
   global $hlpfile, $NPDS_Prefix;
   global $groupe_name, $groupe_description, $sub_op;

   sql_query("delete from ".$NPDS_Prefix."lblocks where member='$groupe_id'");
   sql_query("delete from ".$NPDS_Prefix."rblocks where member='$groupe_id'");
   sql_query("delete from ".$NPDS_Prefix."groupes where groupe_id='$groupe_id'");
   sql_query("delete FROM ".$NPDS_Prefix."blocnotes WHERE bnid='".md5("WS-BN".$groupe_id)."'");

   forum_groupe_delete($groupe_id);
   workspace_archive($groupe_id);
   groupe_mns_delete($groupe_id);

   //  todo - Supprimer YUI si plus de WorkSpace charg - si YUI n'est utilis que par WS ...

   global $aid; Ecr_Log("security", "DeleteGroup($groupe_id) by AID : $aid", "");
}

// --------------

// WORKSPACE
function workspace_create($groupe_id) {
   global $NPDS_Prefix;

   //==>creation fichier conf du groupe
   @copy('modules/f-manager/users/groupe.conf.php','modules/f-manager/users/groupe_'.$groupe_id.'.conf.php');
   $file = file('modules/f-manager/users/groupe_'.$groupe_id.'.conf.php');
   $file[29] ="   \$access_fma = \"$groupe_id\";\n";
   $fic = fopen('modules/f-manager/users/groupe_'.$groupe_id.'.conf.php', "w");
   while (list($n,$ligne) = each($file)) {
      fwrite($fic, $ligne);
   }
   fclose($fic);

   include ("modules/upload/upload.conf.php");
   if ($DOCUMENTROOT=="") {
      global $DOCUMENT_ROOT;
      if ($DOCUMENT_ROOT) {
         $DOCUMENTROOT=$DOCUMENT_ROOT;
      } else {
         $DOCUMENTROOT=$_SERVER['DOCUMENT_ROOT'];
      }
   }
   $user_dir=$DOCUMENTROOT.$racine."/users_private/groupe/".$groupe_id;

   // DOCUMENTS_GROUPE
   @mkdir('users_private/groupe/'.$groupe_id.'/documents_groupe');
   $repertoire=$user_dir."/documents_groupe";
   $directory=$racine."/modules/groupe/matrice/documents_groupe";
   $handle=opendir($DOCUMENTROOT.$directory);
   while (false!==($file = readdir($handle))) $filelist[] = $file;
   asort($filelist);
   while (list ($key, $file) = each ($filelist)) {
      if ($file<>"." and $file<>"..") {
         @copy($DOCUMENTROOT.$directory."/".$file, $repertoire."/".$file);
      }
   }
   closedir($handle);
   unset ($filelist);

   // IMAGES_GROUPE
   @mkdir('users_private/groupe/'.$groupe_id.'/images_groupe');
   $repertoire=$user_dir."/images_groupe";
   $directory=$racine."/modules/groupe/matrice/images_groupe";
   $handle=opendir($DOCUMENTROOT.$directory);
   while (false!==($file = readdir($handle))) $filelist[] = $file;
   asort($filelist);
   while (list ($key, $file) = each ($filelist)) {
      if ($file<>"." and $file<>"..") {
         @copy($DOCUMENTROOT.$directory."/".$file, $repertoire."/".$file);
      }
   }
   closedir($handle);
   unset ($filelist);
   @unlink('users_private/groupe/'.$groupe_id.'/delete');

   global $aid; Ecr_Log("security", "CreateWS($groupe_id) by AID : $aid", "");
}

// PAD
function pad_create($groupe_id) {
   global $NPDS_Prefix;

   sql_query("update ".$NPDS_Prefix."groupes set groupe_pad = '1' where groupe_id = '$groupe_id';");
   global $aid; Ecr_Log("security", "CreatePadWS($groupe_id) by AID : $aid", "");
}
function pad_remove($groupe_id) {
   global $NPDS_Prefix;
   
   sql_query("update ".$NPDS_Prefix."groupes set groupe_pad = '0' where groupe_id = '$groupe_id';");
   global $aid; Ecr_Log("security", "DeletePadWS($groupe_id) by AID : $aid", "");
}

// BLOC-NOTE
function note_create($groupe_id) {
   global $NPDS_Prefix;

   // => Creation table blocnotes
   $type_engine=(int)substr(mysql_get_server_info(), 0, 1);
   $sql="CREATE TABLE IF NOT EXISTS ".$NPDS_Prefix."blocnotes (
   bnid tinytext NOT NULL,
   texte text,
   PRIMARY KEY (bnid(32))
   )";
   if ($type_engine>=5)
      $sql.=" ENGINE=MyISAM";
   else
      $sql.=" TYPE=MyISAM";
   sql_query($sql);

   sql_query("update ".$NPDS_Prefix."groupes set groupe_blocnote = '1' where groupe_id = '$groupe_id';");
   global $aid; Ecr_Log("security", "CreateBlocnoteWS($groupe_id) by AID : $aid", "");
}
function note_remove($groupe_id) {
   global $NPDS_Prefix;
   
   sql_query("delete from ".$NPDS_Prefix."blocnotes where bnid='".md5("WS-BN".$groupe_id)."'");
   sql_query("update ".$NPDS_Prefix."groupes set groupe_blocnote = '0' where groupe_id = '$groupe_id';");

   global $aid; Ecr_Log("security", "DeleteBlocnoteWS($groupe_id) by AID : $aid", "");
}

function workspace_archive($groupe_id) {
   //=> archivage espace groupe
   $fp=fopen ('users_private/groupe/'.$groupe_id.'/delete','w');
   fclose($fp);
   //suppression fichier conf
   @unlink('modules/f-manager/users/groupe_'.$groupe_id.'.conf.php');
   global $aid; Ecr_Log("security", "ArchiveWS($groupe_id) by AID : $aid", "");
}

// FORUMS
function forum_groupe_create($groupe_id,$groupe_name,$description,$moder) {
    global $NPDS_Prefix;

    // creation forum
    // creation catgorie forum_groupe
    $result=sql_query("select cat_id from ".$NPDS_Prefix."catagories where cat_id = -1;");
    list($cat_id)=sql_fetch_row($result);
    if (!$cat_id) {
       sql_query("insert into ".$NPDS_Prefix."catagories values (-1, '".adm_translate("Groupe de travail")."')");
    };
    //==>creation forum

    echo "$groupe_id,$groupe_name,$description,$moder";

    sql_query("insert into ".$NPDS_Prefix."forums values (NULL, '$groupe_name', '$description', '1', '$moder', '-1', '7', '$groupe_id', '0', '0', '0')");
    //=> ajout etat forum (1 ou 0) dans le groupe
    sql_query("update ".$NPDS_Prefix."groupes set groupe_forum = '1' where groupe_id = '$groupe_id';");
    global $aid; Ecr_Log("security", "CreateForumWS($groupe_id) by AID : $aid", "");
}

function moderateur_update($forum_id,$forum_moderator) {
    global $NPDS_Prefix;

    sql_query("update ".$NPDS_Prefix."forums set forum_moderator = '$forum_moderator' where forum_id='$forum_id'");
}
function forum_groupe_delete($groupe_id) {
    global $NPDS_Prefix;

    $result=sql_query("select forum_id from ".$NPDS_Prefix."forums where forum_pass='$groupe_id' and cat_id='-1'");
    list($forum_id) = sql_fetch_row($result);
    // suppression des topics
    sql_query("delete from ".$NPDS_Prefix."forumtopics where forum_id='$forum_id'");
    // maj table lecture
    sql_query("delete from ".$NPDS_Prefix."forum_read where forum_id='$forum_id'");

    //=> suppression du forum
    sql_query("delete from ".$NPDS_Prefix."forums where forum_id='$forum_id'");
    // =>remise  0 forum dans le groupe
    sql_query("update ".$NPDS_Prefix."groupes set groupe_forum = '0' where groupe_id='$groupe_id'");
    global $aid; Ecr_Log("security", "DeleteForumWS($forum_id) by AID : $aid", "");
}

// MNS
function groupe_mns_create($groupe_id) {
   global $NPDS_Prefix;
   include ("modules/upload/upload.conf.php");

   if ($DOCUMENTROOT=="") {
      global $DOCUMENT_ROOT;
      if ($DOCUMENT_ROOT) {
         $DOCUMENTROOT=$DOCUMENT_ROOT;
      } else {
         $DOCUMENTROOT=$_SERVER['DOCUMENT_ROOT'];
      }
   }
   $user_dir=$DOCUMENTROOT.$racine."/users_private/groupe/".$groupe_id;
   $repertoire=$user_dir."/mns";
   if (!is_dir($user_dir)) {
      @umask("0000");
      if (@mkdir($user_dir,0777)) {
         $fp = fopen($user_dir."/index.html", 'w');
         fclose($fp);
         @umask("0000");
         if (@mkdir($repertoire,0777)) {
            $fp = fopen($repertoire."/index.html", 'w');
            fclose($fp);
            $fp = fopen($repertoire."/.htaccess", 'w');
            @fputs($fp, "Deny from All");
            fclose($fp);
         }
      }
   } else {
      @umask("0000");
      if (@mkdir($repertoire,0777)) {
         $fp = fopen($repertoire."/index.html", 'w');
         fclose($fp);
         $fp = fopen($repertoire."/.htaccess", 'w');
         @fputs($fp, "Deny from All");
         fclose($fp);
      }
   }
   // copie de la matrice par dfaut
   $directory=$racine."/modules/groupe/matrice/mns_groupe";
   $handle=opendir($DOCUMENTROOT.$directory);
   while (false!==($file = readdir($handle))) $filelist[] = $file;
   asort($filelist);
   while (list ($key, $file) = each ($filelist)) {
      if ($file<>"." and $file<>"..") {
         @copy($DOCUMENTROOT.$directory."/".$file, $repertoire."/".$file);
      }
   }
   closedir($handle);
   unset ($filelist);
   sql_query("update ".$NPDS_Prefix."groupes set groupe_mns = '1' where groupe_id = '$groupe_id';");
   global $aid; Ecr_Log("security", "CreateMnsWS($groupe_id) by AID : $aid", "");
}
function groupe_mns_delete($groupe_id) {
   global $NPDS_Prefix;
   include ("modules/upload/upload.conf.php");

   if ($DOCUMENTROOT=="") {
      global $DOCUMENT_ROOT;
      if ($DOCUMENT_ROOT) {
         $DOCUMENTROOT=$DOCUMENT_ROOT;
      } else {
         $DOCUMENTROOT=$_SERVER['DOCUMENT_ROOT'];
      }
   }
   $user_dir=$DOCUMENTROOT.$racine."/users_private/groupe/".$groupe_id;

   // Supprimer son ministe s'il existe
   if (is_dir($user_dir."/mns")) {
      $dir = opendir($user_dir."/mns");
      while(false!==($nom = readdir($dir))) {
         if ($nom != "." && $nom != ".." && $nom != "") {
            @unlink($user_dir."/mns/".$nom);
         }
     }
     closedir($dir);
     @rmdir($user_dir."/mns");
   }
   sql_query("update ".$NPDS_Prefix."groupes set groupe_mns = '0' where groupe_id = '$groupe_id';");
   global $aid; Ecr_Log("security", "DeleteMnsWS($groupe_id) by AID : $aid", "");
}

// CHAT
function groupe_chat_create($groupe_id) {
   global $NPDS_Prefix;

   sql_query("update ".$NPDS_Prefix."groupes set groupe_chat = '1' where groupe_id = '$groupe_id';");
   global $aid; Ecr_Log("security", "ActivateChatWS($groupe_id) by AID : $aid", "");
}
function groupe_chat_delete($groupe_id) {
   global $NPDS_Prefix;

   sql_query("update ".$NPDS_Prefix."groupes set groupe_chat = '0' where groupe_id = '$groupe_id';");
   global $aid; Ecr_Log("security", "DesactivateChatWS($groupe_id) by AID : $aid", "");
}

function bloc_groupe_create($groupe_id) {
   global $NPDS_Prefix;

   // Creation bloc espace de travail user et du chargeur YUI (si ncessaire)
   // On recherche si YUI est dj installe via un bloc
   $yui=false;
   $row=sql_fetch_row(sql_query("SELECT count(id) FROM ".$NPDS_Prefix."lblocks WHERE content like '%yui-min.js%'"));
   if ($row[0]==0) {
      $row=sql_fetch_row(sql_query("SELECT count(id) FROM ".$NPDS_Prefix."rblocks WHERE content like '%yui-min.js%'"));
      if ($row[0]<>0)
         $yui=true;
   } else {
      $yui=true;
   }
   if ($yui==false) {
      sql_query("INSERT into ".$NPDS_Prefix."lblocks values (NULL, 'YUI loader', 'hidden#<script type=\"text/javascript\" src=\"lib/yui/build/yui/yui-min.js\"></script>', '0', '-99', '86400', '1', '0', 'Ce bloc charge YUI / This block load YUI')");
   }

   // On crer le bloc s'il n'existe pas dj
   $bloc=false;
   $menu_workspace="function#bloc_espace_groupe\r\nparams#$groupe_id,1";
   $row=sql_fetch_row(sql_query("SELECT count(id) FROM ".$NPDS_Prefix."lblocks WHERE content='$menu_workspace'"));
   if ($row[0]==0) {
      $row=sql_fetch_row(sql_query("SELECT count(id) FROM ".$NPDS_Prefix."rblocks WHERE content='$menu_workspace'"));
      if ($row[0]<>0)
         $bloc=true;
   } else {
      $bloc=true;
   }
   if ($bloc==false) {
      sql_query("INSERT into ".$NPDS_Prefix."lblocks values (NULL, '', '$menu_workspace', '$groupe_id', '3', '0', '1', '0', NULL)");
   }
}

switch ($op) {
   case "membre_add":
        membre_add($groupe_id);
        break;
   case "membre_add_finish":
        membre_add_finish($groupe_id,$luname);
        break;
   case "retiredugroupe":
        retiredugroupe($groupe_id,$uid,$uname);
        break;
   case "retiredugroupe_all":
        retiredugroupe_all($groupe_id,$tab_groupe);
        break;

   case "pad_create":
        pad_create($groupe_id);
        Header("Location: admin.php?op=groupes");    
        break;
   case "pad_remove":
        pad_remove($groupe_id);
        Header("Location: admin.php?op=groupes");    
        break;
        
   case "note_create":
        note_create($groupe_id);
        Header("Location: admin.php?op=groupes");    
        break;
   case "note_remove":
        note_remove($groupe_id);
        Header("Location: admin.php?op=groupes");
        break;
   
   case "workspace_create":
        workspace_create($groupe_id);
        Header("Location: admin.php?op=groupes");
        break;
   case "workspace_archive":
        workspace_archive($groupe_id);
        Header("Location: admin.php?op=groupes");
        break;

   case "forum_groupe_create":
        forum_groupe_create($groupe_id,$groupe_name,$description,$moder);
        break;
   case "moderateur_update":
        moderateur_update($forum_id,$forum_moderator);
        Header('location: admin.php?op=groupes');
        break;
   case "forum_groupe_delete":
        forum_groupe_delete($groupe_id);
        Header('location: admin.php?op=groupes');
        break;

   case "groupe_mns_create":
        groupe_mns_create($groupe_id);
        Header('location: admin.php?op=groupes');
        break;
   case "groupe_mns_delete":
        groupe_mns_delete($groupe_id);
        Header('location: admin.php?op=groupes');
        break;

   case "groupe_chat_create":
        groupe_chat_create($groupe_id);
        Header('location: admin.php?op=groupes');
        break;
   case "groupe_chat_delete":
        groupe_chat_delete($groupe_id);
        Header('location: admin.php?op=groupes');
        break;

   case "groupe_edit":
        groupe_edit($groupe_id);
        break;
   case "groupe_maj":
        groupe_maj();
        break;
   case "groupe_add":
        groupe_edit("groupe_add");
        break;
   case "bloc_groupe_create":
        bloc_groupe_create($groupe_id);
        Header('location: admin.php?op=groupes');
        break;
   case "groupe_add_finish":
        $ok_grp=false;
        if (($groupe_id=="") or ($groupe_id<2) or ($groupe_id>126)) {
           $row=sql_fetch_row(sql_query("SELECT MAX(groupe_id) from ".$NPDS_Prefix."groupes"));      
           if ($row[0]<126) {
              if ($row[0]==0) $row[0]=1;
              $groupe_id=$row[0]+1;
              $ok_grp=true;
           }           
        }  else {
           $ok_grp=true;
        }
        if ($ok_grp) {
           sql_query("INSERT into ".$NPDS_Prefix."groupes values ('$groupe_id', '$groupe_name','$groupe_description','0','0','0','0','0')");
           @mkdir('users_private/groupe/'.$groupe_id);
           $fp=fopen ('users_private/groupe/'.$groupe_id.'/index.html','w');
           fclose($fp);
           @copy('modules/groupe/matrice/groupe.png','users_private/groupe/'.$groupe_id.'/groupe.png');
           @unlink('users_private/groupe/'.$groupe_id.'/delete');
           
           global $aid; Ecr_Log("security", "CreateGroupe($groupe_id, $groupe_name) by AID : $aid", "");
        }
   default:
        group_liste();
        break;
}
?>