<?php
/************************************************************************/
/* DUNE by NPDS                                                         */
/* ===========================                                          */
/*                                                                      */
/* Based on PhpNuke 4.x source code                                     */
/*                                                                      */
/* NPDS Copyright (c) 2002-2013 by Philippe Brunier                     */
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/
include_once("mainfile.php");

function viewbanner() {
   global $NPDS_Prefix;
   $okprint=false; $while_limit=3; $while_cpt=0;
   $bresult = sql_query("select bid from ".$NPDS_Prefix."banner where userlevel!='9'");
   $numrows = sql_num_rows($bresult);
   while ((!$okprint) and ($while_cpt<$while_limit)) {
      // More efficient random stuff, thanks to Cristian Arroyo from http://www.planetalinux.com.ar
      if ($numrows>0) {
         mt_srand((double)microtime()*1000000);
         $bannum = mt_rand(0, $numrows);
      } else {
         break;
      }
      $bresult2 = sql_query("select bid, userlevel from ".$NPDS_Prefix."banner where userlevel!='9' limit $bannum,1");
      list($bid, $userlevel) = sql_fetch_row($bresult2);
      if ($userlevel==0) {
         $okprint=true;
      } else {
         if ($userlevel==1) {
            if (secur_static("member")) {$okprint=true;}
         }
         if ($userlevel==3) {
            if (secur_static("admin")) {$okprint=true;}
         }
      }
      $while_cpt=$while_cpt+1;
   }
   // Le risque est de sortir sans un BID valide
   if (!isset($bid)) {
      $rowQ1=Q_Select("select bid from ".$NPDS_Prefix."banner where userlevel='0' limit 0,1",86400);
      list(,$myrow)=each($rowQ1);
      $bid=$myrow['bid'];
      $okprint=true;
   }

   if ($okprint) {
      global $myIP;
      $myhost = getip();
      if ($myIP!=$myhost) {
         sql_query("update ".$NPDS_Prefix."banner set impmade=impmade+1 where bid='$bid'");
      }
      if (($numrows>0) and ($bid)) {
         $aborrar = sql_query("select cid, imptotal, impmade, clicks, imageurl, clickurl, date from ".$NPDS_Prefix."banner where bid='$bid'");
         list($cid, $imptotal, $impmade, $clicks, $imageurl, $clickurl, $date) = sql_fetch_row($aborrar);
         if ($imptotal==$impmade) {
            sql_query("insert into ".$NPDS_Prefix."bannerfinish values (NULL, '$cid', '$impmade', '$clicks', '$date', now())");
            sql_query("delete from ".$NPDS_Prefix."banner where bid='$bid'");
         }

         if ($imageurl!="") {
            echo"<a href=\"banners.php?op=click&amp;bid=$bid\" target=\"_blank\"><img src=\"".aff_langue($imageurl)."\" alt=\"\" border=\"0\" /></a>";
         } else {
            if (stristr($clickurl,'.txt')) {
               if (file_exists($clickurl)) {
                  include_once($clickurl);
               }
            } else {
               echo $clickurl;
            }
         }
      }
   }
}

function clickbanner($bid) {
    global $NPDS_Prefix;
    $bresult = sql_query("select clickurl from ".$NPDS_Prefix."banner where bid='$bid'");
    list($clickurl) = sql_fetch_row($bresult);
    sql_query("update ".$NPDS_Prefix."banner set clicks=clicks+1 where bid='$bid'");
    sql_free_result($bresult);
    if ($clickurl=="") {
       global $nuke_url;
       $clickurl=$nuke_url;
    }
    Header("Location: ".aff_langue($clickurl));
}

function clientlogin() {
    header_page();
    echo "<br /><br /><form action=\"banners.php\" method=\"post\"><p align=\"center\"><table width=\"50%\" cellspacing=\"2\" cellpadding=\"4\" border=\"0\"><tr><td colspan=\"2\" class=\"header\">\n";
    echo translate("Login")."</td></tr>";
    echo "<tr><td class=\"ligna\">".translate("Login")." :</td><td nowrap class=\"ligna\"><input class=\"textbox_standard\" type=\"text\" name=\"login\" size=\"12\" maxlength=\"10\"></td></tr>";
    echo "<tr><td class=\"ligna\">".translate("Password")." :</td><td nowrap=\"nowrap\" class=\"ligna\"><input class=\"textbox_standard\" type=\"password\" name=\"pass\" size=\"12\" maxlength=\"10\" /></td></tr>";
    echo "<tr><td colspan=\"2\" class=\"ligna\" align=\"center\"><input class=\"textbox\" type=\"hidden\" name=\"op\" value=\"Ok\" />
    <input class=\"bouton_standard\" type=\"submit\" value=\"".translate("Submit")."\" /></td></tr>";
    echo "</table></p></form>\n";
    echo "<p align=\"center\" class=\"noir\">".translate("Please type your client informations")."</p>";
    footer_page();
}

function IncorrectLogin() {
   header_page();
   echo "<p align=\"center\"><br />".translate("Incorrect Login!")."<br /><br /><a href=\"javascript:history.go(-1)\" class=\"noir\">".translate("Go Back")."</a></p>";
   footer_page();
}

function header_page() {
    global $Titlesitename, $Default_Theme, $language;
    include_once("modules/upload/upload.conf.php");
    include("meta/meta.php");
    if ($url_upload_css) {
      $url_upload_cssX=str_replace("style.css","$language-style.css",$url_upload_css);
      if (is_readable($url_upload.$url_upload_cssX))
         $url_upload_css=$url_upload_cssX;
      print ("<link href=\"".$url_upload.$url_upload_css."\" title=\"default\" rel=\"stylesheet\" type=\"text/css\" media=\"all\" />\n");
    }
    echo "</head>\n<body>";
    echo "<table width=\"100%\" cellspacing=\"2\" cellpadding=\"2\" border=\"0\"><tr><td class=\"header\">\n";
    echo translate("Advertising Statistics")." || $Titlesitename";
    echo "</td></tr></table>\n";
    echo "<br />\n<p align=\"center\><table width=\"98%\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tr><td>";
}

function footer_page() {
   echo "</td></tr></table></p></body></html>";
}

function bannerstats($login, $pass) {
   global $NPDS_Prefix;
   $result = sql_query("select cid, name, passwd from ".$NPDS_Prefix."bannerclient where login='$login'");
   list($cid, $name, $passwd) = sql_fetch_row($result);
   if ($login=="" AND $pass=="" OR $pass=="") {
      IncorrectLogin();
   } else {
      if ($pass==$passwd) {
         header_page();
         opentable();
         echo "<table width=\"100%\" cellspacing=\"2\" cellpadding=\"2\" border=\"0\"><tr><td class=\"header\">\n";
         echo translate ("Current Active Banners for")." $name";
         echo "</td></tr></table>\n";
         echo "<br />\n";
         echo"<table width=\"100%\" cellspacing=\"0\" cellpadding=\"2\" border=\"0\"><tr>
         <td class=\"ongl\" align=\"center\">ID</td>
         <td class=\"ongl\" align=\"center\">".translate("Made")."</td>
         <td class=\"ongl\" align=\"center\">".translate("Impressions")."</td>
         <td class=\"ongl\" align=\"center\">".translate("Imp. Left")."</td>
         <td class=\"ongl\" align=\"center\">".translate("Clicks")."</td>
         <td class=\"ongl\" align=\"center\">% ".translate("Clicks")."</td>
         <td class=\"ongl\" align=\"center\">".translate("Functions")."</td></tr>";
         $result = sql_query("select bid, imptotal, impmade, clicks, date from ".$NPDS_Prefix."banner where cid='$cid'");
         while (list($bid, $imptotal, $impmade, $clicks, $date) = sql_fetch_row($result)) {
            $rowcolor = tablos();
            if ($impmade==0) {
               $percent = 0;
            } else {
               $percent = substr(100 * $clicks / $impmade, 0, 5);
            }
            if ($imptotal==0) {
               $left = translate("Unlimited");
            } else {
               $left = $imptotal-$impmade;
            }
            echo "<tr $rowcolor>
            <td align=\"center\">$bid</td>
            <td align=\"center\">$impmade</td>
            <td align=\"center\">$imptotal</td>
            <td align=\"center\">$left</td>
            <td align=\"center\">$clicks</td>
            <td align=\"center\">$percent%</td>
            <td align=\"center\"><a href=\"banners.php?op=EmailStats&amp;login=$login&amp;cid=$cid&amp;bid=$bid\" class=\"noir\">E-mail Stats</a></td></tr>";
         }
         global $nuke_url, $sitename;
         echo "</table><br />";
         echo "<table width=\"100%\" cellspacing=\"2\" cellpadding=\"2\" border=\"0\"><tr><td class=\"header\">\n";
         echo "<a href=\"$nuke_url\" class=\"header\" target=_blank>$sitename</a>";
         echo "</td></tr></table>\n";
         echo "<br />\n";
         $result = sql_query("select bid, imageurl, clickurl from ".$NPDS_Prefix."banner where cid='$cid'");
         echo "<table width=\"100%\" cellspacing=\"0\" cellpadding=\"2\" border=\"0\">";
         while (list($bid, $imageurl, $clickurl) = sql_fetch_row($result)) {
            $rowcolor = tablos();
            $numrows = sql_num_rows($result);
            if ($numrows>1) {
               echo "<tr $rowcolor><td>&nbsp;<br /></td></tr>";
            }
            if ($imageurl!="") {
               echo "<tr $rowcolor><td align=\"center\"><img src=\"".aff_langue($imageurl)."\" border=\"1\"></td></tr>";
            } else {
               echo "<tr $rowcolor><td align=\"center\">";
               echo $clickurl;
               echo "</td></tr>";
            }
            echo "<tr $rowcolor><td>
            Banner ID : $bid<br /></td></tr>";
            if ($imageurl!="") {
               echo "<tr $rowcolor><td>".translate("This Banners points to")." : <a href=\"".aff_langue($clickurl)."\" target=_Blank class=\"noir\">[ URL ]</a><br /></td></tr>";
            }
            echo "<tr $rowcolor><form action=\"banners.php\" method=\"submit\"><td nowrap=\"nowrap\">";
            if ($imageurl!="") {
               echo translate("Change")." URL : <input class=\"textbox_standard\" type=\"text\" name=\"url\" size=\"50\" maxlength=\"200\" value=\"$clickurl\" />";
            } else {
               echo translate("Change")." URL : <input class=\"textbox_standard\" type=\"text\" name=\"url\" size=\"50\" maxlength=\"200\" value=\"".htmlentities($clickurl, ENT_QUOTES, cur_charset)."\" />";
            }
            echo "<input class=\"textbox\" type=\"hidden\" name=\"login\" value=\"$login\" />
            <input class=\"textbox\" type=\"hidden\" name=\"bid\" value=\"$bid\" />
            <input class=\"textbox\" type=\"hidden\" name=\"pass\" value=\"$pass\" />
            <input class=\"textbox\" type=\"hidden\" name=\"cid\" value=\"$cid\" />
            <input class=\"bouton_standard\" type=\"submit\" name=\"op\" value=\"".translate("Change")."\" /></td></form></tr>";
         }
         echo "</table>";
         // Finnished Banners
         echo "<br />";
         echo "<table width=\"100%\" cellspacing=\"2\" cellpadding=\"2\" border=\"0\"><tr><td class=\"header\">\n";
         echo translate("Banners Finished for")." $name";
         echo "</td></tr></table>\n";
         echo "<br />\n
         <table width=\"100%\" cellspacing=\"0\" cellpadding=\"2\" border=\"0\">
         <td class=\"ongl\" align=\"center\">ID</td>
         <td class=\"ongl\" align=\"center\">".translate("Impressions")."</td>
         <td class=\"ongl\" align=\"center\">".translate("Clicks")."</td>
         <td class=\"ongl\" align=\"center\">% ".translate("Clicks")."</td>
         <td class=\"ongl\" align=\"center\">".translate("Start Date")."</td>
         <td class=\"ongl\" align=\"center\">".translate("End Date")."</td></tr>";
         $result = sql_query("select bid, impressions, clicks, datestart, dateend from ".$NPDS_Prefix."bannerfinish where cid='$cid'");
         while (list($bid, $impressions, $clicks, $datestart, $dateend) = sql_fetch_row($result)) {
            $rowcolor = tablos();
            $percent = substr(100 * $clicks / $impressions, 0, 5);
            echo "
            <tr $rowcolor><td align=\"center\">$bid</td>
            <td align=\"center\">$impressions</td>
            <td align=\"center\">$clicks</td>
            <td align=\"center\">$percent%</td>
            <td align=\"center\">$datestart</td>
            <td align=\"center\">$dateend</td></tr>";
         }
         echo "</table>";
         closetable();
         footer_page();
      } else {
         IncorrectLogin();
      }
   }
}

function EmailStats($login, $cid, $bid) {
   global $NPDS_Prefix;
   $result = sql_query("select login from ".$NPDS_Prefix."bannerclient where cid='$cid'");
   list($loginBD) = sql_fetch_row($result);
   if ($login==$loginBD) {
      $result2 = sql_query("select name, email from ".$NPDS_Prefix."bannerclient where cid='$cid'");
      list($name, $email) = sql_fetch_row($result2);
      if ($email=="") {
         header_page();
            echo "<p align=\"center\"><br />".translate("Statistics for Banner ID")." : $bid ".translate("can't be send because")."<br /><br />
            ".translate("there isn't an email associated with client")." $name<br /><br /><a href=\"javascript:history.go(-1)\" class=\"noir\">".translate("Go Back")."</a></p>";
         footer_page();
      } else {
         $result = sql_query("select bid, imptotal, impmade, clicks, imageurl, clickurl, date from ".$NPDS_Prefix."banner where bid='$bid' and cid='$cid'");
         list($bid, $imptotal, $impmade, $clicks, $imageurl, $clickurl, $date) = sql_fetch_row($result);
         if ($impmade==0) {
            $percent = 0;
         } else {
            $percent = substr(100 * $clicks / $impmade, 0, 5);
         }

         if ($imptotal==0) {
            $left = translate("Unlimited");
            $imptotal = translate("Unlimited");
         } else {
            $left = $imptotal-$impmade;
         }
         global $sitename, $gmt;
         echo $fecha=date(translate("dateinternal"),time()+($gmt*3600));
         $subject = "".translate("Advertising Statistics")." : $sitename";
         $message  = "Client : $name\n".translate("Banner")." ID : $bid\n".translate("Banner")." Image : $imageurl\n".translate("Banner")." URL : $clickurl\n\n";
         $message .= "Impressions ".translate("Purchased")." : $imptotal\nImpressions ".translate("Maded")." : $impmade\nImpressions ".translate("Lefted")." : $left\nClicks ".translate("Received")." : $clicks\nClicks ".translate("Percent")." : $percent%\n\n";
         $message .= "".translate("Report Generated on")." : $fecha\n\n";
         include("signat.php");

         send_email($email, $subject, $message, "", true, "text");
         header_page();
         echo "<p align=\"center\">".translate("Statistics for Banner ID")." : $bid ".translate("has been send to")."<br /><br />
         $email : Client : $name<br /></p>";
         echo "<p align=\"center\"><br /><a href=\"javascript:history.go(-1)\" class=\"noir\">".translate("Go Back")."</a></p>";
      }
   } else {
      header_page();
      echo "<p align=\"center\"><br />".translate("Incorrect Login!")."<br /><br />".translate("Please")." <a href=\"banners.php?op=login\" class=\"noir\">".translate("login again")."</a></p>";
   }
   footer_page();
}
function change_banner_url_by_client($login, $pass, $cid, $bid, $url) {
    global $NPDS_Prefix;
    header_page();
    $result = sql_query("select passwd from ".$NPDS_Prefix."bannerclient where cid='$cid'");
    list($passwd) = sql_fetch_row($result);
    if (!empty($pass) AND $pass==$passwd) {
        sql_query("update ".$NPDS_Prefix."banner set clickurl='$url' where bid='$bid'");
        sql_query("update ".$NPDS_Prefix."banner set clickurl='$url' where bid='$bid'");
        echo "<p align=\"center\"><br />".translate("You changed the URL")."<br /><br /><a href=\"javascript:history.go(-1)\" class=\"noir\">".translate("Go Back")."</a></p>";
    } else {
        echo "<p align=\"center\"><br />".translate("Incorrect Login!")."<br /><br />".translate("Please")." <a href=\"banners.php?op=login\" class=\"noir\">".translate("login again")."</a></p>";
    }
    footer_page();
}
settype($op,'string');
switch ($op) {
   case "click":
        clickbanner($bid);
        break;

   case "login":
        clientlogin();
        break;

   case "Ok":
        bannerstats($login, $pass);
        break;

   case translate("Change"):
        change_banner_url_by_client($login, $pass, $cid, $bid, $url);
        break;

   case "EmailStats":
        EmailStats($login, $cid, $bid);
        break;

   default:
        if ($banners) {
           viewbanner();
        } else {
           redirect_url("index.php");
        }
        break;
}
?>