<?php
/************************************************************************/
/* DUNE by NPDS                                                         */
/* ===========================                                          */
/*                                                                      */
/* Installation de NPDS REvolution 13                                   */
/*                                                                      */
/* NPDS Copyright (c) 2001-2013 by Philippe Brunier                     */
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/
if (!function_exists("Mysql_Connexion")) {
   include ("mainfile.php");
}

// Fonctions de l'interface    
function mess_welcome($lang) {
   echo "<form name=\"update_rev13\" method=\"post\" action=\"install.php\">
    <div id=\"welcome\" class=\"mess\">"; 
       $id_fr = fopen("install/languages/welcome-$lang.txt", "r");
      fpassthru($id_fr);
   echo "</div>
    <br />
    <div style=\"text-align: center\">
    <input type=\"hidden\" name=\"op\" value=\"update\" />
    <input type=\"submit\" class=\"bouton_standard\" value=\"";
    if ($lang=="french") echo "Etape suivante"; else echo "Next stage";
   echo "\" />
    </div>
    </form><br />";
}
function mess_update($lang) {
   echo "<form name=\"update_rev13\" method=\"post\" action=\"install.php\">
    <div id=\"maj_deb\" class=\"mess\">";
    $id_fr = fopen("install/languages/update-$lang.txt", "r");
    fpassthru($id_fr);
   echo "</div>
    <br />
    <div style=\"text-align: center\">
    <input type=\"hidden\" name=\"op\" value=\"finish\" />
    <input type=\"submit\" class=\"bouton_standard\" value=\"";
    if ($lang=="french") echo "Terminer la mise &agrave; jour"; else echo "End the update";
   echo "\" />
    </div>
    </form><br />";
}
function mess_finish($lang) {
   echo "<div id=\"maj_deb\" class=\"mess\">";
    $id_fr = fopen("install/languages/finish-$lang.txt", "r");
    fpassthru($id_fr);
   echo "</div><br />";
}

// Fonctions operationnelles    
function maj_db() {
   global $NPDS_Prefix;
   
   // Mise  jour de la table metalang
   $sql="UPDATE ".$NPDS_Prefix."metalang SET description='[french]Fabrique un bloc R (droite) ou L (gauche) en s\'appuyant sur l\'ID (voir gestionnaire de blocs) pour incorporation / syntaxe : blocID(R1) ou blocID(L2)[/french]' WHERE def='blocID'";
   $result = sql_query($sql);
   
   $sql="DELETE FROM ".$NPDS_Prefix."metalang WHERE def='espace_groupe'";
   $result = sql_query($sql);
   $sql='INSERT INTO '.$NPDS_Prefix.'metalang VALUES (\'espace_groupe\', \'function MM_espace_groupe($gr, $t_gr, $i_gr) {\\r\\n$gr = arg_filter($gr);\\r\\n$t_gr = arg_filter($t_gr);\\r\\n$i_gr = arg_filter($i_gr);\\r\\n\\r\\nreturn (fab_espace_groupe($gr, $t_gr, $i_gr));\\r\\n}\', \'meta\', \'-\', NULL, \'[french]Fabrique un WorkSpace / syntaxe : espace_groupe(groupe_id, aff_name_groupe, aff_img_groupe) ou groupe_id est l\\\'ID du groupe - aff_name_groupe(0 ou 1) permet d\\\'afficher le nom du groupe - aff_img_groupe(0 ou 1) permet d\\\'afficher l\\\'image associ&eacute;e au groupe.[/french]\', \'1\');';
   $result = sql_query($sql);

   // Mise  jour des avatars
   $result = sql_query("SELECT uid, user_avatar from ".$NPDS_Prefix."users order by uid DESC");
   while($temp = sql_fetch_assoc($result) ) {
      if (substr($temp['user_avatar'],0,1)=="/") {
         sql_query("UPDATE ".$NPDS_Prefix."users set user_avatar='".substr($temp['user_avatar'],1)."' where uid='".$temp['uid']."'");
      }
   }

   // Rajout d'options pour WS
   $sql="ALTER TABLE ".$NPDS_Prefix."groupes ADD groupe_blocnote INT(1) UNSIGNED NOT NULL DEFAULT '0'";
   $result = sql_query($sql);
   $sql="ALTER TABLE ".$NPDS_Prefix."groupes ADD groupe_pad INT(1) UNSIGNED NOT NULL DEFAULT '0'";
   $result = sql_query($sql);
   
   // Converti en nouveau WS
   $result = sql_query("SELECT id, content from ".$NPDS_Prefix."lblocks where content like '%espace_groupe(%'");
   while($temp = sql_fetch_assoc($result) ) {
      $ibid=str_replace("espace_groupe(","",$temp['content']);
      $ibid=trim(str_replace(",1) ","",$ibid));
      sql_query("UPDATE ".$NPDS_Prefix."lblocks set content='function#bloc_espace_groupe\r\nparams#$ibid,1' where id='".$temp['id']."'");
      sql_query("UPDATE ".$NPDS_Prefix."groupes set groupe_blocnote='1', groupe_pad='1' where groupe_id='$ibid'");
   }
   $result = sql_query("SELECT id, content from ".$NPDS_Prefix."rblocks where content like '%espace_groupe(%'");
   while($temp = sql_fetch_assoc($result) ) {
      $ibid=str_replace("espace_groupe(","",$temp['content']);
      $ibid=str_replace(",1) ","",$ibid);
      sql_query("UPDATE ".$NPDS_Prefix."rblocks set content='function#bloc_espace_groupe\r\nparams#$ibid,1' where id='".$temp['id']."'");
      sql_query("UPDATE ".$NPDS_Prefix."groupes set groupe_blocnote='1', groupe_pad='1' where groupe_id='$ibid'");
   }
}
function maj_files() {   
   global $nuke_url;
   
   @unlink("images/admin/ws/package_locked.gif");
   
   // Update NPDS Version
   $file=file("config.php");
   $fic = fopen("config.php", "w");
      while(list($n,$ligne) = each($file)) {
         if (trim($ligne)=="\$Version_Sub = \"REvolution WS\";") 
            $ligne="\$Version_Sub = \"REvolution\";\n";
         if (trim($ligne)=="\$Version_Sub = \"REvolution WS P1\";") 
            $ligne="\$Version_Sub = \"REvolution\";\n";
         if (trim($ligne)=="\$Version_Num = \"11\";") 
            $ligne="\$Version_Num = \"13\";\n";         
         fwrite($fic, $ligne);
   }
   fclose($fic);

   // Update robot.txt for sitemap.xml
   $fic = fopen("robots.txt", "a");
   fwrite($fic,"\r\nSitemap: ".$nuke_url."/cache/sitemap.xml");
   fclose($fic);
   
   SC_clean();

   include ("admin/settings_save.php");
   $tab_tmp=GetMetaTags("meta/meta.php");
   $tab_tmp['doctype']=doctype;
   MetaTagSave("meta/meta.php", $tab_tmp);
}

   include("header.php");
   opentable();
   echo "<link href=\"install/style/style.css\" title=\"default\" rel=\"stylesheet\" type=\"text/css\" media=\"all\" />";
   echo "<p><img src=\"images/banners/revolution13-update.png\" align=\"center\" class=\"mess\" /></p>";

   if ($language=="french") $lang="french"; else $lang="english"; 

   // Check NPDS version
   if ($Version_Sub != "REvolution WS") {
      echo "<div id=\"welcome\" class=\"mess\"><span class=\"rouge\">";
      if ($lang=="french") 
         echo "Vous n'avez pas la bonne version de NPDS - ce patch s'installe par dessus REvolution WS.";
      else
         echo "You haven't the right NPDS version - this update will only work over REvolution WS.";
      echo "</span></div>";
      $op="bad_version";
   }    
    
   switch ($op) {
      case "update":
         mess_update($lang);
         break;
         
      case "finish":
         maj_db();
         maj_files();
         mess_finish($lang);
         
         // delete installation files
           @unlink("install.php");
          
           @unlink ("install/style/style.css");
           @rmdir ("install/style");
          
           @unlink ("install/languages/welcome-french.txt");
           @unlink ("install/languages/welcome-english.txt");
           @unlink ("install/languages/update-french.txt");
           @unlink ("install/languages/update-english.txt");
           @unlink ("install/languages/finish-french.txt");
           @unlink ("install/languages/finish-english.txt");
           @rmdir("install/languages");
          
           @rmdir("install");
         break;
      
      case "bad_version":
         break;
         
      default:
      case "":
         @unlink("IZ-Xinstall.ok");
         mess_welcome($lang);
         break;
   }
   closetable();
   include("footer.php");
?>