<?php
/************************************************************************/
/* DUNE by NPDS                                                         */
/* ===========================                                          */
/*                                                                      */
/* Manage other configuration and customisation files                   */
/* by Hotfirenet 2004                                                   */
/*                                                                      */
/* NPDS Copyright (c) 2002-2013 by Philippe Brunier                     */
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/
function Access_Error () {
  include("admin/die.php");
}
if (!stristr($_SERVER['PHP_SELF'],"admin.php")) { Access_Error(); }

global $language;
$hlpfile = "manuels/$language/configfiles.html";
$result = sql_query("select radminsuper from ".$NPDS_Prefix."authors where aid='$aid'");
list($radminsuper) = sql_fetch_row($result);
if ($radminsuper!=1) {
   Access_Error();
}

function ConfigFiles($contents, $files) {
   global $hlpfile, $language, $max_car;
   include ("header.php");
   GraphicAdmin($hlpfile);
   opentable();

   if ($contents=="") {
      echo "<table width=\"100%\" cellspacing=\"2\" cellpadding=\"2\" border=\"0\">\n"
          . "<tr>\n"
          . "<td class=\"header\">".adm_translate("Editer les fichiers de configuration")."</td>\n"
          . "</tr>\n"
          . "</table>\n"
          . "<table width=\"100%\" cellspacing=\"2\" cellpadding=\"2\" border=\"0\">"
          . "<tr><td colspan=\"3\"><span class=\"noir\" style=\"font-size: 12px;\"><b>/modules/include</b></span></td></tr>\n"
          . "<tr><td>&nbsp;<a href=\"admin.php?op=ConfigFiles_load&amp;files=header_before\" class=\"noir\">Header_Before</a></td><td>".adm_translate("Ce fichier est appel avant que de commencer la gnration de la page HTML")."</td><td><a href=\"admin.php?op=delete_configfile&amp;file=header_before\" class=\"rouge\">".adm_translate("Supprimer")."</a></td></tr>\n"
          . "<tr><td>&nbsp;<a href=\"admin.php?op=ConfigFiles_load&amp;files=header_head\" class=\"noir\">Header_Head</a></td><td>".adm_translate("Ce fichier est appel entre le HEAD et /HEAD lors de la gnration de la page HTML")."</td><td><a href=\"admin.php?op=delete_configfile&amp;file=header_head\" class=\"rouge\">".adm_translate("Supprimer")."</a></td></tr>\n"
          . "<tr><td>&nbsp;<a href=\"admin.php?op=ConfigFiles_load&amp;files=body_onload\" class=\"noir\">Body_Onload</a></td><td>".adm_translate("Ce fichier est appel dans l'vement ONLOAD de la balise BODY => JAVASCRIPT")."</td><td><a href=\"admin.php?op=delete_configfile&amp;file=body_onload\" class=\"rouge\">".adm_translate("Supprimer")."</a></td></tr>\n"
          . "<tr><td>&nbsp;<a href=\"admin.php?op=ConfigFiles_load&amp;files=header_after\" class=\"noir\">Header_After</a></td><td>".adm_translate("Ce fichier est appel  la fin du header du thme")."</td><td><a href=\"admin.php?op=delete_configfile&amp;file=header_after\" class=\"rouge\">".adm_translate("Supprimer")."</a></td></tr>\n"
          . "<tr><td>&nbsp;<a href=\"admin.php?op=ConfigFiles_load&amp;files=footer_before\" class=\"noir\">Footer_Before</a></td><td>".adm_translate("Ce fichier est appel avant le dbut du footer du thme")."</td><td><a href=\"admin.php?op=delete_configfile&amp;file=footer_before\" class=\"rouge\">".adm_translate("Supprimer")."</a></td></tr>\n"
          . "<tr><td>&nbsp;<a href=\"admin.php?op=ConfigFiles_load&amp;files=footer_after\" class=\"noir\">Footer_After</a></td><td>".adm_translate("Ce fichier est appel aprs la fin de la gnration de la page HTML")."</td><td><a href=\"admin.php?op=delete_configfile&amp;file=footer_after\" class=\"rouge\">".adm_translate("Supprimer")."</a></td></tr>\n"
          . "<tr><td>&nbsp;<a href=\"admin.php?op=ConfigFiles_load&amp;files=new_user\" class=\"noir\">New_User</a></td><td>".adm_translate("Ce fichier permet d'envoyer un MI personnalis lorsqu'un nouveau membre s'inscrit")."</td><td><a href=\"admin.php?op=delete_configfile&amp;file=new_user\" class=\"rouge\">".adm_translate("Supprimer")."</a></td></tr>\n"
          . "<tr><td>&nbsp;<a href=\"admin.php?op=ConfigFiles_load&amp;files=user\" class=\"noir\">User</a></td><td>".adm_translate("Ce fichier permet l'affichage d'informations complmentaires dans la page de login")."</td><td><a href=\"admin.php?op=delete_configfile&amp;file=user\" class=\"rouge\">".adm_translate("Supprimer")."</a></td></tr>\n"
          . "<tr><td colspan=\"3\">&nbsp;</td></tr>\n"
          . "<tr><td>&nbsp;<a href=\"admin.php?op=ConfigFiles_load&amp;files=extend-modules\" class=\"noir\">Extend-Modules</a></td><td colspan=\"2\">".adm_translate("Ce fichier permet la configuration des modules complmentaires de l'administration")." ( admin/ )</td></tr>\n"
          . "<tr><td>&nbsp;<a href=\"admin.php?op=ConfigFiles_load&amp;files=cache.config\" class=\"noir\">Cache.Config</a></td><td colspan=\"2\">".adm_translate("Ce fichier permet la configuration technique de SuperCache")." ( / )</td></tr>\n"
          . "<tr><td>&nbsp;<a href=\"admin.php?op=ConfigFiles_load&amp;files=upload.conf\" class=\"noir\">Upload.Conf</a></td><td colspan=\"2\">".adm_translate("Ce fichier permet la configuration des fonctions d'upload")." ( /modules/upload/ )</td></tr>\n"
          . "<tr><td colspan=\"3\">&nbsp;</td></tr>\n"
          . "<tr><td>&nbsp;<a href=\"admin.php?op=ConfigFiles_load&amp;files=robots\" class=\"noir\">robots.txt</a></td><td colspan=\"2\"> ( / )</td></tr>\n"
          . "<tr><td>&nbsp;<a href=\"admin.php?op=ConfigFiles_load&amp;files=humans\" class=\"noir\">humans.txt</a></td><td colspan=\"2\"> ( / )</td></tr>\n"
          . "</table><br />\n";
   } else {
      echo "<table width=\"100%\" cellspacing=\"2\" cellpadding=\"2\" border=\"0\">\n"
          . "<tr>\n"
          . "<td class=\"header\">".adm_translate("Modification de")." : $files</td>\n"
          . "</tr>\n"
          . "</table>\n"
          . "<br />\n"
          . "<form action=\"admin.php?op=ConfigFiles_save\" method=\"post\">\n"
          . "<p align=\"center\">\n"
          . "<textarea class=\"textbox\" name=\"Xtxt\" rows=\"20\" cols=\"70\">\n";
      echo htmlspecialchars($contents,ENT_COMPAT|ENT_HTML401,cur_charset);
      echo "</textarea>\n"
          . "<br /><br />\n"
          . "<input type=\"hidden\" name=\"Xfiles\" value=\"$files\" />"
          . "<input class=\"bouton_standard\" type=\"submit\" name=\"confirm\" value=\"".adm_translate("Sauver les modifications")."\" /> - \n"
          . "<a href=\"admin.php?op=ConfigFiles\" class=\"noir\">".adm_translate("Abandonner")."</a></p>\n"
          . "</form>\n";
   }
   closetable();
   include ("footer.php");
}

function ConfigFiles_save($Xtxt, $Xfiles) {
   if ($Xfiles == "header_before") {
      $fp=fopen("modules/include/header_before.inc","w");
      fputs($fp,stripslashes($Xtxt));
      fclose($fp);
   }
   elseif ($Xfiles == "header_head") {
      $fp=fopen("modules/include/header_head.inc","w");
      fputs($fp,stripslashes($Xtxt));
      fclose($fp);
   }
   elseif ($Xfiles == "body_onload") {
      $fp=fopen("modules/include/body_onload.inc","w");
      fputs($fp,stripslashes($Xtxt));
      fclose($fp);
   }
   elseif ($Xfiles == "header_after") {
      $fp=fopen("modules/include/header_after.inc","w");
      fputs($fp,stripslashes($Xtxt));
      fclose($fp);
   }
   elseif ($Xfiles == "footer_before") {
      $fp=fopen("modules/include/footer_before.inc","w");
      fputs($fp,stripslashes($Xtxt));
      fclose($fp);
   }
   elseif ($Xfiles == "footer_after") {
      $fp=fopen("modules/include/footer_after.inc","w");
      fputs($fp,stripslashes($Xtxt));
      fclose($fp);
   }

   elseif ($Xfiles == "new_user") {
      $fp=fopen("modules/include/new_user.inc","w");
      fputs($fp,stripslashes($Xtxt));
      fclose($fp);
   }
   elseif ($Xfiles == "user") {
      $fp=fopen("modules/include/user.inc","w");
      fputs($fp,stripslashes($Xtxt));
      fclose($fp);
   }
   elseif ($Xfiles == "extend-modules") {
      $fp=fopen("admin/extend-modules.txt","w");
      fputs($fp,stripslashes($Xtxt));
      fclose($fp);
   }
   elseif ($Xfiles == "cache.config") {
      $fp=fopen("cache.config.php","w");
      fputs($fp,stripslashes($Xtxt));
      fclose($fp);
   }
   elseif ($Xfiles == "upload.conf") {
      $fp=fopen("modules/upload/upload.conf.php","w");
      fputs($fp,stripslashes($Xtxt));
      fclose($fp);
   }
   elseif ($Xfiles == "robots") {
      $fp=fopen("robots.txt","w");
      fputs($fp,stripslashes($Xtxt));
      fclose($fp);
   }
   elseif ($Xfiles == "humans") {
      $fp=fopen("humans.txt","w");
      fputs($fp,stripslashes($Xtxt));
      fclose($fp);
   }

   global $aid; Ecr_Log("security", "SaveConfigFile($Xfiles) by AID : $aid", "");
   header("location: admin.php?op=ConfigFiles");
}

function delete_configfile($fileX) {
   global $hlpfile;
   include("header.php");
   GraphicAdmin($hlpfile);
   opentable();
   echo "<p align=\"center\"><b>".adm_translate("Supprimer le fichier")." $fileX ?</b> ";
   echo "[ <a href=\"admin.php?op=ConfigFiles_delete&amp;file=$fileX\" class=\"rouge\">".adm_translate("Oui")."</a>&nbsp;|&nbsp;<a href=\"admin.php?op=ConfigFiles\" class=\"noir\">".adm_translate("Non")."</a> ]</p>";
   closetable();
   include("footer.php");
}
function ConfigFiles_delete($modele) {
   if ($modele=="header_before") {
      @unlink("modules/include/header_before.inc");
   } elseif ($modele=="header_head")  {
      @unlink("modules/include/header_head.inc");
   } elseif ($modele=="body_onload")  {
      @unlink("modules/include/body_onload.inc");
   } elseif ($modele=="header_after")  {
      @unlink("modules/include/header_after.inc");
   } elseif ($modele=="footer_before")  {
      @unlink("modules/include/footer_before.inc");
   } elseif ($modele=="footer_after")  {
      @unlink("modules/include/footer_after.inc");
   } elseif ($modele=="new_user")  {
      @unlink("modules/include/new_user.inc");
   } elseif ($modele=="user")  {
      @unlink("modules/include/user.inc");
   }

   global $aid; Ecr_Log("security", "DeleteConfigFile($modele) by AID : $aid", "");
   header("location: admin.php?op=ConfigFiles");
}

function copy_sample($fileX) {
   global $hlpfile;
   include("header.php");
   GraphicAdmin($hlpfile);
   opentable();
   echo "<p align=\"center\"><b>".adm_translate("Crer le fichier en utilisant le modle")." ?</b> ";
   echo "[ <a href=\"admin.php?op=ConfigFiles_create&amp;modele=$fileX\" class=\"rouge\">".adm_translate("Oui")."</a>&nbsp;|&nbsp;<a href=\"admin.php?op=ConfigFiles\" class=\"noir\">".adm_translate("Non")."</a> ]</p>";
   closetable();
   include("footer.php");
}
function ConfigFiles_create($modele) {
   @umask("0000");
   if ($modele=="header_before") {
      @copy("modules/include/sample.header_before.inc","modules/include/header_before.inc");
      @chmod("modules/include/header_before.inc",0766);
   } elseif ($modele=="header_head")  {
      @copy("modules/include/sample.header_head.inc","modules/include/header_head.inc");
      @chmod("modules/include/header_head.inc",0766);
   } elseif ($modele=="body_onload")  {
      @copy("modules/include/sample.body_onload.inc","modules/include/body_onload.inc");
      @chmod("modules/include/body_onload.inc",0766);
   } elseif ($modele=="header_after")  {
      @copy("modules/include/sample.header_after.inc","modules/include/header_after.inc");
      @chmod("modules/include/header_after.inc",0766);
   } elseif ($modele=="footer_before")  {
      copy("modules/include/sample.footer_before.inc","modules/include/footer_before.inc");
      chmod("modules/include/footer_before.inc",0766);
   } elseif ($modele=="footer_after")  {
      @copy("modules/include/sample.footer_after.inc","modules/include/footer_after.inc");
      @chmod("modules/include/footer_after.inc",0766);
   } elseif ($modele=="new_user")  {
      @copy("modules/include/sample.new_user.inc","modules/include/new_user.inc");
      @chmod("modules/include/new_user.inc",0766);
   } elseif ($modele=="user")  {
      @copy("modules/include/sample.user.inc","modules/include/user.inc");
      @chmod("modules/include/user.inc",0766);
   }

   global $aid; Ecr_Log("security", "CreateConfigFile($modele) by AID : $aid", "");
   header("location: admin.php?op=ConfigFiles");
}

switch ($op) {
    case "ConfigFiles_load":
       if ($files == "header_before") {
          if (file_exists("modules/include/header_before.inc")) {
             $fp=fopen("modules/include/header_before.inc","r");
             $Xcontents=fread($fp,filesize("modules/include/header_before.inc"));
             fclose($fp);
          } else {
             copy_sample($files);
          }
       }
       elseif ($files == "header_head") {
          if (file_exists("modules/include/header_head.inc")) {
             $fp=fopen("modules/include/header_head.inc","r");
             $Xcontents=fread($fp,filesize("modules/include/header_head.inc"));
             fclose($fp);
          } else {
             copy_sample($files);
          }
       }
       elseif ($files == "body_onload") {
         if (file_exists("modules/include/body_onload.inc")) {
            $fp=fopen("modules/include/body_onload.inc","r");
            $Xcontents=fread($fp,filesize("modules/include/body_onload.inc"));
            fclose($fp);
          } else {
             copy_sample($files);
          }
       }
       elseif ($files == "header_after") {
          if (file_exists("modules/include/header_after.inc")) {
             $fp=fopen("modules/include/header_after.inc","r");
             $Xcontents=fread($fp,filesize("modules/include/header_after.inc"));
             fclose($fp);
          } else {
             copy_sample($files);
          }
       }
       elseif ($files == "footer_before") {
          if (file_exists("modules/include/footer_before.inc")) {
             $fp=fopen("modules/include/footer_before.inc","r");
             $Xcontents=fread($fp,filesize("modules/include/footer_before.inc"));
             fclose($fp);
          } else {
             copy_sample($files);
          }
       }
       elseif ($files == "footer_after") {
          if (file_exists("modules/include/footer_after.inc")) {
             $fp=fopen("modules/include/footer_after.inc","r");
             $Xcontents=fread($fp,filesize("modules/include/footer_after.inc"));
             fclose($fp);
          } else {
             copy_sample($files);
          }
       }

       elseif ($files == "new_user") {
          if (file_exists("modules/include/new_user.inc")) {
             $fp=fopen("modules/include/new_user.inc","r");
             $Xcontents=fread($fp,filesize("modules/include/new_user.inc"));
             fclose($fp);
          } else {
             copy_sample($files);
          }
       }
       elseif ($files == "user") {
          if (file_exists("modules/include/user.inc")) {
             $fp=fopen("modules/include/user.inc","r");
             $Xcontents=fread($fp,filesize("modules/include/user.inc"));
             fclose($fp);
          } else {
             copy_sample($files);
          }
       }

       elseif ($files == "extend-modules") {
          if (file_exists("admin/extend-modules.txt")) {
             $fp=fopen("admin/extend-modules.txt","r");
             $Xcontents=fread($fp,filesize("admin/extend-modules.txt"));
             fclose($fp);
          }
       }
       elseif ($files == "cache.config") {
          if (file_exists("cache.config.php")) {
             $fp=fopen("cache.config.php","r");
             $Xcontents=fread($fp,filesize("cache.config.php"));
             fclose($fp);
          }
       }
       elseif ($files == "upload.conf") {
          if (file_exists("modules/upload/upload.conf.php")) {
             $fp=fopen("modules/upload/upload.conf.php","r");
             $Xcontents=fread($fp,filesize("modules/upload/upload.conf.php"));
             fclose($fp);
          }
       }
       elseif ($files == "robots") {
          if (file_exists("robots.txt")) {
             $fp=fopen("robots.txt","r");
             $Xcontents=fread($fp,filesize("robots.txt"));
             fclose($fp);
          }
       }
       elseif ($files == "humans") {
          if (file_exists("humans.txt")) {
             $fp=fopen("humans.txt","r");
             $Xcontents=fread($fp,filesize("humans.txt"));
             fclose($fp);
          }
       }

       ConfigFiles($Xcontents, $files);
       break;

    case "ConfigFiles_save":
        ConfigFiles_save($Xtxt, $Xfiles);
        break;

    case "ConfigFiles_create":
        ConfigFiles_create($modele);
        break;

    case "delete_configfile":
        delete_configfile($file);
        break;
    case "ConfigFiles_delete":
        ConfigFiles_delete($file);
        break;

    default:
        ConfigFiles("", "");
        break;
}
?>