<?php
/************************************************************************/
/* DUNE by NPDS                                                         */
/* ===========================                                          */
/*                                                                      */
/* Based on PhpNuke 4.x source code                                     */
/*                                                                      */
/* NPDS Copyright (c) 2002-2013 by Philippe Brunier                     */
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/
/*  Translated by :
    Zhang Yingzhu, Li Po, Qian Zhi, Jean Pierre Barbary
*/

function translate($phrase) {
   $tmp=translate_pass1($phrase);
   include("language/lang-mods.php");
   return ($tmp);
}

function translate_pass1($phrase) {
 settype($englishname,'string');
 switch($phrase) {
   case "$englishname": $tmp="$englishname"; break;
   case "datestring": $tmp="%A %d %B %Y @ %H:%M:%S"; break;
   case "datestring2": $tmp="%A, %d %B"; break;
   case "linksdatestring": $tmp="%d-%m-%Y"; break;
   case "dateinternal": $tmp="d-m-Y H:i"; break;
   case "Chatdate" : $tmp = "G:i d-m" ;break;
   case "Monday": $tmp="&#26143;&#26399;&#19968;"; break;
   case "Tuesday": $tmp="&#26143;&#26399;&#20108;"; break;
   case "Wednesday": $tmp="&#26143;&#26399;&#19977;"; break;
   case "Thursday": $tmp="&#26143;&#26399;&#22235;"; break;
   case "Friday": $tmp="&#26143;&#26399;&#20116;"; break;
   case "Saturday": $tmp="&#26143;&#26399;&#20845;"; break;
   case "Sunday": $tmp="&#26143;&#26399;&#26085;"; break;
   case "January": $tmp="&#x4E00;&#x6708;"; break;
   case "February": $tmp="&#x4E8C;&#x6708;"; break;
   case "March": $tmp="&#x4E09;&#x6708;"; break;
   case "April": $tmp="&#x56DB;&#x6708;"; break;
   case "May": $tmp="&#x4E94;&#x6708;"; break;
   case "June": $tmp="&#x516D;&#x6708;"; break;
   case "July": $tmp="&#x4E03;&#x6708;"; break;
   case "August": $tmp="&#x516B;&#x6708;"; break;
   case "September": $tmp="&#x4E5D;&#x6708;"; break;
   case "October": $tmp="&#x5341;&#x6708;"; break;
   case "November": $tmp="&#x5341;&#x4E00;&#x6708;"; break;
   case "December": $tmp="&#x5341;&#x4E8C;&#x6708;"; break;

   case "Printer Friendly Page": $tmp="&#x663E;&#x793A;&#x53EF;&#x6253;&#x5370;&#x7248;&#x672C;"; break;
   case "Send this Story to a Friend": $tmp="&#x53D1;&#x9001;&#x8FD9;&#x7BC7;&#x6587;&#x7AE0;&#x7ED9;&#x670B;&#x53CB;"; break;
   case "next matches": $tmp="&#x4E0B;&#x4E00;&#x4E2A;&#x7B54;&#x590D;"; break;
   case "There are currently,": $tmp="&#x76EE;&#x524D;&#x6709;"; break;
   case "Search": $tmp="&#x641C;&#x7D22;"; break;
   case "Web Links": $tmp="&#x7F51;&#x7AD9;&#x94FE;&#x63A5;"; break;
   case "Submit": $tmp="&#x786E;&#x5B9A;"; break;
   case "by": $tmp="&#x7531;"; break;
   case "Other": $tmp="&#x5176;&#x5B83;&#x7684;"; break;
   case "previous matches": $tmp="&#x524D;&#x4E00;&#x4E2A;&#x7B54;&#x590D;"; break;
   case "Change Status to OK / Delete Request": $tmp="&#x6539;&#x53D8;&#x72B6;&#x51B5;&#x4E3A;&#x662F;/&#x5220;&#x9664;&#x7533;&#x8BF7;"; break;
   case "Go Back": $tmp="&#x540E;&#x9000;"; break;
   case "Thanks for your submission.": $tmp="&#x611F;&#x8C22;&#x60A8;&#x7684;&#x63D0;&#x95EE;&#x3002;&#x6211;&#x4EEC;&#x5C06;&#x4F1A;&#x5728;&#x4E0D;&#x4E45;&#x67E5;&#x770B;&#x5B83;&#x3002;"; break;
   case "Please enter information according to the specifications": $tmp="&#x8BF7;&#x4F9D;&#x7167;&#x8BF4;&#x660E;&#x8F93;&#x5165;&#x4FE1;&#x606F;"; break;
   case "Additional Details": $tmp="&#x9644;&#x52A0;&#x7684;&#x7EC6;&#x8282;"; break;
   case "Links Main": $tmp="&#x94FE;&#x63A5;&#x4E3B;&#x9875;"; break;
   case "Add Link": $tmp="&#x52A0;&#x5165;&#x7F51;&#x7AD9;"; break;
   case "New": $tmp="&#x6700;&#x65B0;&#x7F51;&#x7AD9;"; break;
   case "New links": $tmp="&#x65B0;&#x94FE;&#x63A5;"; break;
   case "Modify": $tmp="&#x4FEE;&#x6539;"; break;
   case "There are": $tmp="&#x73B0;&#x5728;&#x6709;"; break;
   case "Links in our Database": $tmp="&#x4E2A;&#x94FE;&#x63A5;&#x5728;&#x6211;&#x4EEC;&#x7684;&#x6570;&#x636E;&#x5E93;&#x4E2D;"; break;
   case "New Links in this Category Added Today": $tmp="&#x672C;&#x5206;&#x7C7B;&#x4ECA;&#x5929;&#x65B0;&#x589E;&#x52A0;&#x7684;&#x94FE;&#x63A5;"; break;
   case "New Links in this Category Added in the last 3 days": $tmp="&#x672C;&#x5206;&#x7C7B;&#x8FD1;&#x4E09;&#x5929;&#x65B0;&#x589E;&#x52A0;&#x7684;&#x94FE;&#x63A5;"; break;
   case "New Links in this Category Added this week": $tmp="&#x672C;&#x5206;&#x7C7B;&#x672C;&#x5468;&#x65B0;&#x589E;&#x52A0;&#x7684;&#x94FE;&#x63A5;"; break;
   case "Waiting Links": $tmp="&#x7B49;&#x5F85;&#x7684;&#x94FE;&#x63A5;"; break;
   case "Create": $tmp="&#x521B;&#x5EFA;"; break;
   case "Sort links by": $tmp="&#x9009;&#x62E9;&#x7F51;&#x7AD9;&#x94FE;&#x63A5;&#x6392;&#x5E8F;&#x65B9;&#x5F0F;"; break;
   case "Title": $tmp="&#x6807;&#x9898;"; break;
   case "Date": $tmp="&#x65E5;&#x671F;"; break;
   case "Sites currently sorted by": $tmp="&#x7AD9;&#x70B9;&#x73B0;&#x5728;&#x6392;&#x5E8F;&#x4F9D;&#x7167;"; break;
   case "SubCategories": $tmp="&#x5B50;&#x5206;&#x7C7B;"; break;
   case "Description: ": $tmp="&#x63CF;&#x8FF0; : "; break;
   case "Hits: ": $tmp="&#x70B9;&#x51FB;&#x6B21;&#x6570; : "; break;
   case "Added on: ": $tmp="&#x6DFB;&#x52A0;&#x4E8E;: "; break;
   case "Report Broken Link": $tmp="&#x62A5;&#x544A;&#x65E0;&#x6548;&#x94FE;&#x63A5;"; break;
   case "Select page": $tmp="&#x9009;&#x62E9;&#x9875;"; break;
   case "Previous": $tmp="&#x4E0A;&#x4E00;&#x4E2A;"; break;
   case "Next": $tmp="&#x4E0B;&#x4E00;&#x4E2A;"; break;
   case "Main": $tmp="&#x4E3B;&#x5206;&#x7C7B;"; break;
   case "Title (A to Z)": $tmp="&#x6807;&#x9898; (A to Z)"; break;
   case "Title (Z to A)": $tmp="&#x6807;&#x9898; (Z to A)"; break;
   case "Date (Old Links Listed First)": $tmp="&#x65E5;&#x671F; (&#x5148;&#x5217;&#x51FA;&#x65E7;&#x94FE;&#x63A5;)"; break;
   case "Date (New Links Listed First)": $tmp="&#x65E5;&#x671F; (&#x5148;&#x5217;&#x51FA;&#x65B0;&#x94FE;&#x63A5;)"; break;
   case "Editorial by": $tmp="&#x7BA1;&#x7406;&#x5458;&#x8BC4;&#x8BBA;&#x53D1;&#x8868;&#x8005;"; break;
   case "No editorial is currently available for this website.": $tmp="&#x6CA1;&#x6709;&#x5173;&#x4E8E;&#x6B64;&#x4E0B;&#x8F7D;&#x9879;&#x7684;&#x7BA1;&#x7406;&#x5458;&#x8BC4;&#x8BBA;&#x3002;"; break;
   case "Visit this Website": $tmp="&#x8BBF;&#x95EE;&#x8FD9;&#x4E2A;&#x7F51;&#x7AD9;"; break;
   case "Submit a unique link only once.": $tmp="&#x4E00;&#x4E2A;&#x94FE;&#x63A5;&#x5730;&#x5740;&#x53EA;&#x80FD;&#x63D0;&#x4EA4;&#x4E00;&#x6B21;&#x3002;"; break;
   case "All links are posted pending verification.": $tmp="&#x6240;&#x6709;&#x5F20;&#x8D34;&#x51FA;&#x7684;&#x94FE;&#x63A5;&#x662F;&#x7ECF;&#x8FC7;&#x786E;&#x8BA4;&#x7684;&#x3002;"; break;
   case "Username and IP are recorded, so please don't abuse the system.": $tmp="&#x7528;&#x6237;&#x540D;&#x79F0;&#x4E0E;IP&#x5DF2;&#x88AB;&#x8BB0;&#x5F55;, &#x8BF7;&#x522B;&#x6EE5;&#x7528;&#x6216;&#x7834;&#x574F;&#x7CFB;&#x7EDF;&#xFF01;."; break;
   case "Page Title: ": $tmp="&#x7F51;&#x9875;&#x540D;&#x79F0; : "; break;
   case "Page URL: ": $tmp="&#x7F51;&#x9875;URL : "; break;
   case "Category: ": $tmp="&#x5206;&#x7C7B; : "; break;
   case "Description: (255 characters max)": $tmp="&#x63CF;&#x8FF0;&#xFF1A;(&#x6700;&#x591A;255 &#x5B57;&#x7B26;)"; break;
   case "Your Name: ": $tmp="&#x60A8;&#x7684;&#x59D3;&#x540D; : "; break;
   case "Your Email: ": $tmp="&#x4F60;&#x7684;&#x96FB;&#x90F5; : "; break;
   case "Add URL": $tmp="&#x6DFB;&#x52A0;&#x4E00;&#x4E2A;&#x7F51;&#x5740;"; break;
   case "You are not a registered user or you have not logged in.": $tmp="&#x60A8;&#x4E0D;&#x662F;&#x6CE8;&#x518C;&#x7528;&#x6237;&#x6216;&#x8005;&#x60A8;&#x6CA1;&#x6709;&#x767B;&#x5F55;&#x3002;"; break;
   case "If you were registered you could add links on this website.": $tmp="&#x5982;&#x679C;&#x60A8;&#x662F;&#x6CE8;&#x518C;&#x7528;&#x6237;&#x60A8;&#x53EF;&#x4EE5;&#x5728;&#x672C;&#x7AD9;&#x63D0;&#x4EA4;&#x94FE;&#x63A5;&#x3002;"; break;
   case "ERROR: This URL is already listed in the Database!": $tmp="&#x9519;&#x8BEF;&#xFF1A;&#x8FD9;&#x4E2A;URL&#x5DF2;&#x7ECF;&#x5728;&#x6211;&#x4EEC;&#x7684;&#x6570;&#x636E;&#x5E93;&#x4E2D;&#xFF01; !"; break;
   case "ERROR: You need to type a TITLE for your URL!": $tmp="&#x9519;&#x8BEF;: &#x60A8;&#x9700;&#x8981;&#x7ED9;&#x60A8;&#x7684; URL &#x586B;&#x5199;&#x4E00;&#x4E2A;&#x540D;&#x79F0;&#xFF01;"; break;
   case "ERROR: You need to type a URL for your URL!": $tmp="&#x9519;&#x8BEF;: &#x60A8;&#x9700;&#x8981;&#x7ED9;&#x60A8;&#x7684; URL &#x586B;&#x5199;&#x4E00;&#x4E2A;URL&#xFF01;!"; break;
   case "ERROR: You need to type a DESCRIPTION for your URL!": $tmp="&#x9519;&#x8BEF;: &#x60A8;&#x9700;&#x8981;&#x7ED9;&#x60A8;&#x7684; URL &#x586B;&#x5199;&#x4E00;&#x4E2A;&#x63CF;&#x8FF0;&#xFF01;!"; break;
   case "We received your Link submission. Thanks!": $tmp="&#x6211;&#x4EEC;&#x5DF2;&#x7ECF;&#x6536;&#x5230;&#x60A8;&#x63D0;&#x4EA4;&#x7684;&#x94FE;&#x63A5;&#x3002;&#x8C22;&#x8C22;&#xFF01; !"; break;
   case "You'll receive and E-mail when it's approved.": $tmp="&#x5F53;&#x60A8;&#x7684;&#x94FE;&#x63A5;&#x88AB;&#x6211;&#x4EEC;&#x901A;&#x8FC7;&#x60A8;&#x4F1A;&#x6536;&#x5230;&#x4E00;&#x5C01;&#x786E;&#x8BA4;&#x4FE1;&#x3002;"; break;
   case "New Links": $tmp="&#x65B0;&#x94FE;&#x63A5;"; break;
   case "Total new links: Last week": $tmp="&#x6700;&#x8FD1;&#x52A0;&#x5165;&#x7684;&#x65B0;&#x7DB2;&#x7AD9;&#xFF1A;&#x904E;&#x5F80;&#x4E00;&#x661F;&#x671F;"; break;
   case "Last 30 days": $tmp="&#x904E;&#x5F80; 30 &#x65E5;"; break;
   case "week": $tmp="&#x5468"; break;
   case "weeks": $tmp="&#x5468"; break;
   case "Show:": $tmp="&#x663E;&#x793A; :"; break;
   case "days": $tmp="&#x65E5;"; break;
   case "Total new links for last": $tmp="&#x5408;&#x8BA1;&#x6700;&#x8FD1;&#x65B0;&#x94FE;&#x63A5;"; break;
   case "Request Link Modification": $tmp="&#x8BF7;&#x6C42;&#x7F51;&#x7AD9;&#x94FE;&#x63A5;&#x4FEE;&#x6539;"; break;
   case "Link ID: ": $tmp="&#x94FE;&#x63A5;ID : "; break;
   case "Send Request": $tmp="&#x8FD4;&#x56DE"; break;
   case "Thanks for this information. We'll look into your request shortly.": $tmp="&#x611F;&#x8C22;&#x60A8;&#x7684;&#x4FE1;&#x606F;&#x3002;&#x6211;&#x4EEC;&#x5C06;&#x5C3D;&#x5FEB;&#x51FA;&#x529B;&#x60A8;&#x7684;&#x8981;&#x6C42;&#x3002;"; break;
   case "Thank you for helping to maintain this directory's integrity.": $tmp="&#x5341;&#x5206;&#x611F;&#x8C22;&#x60A8;&#x53C2;&#x4E0E;&#x7EF4;&#x62A4;&#x672C;&#x76EE;&#x5F55;&#x7684;&#x5B8C;&#x6574;&#x3002;"; break;
   case "For security reasons your user name and IP address will also be temporarily recorded.": $tmp="&#x51FA;&#x4E8E;&#x7F51;&#x7EDC;&#x5B89;&#x5168;&#x7684;&#x539F;&#x56E0;&#xFF0C;&#x60A8;&#x7684;&#x62E5;&#x62A4;&#x540D;&#x548C;IP&#x5730;&#x5740;&#x5C06;&#x4E34;&#x65F6;&#x4FDD;&#x5B58;&#x3002;"; break;
   case "Online Manual": $tmp="&#x5728;&#x7EBF;&#x624B;&#x518C;"; break;
   case "Links Waiting for Validation": $tmp="&#x8BE5;&#x94FE;&#x63A5;&#x5728;&#x7B49;&#x5F85;&#x5B9E;&#x73B0;&#x4E2D;&#x3002;"; break;
   case "Author": $tmp="&#x4F5C;&#x8005; "; break;
   case "Visit": $tmp="&#x8BBF;&#x95EE;"; break;
   case "Name: ": $tmp="&#x59D3;&#x540D; : "; break;
   case "Email: ": $tmp="E-mail : "; break;
   case "Delete": $tmp="&#x5220;&#x9664;"; break;
   case "Add": $tmp="&#x6DFB;&#x52A0;"; break;
   case "Broken Link Reports": $tmp="&#x65E0;&#x6548;&#x94FE;&#x63A5;&#x62A5;&#x544A;"; break;
   case "Link Modification Requests": $tmp="&#x94FE;&#x63A5;&#x4FEE;&#x6539;&#x8BF7;&#x6C42;"; break;
   case "Add a MAIN Category": $tmp="&#x6DFB;&#x52A0;&#x4E3B;&#x5206;&#x7C7B;"; break;
   case "Modify Category": $tmp="&#x7F16;&#x8F91;&#x5206;&#x7C7B;"; break;
   case "Add a SUB-Category": $tmp="&#x6DFB;&#x52A0;&#x5B50;&#x5206;&#x7C7B;"; break;
   case "in": $tmp="&#x5728;"; break;
   case "Add a New Link": $tmp="&#x6DFB;&#x52A0;&#x65B0;&#x94FE;&#x63A5;"; break;
   case "E-Mail: ": $tmp="E-mail : "; break;
   case "New Link added to the Database": $tmp="&#x65B0;&#x94FE;&#x63A5;&#x5DF2;&#x6DFB;&#x52A0;&#x5230;&#x6570;&#x636E;&#x5E93;"; break;
   case "Your Link at": $tmp="&#x60A8;&#x7684;&#x94FE;&#x63A5;&#x5728;"; break;
   case "Hello": $tmp="&#x60A8;&#x597D;"; break;
   case "We approved your link submission for our search engine.": $tmp="&#x6211;&#x4EEC;&#x5DF2;&#x7ECF;&#x5C06;&#x60A8;&#x63D0;&#x4EA4;&#x7684;&#x94FE;&#x63A5;&#x52A0;&#x5165;&#x6211;&#x4EEC;&#x7684;&#x641C;&#x7D22;&#x5F15;&#x64CE;."; break;
   case "You can browse our search engine at:": $tmp="&#x60A8;&#x53EF;&#x4EE5;&#x8BBF;&#x95EE;&#x6211;&#x4EEC;&#x7684;&#x641C;&#x7D22;&#x5F15;&#x64CE;&#x5728; : "; break;
   case "Thanks for your submission!": $tmp="&#x611F;&#x8C22;&#x60A8;&#x7684;&#x63D0;&#x95EE;&#x3002;&#x6211;&#x4EEC;&#x5C06;&#x4F1A;&#x5728;&#x4E0D;&#x4E45;&#x67E5;&#x770B;&#x5B83;&#x3002; !"; break;
   case "Modify Links": $tmp="&#x4FEE;&#x6539;&#x94FE;&#x63A5;"; break;
   case "Add Editorial": $tmp="&#x6DFB;&#x52A0;&#x793E;&#x8BBA;"; break;
   case "Full Text": $tmp="&#x5B8C;&#x6574;&#x6587;&#x7AE0;"; break;
   case "Modify Editorial": $tmp="&#x4FEE;&#x6539;&#x7F16;&#x8F91;"; break;
   case "already exist!": $tmp="&#x5DF2;&#x7ECF;&#x5B58;&#x5728;!"; break;
   case "ERROR: The SubCategory": $tmp="&#x9519;&#x8BEF;&#xFF1A;&#x8BE5;&#x6B21;&#x76EE;&#x5F55;"; break;
   case "Save Changes": $tmp="&#x4FDD;&#x5B58;&#x66F4;&#x6539;"; break;
   case "Category Name: ": $tmp="&#x5206;&#x7C7B;&#x540D;&#x79F0; : "; break;
   case "Sub-Category Name: ": $tmp="&#x6B21;&#x76EE;&#x5F55;&#x7684;&#x540D;&#x79F0; :"; break;
   case "ERROR: The Category": $tmp="&#x9519;&#x8BEF;&#xFF1A;&#x76EE;&#x5F55;"; break;
   case "WARNING: Are you sure you want to delete this Category and ALL its Links?": $tmp="&#x8B66;&#x544A;&#xFF1A;&#x60A8;&#x786E;&#x8BA4;&#x5220;&#x9664;&#x8BE5;&#x5206;&#x7C7B;&#x548C;&#x5176;&#x4E0B;&#x7684;&#x6240;&#x6709;&#x94FE;&#x63A5;&#xFF1F; ?"; break;
   case "No": $tmp="&#x5426;"; break;
   case "Yes": $tmp="&#x662F;"; break;
   case "User Link Modification Requests": $tmp="&#x7528;&#x6237;&#x94FE;&#x63A5;&#x4FEE;&#x6539;&#x8BF7;&#x6C42;"; break;
   case "Original": $tmp="&#x539F;&#x59CB;&#x7684;"; break;
   case "Description:": $tmp="&#x63CF;&#x8FF0;:"; break;
   case "Title:": $tmp="&#x6807;&#x9898; :"; break;
   case "URL:": $tmp="URL : "; break;
   case "Cat:": $tmp="&#x5206;&#x7C7B; :"; break;
   case "Subcat:": $tmp="&#x6B21;&#x76EE;&#x5F55; :"; break;
   case "Proposed": $tmp="&#x5EFA;&#x8BAE;&#x4FEE;&#x6539;&#x4E3A;"; break;
   case "Submitter": $tmp="&#x63D0;&#x4EA4;&#x8005;"; break;
   case "Owner": $tmp="&#x6240;&#x6709;&#x8005;"; break;
   case "Ignore": $tmp="&#x5FFD;&#x7565;"; break;
   case "Accept": $tmp="&#x63A5;&#x53D7;"; break;
   case "User Reported Broken Links": $tmp="&#x7528;&#x6237;&#x62A5;&#x544A;&#x65E0;&#x6548;&#x94FE;&#x63A5;"; break;
   case "Ignore (Deletes all <b>requests</b> for a given link)": $tmp="&#x5FFD;&#x7565; (&#x5220;&#x9664;&#x6240;&#x6709;<b>&#x94FE;&#x63A5;&#x8BF7;&#x6C42;</b>)"; break;
   case "Delete (Deletes <b>broken link</b> and <b>requests</b> for a given link)": $tmp="&#x5220;&#x9664; (&#x5220;&#x9664;<b>&#x65E0;&#x6548;&#x94FE;&#x63A5;</b>&#x548C;<b><i>&#x8BF7;&#x6C42;</i></b>)"; break;
   case "Links": $tmp="&#x94FE;&#x63A5;"; break;
   case "Welcome to": $tmp="&#x6B22;&#x8FCE;&#x60A8;&#x5728;"; break;
   case "Welcome": $tmp="&#x6B22;&#x8FCE;"; break;
   case "Logout": $tmp="&#x6CE8;&#x9500;"; break;
   case "writes": $tmp="&#x64B0;&#x5199;"; break;
   case "on": $tmp="&#x5728;"; break;
   case "Posted by ": $tmp="&#x53D1;&#x8868;&#x8005; "; break;
   case "reads": $tmp="&#x9605;&#x8BFB;&#x6B21;&#x6570;"; break;
   case "Posted on ": $tmp="&#x7C98;&#x8D34; "; break;
   case "Edit": $tmp="&#x7F16;&#x8F91;"; break;
   case "Topics": $tmp="&#x4E3B;&#x9898;"; break;
   case "All Topics": $tmp="&#x6240;&#x6709;&#x4E3B;&#x9898;"; break;
   case "Note": $tmp="&#x6CE8;&#x610F;&#xFF1A;"; break;
   case "Posted on": $tmp="&#x7C98;&#x8D34;"; break;
   case "Contributed by": $tmp="&#x63D0;&#x4EA4;&#x8005;"; break;
   case "Posted by": $tmp="&#x53D1;&#x8868;&#x8005;"; break;
   case "Edit User": $tmp="&#x60A8;"; break;
   case "Change the home": $tmp="&#x6539;&#x53D8;&#x9996;&#x9875;"; break;
   case "Comments": $tmp="&#x8BC4;&#x8BBA;"; break;
   case "Change Theme": $tmp="&#x66F4;&#x6362;&#x4E3B;&#x9898;"; break;
   case "Menu for": $tmp="&#x83DC;&#x5355;"; break;
   case "Contributed by ": $tmp="&#x63D0;&#x4EA4;&#x8005; "; break;
   case "Edit Journal": $tmp="&#x7F16;&#x8F91;&#x60A8;&#x7684;&#x62A5;&#x7EB8;"; break;
   case "ERROR: Invalid email": $tmp="&#x9519;&#x8BEF;&#xFF1A;&#x65E0;&#x6548;&#x7684;&#x7535;&#x5B50;&#x90AE;&#x4EF6;"; break;
   case "ERROR: Email addresses do not contain spaces.": $tmp="&#x9519;&#x8BEF;&#xFF1A;&#x4E00;&#x4E2A;&#x90AE;&#x4EF6;&#x5730;&#x5740;&#x4E0D;&#x80FD;&#x5305;&#x542B;&#x7A7A;&#x95F4;"; break;
   case "ERROR: Invalid Nickname": $tmp="&#x9519;&#x8BEF;&#xFF1A;&#x60A8;&#x7684;&#x8EAB;&#x4EFD;&#x4E0D;&#x80FD;&#x88AB;&#x8BC6;&#x522B;"; break;
   case "Nickname is too long. It must be less than 25 characters.": $tmp="&#x5462;&#x79F0;&#x5E94;&#x5C11;&#x4E8E;25&#x4E2A;&#x82F1;&#x6587;&#x5B57;&#x6BCD;&#x7684;&#x957F;&#x5EA6;&#x3002;"; break;
   case "ERROR: Name is reserved.": $tmp="&#x9519;&#x8BEF;&#xFF1A;&#x8FD9;&#x4E2A;&#x540D;&#x5B57;&#x662F;&#x88AB;&#x4FDD;&#x7559;&#x7684;&#xFF0C;&#x4E0D;&#x80FD;&#x88AB;&#x4F7F;&#x7528;&#x3002;"; break;
   case "There cannot be any spaces in the Nickname.": $tmp="&#x5462;&#x79F0;&#x4E2D;&#x4E0D;&#x80FD;&#x4F7F;&#x7528;&#x7A7A;&#x683C;&#x3002;"; break;
   case "ERROR: Nickname taken": $tmp="&#x9519;&#x8BEF;&#xFF1A;&#x8FD9;&#x4E2A;&#x5462;&#x79F0;&#x5DF2;&#x7ECF;&#x6709;&#x4EBA;&#x4F7F;&#x7528;&#x4E86;&#x3002;"; break;
   case "ERROR: Email address already registered": $tmp="&#x9519;&#x8BEF;: &#x5DF2;&#x7ECF;&#x6709;&#x4EBA;&#x7528;&#x8FD9;&#x4E2A;Email&#x6CE8;&#x518C;&#x8FC7;"; break;
   case "User ID": $tmp="&#x7528;&#x6237;ID"; break;
   case "Real Name": $tmp="&#x771F;&#x5B9E;&#x59D3;&#x540D;"; break;
   case "Avatar": $tmp="&#x5934;&#x50CF;"; break;
   case "Website: ": $tmp="&#x7F51;&#x7AD9; : "; break;
   case "Your ICQ": $tmp="&#x60A8;&#x7684;ICQ&#x53F7;"; break;
   case "Your AIM": $tmp="&#x60A8;&#x7684;AIM&#x53F7;"; break;
   case "Your YIM": $tmp="YIM &#x53F7;"; break;
   case "Your MSNM": $tmp="&#x60A8;&#x7684;MSNM&#x53F7;"; break;
   case "Location: ": $tmp="&#x60A8;&#x7684;&#x4F4F;&#x5740; : "; break;
   case "Occupation: ": $tmp="&#x804C;&#x4E1A; : "; break;
   case "Interest: ": $tmp="&#x60A8;&#x7684;&#x5174;&#x8DA3; : "; break;
   case "Signature": $tmp="&#x7B7E;&#x540D;"; break;
   case "Finish": $tmp="&#x5B8C;&#x6210;"; break;
   /**/case "You or someone else has used your email account": $tmp="&#x60A8;&#x6216;&#x8005;&#x5176;&#x4ED6;&#x67D0;&#x4E2A;&#x4EBA;&#x5DF2;&#x7ECF;&#x4F7F;&#x7528;&#x4E86;&#x60A8;&#x7684;email&#x5E10;&#x53F7;"; break;
   case "to register an account at": $tmp="&#x6CE8;&#x518C;&#x4E00;&#x4E2A;&#x5E10;&#x53F7;&#x5728;"; break;
   case "The following is the member information:": $tmp="&#x4EE5;&#x4E0B;&#x662F;&#x7528;&#x6237;&#x4FE1;&#x606F;&#xFF1A; :"; break;
   case "-Nickname: ": $tmp="-&#x7528;&#x6237;&#x540D; : "; break;
   case "-Password: ": $tmp="-&#x5BC6;&#x7801; : "; break;
   case "User Password for": $tmp="&#x7528;&#x6237;&#x5BC6;&#x7801;&#x5173;&#x4E8E;"; break;
   case "Your Password is: ": $tmp="&#x60A8;&#x7684;&#x5BC6;&#x7801;&#x662F;&#xFF1A; : "; break;
   case "You can change it after you login at": $tmp="&#x60A8;&#x53EF;&#x4EE5;&#x5728;&#x4FEE;&#x6539;&#x5BC6;&#x7801;&#xFF0C;&#x8BF7;&#x767B;&#x5F55;"; break;
   case "You are now registered. You should receive your password at the email account you provided.": $tmp="&#x60A8;&#x5DF2;&#x7ECF;&#x6CE8;&#x518C;&#x6210;&#x529F;&#x3002;&#x60A8;&#x4F1A;&#x5728;&#x60A8;&#x6240;&#x63D0;&#x4EA4;&#x7684;email&#x4FE1;&#x7BB1;&#x4E2D;&#x6536;&#x5230;&#x60A8;&#x7684;&#x5BC6;&#x7801;&#x3002;"; break;
   case "This is your personal page": $tmp="&#x6B22;&#x8FCE;&#x5B9A;&#x5236;&#x60A8;&#x7684;&#x4E2A;&#x4EBA;&#x559C;&#x597D;"; break;
   case "My HomePage:": $tmp="&#x6211;&#x7684;&#x4E3B;&#x9875;&#xFF1A; : "; break;
   case "My E-Mail:": $tmp="&#x6211;&#x7684; Email&#xFF1A; : "; break;
   case "Signature: ": $tmp="&#x7B7E;&#x540D; : "; break;
   case "Extra Info:": $tmp="&#x5176;&#x5B83;&#x4FE1;&#x606F; : "; break;
   case "There is no available info for": $tmp="&#x6CA1;&#x6709;&#x4FE1;&#x606F;&#x5173;&#x4E8E;"; break;
   case "Online journal for": $tmp="&#x5728;&#x7EBF;&#x8BFB;&#x7269;&#xFF0C;&#x4E3A; "; break;
   case "Last 10 comments by": $tmp="&#x6700;&#x8FD1;10&#x7BC7;&#x8BC4;&#x8BBA;&#x6765;&#x81EA;"; break;
   case "Last 10 news submissions sent by": $tmp="&#x6700;&#x8FD1;10&#x7BC7;&#x65B0;&#x95FB;&#x6765;&#x81EA;"; break;
   case "User not yet allowed by Administrator": $tmp="&#x60A8;&#x672A;&#x88AB;&#x5141;&#x8BB8;&#x8FDE;&#x63A5;&#x5230;&#x8FD9;&#x4E2A;&#x9875;&#x9762;&#x3002;"; break;
   case "Incorrect Login!": $tmp="&#x767B;&#x5F55;&#x5931;&#x8D25;&#xFF01; !"; break;
   case "User Login": $tmp="&#x7528;&#x6237;&#x767B;&#x5F55;"; break;
   case "Nickname: ": $tmp="&#x7528;&#x6237;&#x540D; : "; break;
   case "Password: ": $tmp="&#x5BC6;&#x7801; : "; break;
   case "New User": $tmp="&#x65B0;&#x7528;&#x6237;"; break;
   case "Lost your Password?": $tmp="&#x5FD8;&#x8BB0;&#x60A8;&#x7684;&#x5BC6;&#x7801;&#x4E86;&#xFF1F; ?"; break;
   case "New User:": $tmp="&#x65B0;&#x7528;&#x6237; : "; break;
   case "(required)": $tmp="(&#x5FC5;&#x586B;&#x9879;)"; break;
   case "Avatar: ": $tmp="&#x5934;&#x50CF; : "; break;
   case "List": $tmp="&#x5217;&#x8868;"; break;
   case "Option: ": $tmp="&#x9009;&#x9879; : "; break;
   case "Allow other users to view my email address": $tmp="&#x5141;&#x8BB8;&#x5176;&#x4ED6;&#x6CE8;&#x518C;&#x7528;&#x6237;&#x770B;&#x89C1;&#x6211;&#x7684;email&#x5730;&#x5740;"; break;
   case "(Password will be sent to the email address you enter.)": $tmp="&#xFF08;&#x5BC6;&#x7801;&#x4F1A;&#x53D1;&#x9001;&#x81F3;&#x60A8;&#x6240;&#x63D0;&#x4F9B;&#x7684;Email&#x5730;&#x5740;.&#xFF09;"; break;
   case "Notice: Account preferences are cookie based.": $tmp="&#x6CE8;&#x610F;&#xFF1A;&#x5E10;&#x53F7;&#x53C2;&#x6570;&#x9009;&#x62E9;&#x662F;&#x57FA;&#x4E8E;cookie&#x7684;&#x3002;"; break;
   case "As a registered user you can:": $tmp="&#x4F5C;&#x4E3A;&#x4E00;&#x4E2A;&#x6CE8;&#x518C;&#x7528;&#x6237;&#x60A8;&#x53EF;&#x4EE5;&#xFF1A;"; break;
   case "Post comments with your name": $tmp="&#x7528;&#x60A8;&#x7684;&#x6CE8;&#x518C;&#x540D;&#x5B57;&#x53D1;&#x8868;&#x8BC4;&#x8BBA;"; break;
   case "Send news with your name": $tmp="&#x7528;&#x60A8;&#x7684;&#x6CE8;&#x518C;&#x540D;&#x5B57;&#x53D1;&#x9001;&#x65B0;&#x95FB;"; break;
   case "Have a personal box in the Home": $tmp="&#x62E5;&#x6709;&#x4E00;&#x4E2A;&#x4E2A;&#x4EBA;&#x7AD9;&#x5185;&#x4FE1;&#x7BB1;"; break;
   case "Upload personal avatar": $tmp="&#x4E0A;&#x4F20;&#x4E2A;&#x4EBA;&#x5934;&#x8C61;"; break;
   case "Select how many news you want in the Home": $tmp="&#x9009;&#x62E9;&#x60A8;&#x6240;&#x5E0C;&#x671B;&#x5728;&#x4E3B;&#x9875;&#x4E0A;&#x770B;&#x5230;&#x7684;&#x6D88;&#x606F;&#x7684;&#x6761;&#x6570;"; break;
   case "Customize the comments": $tmp="&#x5B9A;&#x5236;&#x60A8;&#x7684;&#x8BC4;&#x8BBA;"; break;
   case "Select different themes": $tmp="&#x9009;&#x62E9;&#x4E0D;&#x540C;&#x7684;&#x4E3B;&#x9898;&#x6837;&#x5F0F;"; break;
   case "some other cool stuff...": $tmp="&#x7BA1;&#x7406;&#x5176;&#x4ED6;&#x7684;&#x9009;&#x9879;&#x548C;&#x5E94;&#x7528;&#x7A0B;&#x5E8F;"; break;
   case "We don't sell/give to others your personal info.": $tmp="&#x6211;&#x4EEC;&#x4E0D;&#x4F1A;&#x628A;&#x60A8;&#x7684;&#x4E2A;&#x4EBA;&#x4FE1;&#x606F;&#x9500;&#x552E;&#x6216;&#x63D0;&#x4F9B;&#x7ED9;&#x5176;&#x4ED6;&#x4EBA;&#x3002;"; break;
   case "Sorry, no corresponding user info was found": $tmp="&#x5BF9;&#x4E0D;&#x8D77;&#xFF0C;&#x6CA1;&#x6709;&#x627E;&#x5230;&#x5BF9;&#x5E94;&#x7684;&#x7528;&#x6237;&#x4FE1;&#x606F;&#x3002;"; break;
   case "The user account": $tmp="&#x7528;&#x6237;&#x5E10;&#x53F7;"; break;
   case "at": $tmp="&#x5728;"; break;
   case "has this email associated with it.": $tmp="&#x4E0E;&#x8FD9;&#x5C01;&#x90AE;&#x4EF6;&#x662F;&#x76F8;&#x8FDE;&#x7684;&#x5417;."; break;
   case "A web user from": $tmp="&#x67D0;&#x7528;&#x6237;&#xFF0C;&#x5176;&#x5730;&#x5740;IP&#x4E3A; "; break;
   case "If you didn't ask for this, don't worry. You are seeing this message, not 'them'. If this was an error just login with your new password.": $tmp="&#x5982;&#x679C;&#x60A8;&#x5E76;&#x6CA1;&#x6709;&#x8981;&#x6C42;&#x53D1;&#x9001;&#x5BC6;&#x7801;&#xFF0C;&#x522B;&#x62C5;&#x5FC3;&#xFF0C;&#x60A8;&#x4E0D;&#x4F1A;&#x6536;&#x5230;&#x7B2C;&#x4E8C;&#x6761;&#x7C7B;&#x4F3C;&#x4FE1;&#x606F;&#x3002;&#x5982;&#x679C;&#x60A8;&#x7684;&#x786E;&#x5FD8;&#x8BB0;&#x5BC6;&#x7801;&#x8BF7;&#x4F7F;&#x7528;&#x6211;&#x4EEC;&#x53D1;&#x9001;&#x7684;&#x8FD9;&#x4E2A;&#x65B0;&#x5BC6;&#x7801;&#x767B;&#x5F55;&#x3002;"; break;
   /**/case "Password update, please re-connect you.": $tmp="Password update, please re-connect you."; break;
   /**/case "To valid your new password request, just re-type it.": $tmp="To valid your new password request, just re-type it."; break;
   case "mail_password: could not update user entry. Contact the Administrator": $tmp="&#x90AE;&#x4EF6;&#x5BC6;&#x7801;(Mail_Password)&#x4E0D;&#x80FD;&#x66F4;&#x65B0;&#x3002;&#x8BF7;&#x8054;&#x7CFB;&#x7F51;&#x7AD9;&#x7BA1;&#x7406;&#x5458;&#x3002;"; break;
   case "Password for": $tmp="&#x5BC6;&#x7801;&#x7ED9;"; break;
   case "mailed.": $tmp="&#x5DF2;&#x5BC4;&#x51FA;&#x3002;"; break;
   case "If you didn't ask for this, don't worry. Just delete this Email.": $tmp="&#x5982;&#x679C;&#x60A8;&#x6CA1;&#x6709;&#x8981;&#x6C42;&#x5B83;&#xFF0C;&#x522B;&#x62C5;&#x5FC3;&#xFF0C;&#x53EA;&#x8981;&#x5220;&#x9664;&#x8FD9;&#x5C01;Email&#x5C31;&#x884C;&#x4E86;&#x3002; "; break;
   case "has just requested a Confirmation Code to change the password.": $tmp="&#x521A;&#x624D;&#x8BF7;&#x6C42;&#x4E86;&#x9A8C;&#x8BC1;&#x4EE3;&#x7801;&#x5DF2;&#x4FEE;&#x6539;&#x5BC6;&#x7801;&#x3002;"; break;
   case "Confirmation Code for": $tmp="&#x9A8C;&#x8BC1;&#x4EE3;&#x7801;&#x7ED9;"; break;
   case "(optional)": $tmp="(&#x53EF;&#x9009;&#x9879;)"; break;
   case "Real Email": $tmp="&#x60A8;&#x7684;&#x771F;&#x5B9E;&#x7535;&#x5B50;&#x90AE;&#x4EF6;&#x5730;&#x5740;"; break;
   case "(This Email will not be public but is required, will be used to send your password if you lost it)": $tmp="(&#x8FD9;&#x4E2A;&#x90AE;&#x4EF6;&#x5730;&#x5740;&#x4E0D;&#x4F1A;&#x516C;&#x5F00;&#x3002;&#x4F46;&#x662F;&#x5B83;&#x5728;&#x60A8;&#x4E22;&#x5931;&#x6216;&#x9057;&#x5FD8;&#x5BC6;&#x7801;&#x65F6;&#x662F;&#x91CD;&#x8981;&#x7684;&#x4FE1;&#x606F;&#x3002;)"; break;
   case "Fake Email": $tmp="&#x516C;&#x5F00;Email"; break;
   case "(This Email will be public. Just type what you want, Spam proof)": $tmp="(&#x8FD9;&#x4E2A;&#x7535;&#x5B50;&#x90AE;&#x4EF6;&#x5730;&#x5740;&#x5C06;&#x662F;&#x516C;&#x5F00;&#x7684;)"; break;
   case "Your HomePage": $tmp=" &#x60A8;&#x7684;&#x4E3B;&#x9875;"; break;
   case "Your Avatar": $tmp="&#x5316;&#x8EAB;"; break;
   case "Your Location": $tmp="&#x60A8;&#x7684;&#x4F4F;&#x5740;"; break;
   case "Your Occupation": $tmp="&#x60A8;&#x7684;&#x804C;&#x4E1A;"; break;
   case "Your Interest": $tmp="&#x60A8;&#x7684;&#x5174;&#x8DA3;"; break;
   case "(255 characters max. Type your signature with HTML coding)": $tmp="(&#x6700;&#x591A;255 &#x4E2A;&#x5B57;&#x7B26;&#x3002;&#x8BF4;&#x4E00;&#x4E9B;&#x60A8;&#x60F3;&#x8BA9;&#x522B;&#x4EBA;&#x4E86;&#x89E3;&#x4F60;&#x7684;&#x8BDD;)"; break;
   case "Show signature": $tmp="&#x663E;&#x793A;&#x7B7E;&#x540D;"; break;
   case "Extra Info": $tmp="&#x5176;&#x5B83;&#x4FE1;&#x606F;"; break;
   case "(255 characters max. Type what others can know about yourself)": $tmp="(&#x6700;&#x591A;&#x53EF;&#x4EE5;&#x8F93;&#x5165;255&#x4E2A;&#x82F1;&#x6587;&#x5B57;&#x6BCD;&#x3002;&#x8BF7;&#x6CE8;&#x660E;&#x60A8;&#x7684;&#x8EAB;&#x4EFD;&#x6216;&#x60A8;&#x5728;&#x672C;&#x7F51;&#x7AD9;&#x7684;&#x7528;&#x6237;&#x540D;)"; break;
   case "(type a new password twice to change it)": $tmp="(&#x8F93;&#x5165;&#x4E24;&#x6B21;&#x65B0;&#x5BC6;&#x7801;&#x4EE5;&#x6539;&#x53D8;&#x5BC6;&#x7801;)"; break;
   case "Password": $tmp="&#x5BC6;&#x7801;"; break;
   case "Both passwords are different. They need to be identical.": $tmp="&#x8FD9;&#x4E24;&#x4E2A;&#x5BC6;&#x7801;&#x662F;&#x4E0D;&#x540C;&#x7684;&#x3002;&#x4ED6;&#x4EEC;&#x5FC5;&#x987B;&#x6709;&#x6240;&#x533A;&#x522B;&#x3002;"; break;
   case "Sorry, your password must be at least": $tmp="&#x5BF9;&#x4E0D;&#x8D77;&#xFF0C;&#x4F60;&#x7684;&#x5BC6;&#x7801;&#x81F3;&#x5C11;&#x5E94;&#x8BE5;&#x6709;"; break;
   case "characters long": $tmp="&#x4E2A;&#x82F1;&#x6587;&#x5B57;&#x7B26;&#x957F;"; break;
   case "News number in the Home": $tmp="&#x4E3B;&#x9875;&#x4E0A;&#x7684;&#x6587;&#x7AE0;&#x6570;&#x76EE;"; break;
   case "Activate Personal Menu": $tmp="&#x6FC0;&#x6D3B;&#x4E2A;&#x4EBA;&#x83DC;&#x5355;"; break;
   case "(Check this option and the following text will appear in the Home)": $tmp="(&#x63D0;&#x4EA4;&#x8BE5;&#x9009;&#x9879;&#xFF0C;&#x4E0B;&#x7BC7;&#x6587;&#x7AE0;&#x5C06;&#x51FA;&#x73B0;&#x5728;&#x9996;&#x9875;&#x4E0A;)"; break;
   case "(You can use HTML code to put links, for example)": $tmp="(&#x4F8B;&#x5982;&#x60A8;&#x53EF;&#x4EE5;&#x4F7F;&#x7528;HTML&#x4EE3;&#x7801;&#x63D2;&#x5165;&#x8D85;&#x94FE;&#x63A5;&#x3002;)"; break;
   case "Save Changes!": $tmp="&#x4FDD;&#x5B58;&#x66F4;&#x6539;"; break;
   case "Select One Theme": $tmp="&#x9009;&#x62E9;&#x4E00;&#x4E2A;&#x4E3B;&#x9898;&#x6837;&#x5F0F;"; break;
   case "This option will change the look for the whole site.": $tmp="&#x8FD9;&#x4E2A;&#x9009;&#x9879;&#x5C06;&#x6539;&#x53D8;&#x6574;&#x4E2A;&#x7AD9;&#x70B9;&#x7684;&#x5916;&#x89C2;&#x3002;"; break;
   case "The changes will be valid only to you.": $tmp="&#x8FD9;&#x4E9B;&#x6539;&#x53D8;&#x53EA;&#x5BF9;&#x60A8;&#x5728;&#x767B;&#x5F55;&#x540E;&#x6709;&#x6548;&#x3002;"; break;
   case "Each user can view the site with different theme.": $tmp="&#x6BCF;&#x4E2A;&#x6CE8;&#x518C;&#x7528;&#x6237;&#x53EF;&#x4EE5;&#x4EE5;&#x4E0D;&#x540C;&#x4E3B;&#x9898;&#x6837;&#x5F0F;&#x6D4F;&#x89C8;&#x672C;&#x7AD9;&#x3002;"; break;
   case "Score": $tmp="&#x5206;&#x6570;&#xFF1A;"; break;
   case "Edit your journal": $tmp="&#x7F16;&#x8F91;&#x60A8;&#x7684;&#x65E5;&#x5FD7;"; break;
   case "Add date and time stamp": $tmp="&#x52A0;&#x4E0A;&#x65F6;&#x95F4;&#x548C;&#x65E5;&#x671F;"; break;
   case "Save Journal": $tmp="&#x4FDD;&#x5B58;&#x60A8;&#x7684;&#x65E5;&#x5FD7;"; break;
   case "Moderated By: ": $tmp="&#x7248;&#x4E3B; : "; break;
   case "Forum Index": $tmp="&#x9996;&#x9875;"; break;
   case "This is a Private Forum. Please enter the password to gain access": $tmp="&#x8FD9;&#x662F;&#x79C1;&#x4EBA;&#x8BBA;&#x575B;&#x3002;&#x60A8;&#x5FC5;&#x987B;&#x8F93;&#x5165;&#x5BC6;&#x7801;&#x624D;&#x80FD;&#x8FDB;&#x5165;&#x3002;"; break;
   case "Clear": $tmp="&#x53D6;&#x6D88;"; break;
   case "Topic": $tmp="&#x4E3B;&#x9898;"; break;
   case "Replies": $tmp="&#x56DE;&#x590D;"; break;
   case "Poster": $tmp="&#x53D1;&#x8868;&#x8005;"; break;
   case "Views": $tmp="&#x9605;&#x8BFB;"; break;
   case "Last Posts": $tmp="&#x6700;&#x540E;&#x53D1;&#x8868;"; break;
   case "There are no topics for this forum. ": $tmp="&#x8FD9;&#x4E2A;&#x8BBA;&#x575B;&#x76EE;&#x524D;&#x6CA1;&#x6709;&#x5728;&#x8BA8;&#x8BBA;&#x7684;&#x8BDD;&#x9898;. "; break;
   case "You can post one here.": $tmp="&#x60A8;&#x53EF;&#x4EE5;&#x5728;&#x6B64;&#x5F20;&#x8D34;&#x4E00;&#x4E2A;&#x4E3B;&#x9898;."; break;
   case "Mark all Topics to Read": $tmp="&#x628A;&#x6240;&#x6709;&#x7684;&#x4E3B;&#x9898;&#x6807;&#x8BB0;&#x4E3A;&#x5DF2;&#x8BFB;"; break;
   case "Previous Page": $tmp="&#x524D;&#x4E00;&#x9875;"; break;
   case "Next Page": $tmp="&#x540E;&#x4E00;&#x9875;"; break;
   case "Posts": $tmp="&#x5E16;&#x5B50;"; break;
   case "New Posts since your last visit.": $tmp="&#x9605;&#x8BFB;&#x4E0A;&#x6B21;&#x8BBF;&#x95EE;&#x540E;&#x7684;&#x5E16;&#x5B50;."; break;
   case "More than": $tmp="&#x66F4;&#x52A0;"; break;
   case "No New Posts since your last visit.": $tmp="&#x81EA;&#x4ECE;&#x60A8;&#x4E0A;&#x6B21;&#x8BBF;&#x95EE;&#x540E;&#x6CA1;&#x6709;&#x65B0;&#x6D88;&#x606F;&#x5F20;&#x8D34;."; break;
   case "Topic is Locked - No new posts may be made in it": $tmp="&#x6B64;&#x4E3B;&#x9898;&#x88AB;&#x9501;&#x5B9A;&#xFF1A;&#x5B83;&#x4E0D;&#x80FD;&#x63A5;&#x53D7;&#x4EFB;&#x4F55;&#x65B0;&#x7684;&#x63D0;&#x4EA4;&#x4FE1;&#x606F;&#x3002;"; break;
   case "Jump To:": $tmp="&#x8F6C;&#x8DF3;&#x5230; :"; break;
   case "No More Forums": $tmp="&#x6CA1;&#x6709;&#x5176;&#x4ED6;&#x8BBA;&#x575B;"; break;
   case "Error Connecting to DB": $tmp="&#x6570;&#x636E;&#x5E93;&#x8FDE;&#x63A5;&#x6709;&#x9519;&#x8BEF;"; break;
   case "You must provide subject and message to post your topic.": $tmp="&#x60A8;&#x5FC5;&#x987B;&#x9009;&#x62E9;&#x4E00;&#x4E2A;&#x6807;&#x9898;&#x548C;&#x4E00;&#x4E2A;&#x4FE1;&#x606F;&#x4EE5;&#x5F20;&#x8D34;&#x60A8;&#x7684;&#x4E3B;&#x9898;."; break;
   case "Post New Topic in:": $tmp="&#x5F20;&#x8D34;&#x4E00;&#x4E2A;&#x65B0;&#x7684;&#x4E3B;&#x9898;&#x5728;"; break;
   case "About Posting:": $tmp="&#x5173;&#x4E8E;&#x79C1;&#x4EBA;&#x4FE1;&#x606F;"; break;
   case "Anonymous users can post new topics and replies in this forum.": $tmp="&#x533F;&#x540D;&#x7528;&#x6237;&#x53EF;&#x4EE5;&#x5F20;&#x8D34;&#x65B0;&#x7684;&#x4E3B;&#x9898;&#x6216;&#x5728;&#x672C;&#x8BBA;&#x575B;&#x56DE;&#x590D;&#x5176;&#x4ED6;&#x4FE1;&#x606F;"; break;
   case "All registered users can post new topics and replies to this forum.": $tmp="&#x6240;&#x6709;&#x6CE8;&#x518C;&#x7528;&#x6237;&#x53EF;&#x4EE5;&#x5F20;&#x8D34;&#x65B0;&#x7684;&#x4E3B;&#x9898;&#x5E76;&#x56DE;&#x590D;&#x5176;&#x4ED6;&#x4FE1;&#x606F;"; break;
   case "You are not allowed to post in this forum": $tmp="&#x60A8;&#x4E0D;&#x80FD;&#x5728;&#x672C;&#x8BBA;&#x575B;&#x53D1;&#x8A00;"; break;
   case "back": $tmp="&#x8FD4;&#x56DE;"; break;
   case "Subject: ": $tmp="&#x4E3B;&#x9898; : "; break;
   case "Message Icon: ": $tmp="&#x6D88;&#x606F;&#x56FE;&#x6807; : "; break;
   case "Message: ": $tmp="&#x7559;&#x8A00; : "; break;
   case "On": $tmp="&#x5F00;"; break;
   case "Off": $tmp=" &#x5173;"; break;
   case "Options: ": $tmp="&#x9009;&#x9879; : "; break;
   case "Disable HTML on this Post": $tmp="&#x5728;&#x672C;&#x8D34;&#x4E2D;&#x7981;&#x7528;HTML"; break;
   case "This can be altered or added in your profile": $tmp="&#x672C;&#x9879;&#x53EF;&#x4EE5;&#x5728;&#x4F60;&#x7684;&#x4E2A;&#x4EBA;&#x53C2;&#x6570;&#x4E2D;&#x6DFB;&#x52A0;&#x6216;&#x64A4;&#x6D88;"; break;
   case "Notify by email when replies are posted": $tmp="&#x5F53;&#x6709;&#x56DE;&#x590D;&#x65F6;&#x5C06;&#x901A;&#x8FC7;email&#x5F97;&#x5230;&#x901A;&#x77E5;"; break;
   case "Cancel Post": $tmp="&#x53D6;&#x6D88;&#x53D1;&#x8A00;"; break;
   case "This message was edited by": $tmp="&#x53D1;&#x8A00;&#x8005;"; break;
   case "Untitled": $tmp="&#x65E0;&#x6807;&#x9898;"; break;
   case "Click here to view the update": $tmp="&#x70B9;&#x51FB;&#x4EE5;&#x89C2;&#x770B;&#x66F4;&#x65B0;&#x540E;&#x7684;&#x9875;&#x9762;"; break;
   case "Click here to return to the forum index.": $tmp="&#x70B9;&#x51FB;&#x56DE;&#x5230;&#x4E3B;&#x8BBA;&#x575B;."; break;
   case "Your post has NOT been deleted because one or more posts is already attached (TREE forum).": $tmp="&#x60A8;&#x7684;&#x53D1;&#x8A00;&#x6CA1;&#x6709;&#x88AB;&#x5220;&#x9664;&#xFF0C;&#x56E0;&#x4E3A;&#x6709;&#x5176;&#x4ED6;&#x7684;&#x53D1;&#x8A00;&#x4E0E;&#x6B64;&#x6709;&#x5173;&#x8054;."; break;
   case "Editing Post": $tmp="&#x7F16;&#x8F91;&#x5E16;&#x5B50;"; break;
   case "Delete this Post": $tmp="&#x5220;&#x9664;&#x6B64;&#x4FE1;&#x606F;"; break;
   case ".:Page &gt;&gt; Super-Cache:.": $tmp=".:Page &gt;&gt; Super-Cache:."; break;
   case ".:Page &lt;&lt; Super-Cache:.": $tmp=".:Page &lt;&lt; Super-Cache:."; break;
   case "Web Activity": $tmp="&#x672C;&#x7F51;&#x7AD9;&#x7684;&#x6D3B;&#x52A8;&#x4FE1;&#x606F;"; break;
   case "guest(s) and": $tmp="&#x4F4D;&#x6E38;&#x5BA2; &#x548C;"; break;
   case "member(s) that are online.": $tmp="&#x5728;&#x7EBF;&#x4F1A;&#x5458;."; break;
   case "You are logged as": $tmp="&#x60A8;&#x7684;&#x767B;&#x5F55;&#x5E10;&#x53F7;"; break;
   case "here": $tmp="&#x8FD9;&#x91CC;"; break;
   case "You can register for free by clicking": $tmp="&#x70B9;&#x51FB;&#x8FD9;&#x91CC;&#x6210;&#x4E3A;&#x4F1A;&#x5458;"; break;
   case "Who's Online": $tmp="&#x8C01;&#x5728;&#x7EBF;&#xFF1F; ?"; break;
   case "You have": $tmp="&#x60A8;&#x6709;"; break;
   case "private message(s).": $tmp="&#x6761;&#x4E2A;&#x4EBA;&#x77ED;&#x6D88;&#x606F;&#x3002;"; break;
   /*a voir le lien*/case "You are Anonymous user. You can register for free by clicking&nbsp;&nbsp;<a href=user.php>HERE</a>.": $tmp="&#x60A8;&#x662F;&#x533F;&#x540D;&#x7528;&#x6237;&#x3002;&#x60A8;&#x53EF;&#x4EE5;&#x70B9;&#x51FB;&#x8FD9;&#x91CC;&#x4EE5;&#x514D;&#x8D39;&#x6CE8;&#x518C;."; break;
   case "NewsLetter": $tmp="&#x4FE1;&#x7B3A; NewsLetter"; break;
   case "Your email": $tmp="&#x60A8;&#x7684;&#x7535;&#x5B50;&#x90AE;&#x4EF6;&#x5730;&#x5740;"; break;
   case "Sign up now to receive our lastest infos.": $tmp="&#x901A;&#x8FC7;email&#x63A5;&#x53D7;&#x672C;&#x7AD9;&#x7684;&#x6700;&#x65B0;&#x6D88;&#x606F;."; break;
   case "most downloaded": $tmp="&#x4E2A;&#x88AB;&#x4E0B;&#x8F7D;&#x6700;&#x591A;&#x7684;&#x6587;&#x4EF6;"; break;
   case "last downloadable files": $tmp="&#x53EF;&#x4E0B;&#x8F7D;&#x7684;&#x6587;&#x4EF6;"; break;
   case "downloads": $tmp="&#x4E0B;&#x8F09;&#x6B21;&#x6578;"; break;
   case "Category": $tmp="&#x5206;&#x7C7B;"; break;
   case "Category:": $tmp="&#x5206;&#x7C7B; : "; break;
   case "A problem ocurred": $tmp="&#x51FA;&#x73B0;&#x95EE;&#x9898;"; break;
   case "Advanced Search": $tmp="&#x9AD8;&#x7EA7;&#x641C;&#x7D22;"; break;
   case "There isn't a Biggest Story for Today, yet.": $tmp="&#x4ECA;&#x5929;&#x8FD8;&#x6CA1;&#x6709;&#x65B0;&#x7684;&#x6587;&#x7AE0;"; break;
   case "Today's most read Story is:": $tmp="&#x4ECA;&#x5929;&#x6700;&#x53D7;&#x6B22;&#x8FCE;&#x6587;&#x7AE0;&#xFF1A; :"; break;
   case "Today's Big Story": $tmp="&#x4ECA;&#x5929;&#x53D1;&#x8868;&#x6700;&#x53D7;&#x6B22;&#x8FCE;&#x6587;&#x7AE0;"; break;
   case "Past Articles": $tmp="&#x4E2A;&#x88AB;&#x4E0B;&#x8F7D;&#x6700;&#x591A;&#x7684;&#x6587;&#x4EF6;"; break;
   case "Older Articles": $tmp="&#x8F83;&#x65E7;&#x6587;&#x7AE0;"; break;
   case "Waiting Content": $tmp="&#x7B49;&#x5F85;&#x7684;&#x5185;&#x5BB9;"; break;
   case "Submissions": $tmp="&#x6587;&#x7AE0;"; break;
   case "Waiting Reviews": $tmp="&#x8BC4;&#x8BBA;"; break;
   /**/case "Waiting Classifieds": $tmp="Waiting Classifieds"; break;
   case "Ephemerids": $tmp="&#x5386;&#x53F2;&#x4E0A;&#x7684;&#x4ECA;&#x5929;"; break;
   case "One Day like Today...": $tmp="&#x4ECA;&#x5929;..."; break;
   case "Nickname": $tmp="&#x7528;&#x6237;&#x540D;"; break;
   case "Login": $tmp="&#x767B;&#x5F55; "; break;
   case "Don't have an account yet? You can": $tmp="&#x60A8;&#x8FD8;&#x6CA1;&#x6709;&#x4E2A;&#x4EBA;&#x5E10;&#x53F7;&#x5417;&#xFF1F;&#x4F60;&#x53EF;&#x4EE5;&#x8BD5;&#x8BD5;&#x8FD9;&#x91CC;"; break;
   case "create one": $tmp="&#x5EFA;&#x7ACB;&#x65B0;&#x5E10;&#x53F7;"; break;
   case "As registered": $tmp="&#x4E00;&#x65E6;&#x6CE8;&#x518C;"; break;
   case "user you have some advantages like theme manager,": $tmp="&#x60A8;&#x5C06;&#x6709;&#x67D0;&#x4E9B;&#x7279;&#x6743;&#xFF0C;&#x6BD4;&#x5982;&#x53EF;&#x4EE5;&#x4FEE;&#x6539;&#x7F51;&#x7AD9;&#x7684;&#x5916;&#x89C2;,"; break;
   case "comments configuration and post comments with your name.": $tmp="&#x6216;&#x8005;&#x5F20;&#x8D34;&#x6709;&#x60A8;&#x7B7E;&#x540D;&#x7684;&#x8BC4;&#x8BBA;..."; break;
   case "Survey": $tmp="&#x8C03;&#x67E5;"; break;
   case "Past Surveys": $tmp="&#x4EE5;&#x524D;&#x7684;&#x8C03;&#x67E5;"; break;
   case "Votes: ": $tmp="&#x7968;&#x6570; : "; break;
   case "comments:": $tmp="&#x8BC4;&#x8BBA; : "; break;
   case "You already voted today!": $tmp="&#x60A8;&#x4ECA;&#x5929;&#x5DF2;&#x7ECF;&#x5BF9;&#x8BE5;&#x8C03;&#x67E5;&#x6295;&#x7968;&#x4E86; !"; break;
   case "Results": $tmp="&#x7ED3;&#x679C;"; break;
   case "votes": $tmp="&#x7968;&#x6570;"; break;
   case "Total Votes: ": $tmp="&#x5408;&#x8BA1;&#x6295;&#x7968;: "; break;
   case "We allow just one vote per day": $tmp="&#x6211;&#x4EEC;&#x53EA;&#x5141;&#x8BB8;&#x6BCF;&#x5929;&#x6295;&#x7968;&#x4E00;&#x6B21; !"; break;
   case "Voting Booth": $tmp="&#x6295;&#x7968;&#x533A;"; break;
   case "read more...": $tmp="&#x66F4;&#x591A;"; break;
   case "The URL for this story is:": $tmp="&#x8FD9;&#x7BC7;&#x6587;&#x7AE0;&#x7684;URL&#x662F;&#xFF1A; : "; break;
   case "Subscribe": $tmp="&#x9884;&#x5B9A;&#x8BE5;&#x670D;&#x52A1;"; break;
   case "Could not connect to the forums database.": $tmp="&#x4E0D;&#x80FD;&#x8FDE;&#x63A5;&#x5230;&#x8BBA;&#x575B;&#x7684;&#x6570;&#x636E;&#x5E93;"; break;
   case "The forum you selected does not exist. Please go back and try again.": $tmp="&#x60A8;&#x9009;&#x62E9;&#x7684;&#x8BBA;&#x575B;&#x4E0D;&#x5B58;&#x5728;&#x3002;&#x8BF7;&#x8FD4;&#x56DE;&#x5E76;&#x91CD;&#x8BD5;&#x3002;"; break;
   case "Could not query the topics database.": $tmp="&#x4E0D;&#x80FD;&#x8FDE;&#x63A5;&#x5230;&#x4E3B;&#x9898;&#x7684;&#x6570;&#x636E;&#x5E93;"; break;
   case "Error getting messages from the database.": $tmp="&#x5F53;&#x4ECE;&#x6570;&#x636E;&#x5E93;&#x8BFB;&#x53D6;&#x6570;&#x636E;&#x65F6;&#x51FA;&#x73B0;&#x9519;&#x8BEF;"; break;
   case "Please enter the Nickname and the Password.": $tmp="&#x8BF7;&#x8F93;&#x5165;&#x5462;&#x79F0;&#x548C;&#x5BC6;&#x7801;"; break;
   case "You are not the Moderator of this forum therefore you can't perform this function.": $tmp="&#x60A8;&#x4E0D;&#x662F;&#x672C;&#x8BBA;&#x575B;&#x7684;&#x7248;&#x4E3B;&#xFF0C;&#x4F60;&#x4E0D;&#x53EF;&#x4EE5;&#x4F7F;&#x7528;&#x672C;&#x9879;&#x529F;&#x80FD;."; break;
   case "You did not enter the correct password, please go back and try again.": $tmp="&#x5BC6;&#x7801;&#x4E0D;&#x6B63;&#x786E;&#xFF0C;&#x8BF7;&#x8FD4;&#x56DE;&#x5E76;&#x91CD;&#x65B0;&#x8F93;&#x5165;"; break;
   case "Could not remove posts from the database.": $tmp="&#x4E0D;&#x80FD;&#x5220;&#x9664;&#x4FE1;&#x606F;"; break;
   case "Could not move selected topic to selected forum. Please go back and try again.": $tmp="&#x4E0D;&#x80FD;&#x8F6C;&#x79FB;&#x8BE5;&#x4E3B;&#x9898;&#x81F3;&#x8BBA;&#x575B;&#x3002;&#x8BF7;&#x91CD;&#x8BD5;&#x3002;"; break;
   case "Could not lock the selected topic. Please go back and try again.": $tmp="&#x4E0D;&#x80FD;&#x9501;&#x5B9A;&#x8BE5;&#x4E3B;&#x9898;&#xFF0C;&#x8BF7;&#x91CD;&#x8BD5;&#x3002;"; break;
   case "Could not unlock the selected topic. Please go back and try again.": $tmp="&#x4E0D;&#x80FD;&#x89E3;&#x9664;&#x5BF9;&#x8BE5;&#x4E3B;&#x9898;&#x7684;&#x9501;&#x5B9A;&#xFF0C;&#x8BF7;&#x91CD;&#x8BD5;&#x3002;"; break;
   case "Could not query the database.": $tmp="&#x8BBF;&#x95EE;&#x6570;&#x636E;&#x5E93;&#x5931;&#x8D25;"; break;
   case "No such user or post in the database.": $tmp="&#x6570;&#x636E;&#x5E93;&#x4E2D;&#x6CA1;&#x6709;&#x6B64;&#x7528;&#x6237;&#x6216;&#x6B64;&#x4FE1;&#x606F;"; break;
   case "Search Engine was unable to query the forums database.": $tmp="&#x641C;&#x7D22;&#x5F15;&#x64CE;&#x6CA1;&#x6709;&#x627E;&#x5230;&#x5BF9;&#x5E94;&#x6570;&#x636E;&#x5E93;"; break;
   case "That user does not exist. Please go back and search again.": $tmp="&#x8BE5;&#x7528;&#x6237;&#x4E0D;&#x5B58;&#x5728;&#x3002;&#x8BF7;&#x8FD4;&#x56DE;&#x5E76;&#x91CD;&#x8BD5;&#x3002;"; break;
   case "You must type a subject to post. You can't post an empty subject. Go back and enter the subject": $tmp="&#x60A8;&#x5FC5;&#x987B;&#x8F93;&#x5165;&#x4E00;&#x4E2A;&#x4E3B;&#x9898;&#x624D;&#x80FD;&#x5F20;&#x8D34;&#x3002;&#x7A7A;&#x4E3B;&#x9898;&#x65E0;&#x6548;&#x3002;&#x8BF7;&#x8FD4;&#x56DE;&#x5E76;&#x91CD;&#x8BD5;&#x3002;"; break;
   case "You must choose message icon to post. Go back and choose message icon.": $tmp="&#x60A8;&#x5FC5;&#x987B;&#x9009;&#x62E9;&#x4FE1;&#x606F;&#x7684;&#x8868;&#x793A;&#x4EE5;&#x5F20;&#x8D34;&#x3002;&#x8BF7;&#x8FD4;&#x56DE;&#x5E76;&#x91CD;&#x8BD5;&#x3002;"; break;
   case "You must type a message to post. You can't post an empty message. Go back and enter a message.": $tmp="&#x60A8;&#x5FC5;&#x987B;&#x8F93;&#x5165;&#x4FE1;&#x606F;&#x4EE5;&#x5F20;&#x8D34;&#x3002;&#x7A7A;&#x7684;&#x4FE1;&#x606F;&#x65E0;&#x6548;&#x3002;&#x8BF7;&#x8FD4;&#x56DE;&#x5E76;&#x91CD;&#x8BD5;&#x3002;"; break;
   case "Could not enter data into the database. Please go back and try again.": $tmp="&#x5199;&#x5165;&#x6570;&#x636E;&#x5230;&#x6570;&#x636E;&#x5E93;&#x5931;&#x8D25;&#x3002;&#x8BF7;&#x8FD4;&#x56DE;&#x5E76;&#x91CD;&#x8BD5;&#x3002;"; break;
   case "Can't delete the selected message.": $tmp="&#x4E0D;&#x80FD;&#x5220;&#x9664;&#x6240;&#x9009;&#x7684;&#x4FE1;&#x606F;&#x3002;"; break;
   case "An error ocurred while querying the database.": $tmp="&#x8BBF;&#x95EE;&#x6570;&#x636E;&#x5E93;&#x65F6;&#x51FA;&#x73B0;&#x9519;&#x8BEF;"; break;
   case "Selected message was not found in the forum database.": $tmp="&#x6240;&#x9009;&#x7684;&#x4FE1;&#x606F;&#x5728;&#x6570;&#x636E;&#x5E93;&#x4E2D;&#x4E0D;&#x5B58;&#x5728;"; break;
   case "You can't reply to that message. It wasn't sent to you.": $tmp="&#x60A8;&#x4E0D;&#x80FD;&#x56DE;&#x590D;&#x8BE5;&#x4FE1;&#x606F;&#x3002;&#x5B83;&#x4E0D;&#x662F;&#x53D1;&#x9001;&#x7ED9;&#x60A8;&#x7684;&#x3002;"; break;
   case "You can't post a reply to this topic, it has been locked. Contact the administrator if you have any question.": $tmp="&#x60A8;&#x4E0D;&#x80FD;&#x56DE;&#x590D;&#x8BE5;&#x4E3B;&#x9898;&#xFF0C;&#x56E0;&#x4E3A;&#x5B83;&#x88AB;&#x9501;&#x5B9A;&#x4E86;&#x3002;&#x5982;&#x6709;&#x7591;&#x95EE;&#x8BF7;&#x8054;&#x7CFB;&#x7BA1;&#x7406;&#x5458;&#x3002;"; break;
   case "The forum or topic you are attempting to post to does not exist. Please try again.": $tmp=" &#x60A8;&#x6240;&#x9009;&#x62E9;&#x7684;&#x8BBA;&#x575B;&#x6216;&#x4E3B;&#x9898;&#x4E0D;&#x5B58;&#x5728;&#xFF0C;&#x8BF7;&#x91CD;&#x8BD5;&#x3002;"; break;
   case "You must enter your username and password. Go back and do so.": $tmp="&#x60A8;&#x5FC5;&#x987B;&#x8F93;&#x5165;&#x60A8;&#x7684;&#x7528;&#x6237;&#x540D;&#x548C;&#x5BC6;&#x7801;&#x3002;&#x8BF7;&#x8FD4;&#x56DE;&#x5E76;&#x91CD;&#x8BD5;&#x3002;"; break;
   case "You have entered an incorrect password. Go back and try again.": $tmp=" &#x8BE5;&#x5BC6;&#x7801;&#x65E0;&#x6548;&#x3002;&#x8BF7;&#x8FD4;&#x56DE;&#x5E76;&#x91CD;&#x8BD5;&#x3002;"; break;
   case "Couldn't update post count.": $tmp="&#x53D1;&#x5E03;&#x5E16;&#x5B50;&#x7684;&#x7EDF;&#x8BA1;&#x66F4;&#x65B0;&#x5931;&#x8D25;&#x3002;"; break;
   case "The forum you are attempting to post to does not exist. Please try again.": $tmp="&#x60A8;&#x5C1D;&#x8BD5;&#x5F20;&#x8D34;&#x4FE1;&#x606F;&#x7684;&#x8BBA;&#x575B;&#x4E0D;&#x5B58;&#x5728;&#x3002;&#x8BF7;&#x91CD;&#x8BD5;&#x3002;"; break;
   case "You can't edit a post that's not yours.": $tmp="&#x60A8;&#x4E0D;&#x80FD;&#x4FEE;&#x6539;&#x6B64;&#x4FE1;&#x606F;&#xFF0C;&#x5B83;&#x4E0D;&#x662F;&#x53D1;&#x9001;&#x7ED9;&#x4F60;&#x7684;&#x3002;"; break;
   case "You do not have permission to edit this post.": $tmp="&#x60A8;&#x6CA1;&#x6709;&#x6743;&#x5229;&#x4FEE;&#x6539;&#x6B64;&#x4FE1;&#x606F;&#x3002;"; break;
   case "You did not supply the correct password or do not have permission to edit this post. Please go back and try again.": $tmp="&#x5BC6;&#x7801;&#x65E0;&#x6548;&#x6216;&#x60A8;&#x65E0;&#x6743;&#x4FEE;&#x6539;&#x6B64;&#x4FE1;&#x606F;&#x3002;&#x8BF7;&#x8FD4;&#x56DE;&#x5E76;&#x91CD;&#x8BD5;&#x3002;"; break;
   case "You can't reply to that message.": $tmp="&#x60A8;&#x4E0D;&#x80FD;&#x7B54;&#x590D;&#x8BE5;&#x4FE1;&#x606F;&#x3002;"; break;
   case "Forum Error": $tmp="&#x8BBA;&#x575B;&#x9519;&#x8BEF;"; break;
   case "Error Code:": $tmp="&#x9519;&#x8BEF;&#x5E8F;&#x5217;&#x53F7; :"; break;
   case "Please type your client informations": $tmp="&#x8BF7;&#x8F93;&#x5165;&#x60A8;&#x7684;&#x4FE1;&#x606F;"; break;
   case "Advertising Statistics": $tmp="&#x5E7F;&#x544A;(Banner)"; break;
   case "Current Active Banners for": $tmp="&#x5F53;&#x524D;&#x5E7F;&#x544A;&#x4E3A;"; break;
   case "Made": $tmp="&#x5B8C;&#x6210;"; break;
   case "Impressions": $tmp="&#x6295;&#x653E;&#x6B21;&#x6570;"; break;
   case "Imp. Left": $tmp="&#x5269;&#x4F59;&#x6295;&#x653E;&#x6B21;&#x6570;"; break;
   case "Clicks": $tmp="&#x70B9;&#x51FB;&#x6B21;&#x6570;"; break;
   case "Functions": $tmp="&#x529F;&#x80FD;"; break;
   case "Unlimited": $tmp="&#x65E0;&#x9650;"; break;
   case "This Banners points to": $tmp="&#x6B64;&#x5E7F;&#x544A;&#x5F20;&#x8D34;&#x4E8E;&#x4EE5;&#x4E0B;URL&#x5730;&#x5740;"; break;
   case "Change": $tmp="&#x6539;&#x53D8;"; break;
   case "Banners Finished for": $tmp="&#x4EE5;&#x4E0B;&#x7528;&#x6237;&#x7684;&#x5E7F;&#x544A;&#x7ED3;&#x675F;"; break;
   case "Start Date": $tmp="&#x8D77;&#x59CB;&#x65E5;&#x671F;"; break;
   case "End Date": $tmp="&#x7ED3;&#x675F;&#x65E5;&#x671F;"; break;
   case "Statistics for Banner ID": $tmp="&#x7EDF;&#x8BA1;&#x5E7F;&#x544A;&#x6761; ID"; break;
   case "can't be send because": $tmp="&#x4E0D;&#x80FD;&#x53D1;&#x9001;&#xFF0C;&#x56E0;&#x4E3A;."; break;
   case "there isn't an email associated with client": $tmp="&#x6CA1;&#x6709;&#x7ED9;&#x8BE5;&#x7528;&#x6237;&#x7684;&#x90AE;&#x4EF6; : "; break;
   case "Banner": $tmp="&#x5E7F;&#x544A;&#x6761;"; break;
   case "Percent": $tmp="&#x603B;&#x8BA1;&#x767E;&#x5206;&#x6BD4;"; break;
   case "Maded": $tmp="&#x5B8C;&#x6210;"; break;
   case "Purchased": $tmp="&#x5DF2;&#x4ED8;&#x8D39;"; break;
   case "Received": $tmp="&#x6536;&#x5230;"; break;
   case "Lefted": $tmp="&#x4F59;&#x4E0B;&#x7684;"; break;
   case "Report Generated on": $tmp="&#x603B;&#x7ED3;&#x62A5;&#x544A;"; break;
   case "has been send to": $tmp="&#x5DF2;&#x7ECF;&#x53D1;&#x9001;&#x7ED9;."; break;
   case "You changed the URL": $tmp="&#x60A8;&#x6539;&#x53D8;&#x4E86;URL"; break;
   case "Please": $tmp=" &#x8BF7;"; break;
   case "login again": $tmp="&#x518D;&#x6B21;&#x767B;&#x5F55;."; break;
   case "Forums!": $tmp="&#x7248;&#x9762;&#x7BA1;&#x7406;"; break;
   case "Select forums with discussions of your interest, participate and have a lot of fun!": $tmp="&#x9009;&#x62E9;&#x5E76;&#x53C2;&#x4E0E;&#x4E00;&#x4E2A;&#x8BBA;&#x575B;"; break;
   case "The only rule here is: Stay on topic of the discussions.": $tmp="&#x8FD9;&#x91CC;&#x552F;&#x4E00;&#x7684;&#x89C4;&#x5219;&#x662F;&#xFF1A;&#x8BF7;&#x4E0D;&#x8981;&#x79BB;&#x9898;."; break;
   case "Forum": $tmp="&#x7248;&#x9762;&#x7BA1;&#x7406;"; break;
   case "Sub.": $tmp="&#x9884;&#x5B9A;&#x8BE5;&#x670D;&#x52A1;"; break;
   case "Type": $tmp="&#x7C7B;&#x578B;"; break;
   case "Moderator": $tmp="&#x957F;&#x8001;"; break;
   case "No posts": $tmp="&#x6CA1;&#x6709;&#x5E16;&#x5B50;"; break;
   case "Free for All": $tmp="&#x6240;&#x6709;&#x4EBA;&#x81EA;&#x7531;&#x8FDB;&#x5165;"; break;
   case "Group": $tmp="&#x7EC4;"; break;
   case "Group separator is , (12,55,...)": $tmp="&#x7528;&#x6237;&#x7EC4;&#x7684;&#x5206;&#x9694;&#x6807;&#x5FD7;&#x4E3A;&#x9017;&#x53F7;, &#x4F8B;&#x5982; (12, 55, ...)"; break;
   case "Extended Text": $tmp="&#x6587;&#x7AE0;&#x4E3B;&#x4F53;"; break;
   case "Hidden": $tmp="&#x9690;&#x85CF;"; break;
   case "Registered User": $tmp="&#x6CE8;&#x518C;&#x7528;&#x6237;"; break;
   case "Submit / Manage Item": $tmp="&#x63D0;&#x4EA4;/&#x7BA1;&#x7406;&#x4E00;&#x4E2A;&#x7559;&#x8A00;"; break;
   case "Check a Forum and Click on [Sub.] button for receive an Email when a new submission is made in it.": $tmp="&#x9009;&#x62E9;&#x4E00;&#x4E2A;&#x8BBA;&#x575B;&#x5E76;&#x70B9;&#x51FB;[&#x9884;&#x5B9A;&#x8BE5;&#x670D;&#x52A1;]&#x6309;&#x94AE;&#xFF0C;&#x4EE5;&#x4FBF;&#x4E8E;&#x63A5;&#x53D7;&#x90AE;&#x4EF6;&#x901A;&#x77E5;&#x5F53;&#x6709;&#x65B0;&#x7684;&#x4FE1;&#x606F;&#x5728;&#x8FD9;&#x91CC;&#x5F20;&#x8D34;&#x3002;"; break;
   case "To: ": $tmp=" &#x7ED9; : "; break;
   case "Send a copy to me": $tmp="&#x6211;&#x8981;&#x4FDD;&#x5B58;&#x526F;&#x672C;"; break;
   case "Save": $tmp="&#x4FDD;&#x5B58;"; break;
   case "Search in": $tmp="&#x5728;&#x6B64;&#x95F4;&#x641C;&#x7D22;"; break;
   case "Keyword": $tmp="&#x5173;&#x952E;&#x8BCD;"; break;
   case "Search for ANY of the terms (Default)": $tmp="&#x67E5;&#x627E;&#x4EFB;&#x610F;&#x4E3B;&#x9898;&#xFF08;&#x9ED8;&#x8BA4;&#xFF09;"; break;
   case "Search for ALL of the terms": $tmp="&#x67E5;&#x627E;&#x6240;&#x6709;&#x4E3B;&#x9898;"; break;
   case "Search All Forums": $tmp="&#x5728;&#x6240;&#x6709;&#x8BBA;&#x575B;&#x4E2D;&#x67E5;&#x627E;"; break;
   case "Author's Name": $tmp="&#x4F5C;&#x8005;&#x540D;&#x5B57;"; break;
   case "Sort by": $tmp="&#x6392;&#x5E8F;&#x65B9;&#x6CD5;"; break;
   case "Post Time": $tmp="&#x53D1;&#x8868;&#x65F6;&#x95F4;"; break;
   case "No records match that query. Please broaden your search.": $tmp="&#x5BF9;&#x8BE5;&#x5173;&#x952E;&#x8BCD;&#x7684;&#x641C;&#x7D22;&#x6CA1;&#x6709;&#x7ED3;&#x679C;&#x3002;&#x8BF7;&#x6269;&#x5927;&#x60A8;&#x7684;&#x641C;&#x7D22;&#x8303;&#x56F4;&#x3002;"; break;
   case "Posted": $tmp="&#x53D1;&#x8868;&#x4E8E;"; break;
   case "pages": $tmp="&#x9875;"; break;
   case "Anonymous": $tmp="&#x533F;&#x540D;&#x6E38;&#x5BA2;"; break;
   case "Posted: ": $tmp="&#x53D1;&#x8868;&#x4E8E; : "; break;
   case "Profile": $tmp="&#x4E2A;&#x4EBA;&#x8D44;&#x6599;"; break;
   case "Email": $tmp="E-mail"; break;
   case "Quote": $tmp="&#x5F15;&#x7528;"; break;
   case "Goto Page: ": $tmp="&#x524D;&#x5F80;&#x9875;&#x9762;: "; break;
   case "Jump To: ": $tmp="&#x8F6C;&#x8DF3;&#x5230; : "; break;
   case "Administration Tools": $tmp="&#x7BA1;&#x7406;&#x5DE5;&#x5177;"; break;
   case "Lock this Topic": $tmp="&#x9501;&#x5B9A;&#x672C;&#x5E16;"; break;
   case "Unlock this Topic": $tmp="&#x89E3;&#x9501;&#x672C;&#x5E16;"; break;
   case "Move this Topic": $tmp="&#x79FB;&#x52A8;&#x672C;&#x5E16;"; break;
   case "Delete this Topic": $tmp="&#x5220;&#x9664;&#x672C;&#x5E16;"; break;
   case "Administration BlackBoard": $tmp="&#x7BA1;&#x7406;&#x53C2;&#x6570;&#x8868;"; break;
   case "Day(s)": $tmp="&#x65E5;"; break;
   case "Hour(s)": $tmp="&#x5C0F;&#x65F6;"; break;
   case "Minut(s)": $tmp="&#x5206;&#x949F;"; break;
   case "Second(s)": $tmp="&#x7B2C;&#x4E8C;"; break;
   case "General Stats": $tmp="&#x6570;&#x636E;&#x7EDF;&#x8BA1;"; break;
   case "Past Stat": $tmp="&#x6700;&#x540E;&#x7EDF;&#x8BA1;&#x6570;&#x636E;"; break;
   case "Nb of Pages": $tmp="&#x8BBF;&#x95EE;&#x6570;"; break;
   case "Nb of members": $tmp="&#x4F1A;&#x5458;&#x6570;"; break;
   case "Nb of articles": $tmp="&#x6587;&#x7AE0;&#x6570;&#x91CF;"; break;
   case "Nb of forums": $tmp="&#x8BBA;&#x575B;&#x6570;&#x91CF;"; break;
   case "Nb of topics": $tmp="&#x4E3B;&#x9898;&#x6570;&#x91CF;"; break;
   case "Nb of reviews": $tmp="&#x8BC4;&#x8BBA;&#x6570;&#x91CF;"; break;
   case "Nb Outside Users for LNL": $tmp="Newsletter&#x6F5C;&#x5728;&#x7528;&#x6237;&#x7684;&#x7EDF;&#x8BA1;&#x6570;"; break;
   case "Download Stats": $tmp="&#x4E0B;&#x8F7D;&#x7684;&#x7EDF;&#x8BA1;&#x6570;&#x636E;"; break;
   case "Related Links": $tmp="&#x76F8;&#x5173;&#x94FE;&#x63A5;"; break;
   case "More about": $tmp="&#x66F4;&#x591A;&#x7684;&#x6709;&#x5173;"; break;
   case "News by": $tmp="&#x65B0;&#x95FB;&#x63D0;&#x4F9B;"; break;
   case "Most read story about": $tmp="&#x4EBA;&#x6C14;&#x6700;&#x9AD8;&#x7684;&#x6587;&#x7AE0;&#x5728;"; break;
   case "Last news about": $tmp="&#x6700;&#x65B0;&#x6D88;&#x606F;&#xFF0C;&#x5173;&#x4E8E;"; break;
   case "Name:": $tmp="&#x540D;&#x5B57; :"; break;
   case "Text:": $tmp="&#x6587;&#x672C; : "; break;
   case "Configure": $tmp="&#x914D;&#x7F6E;"; break;
   case "comment": $tmp="&#x8BC4;&#x8BBA;"; break;
   case "The comments are owned by the poster. We aren't responsible for their content.": $tmp="&#x4EFB;&#x4F55;&#x8BC4;&#x8BBA;&#x5C5E;&#x4E8E;&#x5176;&#x4F5C;&#x8005;&#x6240;&#x6709;&#x3002;&#x672C;&#x7F51;&#x7AD9;&#x4E0D;&#x5BF9;&#x5176;&#x5185;&#x5BB9;&#x8D1F;&#x8D23;&#x3002;"; break;
   case "Reply": $tmp="&#x56DE;&#x590D;"; break;
   case "Your Name": $tmp="&#x60A8;&#x7684;&#x59D3;&#x540D;"; break;
   case "Subject": $tmp="&#x4E3B;&#x9898;"; break;
   case "Comment": $tmp="&#x8BC4;&#x8BBA;"; break;
   case "Allowed HTML:": $tmp="&#x5141;&#x8BB8;&#x7684;HTML&#xFF1A; : "; break;
   case "Preview": $tmp="&#x9884;&#x89C8;"; break;
   case " on...": $tmp=" &#x4E8E;..."; break;
   case "This account or IP has been temporarily disabled. This means that either this IP, or user account has been moderated down more than x times in the last few hours. If you think this is unfair, you should contact the admin.": $tmp="&#x6B64;&#x5E10;&#x53F7;&#x6216;IP&#x5730;&#x5740;&#x88AB;&#x4E34;&#x65F6;&#x5C01;&#x9501;&#xFF0C;&#x56E0;&#x4E3A;&#x5728;&#x6700;&#x8FD1;&#x7684;&#x51E0;&#x4E2A;&#x5C0F;&#x65F6;&#x5185;&#x5B83;&#x88AB;&#x91CD;&#x590D;&#x4F7F;&#x7528;&#x591A;&#x6B21;&#x3002;&#x5982;&#x679C;&#x60A8;&#x6709;&#x7591;&#x95EE;&#xFF0C;&#x8BF7;&#x8054;&#x7CFB;&#x7BA1;&#x7406;&#x5458;&#x3002;"; break;
   case "File Information": $tmp="&#x6587;&#x4EF6;&#x4FE1;&#x606F;"; break;
   case "Program Name": $tmp="&#x8EDF;&#x4EF6;&#x540D;&#x7A31;"; break;
   case "File Size": $tmp="&#x6A94;&#x6848;&#x5927;&#x5C0F;"; break;
   case "Version": $tmp="&#x7248;&#x672C;"; break;
   case "Upload Date": $tmp="&#x4E0A;&#x50B3;&#x65E5;&#x671F;"; break;
   case "Description": $tmp="&#x7A0B;&#x5E8F;&#x7C21;&#x4ECB;"; break;
   case "Downloads": $tmp="&#x4E0B;&#x8F09;&#x6B21;&#x6578;"; break;
   case "HomePage": $tmp="&#x8EDF;&#x4EF6;&#x7DB2;&#x5740;"; break;
   case "Download This File Now!": $tmp="&#x99AC;&#x4E0A;&#x4E0B;&#x8F09; !"; break;
   case "Select Category Folder": $tmp="&#x9009;&#x62E9;&#x6587;&#x4EF6;&#x5939;&#x7C7B;&#x522B;"; break;
   case "All": $tmp="&#x6240;&#x6709;"; break;
   case "Sort Ascending": $tmp="&#x9012;&#x589E;&#x6392;&#x5E8F;"; break;
   case "Sort Descending": $tmp="&#x9012;&#x51CF;&#x6392;&#x5E8F;"; break;
   case "Download Now!": $tmp="&#x73B0;&#x5728;&#x4E0B;&#x8F7D;"; break;
   case "Info": $tmp="&#x8CC7;&#x6599;"; break;
   case "Display filtered with": $tmp="&#x7ECF;&#x8FC7;&#x4EE5;&#x4E0B;&#x7B5B;&#x9009;&#x540E;&#x663E;&#x793A;&#x7ED3;&#x679C;"; break;
   case "sorted by": $tmp="&#x9009;&#x62E9;&#x663E;&#x793A;&#x7684;&#x987A;&#x5E8F;"; break;
   case "Ascending": $tmp="&#x9012;&#x589E;"; break;
   case "Descending": $tmp="&#x9012;&#x51CF;"; break;
   case "Name": $tmp="&#x540D;&#x79F0;"; break;
   case "Creation Date": $tmp="&#x521B;&#x5EFA;&#x65E5;&#x671F;"; break;
   case "off": $tmp="&#x7684;"; break;
   case "Private": $tmp="&#x975E;&#x516C;&#x5F00;"; break;
   case "Download Section": $tmp="&#x672C;&#x5730;&#x4E0B;&#x8F09;"; break;
   case "There is no such file...": $tmp="&#x8BE5;&#x6587;&#x4EF6;&#x4E0D;&#x5B58;&#x5728; ..."; break;
   case "FAQ (Frequently Ask Question)": $tmp="&#x5E38; &#x89C1; &#x95EE; &#x9898; (FAQ)"; break;
   case "Answer": $tmp="&#x89E3;&#x7B54;"; break;
   case "Back to Top": $tmp="&#x8FD4;&#x56DE;&#x9875;&#x9762;&#x9876;&#x7AEF;"; break;
   case "Back to FAQ Index": $tmp="&#x56DE;&#x5230;FAQ&#x7684;&#x4E3B;&#x9875;"; break;
   case "Send Story to a Friend": $tmp="&#x53D1;&#x9001;&#x4E00;&#x7BC7;&#x6587;&#x7AE0;&#x7ED9;&#x670B;&#x53CB;"; break;
   case "You will send the story": $tmp="&#x60A8;&#x5C06;&#x53D1;&#x9001;&#x8BE5;&#x6587;&#x7AE0;"; break;
   case "to a specified friend:": $tmp="&#x53D1;&#x9001;&#x7ED9;&#x8FD9;&#x4E2A;&#x670B;&#x53CB; : "; break;
   case "Friend Name: ": $tmp="&#x670B;&#x53CB;&#x59D3;&#x540D; : "; break;
   case "Friend Email: ": $tmp="&#x670B;&#x53CB;&#x96FB;&#x90F5; : "; break;
   case "Send": $tmp="&#x9001;&#x51FA;"; break;
   case "Interesting Article at": $tmp="&#x4E00;&#x7BC7;&#x7279;&#x522B;&#x7684;&#x6587;&#x7AE0;&#x5728;&#x4EE5;&#x4E0B;&#x7F51;&#x5740;"; break;
   case "Your Friend": $tmp="&#x60A8;&#x7684;&#x670B;&#x53CB;"; break;
   case "considered the following article interesting and wanted to send it to you.": $tmp=" &#x89C9;&#x5F97;&#x8FD9;&#x7BC7;&#x6587;&#x7AE0;&#x6709;&#x70B9;&#x610F;&#x601D;&#xFF0C;&#x5E0C;&#x671B;&#x53D1;&#x9001;&#x7ED9;&#x60A8;."; break;
   case "Date:": $tmp="&#x65E5;&#x671F; :"; break;
   case "Topic:": $tmp="&#x4E3B;&#x9898; : "; break;
   case "The Article": $tmp="&#x6587;&#x7AE0;"; break;
   case "Story": $tmp="&#x6587;&#x7AE0;"; break;
   case "has been sent to": $tmp="&#x5DF2;&#x53D1;&#x9001;&#x7ED9;"; break;
   case "Thanks!": $tmp="&#x8C22;&#x8C22;&#xFF01;"; break;
   case "Recommend this Site to a Friend": $tmp="&#x63A8;&#x85A6;&#x672C;&#x7AD9;&#x7D66;&#x670B;&#x53CB;"; break;
   case "Interesting Site:": $tmp="&#x63A8;&#x8350;&#x7F51;&#x7AD9; : "; break;
   case "considered our site": $tmp="&#x89C9;&#x5F97;&#x6211;&#x4EEC;&#x7684;&#x7F51;&#x7AD9;"; break;
   case "interesting and wanted to send it to you.": $tmp="&#x4E0D;&#x9519;&#xFF0C;&#x4E0E;&#x60A8;&#x5206;&#x4EAB;."; break;
   case "The reference to our site has been sent to": $tmp="&#x672C;&#x7AD9;&#x7684;&#x63A8;&#x85A6;&#x51FD;&#x5DF2;&#x7D93;&#x5BC4;&#x9001;&#x7D66;"; break;
   case "Thanks for recommend us!": $tmp="&#x8B1D;&#x8B1D;&#x60A8;&#x63A8;&#x85A6;&#x6211;&#x5011;!"; break;
   case "Click on Smilies to insert it on your Message": $tmp="&#x70B9;&#x51FB;&#x8868;&#x60C5;&#x5E76;&#x52A0;&#x5165;&#x5230;&#x60A8;&#x7684;&#x4FE1;&#x606F;&#x4E2D;"; break;
   case "bytes more": $tmp="&#x5B57;&#x8282;"; break;
   case "Read More...": $tmp="&#x66F4;&#x591A;..."; break;
   case "comments?": $tmp="&#x8BC4;&#x8BBA; ?"; break;
   case "comments": $tmp="&#x8BC4;&#x8BBA;"; break;
   case "Popular": $tmp="&#x70ED;&#x95E8;&#x7F51;&#x7AD9;"; break;
   case "Top Rated": $tmp="&#x6700;&#x53D7;&#x6B22;&#x8FCE;&#x7F51;&#x7AD9;"; break;
   case "Random": $tmp="&#x5176;&#x4ED6;&#x7F51;&#x7AD9;"; break;
   case "Link Comments": $tmp="&#x94FE;&#x63A5;&#x8BC4;&#x8BED;"; break;
   case "Editor Review": $tmp="&#x51FA;&#x7248;&#x8005;&#x7684;&#x5BF9;&#x8BE5;&#x6587;&#x7AE0;&#x7684;&#x8BC4;&#x8BBA; "; break;
   case "Register for an Account": $tmp="&#x6CE8;&#x518C;"; break;
   case "vote": $tmp="&#x7968;"; break;
   case "Details": $tmp="&#x8BE6;&#x7EC6;&#x8D44;&#x6599;"; break;
   case "of": $tmp="&#x6765;&#x81EA;&#x4E8E;"; break;
   case "links": $tmp="&#x7F51;&#x7AD9;&#x94FE;&#x63A5;"; break;
   case "Categories": $tmp="&#x5206;&#x7C7B"; break;
   case "No matches found to your query": $tmp="&#x6CA1;&#x6709;&#x4E0E;&#x60A8;&#x7684;&#x67E5;&#x8BE2;&#x76F8;&#x5173;&#x7684;&#x7ED3;&#x679C;"; break;
   case "User": $tmp="&#x7528;&#x6237;"; break;
   case "total votes": $tmp="&#x5408;&#x8BA1;&#x6295;&#x7968;"; break;
   case "Registered Users": $tmp="&#x6CE8;&#x518C;&#x7528;&#x6237;"; break;
   case "to": $tmp="&#x81F3;"; break;
   case "Return to": $tmp="&#x56DE;&#x5230;"; break;
   case "Thank you for taking the time to record you in or DataBase.": $tmp="&#x8C22;&#x8C22;&#x60A8;&#x82B1;&#x8D39;&#x5B9D;&#x8D35;&#x7684;&#x65F6;&#x95F4;&#x8FDB;&#x884C;&#x6570;&#x636E;&#x8F93;&#x5165;&#x3002;"; break;
   case "For Unsubscribe, please goto": $tmp="&#x5982;&#x679C;&#x8981;&#x53D6;&#x6D88;&#x60A8;&#x9884;&#x5B9A;&#x7684;&#x90AE;&#x4EF6;&#x901A;&#x77E5;&#xFF0C;&#x8BF7;&#x4F7F;&#x7528;&#x4EE5;&#x4E0B;&#x529F;&#x80FD;"; break;
   case "Empty data not allowed.": $tmp="&#x8BE5;&#x6570;&#x636E;&#x4E0D;&#x80FD;&#x4E3A;&#x7A7A;."; break;
   case "Sort by:": $tmp="&#x6392;&#x5217;&#x7684;&#x987A;&#x5E8F;&#x4F9D;&#x636E;&#xFF1A; : "; break;
   case "nickname": $tmp="&#x7528;&#x6237;&#x540D;"; break;
   case "real name": $tmp="&#x771F;&#x5B9E;&#x59D3;&#x540D;"; break;
   case "Location": $tmp="&#x4F4F;&#x6240;"; break;
   case "url": $tmp="URL&#x5730;&#x5740;"; break;
   case "Members List": $tmp="&#x4F1A;&#x5458;&#x5217;&#x8868;"; break;
   case "Greetings to our latest registered user:": $tmp="&#x6B22;&#x8FCE;&#x6211;&#x4EEC;&#x7684;&#x6700;&#x65B0;&#x4F1A;&#x5458;"; break;
   case "We have": $tmp="&#x6211;&#x4EEC;&#x6709;"; break;
   case "registered users so far.": $tmp="&#x6CE8;&#x518C;&#x4F1A;&#x5458;"; break;
   case "URL": $tmp="URL&#x5730;&#x5740;"; break;
   case "Send internal Message": $tmp="&#x53D1;&#x9001;&#x4E00;&#x6761;Internet&#x4FE1;&#x606F;"; break;
   case "RAZ member's list": $tmp="&#x91CD;&#x7F6E;&#x4F1A;&#x5458;&#x5217;&#x8868;"; break;
   case "Write to the list": $tmp="&#x5411;&#x5217;&#x8868;&#x4E2D;&#x5199;&#x5165;"; break;
   case "users found for": $tmp="&#x627E;&#x5230;&#x7684;&#x7528;&#x6237;&#x5173;&#x4E8E;"; break;
   case "users shown": $tmp="&#x663E;&#x793A;&#x7684;&#x7528;&#x6237;"; break;
   case "users found": $tmp="&#x627E;&#x5230;&#x7684;&#x7528;&#x6237;"; break;
   case "No Members Found for": $tmp="&#x6CA1;&#x6709;&#x627E;&#x5230;&#x4EFB;&#x4F55;&#x4F1A;&#x5458;&#x5173;&#x4E8E;"; break;
   case "This article comes from": $tmp="&#x8FD9;&#x7BC7;&#x6587;&#x7AE0;&#x6765;&#x81EA;&#x4E8E;"; break;
   case "Private Message": $tmp="&#x6761;&#x4E2A;&#x4EBA;&#x77ED;&#x6D88;&#x606F;&#x3002;"; break;
   case "To": $tmp="&#x53D1;&#x9001;&#x5230;"; break;
   case "From": $tmp="&#x6765;&#x81EA;"; break;
   case "You don't have any Messages.": $tmp="&#x60A8;&#x6CA1;&#x6709;&#x8981;&#x63A5;&#x6536;&#x7684;&#x4FE1;&#x606F;"; break;
   case "Sent": $tmp="&#x5DF2;&#x7ECF;&#x53D1;&#x9001;"; break;
   case "Previous Messages": $tmp="&#x524D;&#x4E00;&#x6761;&#x6D88;&#x606F;"; break;
   case "Next Messages": $tmp="&#x4E0B;&#x4E00;&#x6761;&#x6D88;&#x606F;"; break;
   case "Reply Posted.": $tmp="&#x8D34;&#x7684;&#x56DE;&#x590D;"; break;
   case "You must type a message to post.": $tmp="&#x60A8;&#x5FC5;&#x987B;&#x8F93;&#x5165;&#x4E00;&#x6761;&#x4FE1;&#x606F;&#x4EE5;&#x5F20;&#x8D34;"; break;
   case "Post Reply in Topic:": $tmp="&#x8D34;&#x7ED9;&#x8BE5;&#x4E3B;&#x9898;&#x7684;&#x56DE;&#x590D;"; break;
   case "You are not allowed to reply in this forum": $tmp="&#x60A8;&#x6CA1;&#x6709;&#x88AB;&#x6388;&#x6743;&#x5728;&#x8BE5;&#x8BBA;&#x575B;&#x56DE;&#x590D;&#x3002;"; break;
   case "wrote:": $tmp="&#x5199;&#x9053; :"; break;
   case "Topic Review": $tmp="&#x70ED;&#x95E8;&#x4E3B;&#x9898;"; break;
   case "Write a Review": $tmp="&#x5199;&#x8BC4;&#x8BBA;"; break;
   case "Write a Review for": $tmp="&#x5199;&#x8BC4;&#x8BBA;&#x5173;&#x4E8E;"; break;
   case "Product Title": $tmp="&#x4EA7;&#x54C1;&#x540D;&#x79F0;"; break;
   case "Name of the Reviewed Product.": $tmp="&#x88AB;&#x8BC4;&#x8BBA;&#x4F5C;&#x54C1;&#x7684;&#x540D;&#x79F0;&#x3002;"; break;
   case "Review": $tmp="&#x8BC4;&#x8BBA;"; break;
   case "Your actual review. Please observe proper grammar! Make it at least 100 words, OK? You may also use HTML tags if you know how to use them.": $tmp="&#x60A8;&#x5F53;&#x524D;&#x7684;&#x8BC4;&#x8BBA;&#x3002;&#x8BF7;&#x6CE8;&#x610F;&#x60A8;&#x7684;&#x4E66;&#x5199;&#x65B9;&#x5F0F;&#xFF01;&#x60A8;&#x53EF;&#x4EE5;&#x4F7F;&#x7528;HTML&#x683C;&#x5F0F;&#x5982;&#x679C;&#x60A8;&#x4F1A;&#x4F7F;&#x7528;&#x8BE5;&#x65B9;&#x6CD5;&#x3002;"; break;
   case "Your name": $tmp="&#x60A8;&#x7684;&#x540D;&#x5B57;"; break;
   case "Your Full Name. Required.": $tmp="&#x60A8;&#x7684;&#x5168;&#x540D;&#x3002;&#x5FC5;&#x586B;&#x9879;&#x3002;"; break;
   case "Your E-mail address. Required.": $tmp="&#x60A8;&#x7684;Email&#x5FC5;&#x987B;&#x586B;&#x5199;&#x3002;"; break;
   case "Select from 1=poor to 10=excelent.": $tmp="&#x5728;1&#x4E0E;10&#x4E4B;&#x95F4;&#x8FDB;&#x884C;&#x9009;&#x62E9; &#xFF08;1=&#x5DEE; 10=&#x51FA;&#x8272;&#xFF09;"; break;
   case "Related Link": $tmp="&#x76F8;&#x5173;&#x94FE;&#x63A5;"; break;
   case "Product Official Website. Make sure your URL starts by": $tmp="&#x4EA7;&#x54C1;&#x5B98;&#x65B9;&#x7AD9;&#x70B9;&#x3002;&#x60A8;&#x586B;&#x5199;&#x7684;URL&#x5F00;&#x5934;&#x5E94;&#x6709; \"http://\""; break;
   case "Link title": $tmp="&#x94FE;&#x63A5;&#x540D;&#x79F0;&#xFF1A;"; break;
   case "Required if you have a related link, otherwise not required.": $tmp="&#x5982;&#x679C;&#x60A8;&#x6709;&#x76F8;&#x5173;&#x94FE;&#x63A5;&#x8BF7;&#x586B;&#x5199;&#xFF0C;&#x5426;&#x5219;&#x4E0D;&#x5FC5;&#x586B;&#x5199;&#x3002;"; break;
   case "Image filename": $tmp="&#x56FE;&#x7247;&#x6587;&#x4EF6;&#x540D;"; break;
   case "Name of the cover image, located in images/reviews/. Not required.": $tmp="&#x5C01;&#x9762;&#x56FE;&#x7247;&#x540D;&#x79F0;&#xFF0C;&#x4F4D;&#x4E8E; images/reviews/&#x3002;&#x53EF;&#x9009;&#x9879;&#x3002;"; break;
   case "Please make sure that the information entered is 100% valid and uses proper grammar and capitalization. For instance, please do not enter your text in ALL CAPS, as it will be rejected.": $tmp="&#x8BF7;&#x786E;&#x4FDD;&#x586B;&#x5165;&#x7684;&#x4FE1;&#x606F;&#x5747;&#x6709;&#x6548;&#x3001;&#x8BED;&#x6CD5;&#x6B63;&#x786E;&#x3001;&#x6CE8;&#x610F;&#x5927;&#x5C0F;&#x5199;&#x3002;&#x6BD4;&#x5982;&#xFF0C;&#x4E0D;&#x8981;&#x7528;&#x5927;&#x5199;&#x4E66;&#x5199;&#x6587;&#x672C;&#xFF0C;&#x8FD9;&#x6837;&#x4F1A;&#x62D2;&#x7EDD;&#x5199;&#x5165;&#x7684;&#x3002; !"; break;
   case "Invalid Title... can not be blank": $tmp="&#x540D;&#x79F0;&#x4E0D;&#x80FD;&#x4E3A;&#x7A7A;"; break;
   case "Invalid review text... can not be blank": $tmp="&#x8BC4;&#x8BBA;&#x6587;&#x672C;&#x4E0D;&#x80FD;&#x4E3A;&#x7A7A;"; break;
   case "Invalid score... must be between 1 and 10": $tmp="&#x65E0;&#x6548;&#x8BC4;&#x5206;&#x3002;&#x8BC4;&#x5206;&#x5FC5;&#x987B;&#x5728; 1&#x4E0E;10&#x4E4B;&#x95F4;"; break;
   case "Hits must be a positive integer": $tmp="&#x70B9;&#x51FB;&#x6570;&#x5FC5;&#x987B;&#x4E3A;&#x6B63;&#x6574;&#x6570;"; break;
   case "You must enter both your name and your email": $tmp="&#x60A8;&#x5FC5;&#x987B;&#x586B;&#x5199;&#x60A8;&#x7684;&#x540D;&#x5B57;&#x548C;&#x60A8;&#x7684;Email"; break;
   case "Invalid email (eg: you@hotmail.com)": $tmp="&#x65E0;&#x6548;Email&#x5730;&#x5740;&#xFF08;&#x6B63;&#x786E;&#x5199;&#x6CD5;&#xFF1A;dong@dong.com&#xFF09;"; break;
   case "You must enter BOTH a link title and a related link or leave both blank": $tmp="&#x60A8;&#x5FC5;&#x987B;&#x540C;&#x65F6;&#x586B;&#x5199;&#x94FE;&#x63A5;&#x540D;&#x79F0;&#x53CA;&#x76F8;&#x5173;URL&#xFF0C;&#x5426;&#x5219;&#x90FD;&#x7A7A;&#x7740;"; break;
   case "Added:": $tmp="&#x5DF2;&#x6DFB;&#x52A0;&#xFF1A; :"; break;
   case "Reviewer:": $tmp="&#x8BC4;&#x8BBA;&#x8005;&#xFF1A; : "; break;
   case "Score:": $tmp="&#x5206;&#x6570;&#xFF1A; : "; break;
   case "Review ID": $tmp="&#x8BC4;&#x8BBA;ID"; break;
   case "Hits": $tmp="&#x70B9;&#x51FB;&#x6B21;&#x6570;"; break;
   case "Does this look right?": $tmp="&#x60A8;&#x786E;&#x5B9A;&#x5417;&#xFF1F; ?"; break;
   case "modified": $tmp="&#x4FEE;&#x6539;"; break;
   case "added": $tmp="&#x5DF2;&#x6DFB;&#x52A0;&#xFF1A;"; break;
   case "Note:": $tmp="&#x6CE8;&#x610F;&#xFF1A;"; break;
   case "Currently logged in as admin... this review will be": $tmp="&#x5F53;&#x524D;&#x4EE5;&#x7BA1;&#x7406;&#x5458;&#x8EAB;&#x4EFD;&#x767B;&#x5F55;... &#x8BC4;&#x8BBA;&#x7ACB;&#x5373;&#x53D1;&#x5E03;"; break;
   case "immediately": $tmp="&#x5373;&#x523B;"; break;
   case "Thanks for submitting this review": $tmp="&#x8C22;&#x8C22;&#x60A8;&#x7684;&#x8BC4;&#x8BBA;"; break;
   case "modification": $tmp="&#x4FEE;&#x6539;"; break;
   case "It is now available in the reviews database.": $tmp="&#x5728;&#x8BC4;&#x8BBA;&#x7684;&#x6570;&#x636E;&#x5E93;&#x4E2D;&#x4ECE;&#x6B64;&#x523B;&#x5F00;&#x59CB;&#x751F;&#x6548;&#x3002;"; break;
   case "The editors will look at your submission. It should be available soon!": $tmp="&#x7F16;&#x8F91;&#x8005;&#x5C06;&#x770B;&#x5230;&#x60A8;&#x7684;&#x63D0;&#x4EA4;&#x5185;&#x5BB9;&#x3002;&#x5979;&#x5C06;&#x5F88;&#x5FEB;&#x5C31;&#x751F;&#x6548;&#xFF01;"; break;
   case "Back to Reviews Index": $tmp="&#x8FD4;&#x56DE;&#x8BC4;&#x8BBA;&#x7684;&#x4E3B;&#x5217;&#x8868;"; break;
   case "Welcome to Reviews Section": $tmp="&#x6B22;&#x8FCE;&#x6765;&#x5230;&#x8BC4;&#x8BBA;&#x4E13;&#x680F;"; break;
   case "most popular reviews": $tmp="&#x4E2A;&#x6700;&#x53D7;&#x6B22;&#x8FCE;&#x8BC4;&#x8BBA;"; break;
   case "most recent reviews": $tmp="&#x4E2A;&#x6700;&#x65B0;&#x8BC4;&#x8BBA;"; break;
   case "reviews in the database": $tmp="&#x8BC4;&#x8BBA;"; break;
   case "Reviews for letter": $tmp="&#x5BF9;&#x4FE1;&#x4EF6;&#x7684;&#x8BC4;&#x8BBA;"; break;
   case "There isn't any Review for letter": $tmp="&#x6CA1;&#x6709;&#x5BF9;&#x4FE1;&#x4EF6;&#x7684;&#x8BC4;&#x8BBA;"; break;
   case "Total Review(s) found.": $tmp="&#x627E;&#x5230;&#x7684;&#x6240;&#x6709;&#x8BC4;&#x8BBA;."; break;
   case "Comment on the Review:": $tmp="&#x5BF9;&#x8BE5;&#x8BC4;&#x8BBA;&#x4F5C;&#x51FA;&#x7B80;&#x8BC4;:"; break;
   case "This Product Score:": $tmp="&#x672C;&#x4EA7;&#x54C1;&#x7684;&#x8BC4;&#x5206; : "; break;
   case "Your Comment:": $tmp="&#x60A8;&#x7684;&#x8BC4;&#x8BBA; : "; break;
   case "My Score:": $tmp="&#x6211;&#x7684;&#x8BC4;&#x5206;&#xFF1A; : "; break;
   case "Admin:": $tmp="&#x5B8C;&#x5168;&#x7BA1;&#x7406; : "; break;
   case "Related Link:": $tmp="&#x76F8;&#x5173;&#x94FE;&#x63A5; : "; break;
   case "Hits:": $tmp="&#x9020;&#x8BBF;&#x6B21;&#x6570;: "; break;
   case "Review Modification": $tmp="&#x4FEE;&#x6539;&#x4E00;&#x4E2A;&#x8BC4;&#x8BBA;"; break;
   case "Email:": $tmp="&#x7535;&#x5B50;&#x90AE;&#x4EF6; : "; break;
   case "Link:": $tmp="&#x94FE;&#x63A5; : "; break;
   case "Link title:": $tmp="&#x94FE;&#x63A5;&#x540D;&#x79F0;&#xFF1A; : "; break;
   case "Cover image:": $tmp="&#x5C01;&#x9762;&#x56FE;&#x7247;&#xFF1A; : "; break;
   case "Preview Modifications": $tmp="&#x5BF9;&#x4FEE;&#x6539;&#x8FDB;&#x884C;&#x9884;&#x89C8;"; break;
   case "Cancel": $tmp="&#x53D6;&#x6D88;"; break;
   case "Total": $tmp="&#x603B;&#x8BA1;&#xFF1A;"; break;
   case "Usage": $tmp="&#x7528;&#x6CD5;"; break;
   case "Free": $tmp="&#x81EA;&#x7531;"; break;
   case "cached": $tmp="&#x9690;&#x85CF;"; break;
   case "Total:": $tmp="&#x603B;&#x8BA1;&#xFF1A; : "; break;
   case "Usage:": $tmp="&#x7528;&#x6CD5; : "; break;
   case "Size": $tmp="&#x5927;&#x5C0F;"; break;
   case "Used": $tmp="&#x4F7F;&#x7528;&#x8FC7;"; break;
   case "We received": $tmp="&#x6211;&#x4EEC;&#x7684;&#x8BBF;&#x95EE;&#x8005;&#x5DF2;&#x7ECF;&#x6D4F;&#x89C8;&#x8FC7;"; break;
   case "views since": $tmp="&#x9875;&#x9762;&#x81EA;&#x4ECE;"; break;
   case "Browsers": $tmp="&#x6D4F;&#x89C8;&#x5668;&#x8BBF;&#x95EE;&#x6B21;&#x6570;&#x7EDF;&#x8BA1;"; break;
   case "Search Engines": $tmp="&#x641C;&#x7D22;&#x5F15;&#x64CE;"; break;
   case "Robots - Spiders": $tmp="Robots"; break;
   case "Unknown": $tmp="&#x672A;&#x77E5;"; break;
   case "Operating Systems": $tmp="&#x6D4F;&#x89C8;&#x5668;"; break;
   case "Number of users per theme": $tmp="&#x6309;&#x4E0D;&#x540C;&#x4E3B;&#x9898;&#x7684;&#x4F7F;&#x7528;&#x8005;&#x7684;&#x6570;&#x76EE;"; break;
   case "Default": $tmp="&#x9ED8;&#x8BA4;"; break;
   case "Miscelaneous Stats": $tmp="&#x591A;&#x6837;&#x7684;&#x7EDF;&#x8BA1;&#x6570;&#x636E;"; break;
   case "Registered Users: ": $tmp="&#x6CE8;&#x518C;&#x7528;&#x6237; : "; break;
   case "Active Authors: ": $tmp="&#x4F5C;&#x54C1;&#x4E30;&#x5BCC;&#x7684;&#x4F5C;&#x8005; : "; break;
   case "Stories Published: ": $tmp="&#x5DF2;&#x53D1;&#x8868;&#x6587;&#x7AE0;&#xFF1A; : "; break;
   case "Active Topics: ": $tmp="&#x6D3B;&#x8DC3;&#x7684;&#x4E3B;&#x9898;&#xFF1A; : "; break;
   case "Comments Posted: ": $tmp="&#x53D1;&#x5E03;&#x8BC4;&#x8BED;&#xFF1A; : "; break;
   case "Special Sections: ": $tmp="&#x7CBE;&#x534E;&#x533A;&#xFF1A; : "; break;
   case "Articles in Sections: ": $tmp="&#x5728;&#x7CBE;&#x534E;&#x533A;&#x4E2D;&#x7684;&#x6587;&#x7AE0;&#xFF1A; : "; break;
   case "Links in Web Links: ": $tmp="&#x94FE;&#x63A5;&#x8D44;&#x6E90;&#x6570;&#xFF1A; : "; break;
   /**/case "Categories in Web Links: ": $tmp="Categories in Web Links: "; break;
   case "News Waiting to be Published: ": $tmp="&#x7B49;&#x5F85;&#x53D1;&#x8868;&#x7684;&#x6587;&#x7AE0;&#xFF1A; : "; break;
   case "Submit News": $tmp="&#x63D0;&#x4EA4;&#x6587;&#x7AE0;&#x8BBE;&#x7F6E;"; break;
   case "Be Descriptive, Clear and Simple": $tmp="&#x63CF;&#x8FF0;&#x6027;&#x7684;&#xFF0C;&#x6E05;&#x695A;&#x4E14;&#x7B80;&#x6D01; !"; break;
   case "bad titles='Check This Out!' or 'An Article'.": $tmp="&#x4F46;&#x662F;&#x4E0D;&#x8981;&#x547D;&#x540D;&#x4E3A;&#x201D;&#x4E00;&#x7BC7;&#x6587;&#x7AE0;&#x201D;&#x6216;&#x201D;&#x8BFB;&#x8BFB;..&#x201D;&#x3002;"; break;
   case "Select Topic": $tmp="&#x9009;&#x62E9;&#x4E3B;&#x9898;"; break;
   case "Intro Text": $tmp="&#x4ECB;&#x7ECD;&#x6587;&#x7AE0;"; break;
   case "HTML is fine, but double check those URLs and HTML tags!": $tmp="HTML&#x53EF;&#x4EE5;&#x4F7F;&#x7528;&#xFF0C;&#x8BF7;&#x53CC;&#x500D;&#x68C0;&#x67E5;URL&#x548C;HTML&#x6807;&#x8BB0;&#x662F;&#x5426;&#x6709;&#x8BEF;&#xFF01; !"; break;
   case "You must preview once before you can submit": $tmp="&#x5728;&#x63D0;&#x4EA4;&#x524D;&#x60A8;&#x5FC5;&#x987B;&#x9884;&#x89C8;&#x8BE5;&#x6587;&#x7AE0;&#x3002;"; break;
   case "The topic has been moved.": $tmp="&#x4E3B;&#x9898;&#x5DF2;&#x4E0D;&#x5728;&#x5F53;&#x524D;&#x4F4D;&#x7F6E;&#x3002;"; break;
   case "Click here to view the updated topic.": $tmp="&#x70B9;&#x51FB;&#x8FD9;&#x91CC;&#x770B;&#x65B0;&#x7684;&#x4E3B;&#x9898;&#x3002;"; break;
   case "Users IP and Account information": $tmp="&#x4F7F;&#x7528;&#x8005;IP&#x5730;&#x5740;&#x548C;&#x5E10;&#x53F7;&#x4FE1;&#x606F;&#x3002;"; break;
   case "User IP: ": $tmp="&#x7528;&#x6237;&#x7684;IP&#x5730;&#x5740;&#xFF1A; : "; break;
   case "Move Topic To: ": $tmp="&#x5C06;&#x8BE5;&#x4E3B;&#x9898;&#x8F6C;&#x79FB;&#x5230;&#xFF1A; : "; break;
   case "Delete Topic": $tmp="&#x5220;&#x9664;&#x4E3B;&#x9898;"; break;
   case "Move Topic": $tmp="&#x79FB;&#x52A8;&#x672C;&#x5E16;"; break;
   case "Lock Topic": $tmp="&#x9501;&#x5B9A;&#x672C;&#x5E16;"; break;
   case "Unlock Topic": $tmp="&#x89E3;&#x9501;&#x672C;&#x5E16;"; break;
   case "View IP": $tmp="&#x67E5;&#x770B;&#x8BE5;IP&#x5730;&#x5740;"; break;
   case "You are not the moderator of this forum therefor you cannot perform this function.": $tmp="&#x60A8;&#x4E0D;&#x662F;&#x672C;&#x8BBA;&#x575B;&#x7684;&#x7248;&#x4E3B;&#x3002;&#x60A8;&#x4E0D;&#x80FD;&#x4F7F;&#x7528;&#x8BE5;&#x529F;&#x80FD;&#x3002;"; break;
   case "Inbox": $tmp="&#x6536;&#x4EF6;&#x5939;"; break;
   case "Not Read": $tmp="&#x672A;&#x8BFB;"; break;
   case "Outbox": $tmp="&#x53D1;&#x4EF6;&#x5939;"; break;
   case "Home": $tmp="&#x56DE;&#x5230;&#x9996;&#x9875;"; break;
   case "Internal": $tmp="&#x5185;&#x90E8;&#x7684;"; break;
   case "All registered users can post private messages.": $tmp="&#x6240;&#x6709;&#x6CE8;&#x518C;&#x7528;&#x6237;&#x53EF;&#x4EE5;&#x53D1;&#x9001;&#x79C1;&#x4EBA;&#x6D88;&#x606F;."; break;
   case "Cancel Reply": $tmp="&#x53D6;&#x6D88;&#x56DE;&#x590D;"; break;
   case "Cancel Send": $tmp="&#x53D6;&#x6D88;&#x53D1;&#x9001;"; break;
   case "Room": $tmp="&#x623F;&#x95F4;"; break;
   case "SubCategory": $tmp="&#x6B21;&#x76EE;&#x5F55;"; break;
   case "Add articles": $tmp="&#x6DFB;&#x52A0;&#x4E00;&#x4E2A;&#x7269;&#x54C1;"; break;
   case "stb = Request in standby": $tmp="stb= &#x8BF7;&#x7A0D;&#x7B49;&#xFF0C;&#x60A8;&#x7684;&#x7533;&#x8BF7;&#x5728;&#x7CFB;&#x7EDF;&#x5904;&#x7406;&#x4E2D;"; break;
   case "Price": $tmp="&#x4EF7;&#x683C;"; break;
   case "To use this application you must be": $tmp="&#x8981;&#x4F7F;&#x7528;&#x8BE5;&#x529F;&#x80FD;&#xFF0C;&#x60A8;&#x5FC5;&#x987B;&#x662F;"; break;
   case "Advance User": $tmp="&#x8D85;&#x7EA7;&#x7528;&#x6237;"; break;
   case "Name is too long or empty. It must be less than 50 characters.": $tmp="&#x540D;&#x5B57;&#x592A;&#x957F;&#x6216;&#x672A;&#x8F93;&#x5165;&#x3002;&#x540D;&#x5B57;&#x5FC5;&#x987B;&#x5C11;&#x4E8E;50&#x4E2A;&#x5B57;&#x7B26;&#x7684;&#x957F;&#x5EA6;&#x3002;"; break;
   case "Address": $tmp="&#x5730;&#x5740;"; break;
   case "City": $tmp="&#x57CE;&#x5E02;"; break;
   case "Country": $tmp="&#x56FD;&#x5BB6;"; break;
   case "User Informations": $tmp="&#x5E10;&#x6237;&#x4FE1;&#x606F;"; break;
   case "Zip Code": $tmp="&#x90AE;&#x653F;&#x7F16;&#x7801;"; break;
   case "Name or Entrepise": $tmp="&#x59D3;&#x540D;&#x6216;&#x516C;&#x53F8;&#x540D;&#x79F0;"; break;
   case "Money": $tmp="&#x8D27;&#x5E01;"; break;
   case "Period": $tmp="&#x65F6;&#x671F;"; break;
   case "Look": $tmp="&#x754C;&#x9762;"; break;
   case "Allow the automatic validation of offers?": $tmp="&#x5141;&#x8BB8;&#x8BE5;&#x9500;&#x552E;&#x8D44;&#x6E90;&#x7684;&#x4FE1;&#x606F;&#x81EA;&#x52A8;&#x751F;&#x6548;?"; break;
   case "Max days for offers": $tmp="&#x8BE5;&#x9500;&#x552E;&#x8D44;&#x6E90;&#x7684;&#x4FE1;&#x606F;&#x7684;&#x6709;&#x6548;&#x5929;&#x6570;"; break;
   case "0 : unlimited / 1 to": $tmp="0&#xFF1A;&#x65E0;&#x9650; / 1 &#x81F3;"; break;
   case "request for the same user.": $tmp="&#x540C;&#x4E00;&#x4E2A;&#x7528;&#x6237;&#x7684;&#x7533;&#x8BF7;."; break;
   case "Submit an offer": $tmp="&#x63D0;&#x4EA4;&#x4E00;&#x4E2A;&#x9500;&#x552E;&#x8D44;&#x6E90;&#x4FE1;&#x606F;"; break;
   case "Access to this application is reserved to Advance Registered Users. Please Registered.": $tmp="&#x672C;&#x529F;&#x80FD;&#x53EA;&#x63D0;&#x4F9B;&#x7ED9;&#x8D85;&#x7EA7;&#x6CE8;&#x518C;&#x7528;&#x6237;&#x3002;&#x8BF7;&#x60A8;&#x6CE8;&#x518C;&#x3002;"; break;
   case "Offers per page": $tmp="&#x6BCF;&#x9875;&#x5C55;&#x793A;&#x7684;&#x5546;&#x54C1;&#x4FE1;&#x606F;&#x6570;&#x91CF;"; break;
   case "Subcategory per row": $tmp="&#x6BCF;&#x884C;&#x7684;&#x6B21;&#x76EE;&#x5F55;&#xFF08;&#x4E3B;&#x8981;&#x9875;&#x9762;&#xFF09;"; break;
   case "Allow automated new-users configuration?": $tmp="&#x5141;&#x8BB8;&#x81EA;&#x52A8;&#x521B;&#x5EFA;&#x65B0;&#x4F1A;&#x5458;&#xFF1F;"; break;
   case "0=No - 1=Yes": $tmp="O=&#x5426; - 1=&#x662F;"; break;
   case "Your client informations (Name, Tel, ...)": $tmp="&#x60A8;&#x7684;&#x4E2A;&#x4EBA;&#x4FE1;&#x606F;"; break;
   case "Your offer": $tmp="&#x60A8;&#x63D0;&#x4F9B;&#x7684;&#x5546;&#x54C1;&#x8D44;&#x6E90;"; break;
   case "Offer": $tmp="&#x5546;&#x54C1;&#x8D44;&#x6E90;"; break;
   case "Your Message has been Posted": $tmp="&#x60A8;&#x7684;&#x6D88;&#x606F;&#x5DF2;&#x7ECF;&#x53D1;&#x51FA;"; break;
   case "Are you sure you want to delete SubCategory": $tmp="&#x60A8;&#x80AF;&#x5B9A;&#x8981;&#x5220;&#x9664;&#x8BE5;&#x6B21;&#x76EE;&#x5F55;&#x5417; ?"; break;
   case "Search in Users Database": $tmp="&#x6CA1;&#x6709;&#x627E;&#x5230;&#x5339;&#x914D;&#x7684;&#x7528;&#x6237;"; break;
   /**/case "Search in Special Sections": $tmp="Search in Special Sections"; break;
   case "Search in Reviews": $tmp="&#x641C;&#x7D22;&#x8BC4;&#x8BBA;"; break;
   case "Articles": $tmp="&#x6587;&#x7AE0;"; break;
   case "All Authors": $tmp="&#x6240;&#x6709;&#x4F5C;&#x8005;"; break;
   case "month": $tmp="&#x6708;"; break;
   case "months": $tmp="&#x6708;"; break;
   case "Search on:": $tmp="&#x641C;&#x7D22; : "; break;
   case "Stories": $tmp="&#x6587;&#x7AE0;"; break;
   case "Sections": $tmp="&#x7CBE;&#x534E;&#x533A;"; break;
   case "Users": $tmp="&#x7528;&#x6237;"; break;
   case "Reviews": $tmp="&#x8BC4;&#x8BBA;"; break;
   case "in the Section": $tmp="&#x5728;&#x680F;&#x76EE;&#x4E2D;"; break;
   case "No name entered": $tmp="&#x6CA1;&#x6709;&#x540D;&#x5B57;&#x8F93;&#x5165;"; break;
   case "Welcome to the TOP page for": $tmp="&#x6B22;&#x8FCE;&#x5149;&#x4E34;Top&#x5217;&#x8868;&#x5728;"; break;
   case "most read stories": $tmp="&#x4EBA;&#x6C14;&#x6700;&#x9AD8;&#x7684;&#x6587;&#x7AE0;"; break;
   case "read:": $tmp="&#x9605;&#x8BFB; : "; break;
   /**/case "times": $tmp="times"; break;
   case "most commented stories": $tmp="&#x7BC7;&#x8BC4;&#x8BBA;&#x6700;&#x591A;&#x7684;&#x6587;&#x7AE0;"; break;
   case "most active categories": $tmp="&#x6700;&#x6D3B;&#x8DC3;&#x7684;&#x5206;&#x7C7B;"; break;
   case "most read articles in special sections": $tmp="&#x5728;&#x7279;&#x522B;&#x680F;&#x76EE;&#x4E2D;&#x7684;&#x7126;&#x70B9;&#x6587;&#x7AE0;"; break;
   case "most active news submitters": $tmp="&#x4F4D;&#x6700;&#x6D3B;&#x8DC3;&#x7684;&#x65B0;&#x95FB;&#x63D0;&#x4EA4;&#x8005;"; break;
   case "sent news:": $tmp="&#x6587;&#x7AE0;&#x5DF2;&#x7ECF;&#x53D1;&#x9001; : "; break;
   case "most voted polls": $tmp="&#x4E2A;&#x6295;&#x7968;&#x6700;&#x591A;&#x7684;&#x7968;&#x9009;&#x9879;"; break;
   case "votes:": $tmp="&#x7968;&#x6570; :"; break;
   case "most active authors": $tmp="&#x4F4D;&#x6700;&#x6D3B;&#x8DC3;&#x7684;&#x4F5C;&#x8005;"; break;
   case "news published:": $tmp="&#x7BC7;&#x6587;&#x7AE0;&#x88AB;&#x53D1;&#x5E03; : "; break;
   case "most read reviews": $tmp="&#x4E2A;&#x88AB;&#x9605;&#x8BFB;&#x6700;&#x591A;&#x7684;&#x8BC4;&#x8BBA;"; break;
   case "Current Active Topics": $tmp="&#x5F53;&#x524D;&#x6D3B;&#x8DC3;&#x7684;&#x4E3B;&#x9898;"; break;
   case "Click to list all articles in this topic": $tmp="&#x70B9;&#x51FB;&#x5217;&#x51FA;&#x672C;&#x4E3B;&#x9898;&#x7684;&#x6240;&#x6709;&#x6587;&#x7AE0;"; break;
   case "Manage your subscribes": $tmp="&#x7BA1;&#x7406;&#x60A8;&#x7684;&#x6CE8;&#x518C;&#x7528;&#x6237;"; break;
   /**/case "Current Survey Voting Booth": $tmp="Current Survey Voting Booth"; break;
   case "Welcome to the Special Sections at": $tmp="&#x6B22;&#x8FCE;&#x5149;&#x4E34;&#x7CBE;&#x534E;&#x533A;&#x4E8E;"; break;
   case "Here you can find some cool articles not presents in the Home.": $tmp="&#x8FD9;&#x91CC;&#xFF0C;&#x60A8;&#x53EF;&#x4EE5;&#x627E;&#x5230;&#x6700;&#x8BE6;&#x7EC6;&#x7684;&#x4E00;&#x4E9B;&#x6587;&#x7AE0;"; break;
   case "This is Section": $tmp="&#x672C;&#x9879;&#x4E3A;&#x680F;&#x76EE;"; break;
   case "Following are the articles published under this section.": $tmp="&#x5982;&#x4E0B;&#x662F;&#x53D1;&#x5E03;&#x5728;&#x6B64;&#x533A;&#x7684;&#x6587;&#x7AE0;&#x3002;"; break;
   case "Return to Sections Index": $tmp="&#x8FD4;&#x56DE;&#x5230;&#x7CBE;&#x534E;&#x533A;&#x7D22;&#x5F15;"; break;
   case "total words in this text)": $tmp=" &#x6587;&#x672C;&#x5B57;&#x6570; )"; break;
   case "Back to": $tmp="&#x8FD4;&#x56DE;&#x5230;"; break;
   case "Sections Index": $tmp="&#x7CBE;&#x534E;&#x533A;&#x7D22;&#x5F15;"; break;
   case "Counter": $tmp="&#x8BA1;&#x6570;&#x5668;"; break;

   // NPDS 4.8 P3
   case "Submission in progress. After Uploading your files, please click on the OK button to finish.": $tmp="&#x63D0;&#x4EA4;&#x4E2D;&#x3002;&#x7B49;&#x6587;&#x4EF6;&#x4E0A;&#x4F20;&#x540E;&#xFF0C;&#x8BF7;&#x70B9;&#x51FB;ok&#x4EE5;&#x7ED3;&#x675F;&#x64CD;&#x4F5C;&#x3002;"; break;
   case "Join us ! As a registered user, cool stuff like : forum'subscribing, special forums (hidden, members ...), post and read status, ... are avaliable.": $tmp="&#x6CE8;&#x518C;&#x4E3A;&#x4F1A;&#x5458;&#xFF01;&#x60A8;&#x5C06;&#x53EF;&#x4EE5;&#x4F7F;&#x7528;&#x8BB8;&#x591A;&#x7279;&#x522B;&#x7684;&#x529F;&#x80FD;&#xFF1A;&#x6CE8;&#x518C;&#x670D;&#x52A1;&#xFF0C;&#x7279;&#x522B;&#x8BBA;&#x575B;&#xFF08;&#x9690;&#x85CF;&#x7B49;&#xFF09;&#xFF0C;&#x67E5;&#x770B;&#x5F20;&#x8D34;&#x548C;&#x6D4F;&#x89C8;&#x7684;&#x72B6;&#x51B5;&#x2026;"; break;
   case "Unsubscribe": $tmp="&#x53D6;&#x6D88;&#x6CE8;&#x518C;&#x670D;&#x52A1;"; break;
   // NPDS 4.8 P3

   // NPDS 4.8 P4
   case "Closed": $tmp="&#x5173;&#x95ED;"; break;
   case "Only Moderators can post new topics and replies in this forum.": $tmp="&#x53EA;&#x6709;&#x7248;&#x4E3B;&#x624D;&#x80FD;&#x5728;&#x672C;&#x8BBA;&#x575B;&#x4E2D;&#x5F20;&#x8D34;&#x65B0;&#x4E3B;&#x9898;&#x5E76;&#x56DE;&#x590D;"; break;
   case "Normal post": $tmp="&#x663E;&#x793A;&#x7684;&#x5F20;&#x8D34;&#xFF08;&#x4F4D;&#x7F6E;&#xFF09;"; break;
   case "Hidden post": $tmp="&#x9690;&#x85CF;&#x7684;&#x5F20;&#x8D34;&#xFF08;&#x4F4D;&#x7F6E;&#xFF09;"; break;
   case "User DNS: ": $tmp="&#x4F7F;&#x7528;&#x8005;&#x7684;DNS&#x5730;&#x5740; : "; break;
   case "Referer max count limit : Save your referer via Admin function.": $tmp="&#x5BF9;&#x6765;&#x8BBF;&#x7F51;&#x7AD9;&#x7684;&#x7EDF;&#x8BA1;&#x9650;&#x5236;&#x4E8E;&#x4EE5;&#x4E0B;&#x6570;&#x91CF;:  &#x8BF7;&#x6CE8;&#x610F;&#x4FDD;&#x5B58;&#x60A8;&#x7684;&#x76F8;&#x5173;&#x7EDF;&#x8BA1;&#x6570;&#x636E;&#x5230;&#x7BA1;&#x7406;&#x9875;&#x9762;."; break;
   case "You have a new message.": $tmp="&#x60A8;&#x6536;&#x5230;&#x4E00;&#x6761;&#x65B0;&#x6D88;&#x606F;"; break;
   case "Click here to read your new message.": $tmp="&#x70B9;&#x51FB;&#x8FD9;&#x91CC;&#x4EE5;&#x6D4F;&#x89C8;&#x60A8;&#x7684;&#x6D88;&#x606F;."; break;
   case "Send me an email when Internal Message arrive": $tmp="&#x901A;&#x8FC7;&#x7535;&#x5B50;&#x90AE;&#x4EF6;&#x901A;&#x77E5;&#x6211;&#x6709;&#x5185;&#x90E8;&#x6D88;&#x606F;&#x7684;&#x5230;&#x8FBE;"; break;
   case "Invisible' member": $tmp="&#x9690;&#x85CF;&#x4F1A;&#x5458;"; break;
   /**/case "not showed in memberlist, members' message bloc ...": $tmp="not showed in memberlist, members' message bloc ..."; break;
   case "Day": $tmp="&#x5929;"; break;
   case "Month": $tmp="&#x6708;"; break;
   case "Hour": $tmp="&#x5C0F;&#x65F6;"; break;
   case "Start Date for this New": $tmp="&#x5F00;&#x59CB;&#x516C;&#x5E03;&#x8BE5;&#x6D88;&#x606F;&#x7684;&#x65E5;&#x671F;"; break;
   case "End Date for this New": $tmp="&#x8BE5;&#x6D88;&#x606F;&#x7ED3;&#x675F;&#x7684;&#x65E5;&#x671F;"; break;
   case "Auto Delete the New at End Date": $tmp="&#x5728;&#x7ED3;&#x675F;&#x65E5;&#x81EA;&#x52A8;&#x5220;&#x9664;&#x8BE5;&#x6D88;&#x606F;"; break;
   case "Make this Topic the first one": $tmp="&#x5C06;&#x8BE5;&#x4E3B;&#x9898;&#x6392;&#x5217;&#x5728;&#x5148;"; break;
   case "We allow just one vote per poll.": $tmp="&#x6BCF;&#x4E2A;&#x8C03;&#x67E5;&#x53EA;&#x6709;&#x4E00;&#x6B21;&#x6295;&#x7968;&#x673A;&#x4F1A;"; break;
   // NPDS 4.8 P4

   // NPDS 5.0
   case "* for mandatory field": $tmp="* &#x6307;&#x5B9A;&#x5FC5;&#x8981;&#x533A;&#x57DF;"; break;
   case "Retype Password": $tmp="&#x91CD;&#x65B0;&#x8F93;&#x5165;&#x5BC6;&#x7801;"; break;
   case "Re-activate the standard'avatars": $tmp="&#x6062;&#x590D;&#x6807;&#x51C6;&#x5934;&#x50CF; "; break;
   case "the page": $tmp="&#x8BE5;&#x9875;"; break;
   // NPDS 5.0

   // NPDS 5.0 P1
   case "Bookmark": $tmp="&#x5730;&#x5740;&#x7C3F;"; break;
   case "Upload file after send accepted": $tmp="&#x5728;&#x53D1;&#x9001;&#x88AB;&#x63A5;&#x53D7;&#x540E;&#x4E0A;&#x4F20;&#x6587;&#x4EF6;"; break;
   case "Avatar": $tmp="&#x5934;&#x50CF;"; break;
   case "Files": $tmp="&#x6587;&#x4EF6;"; break;
   case "You can upload a file <b>carnet.txt</b> in your Mini-Web site.<br /><br />the data structure of any line :<br />&nbsp;&nbsp;<b>name_of_the_member;email;comments</b>"; $tmp="&#x60A8;&#x53EF;&#x4EE5;&#x5728;&#x60A8;&#x7684;&#x5C0F;&#x578B;&#x7F51;&#x7AD9;&#x4E2D;&#x4E0A;&#x4F20;&#x6587;&#x4EF6;<b>carnet.txt</b>&#x3002;<br /><br /> &#x8BE5;&#x6587;&#x4EF6;&#x7684;&#x884C;&#x683C;&#x5F0F;: <br />&nbsp;&nbsp;<b>&#x4F1A;&#x5458;&#x540D;;&#x7535;&#x5B50;&#x90AE;&#x4EF6;&#x5730;&#x5740;; &#x7B80;&#x8BC4;</b>"; break;
   case "Pages showed since"; $tmp="&#x9875;&#x9762;&#x8BBF;&#x95EE;&#x91CF;&#x81EA;&#x4ECE;"; break;
   case "Statistics"; $tmp="&#x884C;&#x7EDF;&#x8BA1;"; break;
   case "Top"; $tmp="&#x9875;&#x9762;&#x9876;&#x90E8;"; break;
   case "Mini-Web site"; $tmp="&#x5C0F;&#x578B;&#x7F51;&#x7AD9;"; break;
   case "Manage my Mini-Web site"; $tmp="&#x7BA1;&#x7406;&#x60A8;&#x7684;&#x5C0F;&#x578B;&#x7F51;&#x7AD9;"; break;
   case "Your account"; $tmp="&#x60A8;&#x7684;&#x5E10;&#x53F7;"; break;
   // NPDS 5.0 P1

   // NPDS 5.0 Runner
   case "Question": $tmp="&#x95EE;&#x9898;"; break;
   case "EDITO": $tmp="&#x7BA1;&#x7406;&#x5458;&#x8BC4;&#x8BBA;"; break;
   case "Top of the article": $tmp="&#x76FC;&#x607C;&#x788C;&#x94A0;&#x9E57;"; break;
   // NPDS 5.0 Runner

   // NPDS 5.0 Narval
   case "No category": $tmp="&#x6CA1;&#x6709;&#x76EE;&#x5F55;"; break;
   case "Select a language": $tmp="&#x9009;&#x62E9;&#x8BED;&#x8A00;(Select language)"; break;
   case "No language": $tmp="&#x6CA1;&#x6709;&#x8BED;&#x8A00;"; break;
   case "Login box": $tmp="&#x8FDE;&#x63A5;"; break;
   case "More smilies": $tmp="&#x66F4;&#x591A;&#x7684;&#x8868;&#x60C5;"; break;
   case "favourite": $tmp="&#x6536;&#x85CF;"; break;
   // NPDS 5.0 Narval

   // NPDS Sable
   case "All to develop": $tmp="&#x5F00;&#x53D1;&#x6240;&#x6709;"; break;
   case "All to gather": $tmp=" &#x91CD;&#x7EC4;&#x6240;&#x6709;"; break;
   case "Site map": $tmp="&#x7F51;&#x7AD9;&#x5730;&#x56FE;"; break;
   case "Archives": $tmp="&#x6863;&#x6848;&#x8D44;&#x6599;"; break;
   case "You must accept the terms of use of this website": $tmp=" &#x60A8;&#x5FC5;&#x987B;&#x63A5;&#x53D7;&#x672C;&#x7AD9;&#x7684;&#x7528;&#x6237;&#x4F7F;&#x7528;&#x6761;&#x6B3E;"; break;
   case "Solved": $tmp="&#x89E3;&#x51B3;"; break;
   case "Editor": $tmp="&#x51FA;&#x7248;&#x8005;"; break;
   case "Only": $tmp="&#x53EA;"; break;
   case "Without": $tmp="&#x65E0;"; break;
   case "or": $tmp="&#x6216;"; break;
   case "Your IP is recorded": $tmp="&#x60A8;&#x7684;IP&#x5730;&#x5740;&#x5DF2;&#x88AB;&#x767B;&#x8BB0;"; break;
   case "daydate": $tmp="%A %e %B %Y"; break; // meta-lang !date!
   case "Register to web site' mailing list" : $tmp="&#x5728;&#x7F51;&#x7AD9;&#x7684;&#x90AE;&#x4EF6;&#x5217;&#x8868;&#x4E2D;&#x6CE8;&#x518C;"; break;
   case "Update": $tmp="&#x66F4;&#x65B0;"; break;
   case "Theme(s)": $tmp=""; break;
   case "Status": $tmp=""; break;
   case "You may be interested in:": $tmp="&#x60A8;&#x53EF;&#x80FD;&#x5BF9;&#x6B64;&#x611F;&#x5174;&#x8DA3;&#xFF1A;"; break;
   case "Back to chapter:": $tmp="&#x8FD4;&#x56DE;&#x5230;&#x6B21;&#x76EE;&#x5F55;"; break;
   case "Other courses in chapter:": $tmp="&#x6B21;&#x76EE;&#x5F55;&#x4E2D;&#x7684;&#x5176;&#x4ED6;&#x53D1;&#x5E03;&#x7684;&#x4FE1;&#x606F;"; break;
   case "Back to console": $tmp="&#x8FD4;&#x56DE;&#x5230;&#x7BA1;&#x7406;"; break;
   case "in the sub-section": $tmp="&#x5728;&#x6B21;&#x76EE;&#x5F55;&#x4E2D;"; break;
   case "Search in Sections": $tmp="&#x5728;&#x76EE;&#x5F55;&#x4E2D;&#x67E5;&#x627E;"; break;
   // NPDS Sable

   // NPDS Dune
   case "Ok": $tmp="Ok"; break;
   case "Anti-Spam / Thank to reply to the question :": $tmp="Anti-Spam / Thank to reply to the question :"; break;
   case "Guest": $tmp="Guest"; break;
   case "Last articles": $tmp="Last articles"; break;

   // Phrases modifies :
   /**/case "Check a forum and click on button for receive an Email when a new submission is made in it.": $tmp="Check a forum and click on button for receive an Email when a new submission is made in it."; break;
   /**/case "Error": $tmp="Error"; break;
   // NPDS Dune

   // Fusion PP_translate
   case "Message to Member": $tmp = "&#x7ED9;&#x4F1A;&#x5458;&#x53D1;&#x9001;&#x7684;&#x6D88;&#x606F;"; break;
   case "person chatting right now.": $tmp = "&#x4EBA;&#x6B63;&#x5728;&#x804A;&#x5929;&#x5BA4;"; break;
   case "people chatting right now.": $tmp = "&#x4EBA;&#x6B63;&#x5728;&#x804A;&#x5929;&#x5BA4;"; break;
   case "You are logged in as": $tmp = "&#x60A8;&#x7684;&#x767B;&#x5F55;&#x5E10;&#x53F7; :"; break;
   case "click here to open the chat window...": $tmp = "&#x70B9;&#x51FB;&#x8FD9;&#x91CC;&#x6253;&#x5F00;&#x804A;&#x5929;&#x7A97;&#x53E3;"; break;
   case "Clear Chat DB": $tmp = "&#x6E05;&#x7A7A;&#x804A;&#x5929;&#x5BA4;"; break;
   case "Chat box": $tmp = "&#x804A;&#x5929;&#x5BA4;"; break;
   case "M2M box": $tmp = "M2M &#x5BA4;"; break;
   case "Forums infos": $tmp = "&#x8BBA;&#x575B;&#x4FE1;&#x606F;"; break;

   // WS
   /**/case "Groups setting.": $tmp = "Groups setting."; break;
   /**/case "Group blog.": $tmp = "Group blog."; break;
   /**/case "File manager": $tmp = "File manager"; break;
   /**/case "Group forum.": $tmp = "Group forum."; break;
   /**/case "forum": $tmp = "forum"; break;
   /**/case "Group file manager.": $tmp = "Group file manager."; break;
   /**/case "Group chat.": $tmp = "Group chat."; break;
   /**/case "Group members list.": $tmp = "Group members list."; break;
   /**/case "Members": $tmp = "Members"; break;
   /**/case "is connected !": $tmp = "is connected !"; break;
   /**/case "is not connected !": $tmp = "is not connected !"; break;
   /**/case "Visit the Mini Web Site !": $tmp = "Visit the Mini Web Site !"; break;
   /**/case "Co-writing": $tmp = "Co-writing"; break;
   /**/case "Hide list": $tmp = "Hide list"; break;
   /**/case "Show list": $tmp = "Show list"; break;
   /**/case "Multi-writers document": $tmp = "Multi-writers document"; break;
   /**/case "Open a chat for the group.": $tmp = "Open a chat for the groupe."; break;
   /**/case "Last editor": $tmp = "Last editor"; break;
   /**/case "for group": $tmp = "for group"; break;
   /**/case "Mailing list": $tmp = "Mailing list"; break;
   /**/case "Add to mailing list": $tmp = "Add to mailing list"; break;
   /**/case "Connection allowed": $tmp = "Connection allowed"; break;
   /**/case "Connection not allowed": $tmp = "Connection not allowed"; break;
   /**/case "0": $tmp="zero"; break;
   /**/case "1": $tmp="one"; break;
   /**/case "2": $tmp="twho"; break;
   /**/case "3": $tmp="three"; break;
   /**/case "4": $tmp="four"; break;
   /**/case "5": $tmp="five"; break;
   /**/case "6": $tmp="six"; break;
   /**/case "7": $tmp="seven"; break;
   /**/case "8": $tmp="eight"; break;
   /**/case "9": $tmp="nine"; break;
   /**/case "+": $tmp="plus"; break;
   /**/case "-": $tmp="minus"; break;
   /**/case "/": $tmp="divided by"; break;
   /**/case "*": $tmp="multiplied by"; break;
   /**/case "Ban this @IP": $tmp="Ban this @IP"; break;
   // WS

   default: $tmp = "&#x9700;&#x8981;&#x7FFB;&#x8BD1;&#x7A3F; <b>[** $phrase **]</b>"; break;
 }
 return $tmp;
}
?>