<?php
/************************************************************************/
/* NPDS : Nuke Permanent Double-Side Web Portal System                  */
/* ===========================                                          */
/*                                                                      */
/* Original Copyright (c) 2001 by Francisco Burzi (fburzi@ncc.org.ve)   */
/* http://phpnuke.org                                                   */
/*                                                                      */
/* This version name NPDS Copyright (c) 2001 by Philippe Brunier        */
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/
/************************************************************************/
/* NPDS: SuperCache Addon                                               */
/* ========================================                             */
/*  Archivo: cache.class.php                                            */
/*  Autor: Francisco Echarte [patxi@eslomas.com]                        */
/*  Fecha: 2001-08-23                                                   */
/*  Version: 0.2                                                        */
/*                                                                      */
/* Intgration dans NPDS                                                */
/* Philippe Brunier                                                     */
/* Best include in NPDS  (Nuke Permanent Double Side Web Portal System) */
/*                                                                      */
/************************************************************************/

include_once('cache.config.php');
include_once('cache.timings.php');
global $LOCK_EX, $LOCK_UN;
$LOCK_EX=2;
$LOCK_UN=3;

class cacheManager{

   var $request_uri; //Para guardar solicitdud del usuario
   var $query_string; //Para guardar la query solicitada
   var $php_self; //Para guardar pgina solicitada
   var $gzip_supported; //Para indicar si en la peticin, el navegador del
                        //usuario soporta informacin en formato gzip

   var $genereting_output; //Para indicar cuando se est generando output para
                           //guardar en cache

   /*---------------------------------------------------------------------------
     Entrada:
     Salida :
     Efecto : Construtcr de la clase, inicializa las variables. Ejecuta la autolimpieza
              con cierta probabilidad, si la opcin est activada
     ---------------------------------------------------------------------------*/
   function cacheManager(){
      global $CACHE_CONFIG;

      $this->gzip_supported = 0;
      $this->genereting_output = 0;
      $this->request_uri = $GLOBALS[REQUEST_URI];
      $this->query_string = $GLOBALS[QUERY_STRING];
      $this->php_self = basename($GLOBALS[PHP_SELF]);

      $CACHE_CONFIG['run_cleanup'] == 1? $this->cacheCleanup() : NULL;

      // Miro si el navegador del usuario permite envo de informacin comprimida
      if(strpos(" ".$GLOBALS[HTTP_ACCEPT_ENCODING],'gzip') != 0)
         $this->gzip_supported = 1;
      else
         $this->gzip_supported = 0;
   }

   /*---------------------------------------------------------------------------
     Entrada:
     Salida : Si la pgina existe en cache, devuelve el contenido y finaliza el script.
     Efecto : Si la pgina solicitada por el usuario est entre las que hay
              que cachear, comprueba si hay una copia disponible y la enva,
              finalizndose la ejecucin. Si no hay una copia disponible, se
              inicializa el output buffer, para poder luego capturar la salida
              generada por el script.
     ---------------------------------------------------------------------------*/
   function startCachingPage(){
      global $CACHE_TIMINGS, $CACHE_CONFIG, $CACHE_QUERYS;


      if($CACHE_TIMINGS[$this->php_self] > 0
             && ($this->query_string == ''
                     || ereg($CACHE_QUERYS[$this->php_self], $this->query_string)) ){

         // Est la pgina cacheada ?
         list($cached_page,$gzip) = $this->checkCache($this->request_uri,$CACHE_TIMINGS[$this->php_self]);

         if($cached_page != ''){
            // Compressed?
            if($CACHE_CONFIG['return_compressed'] == 1 AND $gzip== 1){
               header ("Content-Encoding: gzip");
            }
            echo $cached_page;
            global $npds_sc;
            $npds_sc=true;
            $this->logVisit($this->request_uri, 'HIT', $gzip);
            // P. Brunier - Add For return used cache classe in html stream
            if($CACHE_CONFIG['exit'] == 1) { exit; }
         }
         else{
            ob_start();
            $this->genereting_output = 1;
            $this->logVisit($this->request_uri, 'MISS', $gzip);
         }
      }
      else {
         $this->logVisit($this->request_uri, 'EXCL', $gzip);
         // P. Brunier - Add For return that the demand is exclude
         $this->genereting_output = -1;
      }
   }

   /*---------------------------------------------------------------------------
     Entrada:
     Salida :
     Efecto : Si la pgina solicitada por el usuario est entre las que hay
              que cachear, comprueba si hay una copia disponible y la enva,
              finalizndose la ejecucin. Si no hay una copia disponible, se
              inicializa el output buffer, para poder luego capturar la salida
              generada por el script.
     ---------------------------------------------------------------------------*/
   function endCachingPage(){
      global $CACHE_CONFIG;

      if($this->genereting_output == 1){

         $output = ob_get_contents();
         ob_end_clean();

         $this->insertIntoCache($output, $this->request_uri);

      }
   }

   /*----------------------------------------------------------------------
     Entrada: $request => indica la pgina (uri) o bloque que se quiere comprobar
              $refresh => indica el tiempo de permanencia en cache de la solicitud
              $compressed => indica si se prefiere salida comprimida. Si la
                             solicitud es para un bloque debe ser false!!!
     Salida : Si se consigue obtener (HIT) la solicitud de cache, se devuelve
             un array con el contenido y true o false indicando si
             est comprimido o no. Si no se puede realizar la solicitud (MISS)
             se devuelve un array con FALSE y false como comprimido
    Efecto : a partir de la solicitud y compressed, con md5 se crea el nombre de
             que tendra en cache. Si el archivo existe se compara su fecha con el
             tiempo de permanencia. En el caso de que se solicite comprimido
             y este no exista, se intenta obtener la versin sin comprimir.
    ----------------------------------------------------------------------*/
   function checkCache($request,$refresh,$compressed = '-1'){
      global $CACHE_CONFIG;
      global $user;
      if(isset($user)) {
         $cookie = explode(":", base64_decode($user));
      }

      $filename = $CACHE_CONFIG['data_dir'].$cookie[1].md5($request);

      if($compressed == '-1') $compressed = $this->gzip_supported;

      if($CACHE_CONFIG['return_compressed'] == 1 && $compressed == 1)
         $filename .= ".gz";

      if(file_exists($filename)){
         if(filemtime($filename) > time()-$refresh){
            $data = fread($fp = fopen($filename, 'r'), filesize($filename));
            fclose($fp);
            return array($data,$compressed);
         }
         else
            return array(0,1);
      } else if($compressed == 1) {
         $this->checkCache($request,$refresh,0);
      } else {
         return array(0,0);
      }
   }

   /*----------------------------------------------------------------------
     Entrada: $content => el contenido
           $request => la solicitud
     Salida : se imprime el contenido que se ha metido en cache
     Efecto : se crea un archivo en el filesystem en base al nombre de la solicitud
           codificndolo con md5. Adems si est habilitada la opcin de
           guardar comprimido, se guarda el mismo archivo con extensin gz. Esto
           se puede realizar exista o no la funcin gzcompress, utilizando una
           llamada al shell para gzip.
    ----------------------------------------------------------------------*/
   function insertIntoCache($content, $request){
      global $CACHE_CONFIG, $LOCK_EX, $LOCK_UN;
      global $user;
      if(isset($user)) {
         $cookie = explode(":", base64_decode($user));
      }

      $content .= "\n<!-- CACHED : ".date('Y/m/d : H:m:s')." by NPDS-SuperCache -->\n";
      $nombre = $CACHE_CONFIG['data_dir'].$cookie[1].md5($request);

      if($fp = fopen($nombre, 'w')){
         flock($fp, $LOCK_EX);
         fwrite($fp,$content);
         flock($fp, $LOCK_UN);
         fclose($fp);

         if($CACHE_CONFIG['compress_output'] == 1){

            if(function_exists('gzcompress')){
               $gzcontent =  "\x1f\x8b\x08\x00\x00\x00\x00\x00";
               $Size = strlen($content);
               $Crc = crc32($content);
               $aux = gzcompress($content,$level);
               $gzcontent .= substr($aux, 0, strlen($aux) - 4);
               $gzcontent .= pack('V',$Crc);
               $gzcontent .= pack('V',$Size);

               $fp = fopen("$nombre.gz",'w');
               flock($fp, $LOCK_EX);
               fwrite($fp,$gzcontent);
               flock($fp, $LOCK_UN);
               fclose($fp);
            }
            else{
               exec("cp $nombre $nombre.bak;gzip $nombre.bak;mv $nombre.bak.gz $nombre.gz");
            }
         }

      }
      echo $content;
      global $npds_sc;
      $npds_sc=false;
   }

    /*----------------------------------------------------------------------
      Entrada: $request => indica la solicitud realizada
           $type => el resultado de la solicitud (HIT, MISS, EXCL)
           $compressed => si se ha devuelto el resultado comprimido o no
      Salida : nada
      Efecto : aade una lnea al log, si la opcin esta activa.
      ----------------------------------------------------------------------*/
   function logVisit($request, $type, $compressed){
      global $CACHE_CONFIG, $LOCK_EX, $LOCK_UN;

      if(!$CACHE_CONFIG['save_stats']) return;

          if($compressed == 1) $compressed = 'true';
          else $compressed = 'false';

      $logfile = $CACHE_CONFIG['data_dir'].'stats.log';
      $fp = fopen($logfile, 'a');
      flock($fp, $LOCK_EX);
      fseek($fp, filesize($logfile));
          $salida = sprintf("%-10s %-74s %-4s %-5s\r\n",time(),$request,$type,$compressed);
          fwrite($fp, $salida);
      flock($fp, $LOCK_UN);
      fclose($fp);
   }

   /*----------------------------------------------------------------------
     Entrada: nada
     Salida : nada
     Efecto : elimina los archivos del filesystem correspondientes a cachings viejos
     ----------------------------------------------------------------------*/
   function cacheCleanup(){
      global $CACHE_CONFIG;

      srand((double)microtime()*1000000);
      $num = rand(1,100);
      if($num <= $CACHE_CONFIG['cleanup_freq']){
         $dh = opendir($CACHE_CONFIG['data_dir']);
         while($filename = readdir($dh)){
            if($filename === '.' OR $filename === '..') continue;
            if(filemtime($CACHE_CONFIG['data_dir'].$filename) < time() - $CACHE_CONFIG['max_age'])
               unlink($CACHE_CONFIG['data_dir'].$filename);
         }
      }
   }

   /*----------------------------------------------------------------------
     P.BR / NPDS - Elimine les pages de cache relative  un user particulier
     ----------------------------------------------------------------------*/
   function UsercacheCleanup(){
      global $CACHE_CONFIG;
      global $user;
      if(isset($user)) {
         $cookie = explode(":", base64_decode($user));
      }

      $dh = opendir($CACHE_CONFIG['data_dir']);
      while($filename = readdir($dh)){
         if ($filename === '.' OR $filename === '..') continue;
            // Le fichier appartient-il  l'utilisateur connect ?
            if (substr($filename,0,strlen($cookie[1]))==$cookie[1]) {
               // Le calcul md5 fournit une chaine de 32 chars donc si ce n'est pas 32 c'est que c'est un homonyme ...
               if (strlen(substr($filename,strlen($cookie[1])))==32) {
                  unlink($CACHE_CONFIG['data_dir'].$filename);
               }
            }
      }
   }

}
?>