<?
################################################################################################
// Simple Form generator  SFORM / version 0.97
// Classe to manage several Form in a single database(MySql) in XML Format
// P.Brunier 2001 and 2002
//
// This program is free software. You can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License.
//
// Based on Form_Handler 19-4-01 Copyright Drs. Jelte 'YeeHaW' Werkhoven
################################################################################################
// Constante
   define('CRLF', "\n", TRUE);
   if (!$bgcolor1) {
      $bgcolor1="#AAcccc";
   }
   if (!$bgcolor2) {
      $bgcolor2="#FFFFFF";
   }
   if (!$sform_path) {
      $sform_path="";
   }
################################################################################################
class form_handler {
  var $form_fields=array();// form fields
  var $title;// form title
  var $mess; // obligatoire message
  var $form_title; // form title
  var $form_method; // form method (Post or Get)
  var $form_key; // form key (for mysql stockage)
  var $form_key_value; // value of the form key (for mysql stockage)
  var $form_key_status="open"; // Status of the key (open or close)
  var $submit_value=""; // the name off all submit buttons of the form
  var $form_password_access=""; // Protect the data with a password
  var $answer=""; // answer table
  var $form_check="true"; // sring which will be inserted into javascript check function
  var $url; // path at 'action' option of form

  /**************************************************************************************/
  // Interrogate the object for identify the position of an item
  // public void
  function interro_fields($ibid) {
    $number="no";
    for(Reset($this->form_fields),$node=0;$node<count($this->form_fields);Next($this->form_fields),$node++) {
       if ($ibid==$this->form_fields[$node]['name']) {
          $number=$node;
          break;
       }
    }
    return ($number);
  }

  function interro_array($ibid0,$ibid1) {
    $number="no";
    while(list($key,$val)=each($ibid0) ){
       if ($ibid1==$val['en']) {
          $number=$key;
          break;
       }
    }
    return ($number);
  }

  /**************************************************************************************/
  // add title of <form> / This is also the id_form field in the database (unique)
  // public void
  function add_form_title($en) {
    $this->form_title=$en;
  }

  /**************************************************************************************/
  // add method of <form action=> Get or Post
  // public void
  function add_form_method($en) {
    $this->form_method=$en;
  }

  /**************************************************************************************/
  // add form check after submit for obligatory fields
  // public void
  function add_form_check($en) {
    $this->form_check=$en;
  }

  /**************************************************************************************/
  // add the return url after action
  // public void
  function add_url($en) {
    $this->url=$en;
  }

  /**************************************************************************************/
  // designate a specfific field off the form as key in the DB
  // public void
  function add_key($en) {
    $this->form_key=$en;
  }

  /**************************************************************************************/
  // add the name for all submit buttons of <form>
  // public void
  function add_submit_value($en) {
    $this->submit_value=$en;
  }

  /**************************************************************************************/
  // Lock the Key of <form> for disable edit
  // public void
  function key_lock($en) {
     if ($en=="open") {
        $this->form_key_status="open";
     } else {
        $this->form_key_status="close";
     }
  }

  /**************************************************************************************/
  // add mess
  // public void
  function add_mess($en) {
    $this->mess=$en;
  }

  /**************************************************************************************/
  // add fields text,hidden,textarea,password,submit,reset
  // public void
  function add_field($name,$en, $value='', $type='text', $obligation=false, $size='50', $diviseur='5', $ctrl='') {
    if ($type=="submit") {$name=$this->submit_value;}
    $this->form_fields[count($this->form_fields)]=array(
      'name'=>$name,
      'type'=>$type,
      'en'=>$en,
      'value'=>$value,
      'size'=>$size,
      'diviseur'=>$diviseur,
      'obligation'=>$obligation,
      'ctrl'=>$ctrl
    );
  }

  /**************************************************************************************/
  // add field checkbox
  // public void
  function add_checkbox($name, $en, $value='', $obligation=false, $checked=false) {
    $this->form_fields[count($this->form_fields)]=array(
      'name'=>$name,
      'en'=>$en,
      'value'=>$value,
      'type'=>"checkbox",
      'checked'=>$checked,
      'obligation'=>$obligation
    );
  }

  /**************************************************************************************/
  // add field select
  // public void
  function add_select($name, $en, $values, $obligation=false, $size=1, $multiple=false) {
    $this->form_fields[count($this->form_fields)]=array(
      'name'=>$name,
      'en'=>$en,
      'type'=>"select",
      'value'=>$values,
      'size'=>$size,
      'multiple'=>$multiple,
      'obligation'=>$obligation
    );
  }

  /**************************************************************************************/
  // add field radio
  // public void
  function add_radio($name, $en, $values, $obligation=false) {
    $this->form_fields[count($this->form_fields)]=array(
      'name'=>$name,
      'en'=>$en,
      'type'=>"radio",
      'value'=>$values,
      'obligation'=>$obligation
    );
  }

  /**************************************************************************************/
  // add title of the HTML tab
  // public void
  function add_title($en) {
    $this->title=$en;
  }

  /**************************************************************************************/
  // add comment into HTML tab
  // public void
  function add_comment($en) {
    $this->form_fields[count($this->form_fields)]=array(
      'en'=>$en,
      'type'=>"comment"
    );
  }

  /**************************************************************************************/
  // add extra into HTML tab (link html tags ...)
  // public void
  function add_extra($en) {
    $this->form_fields[count($this->form_fields)]=array(
      'en'=>$en,
      'type'=>"extra"
    );
  }

  /**************************************************************************************/
  // print <form> into html output Form
  // public string
  function print_form($bg) {
    global $bgcolor1, $bgcolor2, $sform_path;
    if ($this->form_method=="") {$this->form_method="post";}
    $str ="<LINK rel=\"StyleSheet\" HREF=\"".$sform_path."sform.css\" TYPE=\"text/css\">";
    $str.="<form action='".$this->url."' method='".$this->form_method."' name='".$this->form_title."' enctype='multipart/form-data'";
    if ($this->form_check=="true") {
        $str.="onsubmit='return check();'>";
    } else {
        $str.=">";
    }
    $str.="<table width=100% border=0 cellspacing=1 cellpadding=1 bgcolor=".$bgcolor1."><tr><td>";
    $str.="<table width=100% border=0 cellspacing=1 cellpadding=2 bgcolor=".$bgcolor2.">";
    $str.="<tr bgcolor=".$bgcolor1."><td width=40% align=center><b>".$this->title."</b></td><td align=center><font size=1>".$this->mess."</font></td></tr>";
    $str.="<tr><td width=40%></td><td></td></tr>";

    for($i=0;$i<count($this->form_fields);$i++){
      switch($this->form_fields[$i]['type']){
        case 'text':
          $str.="<tr bgcolor=$bg><td>".$this->form_fields[$i]['en'];

          if($this->form_fields[$i]['obligation']){
            $this->form_check.=" && (f.elements['".$this->form_fields[$i]['name']."'].value!='')";
            $str.="&nbsp;<font color=red>*</font></td><td>";
          }else $str.="</td><td>";

          // Charge la valeur et analyse la clef
          if ($this->form_fields[$i]['name']==$this->form_key) {
             $this->form_key_value=$this->form_fields[$i]['value'];
             if ($this->form_key_status=="close") {
                $str.="<input type=hidden name='".$this->form_fields[$i]['name']."' value='".$this->form_fields[$i]['value']."' size=".($this->form_fields[$i]['size']+1)." maxlength=".$this->form_fields[$i]['size'].">";
                $str.="<b>".$this->form_fields[$i]['value']."</b>";
             } else {
                $str.="<input type=".$this->form_fields[$i]['type']." name='".$this->form_fields[$i]['name']."' value='".$this->form_fields[$i]['value']."' size=".($this->form_fields[$i]['size']+1)." maxlength=".$this->form_fields[$i]['size'].">";
             }
          } else {
             $str.="<input type=".$this->form_fields[$i]['type']." name='".$this->form_fields[$i]['name']."' value='".$this->form_fields[$i]['value']."' size=".($this->form_fields[$i]['size']+1)." maxlength=".$this->form_fields[$i]['size'].">";
          }
          $str.="</td></tr>";
          break;

        case 'password-access':
          $this->form_fields[$i]['value']=$this->form_password_access;
        case 'password':
          $str.="<tr bgcolor=$bg><td>".$this->form_fields[$i]['en'];

          if($this->form_fields[$i]['obligation']){
            $this->form_check.=" && (f.elements['".$this->form_fields[$i]['name']."'].value!='')";
            $str.="&nbsp;<font color=red>*</font></td><td>";
          }else $str.="</td><td>";

          $str.="<input type=".$this->form_fields[$i]['type']." name='".$this->form_fields[$i]['name']."' value='".$this->form_fields[$i]['value']."' size=".($this->form_fields[$i]['size']+1)." maxlength=".$this->form_fields[$i]['size'].">";
          $str.="</td></tr>";
          break;

        case 'checkbox':
          $str.="<tr bgcolor=$bg><td>".$this->form_fields[$i]['en'];
          $str.=($this->form_fields[$i]['obligation'])? "&nbsp;*</td><td>" : "</td><td>";
          $str.="<input type=checkbox name='".$this->form_fields[$i]['name']."'";
          $str.=($this->form_fields[$i]['checked'])? " checked>" : ">";
          $str.="</td></tr>";
          break;

        case 'textarea':
          $str.="<tr bgcolor=$bg><td>".$this->form_fields[$i]['en'];
          if($this->form_fields[$i]['obligation']){
            $this->form_check.=" && (f.elements['".$this->form_fields[$i]['name']."'].value!='')";
            $str.="&nbsp;<font color=red>*</font></td><td>";
          }else $str.="</td><td>";
          $txt_row=$this->form_fields[$i]['diviseur'];
          $txt_col=( ($this->form_fields[$i]['size'] - ($this->form_fields[$i]['size'] % $txt_row)) / $txt_row);
          $str.="<textarea name='".$this->form_fields[$i]['name']."' cols=$txt_col rows=$txt_row>".$this->form_fields[$i]['value']."</textarea>";
          $str.="</td></tr>";
          break;

        case 'hidden':
          $str.="<input type=hidden name='".$this->form_fields[$i]['name']."' value='".$this->form_fields[$i]['value']."'>";
          break;

        case 'select':
          $str.="<tr bgcolor=$bg><td>".$this->form_fields[$i]['en'];
          $str.="</td><td>";
          $str.="<select name='".$this->form_fields[$i]['name'];
          $str.=($this->form_fields[$i]['multiple'])? "[]' multiple" : "'";
          $str.=($this->form_fields[$i]['size'] > 1)? " size=".$this->form_fields[$i]['size'].">" : ">";
          while(list($key,$val)=each($this->form_fields[$i]['value']) ){
            $str.="<option value='".$key."'";
            $str.=($val['selected'])? " selected>" : ">";
            $str.=$val['en']."</option>";
          }
          $str.="</select>";
          $str.="</td></tr>";
          break;

        case 'radio':
          $str.="<tr bgcolor=$bg><td>".$this->form_fields[$i]['en'];
          $str.="</td><td>";
          while(list($key,$val)=each($this->form_fields[$i]['value']) ){
            $str.="<input type=radio name='".$this->form_fields[$i]['name']."' value='".$key."'";
            $str.=($val['checked'])? " checked>&nbsp;" : ">&nbsp;";
            $str.=$val['en']."<br>";
          }
          $str.="</td></tr>";
          break;

        case 'comment':
          $str.="<tr bgcolor=$bg><td colspan=2>";
          $str.=$this->form_fields[$i]['en'];
          $str.="</td></tr>";
          break;

        case 'extra':
          $str.=$this->form_fields[$i]['en'];
          break;

        case 'submit':
          $str.=$this->form_fields[$i][$this->lang];
          $str.="<input type=submit name='".$this->form_fields[$i]['name']."' value='".$this->form_fields[$i]['value']."'>";
          break;

        case 'reset':
          $str.=$this->form_fields[$i]['en'];
          $str.="<input type=reset name='".$this->form_fields[$i]['name']."' value='".$this->form_fields[$i]['value']."'>";
          break;

        default:
          break;
      }
    }
    $str.="</table>";
    $str.="</td></tr></table>";
    $str.="</form>";
    if($this->form_check!="false"){
      $str.="<script>".CRLF;
      $str.="var f=document.forms['".$this->form_title."'];".CRLF;
      $str.="function check(){".CRLF;
      $str.=" if(".$this->form_check."){".CRLF;
      $str.="   f.submit();".CRLF;
      $str.="   return true;".CRLF;
      $str.=" } else {".CRLF;
      $str.="   alert('".$this->mess."');".CRLF;
      $str.="   return false;".CRLF;
      $str.="}}".CRLF;
      $str.="</script>";
    }
    return $str;
  }

  /**************************************************************************************/
  // make the anwer array
  // private string
  function make_response(){

    for($i=0;$i<count($this->form_fields);$i++) {
      switch($this->form_fields[$i]['type']){
        case 'text':
          // Charge la valeur de la clef
          if ($this->form_fields[$i]['name']==$this->form_key) {
             $this->form_key_value=$GLOBALS[$this->form_fields[$i]['name']];
          }
        case 'password':
          if ($this->form_fields[$i]['ctrl']!="") {
             $this->control($this->form_fields[$i]['name'],$this->form_fields[$i]['en'],$GLOBALS[$this->form_fields[$i]['name']],$this->form_fields[$i]['ctrl']);
          }
          $this->answer[$i].="<TEXT>\n";
          $this->answer[$i].="<".$this->form_fields[$i]['name'].">".$GLOBALS[$this->form_fields[$i]['name']]."</".$this->form_fields[$i]['name'].">\n";
          $this->answer[$i].="</TEXT>";
          break;

        case 'password-access':
          if ($this->form_fields[$i]['ctrl']!="") {
             $this->control($this->form_fields[$i]['name'],$this->form_fields[$i]['en'],$GLOBALS[$this->form_fields[$i]['name']],$this->form_fields[$i]['ctrl']);
          }
          $this->form_password_access=$GLOBALS[$this->form_fields[$i]['name']];
          break;

        case 'textarea':
          $this->answer[$i].="<TEXT>\n";
          $this->answer[$i].="<".$this->form_fields[$i]['name'].">".htmlspecialchars(str_replace(chr(13).chr(10),"<br />",$GLOBALS[$this->form_fields[$i]['name']]))."</".$this->form_fields[$i]['name'].">\n";
          $this->answer[$i].="</TEXT>";
          break;

        case 'select':
          $this->answer[$i].="<SELECT>\n";
          if( is_array($GLOBALS[$this->form_fields[$i]['name']]) ){
            for($j=0;$j<count($GLOBALS[$this->form_fields[$i]['name']]);$j++){
              $this->answer[$i].="<".$this->form_fields[$i]['name'].">".$this->form_fields[$i]['value'][ $GLOBALS[$this->form_fields[$i]['name']][$j] ]['en']."</".$this->form_fields[$i]['name'].">\n";
            }
          }else{
            $this->answer[$i].="<".$this->form_fields[$i]['name'].">".$this->form_fields[$i]['value'][ $GLOBALS[$this->form_fields[$i]['name']] ]['en']."</".$this->form_fields[$i]['name'].">";
          }
          $this->answer[$i].="</SELECT>";
          break;

        case 'radio':
          $this->answer[$i].="<RADIO>\n";
          $this->answer[$i].="<".$this->form_fields[$i]['name'].">".$this->form_fields[$i]['value'][ $GLOBALS[$this->form_fields[$i]['name']] ]['en']."</".$this->form_fields[$i]['name'].">\n";
          $this->answer[$i].="</RADIO>";
          break;

        case 'checkbox':
          $this->answer[$i].="<CHECK>\n";
          if($GLOBALS[$this->form_fields[$i]['name']]=="on"){
            $this->answer[$i].="<".$this->form_fields[$i]['name'].">".$this->form_fields[$i]['value']."</".$this->form_fields[$i]['name'].">\n";
          } else {
            $this->answer[$i].="<".$this->form_fields[$i]['name']."></".$this->form_fields[$i]['name'].">\n";
          }
          $this->answer[$i].="</CHECK>";
          break;

        case 'hidden':
        case 'submit':
        case 'reset':
        default:
          $this->answer[$i].="no_reg";
          break;
      }
    }
  }

  /**************************************************************************************/
  // Read Data structure and build a plain-text response
  function write_sform_data($response) {
   $content = "<CONTENTS>\n";
   for(Reset($response),$node=0;$node<count($response);Next($response),$node++) {
      if ($response[$node]!="no_reg") {
        $content.=$response[$node]."\n";
      }
   }
   $content .= "</CONTENTS>";
   return ($content);
  }

  /**************************************************************************************/
  // Read Data structure and build the Internal Data Structure
  function read_load_sform_data($line,$op) {
   if ((!stristr($line,"<CONTENTS>")) and (!stristr($line,"</CONTENTS>"))) {
      // Premier tag
      $nom=substr($line,1,strpos($line,">")-1);
      // jusqu'a </xxx
      $valeur=substr($line,strpos($line,">")+1,(strpos($line,"<",1)-strlen($nom)-2));
      if ($valeur=="" and $op!="CHECK_S") {$op=$nom;}
      switch($op) {
         case "TEXT":
            $op="TEXT_S";
            break;
         case "TEXT_S":
            $num=$this->interro_fields($nom);
            if ($num!="no" or $num=="0") {
               $valeur=str_replace(htmlspecialchars("<br />"), chr(13).chr(10), $valeur);
               $this->form_fields[$num]['value']=$valeur;
            }
            break;
         case "/TEXT":
            break;

         case "SELECT":
            $op="SELECT_S";
            break;
         case "SELECT_S":
            $num=$this->interro_fields($nom);
            if ($num!="no" or $num=="0") {
               $tmp=$this->interro_array($this->form_fields[$this->interro_fields($nom)]['value'],$valeur);
               $this->form_fields[$this->interro_fields($nom)]['value'][$tmp]['selected']=true;
            }
            break;
         case "/SELECT":
            break;

         case "RADIO":
            $op="RADIO_S";
            break;
         case "RADIO_S":
            $num=$this->interro_fields($nom);
            if ($num!="no" or $num=="0") {
               $tmp=$this->interro_array($this->form_fields[$this->interro_fields($nom)]['value'],$valeur);
               $this->form_fields[$this->interro_fields($nom)]['value'][$tmp]['checked']=true;
            }
            break;
         case "/RADIO":
            break;

         case "CHECK":
            $op="CHECK_S";
            break;
         case "CHECK_S":
            $num=$this->interro_fields($nom);
            if ($num!="no" or $num=="0") {
               if ($valeur) {$valeur=true;}else{$valeur=false;}
               $this->form_fields[$this->interro_fields($nom)]['checked']=$valeur;
            }
            break;
         case "/CHECK":
            break;

         default:
            break;
      }
   }
   return ($op);
  }

  /**************************************************************************************/
  // print html response
  // $bg      => Background color for TD
  // $retour  => Comment for the link at the end of the page OR ="not_echo" for not 'echo' the reply but return in a string !
  // $action  => url to go
  function aff_response($bg,$retour="",$action="") {
    global $bgcolor1, $bgcolor2, $sform_path;
    $str.="<LINK rel=\"StyleSheet\" HREF=\"".$sform_path."sform.css\" TYPE=\"text/css\">";
    $str.="<table width=100% border=0 cellspacing=1 cellpadding=1 bgcolor=".$bgcolor1."><tr><td>";
    $str.="<table width=100% border=0 cellspacing=1 cellpadding=2 bgcolor=".$bgcolor2.">";
    $str.="<tr bgcolor=".$bgcolor1."><td width=40% align=center><b>".$this->title."</b></td><td></td></tr>";

    for($i=0;$i<count($this->form_fields);$i++){
      switch($this->form_fields[$i]['type']){
        case 'text':
          $str.="<tr bgcolor=$bg><td>".$this->form_fields[$i]['en'];
          $str.="</td><td>";
          $str.="<b>".$GLOBALS[$this->form_fields[$i]['name']]."&nbsp;</b>";
          $str.="</td></tr>";
          break;

        case 'password':
          $str.="<tr bgcolor=$bg><td>".$this->form_fields[$i]['en'];
          $str.="</td><td>";
          $str.="<b>".str_repeat("*", strlen($GLOBALS[$this->form_fields[$i]['name']]))."&nbsp;</b>";
          $str.="</td></tr>";
          break;

        case 'checkbox':
          $str.="<tr bgcolor=$bg><td>".$this->form_fields[$i]['en'];
          $str.="</td><td>";
          if($GLOBALS[$this->form_fields[$i]['name']]=="on"){
            $str.="<b>".$this->form_fields[$i]['value']."&nbsp;</b>";
          } else {
            $str.= "";
          }
          $str.="</td></tr>";
          break;

        case 'textarea':
          $str.="<tr bgcolor=$bg><td>".$this->form_fields[$i]['en'];
          $str.="</td><td>";
          $str.="<b>".str_replace(chr(13).chr(10),"<br />",$GLOBALS[$this->form_fields[$i]['name']])."&nbsp;</b>";
          $str.="</td></tr>";
          break;

        case 'select':
          $str.="<tr bgcolor=$bg><td>".$this->form_fields[$i]['en'];
          $str.="</td><td>";
          if( is_array($GLOBALS[$this->form_fields[$i]['name']]) ){
            for($j=0;$j<count($GLOBALS[$this->form_fields[$i]['name']]);$j++){
              $str.="<b>".$this->form_fields[$i]['value'][ $GLOBALS[$this->form_fields[$i]['name']][$j] ]['en']."&nbsp;</b><br>";
            }
          }else{
            $str.="<b>".$this->form_fields[$i]['value'][ $GLOBALS[$this->form_fields[$i]['name']] ]['en']."&nbsp;</b>";
          }
          $str.="</td></tr>";
          break;

        case 'radio':
          $str.="<tr bgcolor=$bg><td>".$this->form_fields[$i]['en'];
          $str.="</td><td>";
          $str.="<b>".$this->form_fields[$i]['value'][ $GLOBALS[$this->form_fields[$i]['name']] ]['en']."&nbsp;</b>";
          $str.="</td></tr>";
          break;

        case 'comment':
          $str.="<tr bgcolor=$bg><td colspan=2>";
          $str.=$this->form_fields[$i]['en'];
          $str.="</td></tr>";
          break;

        case 'extra':
          $str.=$this->form_fields[$i]['en'];
          break;

        default:
          break;
      }
    }
    if (($retour!="") and ($retour!="not_echo")) {
       $str.="<tr bgcolor=$bg><td colspan=2 align=center><a href=\"$action\">[ $retour ]</a></td></tr>";
    }
    $str.="</table>";
    $str.="</td></tr></table>";

    if ($retour!="not_echo") {
       echo $str;
    } else {
       return $str;
    }
  }

  /**************************************************************************************/
  // Control the respect off Data Type
  function control($name,$nom, $valeur, $controle) {

    $i=$this->interro_fields($name);
    if (($this->form_fields[$i]['obligation']!=true) and ($valeur=="")) {
       $controle="";
    }

     switch ($controle) {
        case 'a-9':
          if (preg_match_all("/([^a-zA-Z0-9 ])/i", $valeur,$trouve)) {
             $this->error($nom, implode(" ",$trouve[0]));
             exit ();
          }
          break;
        case 'A-9':
          if (preg_match_all("/([^A-Z0-9 ])/i", $valeur,$trouve)) {
             $this->error($nom, implode(" ",$trouve[0]));
             exit ();
          }
          break;

        case 'email':
          $valeur = strtolower($valeur);
          if (preg_match_all("/([^a-z0-9_@.-])/i", $valeur, $trouve)) {
             $this->error($nom, implode(" ",$trouve[0]));
             exit();
          }
          if (!preg_match("/^([a-z0-9_]|\\-|\\.)+@(([a-z0-9_]|\\-)+\\.)+[a-z]{2,4}\$/i", $valeur)) {
             $this->error($nom, "Format email invalide");
             exit ();
          }
          break;

        case '0-9':
          if (preg_match_all("/([^0-9])/i", $valeur,$trouve)) {
             $this->error($nom, implode(" ",$trouve[0]));
             exit ();
          }
        case '0-9extend':
          if (preg_match_all("/([^0-9_\-\+\-\*\/\)\]\(\[\& ])/i", $valeur,$trouve)) {
             $this->error($nom, implode(" ",$trouve[0]));
             exit ();
          }
          break;
        case '0-9number':
          if (preg_match_all("/([^0-9+-., ])/i", $valeur,$trouve)) {
             $this->error($nom, implode(" ",$trouve[0]));
             exit ();
          }
          break;

        default:
          break;
      }
  }

  /**************************************************************************************/
  function error($ibid, $car) {
    global $bgcolor1, $bgcolor2, $sform_path;
    echo "<LINK rel=\"StyleSheet\" HREF=\"".$sform_path."sform.css\" TYPE=\"text/css\">";
    echo "<table width=100% border=0 cellspacing=1 cellpadding=1 bgcolor=".$bgcolor1."><tr><td>";
    echo "<table width=100% border=0 cellspacing=1 cellpadding=2 bgcolor=".$bgcolor2.">";
    echo "<tr bgcolor=".$bgcolor1."><td>";
    echo "champ : $ibid => valeur non conforme : $car<br><br>";
    echo " <a href=\"javascript:history.go(-1)\">Retour</a>";
    echo "</td></tr></table>";
    echo "</td></tr></table>";
  }

  /**************************************************************************************/
  // Mysql Interface
  // If the first char of $mess_ok is : ! => the button is hidden
  function sform_browse_mysql($pas,$mess_passwd,$mess_ok,$presentation='') {
     global $bgcolor1, $bgcolor2, $sform_path;
     $result=mysql_query("select key_value, passwd from sform where id_form='".$this->form_title."' and id_key='".$this->form_key."' ORDER BY key_value ASC");
     echo "<LINK rel=\"StyleSheet\" HREF=\"".$sform_path."sform.css\" TYPE=\"text/css\">";
     echo "<form action='".$this->url."' method=post name='browse' enctype='multipart/form-data'>";
     echo "<table width=100% border=0 cellspacing=1 cellpadding=1 bgcolor=".$bgcolor1."><tr><td>";
     echo "<table width=100% border=0 cellspacing=1 cellpadding=1 bgcolor=".$bgcolor2.">";
     $hidden=false;
     if (substr($mess_ok,0,1)=="!") {
        $mess_ok=substr($mess_ok,1);
        $hidden=true;
     }
     $ibid=0;
     while (list($key_value, $passwd) = mysql_fetch_array($result)) {
        if ($ibid==0) {
           echo "<tr bgcolor=".$bgcolor1.">";
        }
        $ibid++;
        if ($passwd!="") {$red="<font color=red>$key_value (v)</font>";}else{$red="$key_value";}
        if ($presentation=="liste") {
           echo "<td><a href=\"".$this->url."&".$this->submit_value."=$mess_ok&browse_key=".urlencode($key_value)."\">$key_value</a></td>";
        } else {
           echo "<td><input type=radio name=browse_key value=".urlencode($key_value)."> $red</td>";
        }
        if ($ibid>=$pas) {
           echo "</tr>";
           $ibid=0;
        }
     }
     echo "</table><br>";
     if ($this->form_password_access!="") {
        echo "$mess_passwd : <input type=password name=password value=''> - ";
     }
     if (!$hidden) {
        echo "<input type=submit name=\"".$this->submit_value."\" value=\"$mess_ok\">";
     }
     echo "</td></tr></table></form>";
  }

  /**************************************************************************************/
  function sform_read_mysql($clef) {
     if ($clef!="") {
        $clef=urldecode($clef);
        $result=mysql_query("select content from sform where id_form='".$this->form_title."' and id_key='".$this->form_key."' and key_value='$clef' and passwd='".$this->form_password_access."' ORDER BY key_value ASC");
        $tmp = mysql_fetch_array($result);
        if ($tmp) {
           $ibid=explode("\n",$tmp['content']);
           while (list($num,$line)=each($ibid)) {
              $op=$this->read_load_sform_data($line,$op);
           }
           return(true);
        } else {
           return(false);
        }
     }
  }

  /**************************************************************************************/
  function sform_insert_mysql($response) {
     $content=$this->write_sform_data($response);
     $sql = "INSERT INTO sform (id_form, id_key, key_value, passwd, content) ";
     $sql .= "VALUES ('".$this->form_title."', '".$this->form_key."', '".$this->form_key_value."', '".$this->form_password_access."', '$content')";
     if(!$result = mysql_query($sql)) {
       return ("Error Sform : Insert DB");
     }
  }

  /**************************************************************************************/
  function sform_delete_mysql() {
     $sql = "DELETE FROM sform WHERE id_form='".$this->form_title."' and id_key='".$this->form_key."' and key_value='".$this->form_key_value."'";
     if(!$result = mysql_query($sql)) {
       return ("Error Sform : Delete DB");
     }
  }

  /**************************************************************************************/
  function sform_modify_mysql($response) {
     $content=$this->write_sform_data($response);
     $sql = "UPDATE sform SET passwd='".$this->form_password_access."', content='$content' WHERE (id_form='".$this->form_title."' and id_key='".$this->form_key."' and key_value='".$this->form_key_value."')";
     if(!$result = mysql_query($sql)) {
       return ("Error Sform : Update DB");
     }
  }

}
?>