<?
/************************************************************************/
/* NPDS : Nuke Permanent Double-Side Web Portal System                  */
/* ===========================                                          */
/*                                                                      */
/* Original Copyright (c) 2001 by Francisco Burzi (fburzi@ncc.org.ve)   */
/* http://phpnuke.org                                                   */
/*                                                                      */
/* This version name NPDS Copyright (c) 2001 by Philippe Brunier        */
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/
/************************************************************************/
/* PHP-Nuke: User Journal System Add-On                                 */
/* ========================================                             */
/*                                                                      */
/* Brought to you by Chris "Surge" Kacerguis (surge@mindstorm.org)      */
/* http://www.mindstorm.org                                             */
/*                                                                      */
/************************************************************************/

if(!isset($mainfile)) { include("mainfile.php"); }
global $pdst; $pdst="1";

function nav() {
    global $site_font;
    OpenTable();
    // International version by P. Brunier
    echo "<font size=2 face=$site_font><b><center>
        [<a href=\"user.php?op=edituser\">".translate("Edit User")."</a>]&nbsp;
        [<a href=\"user.php?op=editjournal\">".translate("Edit Journal")."</a>]&nbsp;
        [<a href=\"user.php?op=edithome\">".translate("Change the home")."</a>]<br>
        [<a href=\"user.php?op=editcomm\">".translate("Comments")."</a>]&nbsp;
        [<a href=\"user.php?op=chgtheme\">".translate("Change Theme")."</a>]&nbsp;
        [<a href=\"user.php?op=logout\">".translate("Logout")."</a>]&nbsp;
        </center></b></font>\n";
        CloseTable();
    echo "<br><br>\n\n";
}

function userCheck($uname, $email) {
        global $stop;
        if ((!$email) || ($email=="") || (!eregi("^[_\.0-9a-z-]+@([0-9a-z][0-9a-z-]+\.)+[a-z]{2,4}$",$email))) $stop = "<center>".translate("ERROR: Invalid email")."</center><br>";
        if (strrpos($email,' ') > 0) $stop = "<center>".translate("ERROR: Email addresses do not contain spaces.")."</center>";
        if ((!$uname) || ($uname=="") || (ereg("[^a-zA-Z0-9_-]",$uname))) $stop = "<center>".translate("ERROR: Invalid Nickname")."</center><br>";
        if (strlen($uname) > 25) $stop = "<center>".translate("Nickname is too long. It must be less than 25 characters.")."</center>";
        if (eregi("^((root)|(adm)|(linux)|(webmaster)|(admin)|(god)|(administrator)|(administrador)|(nobody)|(anonymous)|(anonimo)|(annimo)|(operator)|(dune)|(netadm))$",$uname)) $stop = "<center>".translate("ERROR: Name is reserved.")."";
        if (strrpos($uname,' ') > 0) $stop = "<center>".translate("There cannot be any spaces in the Nickname.")."</center>";
        if (mysql_num_rows(mysql_query("select uname from users where uname='$uname'")) > 0) {
           $stop = "<center>".translate("ERROR: Nickname taken")."</center><br>";
        }
        if (mysql_num_rows(mysql_query("select email from users where email='$email'")) > 0) {
           $stop = "<center>".translate("ERROR: Email address already registered")."</center><br>";
        }
        return($stop);
}

function makePass() {
        $makepass="";
        $syllables="er,in,tia,dun,fe,pre,vet,jo,nes,al,len,son,cha,ir,ler,bo,ok,tio,nar,sim,ple,bla,ten,toe,cho,co,lat,spe,ak,er,po,co,lor,pen,cil,li,ght,wh,at,the,he,ck,is,mam,bo,no,fi,ve,any,way,pol,iti,cs,ra,dio,sou,rce,sea,rch,pa,per,com,bo,sp,eak,st,fi,rst,gr,oup,boy,ea,gle,tr,ail,bi,ble,brb,pri,dee,kay,en,be,se";
        $syllable_array=explode(",", $syllables);
        srand((double)microtime()*1000000);
        for ($count=1;$count<=4;$count++) {
                if (rand()%10 == 1) {
                        $makepass .= sprintf("%0.0f",(rand()%50)+1);
                } else {
                        $makepass .= sprintf("%s",$syllable_array[rand()%62]);
                }
        }
        return($makepass);
}

function confirmNewUser($uname, $name, $email, $url, $user_avatar, $user_icq, $user_occ, $user_from, $user_intrest, $user_sig, $user_viewemail, $user_aim, $user_yim, $user_msnm, $pass, $vpass) {
        global $stop, $EditedMessage, $smilies, $short_user, $minpass, $memberpass;
        include("header.php");
        filter_text($uname);
        $uname = $EditedMessage;
        if($user_viewemail == 1) {
           $user_viewemail = "1";
        }
        else {
           $user_viewemail = "0";
        }
        userCheck($uname, $email);
        if ($memberpass) {
           if ((isset($pass)) and ("$pass" != "$vpass")) {
              $stop="<center>".translate("Both passwords are different. They need to be identical.")."</center>";
           } elseif (strlen($pass) < $minpass) {
              $stop="<center>".translate("Sorry, your password must be at least")." <b>$minpass</b> ".translate("characters long")."</center>";
           }
        }
        if (!$stop) {
           OpenTable();
           echo translate("User ID")." : $uname<br><br>";
           echo ". ".translate("Real Name")." : ".removeHack($name)."<br>";
           echo ". Email : $email<br>";
           if ($smilies) {
              if (($user_avatar) || ($user_avatar!="")) echo translate("Avatar").": <img src=images/forum/avatar/$user_avatar hspace=2 vspace=2 align=\"absMiddle\"><br>";
           }
           if ($url=="http://") {$url="";}
           if (($url) || ($url!="")) echo translate("Website: ").removeHack($url)."<br>";
           if ($short_user=="yes") {
              if (($user_icq) || ($user_icq!="")) echo translate("Your ICQ: ").stripslashes(removeHack($user_icq))."<br>";
              if (($user_aim) || ($user_aim!="")) echo translate("Your AIM: ").stripslashes(removeHack($user_aim))."<br>";
              if (($user_yim) || ($user_yim!="")) echo translate("Your YIM: ").stripslashes(removeHack($user_yim))."<br>";
              if (($user_msnm) || ($user_msnm!="")) echo translate("Your MSNM: ").stripslashes(removeHack($user_msnm))."<br>";
           }
           if (($user_from) || ($user_from!="")) {
              echo translate("Location: ").stripslashes(removeHack($user_from))."<br>";
           }
           if (($user_occ) || ($user_occ!="")) {
              echo translate("Occupation: ").stripslashes(removeHack($user_occ))."<br>";
           }
           if (($user_intrest) || ($user_intrest!="")) {
              echo translate("Interest: ").stripslashes(removeHack($user_intrest))."<br>";
           }
           if (($user_sig) || ($user_sig!="")) {
              echo translate("Signature")." : ".stripslashes(removeHack($user_sig))."<br>";
           }
           echo "
              <form action=user.php method=post>
              <input type=hidden name=uname value=\"$uname\">
              <input type=hidden name=name value=\"".removeHack($name)."\">
              <input type=hidden name=email value=\"$email\">
              <input type=hidden name=user_avatar value=\"$user_avatar\">
              <input type=hidden name=user_icq value=\"".removeHack($user_icq)."\">
              <input type=hidden name=url value=\"".removeHack($url)."\">
              <input type=hidden name=user_from value=\"".removeHack($user_from)."\">
              <input type=hidden name=user_occ value=\"".removeHack($user_occ)."\">
              <input type=hidden name=user_intrest value=\"".removeHack($user_intrest)."\">
              <input type=hidden name=user_sig value=\"".removeHack($user_sig)."\">
              <input type=hidden name=user_aim value=\"".removeHack($user_aim)."\">
              <input type=hidden name=user_yim value=\"".removeHack($user_yim)."\">
              <input type=hidden name=user_msnm value=\"".removeHack($user_msnm)."\">
              <input type=hidden name=user_viewemail value=\"$user_viewemail\">
              <input type=hidden name=pass value=\"".removeHack($pass)."\">";
           echo "<br><br><input type=hidden name=op value=finish><input type=submit value=\"".translate("Finish")."\"></form>";
           CloseTable();
        } else {
           echo "$stop";
        }
        include("footer.php");
}

function finishNewUser($uname, $name, $email, $url, $user_avatar, $user_icq, $user_occ, $user_from, $user_intrest, $user_sig, $user_viewemail, $user_aim, $user_yim, $user_msnm, $pass) {
        global $stop, $makepass, $EditedMessage, $system, $adminmail, $sitename, $AutoRegUser, $memberpass;
        global $pdst;
        $pdst="1";
        include("header.php");
        userCheck($uname, $email);
        $user_regdate = date("M d, Y");
        if (!isset($stop)) {
           if (!$memberpass) {
              $makepass=makepass();
           } else {
              $makepass=$pass;
           }

           if(!$system)
              $cryptpass=crypt($makepass,$cryptpass);
           else
              $cryptpass=$makepass;

           $result = mysql_query("insert into users values (NULL,'$name','$uname','$email','','$url','$user_avatar','$user_regdate','$user_icq','$user_occ','$user_from','$user_intrest','$user_sig','$user_viewemail','','$user_aim','$user_yim','$user_msnm','','$cryptpass',10,'',0,0,0,'',0,'','','$commentlimit','0')");
           if ($user_viewemail) {
              $attach = 1;
           } else {
              $attach = 0;
           }
           // P.BR for auto-reg-user or not
           if (($AutoRegUser==1) or (!isset($AutoRegUser))) {
              $result = mysql_query("insert into users_status values (NULL,'0','$attach','0','1','1','')");
           } else {
              $result = mysql_query("insert into users_status values (NULL,'0','$attach','0','1','0','')");
           }

           if(!$result) {
              echo mysql_errno(). ": ".mysql_error(). "<br>";
           } else {
              $message = "".translate("Welcome to")." $sitename !\n\n".translate("You or someone else has used your email account")." ($email) ".translate("to register an account at")." $sitename. ".translate("The following is the member information:")."\n\n".translate("-Nickname: ")." $uname\n".translate("-Password: ")." $makepass\n\n";
              include ("signat.php");
              $subject="".translate("User Password for")." $uname";
              if ($system == 1) {
                 echo translate("Your Password is: ")."<b>$makepass</b><br><br>";
                 echo translate("You can change it after you login at")." : <a href=\"user.php?op=login&uname=$uname&pass=$makepass\">$sitename</a>";
              } else {
                 send_email($email, $subject, $message, "", true, "text");
                 OpenTable();
                 echo translate("You are now registered. You should receive your password at the email account you provided.")."";
                 CloseTable();
              }
           }
        } else {
           echo "$stop";
        }
        include("footer.php");
}

function userinfo($uname, $bypass=0) {
        global $user, $cookie, $sitename, $smilies, $short_user, $site_font;

        $uname=removeHack($uname);
        $result = mysql_query("SELECT femail, url, bio, user_avatar, user_icq, user_aim, user_yim, user_msnm, user_from, user_occ, user_intrest, user_sig, user_journal FROM users WHERE uname='$uname'");
        $userinfo = mysql_fetch_array($result);
        if (!$bypass) cookiedecode($user);
        include("header.php");
        OpenTable();
        echo "<center>";
        if(($uname == $cookie[1]) || ($bypass==1)) {
           echo "<font size=3 face=$site_font><b><center>$uname, ".translate("Welcome to")." $sitename</b><br><br>";
           echo translate("This is your personal page")."</font><br><br>";
           nav();
        }
        echo "<font size=2 face=$site_font>";
        if (($userinfo[url]!="") or ($userinfo[femail]!="") or ($userinfo[bio]!="") or ($userinfo[user_avatar]!="") or ($userinfo[user_icq]!="" or $userinfo[user_aim]!="" or $userinfo[user_yim]!="" or $userinfo[user_msnm]!="") or ($userinfo[user_from]!="") or ($userinfo[user_occ]!="") or ($userinfo[user_intrest]!="") or ($userinfo[user_sig]!="")) {
                opentable();
                if ($smilies) {
                   if ($userinfo[user_avatar]) echo "<img src=\"images/forum/avatar/$userinfo[user_avatar]\"><br>\n";
                }
                if ($userinfo[url]) { echo "<b>".translate("My HomePage:")."</b> <a href=\"$userinfo[url]\">".removeHack($userinfo[url])."</a><br>\n"; }
                if ($userinfo[femail]) { echo "<b>".translate("My E-Mail:")."</b> <a href=\"mailto:$userinfo[femail]\">".removeHack($userinfo[femail])."</a><br>\n"; }
                if ($short_user=="yes") {
                   if ($userinfo[user_icq]) echo "<b>".translate("Your ICQ: ")."</b> ".stripslashes(removeHack($userinfo[user_icq]))."<br>\n";
                   if ($userinfo[user_aim]) echo "<b>".translate("Your AIM: ")."</b> ".stripslashes(removeHack($userinfo[user_aim]))."<br>\n";
                   if ($userinfo[user_yim]) echo "<b>".translate("Your YIM: ")."</b> ".stripslashes(removeHack($userinfo[user_yim]))."<br>\n";
                   if ($userinfo[user_msnm]) echo "<b>".translate("Your MSNM: ")."</b> ".stripslashes(removeHack($userinfo[user_msnm]))."<br>\n";
                }
                if ($userinfo[user_from]) echo "<b>".translate("Location: ")."</b> ".stripslashes(removeHack($userinfo[user_from]))."<br>\n";
                if ($userinfo[user_occ]) echo "<b>".translate("Occupation: ")."</b> ".stripslashes(removeHack($userinfo[user_occ]))."<br>\n";
                if ($userinfo[user_intrest]) echo "<b>".translate("Interest: ")."</b> ".stripslashes(removeHack($userinfo[user_intrest]))."<br>\n";
                $userinfo[user_sig] = nl2br($userinfo[user_sig]);
                if ($userinfo[user_sig]) echo "<br><b>".translate("Signature: ")." </b><br>".stripslashes(removeHack($userinfo[user_sig]))."<br>\n";
                if ($userinfo[bio]) { echo "<br><b>".translate("Extra Info:")." </b>".stripslashes(removeHack($userinfo[bio]))."<br>\n"; }
                closetable();
        } else {
           echo "<center>".translate("There is no available info for")." $uname</center>";
        }

        CloseTable();
        echo "<br><br>";
        OpenTable();
        echo "<b>".translate("Online journal for")."$uname :</b><br>";
        echo removeHack($userinfo[user_journal]);
        echo "</font>";
        echo "<font size=1 face=$site_font>";
        CloseTable();
        echo "<br><br>";

        OpenTable();
        echo "<b>".translate("Last 10 comments by")." $uname :</b><br>";
        $result = mysql_query("select c.tid, c.sid, c.subject, s.ihome from comments c, stories s where c.sid=s.sid and name='$uname' order by tid DESC limit 0,10");
        while(list($tid, $sid, $subject, $ihome) = mysql_fetch_row($result)) {
            if (ctrl_aff($ihome)) {
               echo "<li><a href=article.php?thold=-1&mode=flat&order=0&sid=$sid#$tid>$subject</a><br>";
            }
        }
        CloseTable();
        echo "<br><br>";
        OpenTable();
        echo "<b>".translate("Last 10 news submissions sent by")." $uname :</b><br>";

        $xtab=news_aff("index", "where informant='$uname'", 10, "");
        $story_limit=0;
        while (($story_limit<10) and ($story_limit<sizeof($xtab))) {
           list($sid, $catid, $aid, $title) = $xtab[$story_limit];
           $story_limit++;
            echo "<li><a href=article.php?sid=$sid>$title</a><br>";
        }
        CloseTable();
        echo "</font>";
        include("footer.php");
}

function main($user) {
        global $stop, $smilies;
        if (!isset($user)) {
                include("header.php");
                if ($stop==99) {
                   echo "<center><blink><marquee><h3>".translate("User not yet allowed by Administrator")."</h3></marquee></blink></center>";
                } elseif ($stop)  {
                   echo "<center><blink><marquee><h3>".translate("Incorrect Login!")."</h3></marquee></blink></center>";
                }
                if (!$user) {
                   OpenTable();
                   echo "<form action=user.php method=post>";
                   echo "<b>".translate("User Login")."</b><br><br>";
                   echo translate("Nickname: ")."<input type=text name=uname size=26 maxlength=25><br>";
                   echo translate("Password: ")."<input type=password name=pass size=21 maxlength=20><br>";
                   echo "<input type=hidden name=op value=login>";
                   echo "<input type=submit value=\"".translate("Submit")."\">";
                   echo "</td></tr></table>";
                   echo "<center><font size=2><b><a href=user.php?op=only_newuser>".translate("New User")."</a> - <a href=user.php?op=forgetpassword>".translate("Lost your Password?")."</a></b></center>";
                   echo "</td></tr></table></form><br>";
                }
                include("footer.php");
        } elseif (isset($user)) {
                global $cookie;
                cookiedecode($user);
                userinfo($cookie[1]);
        }
}

function Only_NewUser() {
        global $smilies, $short_user, $memberpass;
        include("header.php");
                OpenTable();
                ?>
                <form name="Register" action="user.php" method="post">
                <b><? echo translate("New User:"); ?></b>
                <table cellpadding=0 cellspacing border=0>
                <tr><td><font size=1 color=red><? echo "* ".translate("(required)"); ?></font></td></tr>
                <tr><td><? echo translate("Nickname: "); ?> <font color=red>*</font></td><td><input class=textbox type="text" name="uname" size=26 maxlength=25></td></tr>
                <tr><td><? echo translate("Real Name"); ?> :</td><td><input class=textbox type="text" name="name" size=26 maxlength=60></td></tr>
                <tr><td><? echo translate("E-Mail: "); ?> <font color=red>*</font></td><td><input class=textbox type="text" name="email" size=26 maxlength=60></td></tr>
                <tr><td><? echo translate("Website: "); ?></td><td><input class=textbox type="text" name="url" size=26 maxlength=255 value='http://'></td></tr>
                <?
                if ($smilies) {
                   echo "
                   <tr valign=top><td>".translate("Avatar: ")."<br>[ <a href=user.php?op=avatarlist>".translate("List")."</a> ]</td><td>
                   <select name=\"user_avatar\" onChange=\"showimage()\">";
                   $direktori = "images/forum/avatar";
                   $handle=opendir($direktori);
                   while ($file = readdir($handle)) {
                      $filelist[] = $file;
                   }
                   asort($filelist);
                   while (list ($key, $file) = each ($filelist)) {
                      ereg(".gif|.jpg",$file);
                      if ($file == "." || $file == ".." || $file == "index.html") {
                         $a=1;
                      } else {
                         echo "<option value=$file>$file</option>";
                      }
                   }
                }
                ?>
                </select>&nbsp;&nbsp;<img src="images/forum/avatar/blank.gif" name="avatar" width="32" height="32">
                </td></tr>
                <?
                if ($short_user=="yes") {?>
                   <tr><td><? echo translate("Your ICQ: "); ?></td><td><input class=textbox type="text" name="user_icq" size=20 maxlength=20></td></tr>
                   <tr><td><? echo translate("Your AIM: "); ?></td><td><input class=textbox type="text" name="user_aim" size=20 maxlength=20></td></tr>
                   <tr><td><? echo translate("Your YIM: "); ?></td><td><input class=textbox type="text" name="user_yim" size=20 maxlength=20></td></tr>
                   <tr><td><? echo translate("Your MSNM: "); ?></td><td><input class=textbox type="text" name="user_msnm" size=20 maxlength=20></td></tr>
                <? } ?>
                <tr><td><? echo translate("Location: "); ?></td><td><input class=textbox type="text" name="user_from" size=25 maxlength=60></td></tr>
                <tr><td><? echo translate("Occupation: "); ?></td><td><input class=textbox type="text" name="user_occ" size=25 maxlength=60></td></tr>
                <tr><td><? echo translate("Interest: "); ?></td><td><input class=textbox type="text" name="user_intrest" size=25 maxlength=255></td></tr>
                <tr><td><? echo translate("Option: "); ?></td><td><INPUT TYPE="CHECKBOX" NAME="user_viewemail" VALUE="1"> <? echo translate("Allow other users to view my email address"); ?></td></tr>
                <tr><td><? echo translate("Signature: "); ?></td><td><font size=2><TEXTAREA class=textbox NAME="user_sig" ROWS=6 COLS=30></TEXTAREA></font></td></tr>
                <?
                if ($memberpass) {
                   echo "<tr><td>";
                   echo "<b>".translate("Password")."</b> ".translate("(type a new password twice to change it)")."</td><td>";
                   echo "<input class=textbox type=\"password\" name=\"pass\" size=10 maxlength=20> <input class=textbox type=\"password\" name=\"vpass\" size=10 maxlength=20>";
                   echo "</td></tr>";
                } ?>
                <input type=hidden name=op value="new user">
                <tr><td></td><td><input type="submit" value="<? echo translate("New User"); ?>"></td></tr>
                </form>
                </table>
                <center><font color=red size=2><? echo translate("(Password will be sent to the email address you enter.)"); ?></font></center><br>
                <font size=2><? echo translate("Notice: Account preferences are cookie based."); ?><br><br>
                <b><? echo translate("As a registered user you can:"); ?></b><br>
                <li> <? echo translate("Post comments with your name"); ?>
                <li> <? echo translate("Send news with your name"); ?>
                <li> <? echo translate("Have a personal box in the Home"); ?>
                <li> <? echo translate("Select how many news you want in the Home"); ?>
                <li> <? echo translate("Customize the comments"); ?>
                <li> <? echo translate("Select different themes"); ?>
                <li> <? echo translate("some other cool stuff..."); ?><br>
                <br><center><? echo translate("We don't sell/give to others your personal info."); ?></center>
                </td></tr></table></td></tr></table>
                <br><br>
                <?
                include("footer.php");
}

function ForgetPassword() {
   include("header.php");
   OpenTable();
   echo "<b>".translate("Lost your Password?")."</b><br><br>";
   echo "<font size=2>";
   echo translate("No problem. Just type your Nickname and click on send button.")."<br>";
   echo translate("Confirmation Info")."<br>";
   echo "<form action=\"user.php\" method=post>";
   echo translate("Nickname: ")."<input class=textbox type=text name=uname size=26 maxlength=25><br>";
   echo translate("Confirmation Code: ")."<input class=textbox type=text name=code size=5 maxlength=6><br>";
   echo "<input type=hidden name=op value=mailpasswd>";
   echo "<input type=submit value=".translate("Send Password").">";
   echo "</td></tr></table></td></tr></table></form>";
   include("footer.php");
}

function logout() {
    global $user;
    $userX = base64_decode($user);
    $cookie = explode(":", $userX);
    if ($cookie[1]!="") {
       mysql_query("DELETE FROM session WHERE username='$cookie[1]'");
    }
    setcookie("user","",0);
    unset($user);
    Header("Location: index.php?");
}

function mail_password($uname, $code) {
    global $sitename, $system, $adminmail, $nuke_url;
    $result = mysql_query("select email, pass from users where (uname='$uname')");
    if (!$result) {
       echo "<center>".translate("Sorry, no corresponding user info was found")."</center>";
    } else {
       $host_name = getenv("REMOTE_ADDR");
       list($email, $pass) = mysql_fetch_row($result);

       $areyou = substr($pass, 0, 5);
       if ($areyou==$code) {
          $newpass=makepass();
          $message  = "".translate("The user account")." '$uname' ".translate("at")." $sitename ".translate("has this email associated with it.")."\n";
          $message .= translate("A web user from")." $host_name ".translate("has just requested that password be sent.")."\n\n";
          $message .= translate("Your New Password is:")." $newpass\n\n".translate("You can change it after you login at")." $nuke_url/user.php\n".translate("If you didn't ask for this, don't worry. You are seeing this message, not 'them'. If this was an error just login with your new password.")."\n";
          include("signat.php");
          $subject="".translate("User Password for")." $uname";
          send_email($email, $subject, $message, "", true, "text");

          // Next step: add the new password to the database
          if (!$system) {
             $cryptpass=crypt($newpass,$cryptpass);
          } else {
             $cryptpass=$newpass;
          }
          $query="update users set pass='$cryptpass' where uname='$uname'";
          if (!mysql_query($query)) {
             echo translate("mail_password: could not update user entry. Contact the Administrator");
          }

          global $pdst;
          $pdst="1";
          include ("header.php");
          opentable();
          echo "<center>".translate("Password for")." $uname ".translate("mailed.")."";
          closetable();
          include ("footer.php");

       // If no Code, send it
       } else {
          $result = mysql_query("select email, pass from users where (uname='$uname')");
          if (!$result) {
             echo "<center>".translate("Sorry, no corresponding user info was found")."</center>";
          } else {
             $host_name = getenv("REMOTE_ADDR");
             list($email, $pass) = mysql_fetch_row($result);
             $areyou = substr($pass, 0, 5);

             $message = "".translate("The user account")." '$uname' ".translate("at")." $sitename ".translate("has this email associated with it.")."\n";
             $message .= translate("A web user from")." $host_name ".translate("has just requested a Confirmation Code to change the password.")."\n\n".translate("Your Confirmation Code is:")." $areyou \n\n".translate("With this code you can now assign a new password at")." $nuke_url/user.php\n".translate("If you didn't ask for this, don't worry. Just delete this Email.")."\n";
             include("signat.php");

             $subject="".translate("Confirmation Code for")." $uname";
             send_email($email, $subject, $message, "", true, "text");

             include ("header.php");
             opentable();
             echo "<center>".translate("Confirmation Code for")." $uname ".translate("mailed.")."";
             closetable();
             include ("footer.php");
          }
       }
    }
}

function docookie($setuid, $setuname, $setpass, $setstorynum, $setumode, $setuorder, $setthold, $setnoscore, $setublockon, $settheme, $setcommentmax) {
    $info = base64_encode("$setuid:$setuname:".md5($setpass).":$setstorynum:$setumode:$setuorder:$setthold:$setnoscore:$setublockon:$settheme:$setcommentmax");
    global $user_cook_duration;
    if ($user_cook_duration<=0) {$user_cook_duration=1;}
    $timeX=time()+(3600*$user_cook_duration);
    setcookie("user","$info",$timeX);
}

function login($uname, $pass) {
    global $setinfo, $system;

    $result = mysql_query("select pass, uid, uname, storynum, umode, uorder, thold, noscore, ublockon, theme, commentmax from users where uname='$uname'");
    if (mysql_num_rows($result)==1) {
       $setinfo = mysql_fetch_array($result);
       $result = mysql_query("select open from users_status where uid='$setinfo[uid]'");
       list($open_user) = mysql_fetch_row($result);
       if ($open_user==0) {
          Header("Location: user.php?stop=99");
          return;
       }
       $dbpass=$setinfo[pass];
       if (!$system) {
          $passwd=crypt($pass,$dbpass);
       } else {
          $passwd=$pass;
       }
       if (strcmp($dbpass,$passwd)==0) {
          docookie($setinfo[uid], $setinfo[uname], $passwd, $setinfo[storynum], $setinfo[umode], $setinfo[uorder], $setinfo[thold], $setinfo[noscore], $setinfo[ublockon], $setinfo[theme], $setinfo[commentmax]);
       } else {
          Header("Location: user.php?stop=1");
          return;
       }

       $ip = getenv("REMOTE_ADDR");
       $result = mysql_query("SELECT * from session WHERE host_addr='$ip' and guest='1'");
       if ($row = mysql_fetch_array($result)) {
          mysql_query("DELETE FROM session WHERE host_addr='$ip' and guest='1'");
       }

       Header("Location: index.php?");
    } else {
       Header("Location: user.php?stop=1");
    }
}

function infoCheck($uid, $email, $url) {
    global $stop;
    if ((!$email) || ($email=="") || (!ereg("[@]",$email)) || (!ereg("[.]",$email)) || (strlen($email) < 7) || (ereg("[^a-zA-Z0-9@.]",$email))) { $stop = "Invalid email<br>"; }
    if (($url) && ($url!="http://") && ((!ereg("[http://]",$url)) || (!ereg("[.]",$url)) || (strlen($url) < 12) || (ereg("[^a-zA-Z0-9~.:/]",$url)))) { $stop = "Invalid URL<br>"; }
    list($test) = mysql_fetch_row(mysql_query("select email from users where (email='$email' and uid!=$uid)"));
    if ("$test"=="$email") $stop = "<center>".translate("ERROR: Email address already registered")."</center><br>";
    return($stop);
}

function edituser() {
        global $user, $userinfo, $cookie, $smilies, $short_user;
        include("header.php");
        getusrinfo($user);
        nav();
        OpenTable();
        ?>
        <table cellpadding=8 border=0><tr><td>
        <form name="Register" action="user.php" method="post">
        <b><? echo translate("Real Name"); ?></b> <? echo translate("(optional)"); ?><br>
        <input class=textbox type="text" name="name" value="<? echo"$userinfo[name]"; ?>" size=30 maxlength=60><br>
        <b><? echo translate("Real Email"); ?></b> <? echo translate("(required)"); ?><br>
        <? echo translate("(This Email will not be public but is required, will be used to send your password if you lost it)"); ?><br>
        <input class=textbox type="text" name="email" value="<? echo"$userinfo[email]"; ?>" size=30 maxlength=60><br>
        <b><? echo translate("Fake Email"); ?></b> <? echo translate("(optional)"); ?><br>
        <? echo translate("(This Email will be public. Just type what you want, Spam proof)"); ?><br>
        <input class=textbox type="text" name="femail" value="<? echo"$userinfo[femail]"; ?>" size=30 maxlength=60><br>
        <b><? echo translate("Your HomePage"); ?></b> <? echo translate("(optional)"); ?><br>
        <input class=textbox type="text" name="url" value="<? echo"$userinfo[url]"; ?>" size=30 maxlength=100><br>
        <?
        if ($smilies) {
           echo "
           <b>".translate("Your Avatar")."</b> ".translate("(optional)")." [ <a href=user.php?op=avatarlist>".translate("List")."</a> ]<br>
           <select name=\"user_avatar\" onChange=\"showimage();\">
           <OPTION value=\"$userinfo[user_avatar]\">$userinfo[user_avatar]</OPTION>";
           $direktori = "images/forum/avatar";
           $handle=opendir($direktori);
           while ($file = readdir($handle)) {
              $filelist[] = $file;
           }
           asort($filelist);
           while (list ($key, $file) = each ($filelist)) {
              ereg(".gif|.jpg",$file);
              if ($file == "." || $file == ".." || $file == "index.html") {
                 $a=1;
              } else {
                 echo "<option value=$file>$file</option>";
              }
           }
           echo "</select>&nbsp;&nbsp;<img src=\"images/forum/avatar/$userinfo[user_avatar]\" name=avatar width=32 height=32><br><br>";
        }
        ?>
        <? if ($short_user=="yes") { ?>
           <b><? echo translate("Your ICQ: "); ?></b> <? echo translate("(optional)"); ?><br>
           <input class=textbox type="text" name="user_icq" value="<? echo"$userinfo[user_icq]"; ?>" size=30 maxlength=100><br>
           <b><? echo translate("Your AIM: "); ?></b> <? echo translate("(optional)"); ?><br>
           <input class=textbox type="text" name="user_aim" value="<? echo"$userinfo[user_aim]"; ?>" size=30 maxlength=100><br>
           <b><? echo translate("Your YIM: "); ?></b> <? echo translate("(optional)"); ?><br>
           <input class=textbox type="text" name="user_yim" value="<? echo"$userinfo[user_yim]"; ?>" size=30 maxlength=100><br>
           <b><? echo translate("Your MSNM: "); ?></b> <? echo translate("(optional)"); ?><br>
           <input class=textbox type="text" name="user_msnm" value="<? echo"$userinfo[user_msnm]"; ?>" size=30 maxlength=100><br>
        <? } ?>
        <b><? echo translate("Your Location"); ?></b> <? echo translate("(optional)"); ?><br>
        <input class=textbox type="text" name="user_from" value="<? echo"$userinfo[user_from]"; ?>" size=30 maxlength=100><br>
        <b><? echo translate("Your Occupation"); ?></b> <? echo translate("(optional)"); ?><br>
        <input class=textbox type="text" name="user_occ" value="<? echo"$userinfo[user_occ]"; ?>" size=30 maxlength=100><br>
        <b><? echo translate("Your Interest"); ?></b> <? echo translate("(optional)"); ?><br>
        <input class=textbox type="text" name="user_intrest" value="<? echo"$userinfo[user_intrest]"; ?>" size=30 maxlength=100><br>
        <b><? echo translate("Signature"); ?></b> <? echo translate("(optional)"); ?><br>
        <? echo translate("(255 characters max. Type your signature with HTML coding)"); ?><br>
        <font size=2><textarea class=textbox wrap=virtual cols=38 rows=5 name=user_sig><? echo"$userinfo[user_sig]"; ?></TEXTAREA></font><br>
        <?
        $asig = mysql_query("select attachsig from users_status where uid='$userinfo[uid]'");
        list($attsig) = mysql_fetch_row($asig);
        if ($attsig == 1) {
            $sel = "checked";
        } else {
            $sel = "";
        }
        ?>
        <input type=checkbox name=attach <? echo $sel ?>> <? echo translate("Show signature"); ?>
        <br><br>
        <b><? echo translate("Extra Info"); ?></b> <? echo translate("(optional)"); ?><br>
        <? echo translate("(255 characters max. Type what others can know about yourself)"); ?><br>
        <font size=2><textarea class=textbox wrap=virtual cols=38 rows=5 name=bio><? echo"$userinfo[bio]"; ?></TEXTAREA></font>
        <br><br>
        <b><? echo translate("Password"); ?></b> <? echo translate("(type a new password twice to change it)"); ?><br>
        <input class=textbox type="password" name="pass" size=10 maxlength=20> <input class=textbox type="password" name="vpass" size=10 maxlength=20>
        <br><br>
        <input type="hidden" name="uname" value="<? echo"$userinfo[uname]"; ?>">
        <input type="hidden" name="uid" value="<? echo"$userinfo[uid]"; ?>">
        <input type="hidden" name="op" value="saveuser">
        <input type="submit" value="<? echo translate("Save Changes"); ?>">
        </form></td></tr></table>
        <?
        CloseTable();
        echo "<br><br>";
        include("footer.php");
}

function saveuser($uid, $name, $uname, $email, $femail, $url, $pass, $vpass, $bio, $user_avatar, $user_icq, $user_occ, $user_from, $user_intrest, $user_sig, $user_aim, $user_yim, $user_msnm, $attach) {
    global $user, $cookie, $userinfo, $EditedMessage, $system, $minpass;
    cookiedecode($user);
    $check = $cookie[1];
    $result = mysql_query("select uid, email from users where uname='$check'");
    list($vuid, $vemail) = mysql_fetch_row($result);
    if (($check == $uname) AND ($uid == $vuid)) {
        if ((isset($pass)) && ("$pass" != "$vpass")) {
                include ("header.php");
                opentable();
                echo "<center>".translate("Both passwords are different. They need to be identical.")."</center>";
                closetable();
                include ("footer.php");
                exit();
        } elseif (($pass != "") && (strlen($pass) < $minpass)) {
                include ("header.php");
                opentable();
                echo "<center>".translate("Sorry, your password must be at least")." <b>$minpass</b> ".translate("characters long")."</center>";
                closetable();
                include ("footer.php");
                exit();
        } else {
                global $stop;
                userCheck("bidon", $email);
                if (($stop=="") or ($stop!="" and isset($pass))) {
                   if ($bio) { filter_text($bio); $bio = $EditedMessage; $bio = FixQuotes($bio); }
                   if ($attach) {
                      $a = 1;
                   } else {
                      $a = 0;
                   }
                   if ($pass != "") {
                        cookiedecode($user);
                        mysql_query("LOCK TABLES users WRITE");
                        if (!$system)
                           $pass=crypt($pass,$pass);
                        mysql_query("update users set name='$name', email='$email', femail='".removeHack($femail)."', url='".removeHack($url)."', pass='$pass', bio='".removeHack($bio)."', user_avatar='$user_avatar', user_icq='".removeHack($user_icq)."', user_occ='".removeHack($user_occ)."', user_from='".removeHack($user_from)."', user_intrest='".removeHack($user_intrest)."', user_sig='".removeHack($user_sig)."', user_aim='".removeHack($user_aim)."', user_yim='".removeHack($user_yim)."', user_msnm='".removeHack($user_msnm)."', user_viewemail='$a' where uid='$uid'");
                        $result = mysql_query("select uid, uname, pass, storynum, umode, uorder, thold, noscore, ublockon, theme from users where uname='$uname' and pass='$pass'");
                        if(mysql_num_rows($result)==1) {
                           $userinfo = mysql_fetch_array($result);
                           docookie($userinfo[uid],$userinfo[uname],$userinfo[pass],$userinfo[storynum],$userinfo[umode],$userinfo[uorder],$userinfo[thold],$userinfo[noscore],$userinfo[ublockon],$userinfo[theme],$userinfo[commentmax]);
                           logout();
                        } else {
                           echo "<center>".translate("Something screwed up... don't you hate that?")."</center><br>";
                        }
                        mysql_query("UNLOCK TABLES");
                   } else {
                        mysql_query("update users set name='$name', email='$email', femail='".removeHack($femail)."', url='".removeHack($url)."', bio='".removeHack($bio)."', user_avatar='$user_avatar', user_icq='".removeHack($user_icq)."', user_occ='".removeHack($user_occ)."', user_from='".removeHack($user_from)."', user_intrest='".removeHack($user_intrest)."', user_sig='".removeHack($user_sig)."', user_aim='".removeHack($user_aim)."', user_yim='".removeHack($user_yim)."', user_msnm='".removeHack($user_msnm)."', user_viewemail='$a' where uid='$uid'");
                   }
                   mysql_query("update users_status set attachsig='$a' where uid='$uid'");
                }
                Header("Location: user.php?");
        }
    } else {
       Header("Location: index.php?");
    }
}

function edithome() {
        global $user, $userinfo, $Default_Theme;
        include ("header.php");
        getusrinfo($user);
        nav();
        if($userinfo[theme]=="") {
            $userinfo[theme] = "$Default_Theme";
        }
        OpenTable();
        echo "
        <form action=\"user.php\" method=\"post\">
        <b>".translate("News number in the Home")."</b> (max. 127):
        <input class=\"textbox\" type=\"text\" name=\"storynum\" size=3 maxlength=3 value=\"$userinfo[storynum]\">
        <br><br>";
        if ($userinfo[ublockon]==1) {
            $sel = "checked";
        }
        echo "
        <INPUT type=\"checkbox\" name=\"ublockon\" $sel>
        <B>".translate("Activate Personal Menu")."</B>
        <br>".translate("(Check this option and the following text will appear in the Home)")."
        <br>".translate("(You can use HTML code to put links, for example)")."<br>
        <font size=2><textarea class=\"textbox\" cols=38 rows=5 name=\"ublock\">$userinfo[ublock]</textarea></font>
        <br><br>
        <input type=\"hidden\" name=\"theme\" value=\"$userinfo[theme]\">
        <input type=\"hidden\" name=\"uname\" value=\"$userinfo[uname]\">
        <input type=\"hidden\" name=\"uid\" value=\"$userinfo[uid]\">
        <input type=\"hidden\" name=\"op\" value=\"savehome\">
        <input type=\"submit\" value=\"".translate("Save Changes!")."\">
        </form>";
        CloseTable();
        echo "<br><br>\n\n";
        include ("footer.php");
}

function chgtheme() {
        global $user, $userinfo;
        include ("header.php");
        getusrinfo($user);
        nav();
        OpenTable();
        ?>
        <center>
        <form action="user.php" method="post">
        <b><? echo translate("Select One Theme"); ?></b><br>
        <select class=textbox name=theme>
        <?
        include("themes/list.php");
        $themelist = explode(" ", $themelist);
        for ($i=0; $i < sizeof($themelist); $i++) {
                if($themelist[$i]!="") {
                        echo "<option value=\"$themelist[$i]\" ";
                        if((($userinfo[theme]=="") && ($themelist[$i]=="$Default_Theme")) || ($userinfo[theme]==$themelist[$i])) echo "selected";
                        echo ">$themelist[$i]\n";
                }
        }
        if($userinfo[theme]=="") $userinfo[theme] = "Default_Theme";
        ?>
        </select><br>
        <? echo "
        ".translate("This option will change the look for the whole site.")."<br>
        ".translate("The changes will be valid only to you.")."<br>
        ".translate("Each user can view the site with different theme.")."<br>
        "; ?>
        <br>

        <input type="hidden" name="storynum" value="<? echo"$userinfo[storynum]"; ?>">
        <input type="hidden" name="ublockon" value="<? echo"$userinfo[ublockon]"; ?>">
        <input type="hidden" name="ublock" value="<? echo"$userinfo[ublock]"; ?>">

        <input type="hidden" name="uname" value="<? echo"$userinfo[uname]"; ?>">
        <input type="hidden" name="uid" value="<? echo"$userinfo[uid]"; ?>">
        <input type="hidden" name="op" value="savetheme">
        <input type="submit" value="<? echo translate("Save Changes!"); ?>">
        </form>
        <?
        CloseTable();
        echo "<br><br>";
        include ("footer.php");
}

function savehome($uid, $uname, $theme, $storynum, $ublockon, $ublock) {
    global $user, $cookie, $userinfo;
    cookiedecode($user);
    $check = $cookie[1];
    $result = mysql_query("select uid from users where uname='$check'");
    list($vuid) = mysql_fetch_row($result);
    if (($check == $uname) AND ($uid == $vuid)) {
        if(isset($ublockon)) $ublockon=1; else $ublockon=0;
        $ublock = FixQuotes($ublock);
        mysql_query("update users set storynum='$storynum', ublockon='$ublockon', ublock='$ublock' where uid=$uid");
        getusrinfo($user);
        docookie($userinfo[uid],$userinfo[uname],$userinfo[pass],$userinfo[storynum],$userinfo[umode],$userinfo[uorder],$userinfo[thold],$userinfo[noscore],$userinfo[ublockon],$userinfo[theme],$userinfo[commentmax]);
        // Include cache manager for purge cache Page
        $cache_obj = new cacheManager();
        $cache_obj->UsercacheCleanup();
        Header("Location: user.php?");
    } else {
        Header("Location: index.php?");
    }
}

function savetheme($uid, $theme) {
    global $user, $cookie, $userinfo;
    cookiedecode($user);
    $check = $cookie[1];
    $result = mysql_query("select uid from users where uname='$check'");
    list($vuid) = mysql_fetch_row($result);
    if ($uid == $vuid) {
        mysql_query("update users set theme='$theme' where uid=$uid");
        getusrinfo($user);
        docookie($userinfo[uid],$userinfo[uname],$userinfo[pass],$userinfo[storynum],$userinfo[umode],$userinfo[uorder],$userinfo[thold],$userinfo[noscore],$userinfo[ublockon],$userinfo[theme],$userinfo[commentmax]);
        // Include cache manager for purge cache Page
        $cache_obj = new cacheManager();
        $cache_obj->UsercacheCleanup();
        Header("Location: user.php?theme=$theme");
    }
    Header("Location: index.php?");
}

function editcomm() {
        global $user, $userinfo;
        include ("header.php");
        getusrinfo($user);
        nav();
        OpenTable();
        ?>
        <table cellpadding=8 border=0><tr><td>
        <form action="user.php" method="post">
        <b><? echo translate("Display Mode"); ?></b>
        <select class=textbox name=umode>
        <option value="nocomments" <? if ($userinfo[umode] == 'nocomments') { echo "selected"; } ?>><? echo translate("No Comments"); ?>
        <option value="nested" <? if ($userinfo[umode] == 'nested') { echo "selected"; } ?>><? echo translate("Nested"); ?>
        <option value="flat" <? if ($userinfo[umode] == 'flat') { echo "selected"; } ?>><? echo translate("Flat"); ?>
        <option value="thread" <? if (!isset($userinfo[umode]) || ($userinfo[umode]=="") || $userinfo[umode]=='thread') { echo "selected"; } ?>><? echo translate("Thread"); ?>
        </select>
        <br><br>
        <b><? echo translate("Sort Order"); ?></b>
        <select class=textbox name=uorder>
        <option value="0" <? if (!$userinfo[uorder]) { echo "selected"; } ?>><? echo translate("Oldest First"); ?>
        <option value="1" <? if ($userinfo[uorder]==1) { echo "selected"; } ?>><? echo translate("Newest First"); ?>
        <option value="2" <? if ($userinfo[uorder]==2) { echo "selected"; } ?>><? echo translate("Highest Scores First"); ?>
        </select>
        <br><br>
        <b><? echo translate("Threshold"); ?></b>
        <? echo translate("Comments scored less than this setting will be ignored."); ?><br>
        <select class=textbox name=thold>
        <option value="-1" <? if ($userinfo[thold]==-1) { echo "selected"; } ?>>-1: <? echo translate("Uncut and Raw"); ?>
        <option value="0" <? if ($userinfo[thold]==0) { echo "selected"; } ?>>0: <? echo translate("Almost Everything"); ?>
        <option value="1" <? if ($userinfo[thold]==1) { echo "selected"; } ?>>1: <? echo translate("Filter Most Anon"); ?>
        <option value="2" <? if ($userinfo[thold]==2) { echo "selected"; } ?>>2: <? echo translate("Score"); ?> +2
        <option value="3" <? if ($userinfo[thold]==3) { echo "selected"; } ?>>3: <? echo translate("Score"); ?> +3
        <option value="4" <? if ($userinfo[thold]==4) { echo "selected"; } ?>>4: <? echo translate("Score"); ?> +4
        <option value="5" <? if ($userinfo[thold]==5) { echo "selected"; } ?>>5: <? echo translate("Score"); ?> +5
        </select><br>
        <? echo translate("Anonymous posts start at 0, logged in posts start at 1. Moderators add and subtract points."); ?>
        <br><br>
        <INPUT type=checkbox name=noscore <? if ($userinfo[noscore]==1) { echo "checked"; } ?>><B> <? echo translate("Do Not Display Scores"); ?></B> <? echo translate("(Hides score: They still apply, you just don't see them.)"); ?>
        <br><br>
        <b><? echo translate("Max Comment Length"); ?></b> <? echo translate("(Truncates long comments, and adds a Read More link. Set really big to disable)"); ?><br>
        <input class=textbox type="text" name="commentmax" value="<? echo $userinfo[commentmax] ?>" size=11 maxlength=11> bytes (1024 bytes = 1K)
        <br><br>
        <input type="hidden" name="uname" value="<? echo"$userinfo[uname]"; ?>">
        <input type="hidden" name="uid" value="<? echo"$userinfo[uid]"; ?>">
        <input type="hidden" name="op" value="savecomm">
        <input type="submit" value="<? echo translate("Save Changes"); ?>">
        </form></td></tr></table>
        <?
        CloseTable();
        echo "<br><br>";
        include ("footer.php");
}

function savecomm($uid, $uname, $umode, $uorder, $thold, $noscore, $commentmax) {
    global $user, $cookie, $userinfo;
    cookiedecode($user);
    $check = $cookie[1];
    $result = mysql_query("select uid from users where uname='$check'");
    list($vuid) = mysql_fetch_row($result);
    if (($check == $uname) AND ($uid == $vuid)) {
        if(isset($noscore)) $noscore=1; else $noscore=0;
        mysql_query("update users set umode='$umode', uorder='$uorder', thold='$thold', noscore='$noscore', commentmax='$commentmax' where uid=$uid");
        getusrinfo($user);
        docookie($userinfo[uid],$userinfo[uname],$userinfo[pass],$userinfo[storynum],$userinfo[umode],$userinfo[uorder],$userinfo[thold],$userinfo[noscore],$userinfo[ublockon],$userinfo[theme],$userinfo[commentmax]);
        // Include cache manager for purge cache Page
        $cache_obj = new cacheManager();
        $cache_obj->UsercacheCleanup();
        Header("Location: user.php?");
    } else {
        Header("Location: index.php?");
    }
}

function avatarlist() {
   global $smilies;
   if ($smilies) {
      global $pdst;
      $pdst="1";
      include("header.php");

      Opentable();
      $direktori = "images/forum/avatar";
      $handle=opendir($direktori);

      while ($file = readdir($handle)) $filelist[] = $file;
      asort($filelist);
      $ibid=0;
      while (list ($key, $file) = each ($filelist)) {
         ereg(".gif|.jpg",$file);
         if ($file != "." and $file != ".." and $file != "index.html") {
            echo "<img src=\"$direktori/$file\" border=\"0\" width=\"32\" height=\"32\" Alt=\"$file\" hspace=\"10\" vspace=\"10\">";
            if ($ibid>6) {
               echo "<br>";
               $ibid=0;
            } else {
               $ibid++;
            }
         }
      }
      echo "<br><br><center><b>[ <A HREF=\"javascript:history.go(-1)\">".translate("Go Back")."</a> ]</b></center>";
      CloseTable();
      include("footer.php");
   }
}

function editjournal(){
        global $user, $userinfo;
        include("header.php");
        getusrinfo($user);
        nav();
        OpenTable();
        echo "<form action=\"user.php\" method=\"post\">";
        echo "<b>".translate("Edit your journal")."</b><br>";
        echo "<font size=2><textarea class=\"textbox\" cols=40 rows=30 name=journal>$userinfo[user_journal]</textarea></font>";
        echo "<br><br>";
        echo "<input type=\"hidden\" name=\"uname\" value=$userinfo[uname]>";
        echo "<input type=\"hidden\" name=\"uid\" value=$userinfo[uid]>";
        echo "<input type=\"hidden\" name=\"op\" value=\"savejournal\">";
        echo "<input type=\"checkbox\" name=\"datetime\" value=1 checked><font size=2>".translate("Add date and time stamp")."</font><br>";
        echo "<input type=\"submit\" value=\"".translate("Save Journal")."\">";
        echo "</form>";
        CloseTable();
        include("footer.php");
}

function savejournal($uid, $journal, $datetime){
    global $user, $cookie, $userinfo;
    cookiedecode($user);
    $check = $cookie[1];
    $result = mysql_query("SELECT uid FROM users WHERE uname='$check'");
    list($vuid) = mysql_fetch_row($result);
    if ($uid == $vuid) {
       filter_text($journal);
       $journal = FixQuotes(removeHack($journal));
       if ($datetime) {
          $journalentry .= "<br><br>";
          if ($language!="english") {
             $journalentry .= date("j/m/Y - H:i");
          } else {
             $journalentry .= date("F j, Y - H:i");
          }
          $journalentry .= "<br>---------------------------------------<br>";
          $journalentry .= $journal;
          mysql_query("update users set user_journal='$journalentry' where uid=$uid");
       } else {
          mysql_query("update users set user_journal='$journal' where uid=$uid");
       }
       getusrinfo($user);
       Header("Location: user.php?");
    } else {
       Header("Location: index.php?");
    }
}

switch($op) {
    case "logout":
         logout();
         break;

    case "lost_pass":
         lost_pass();
         break;

    case "new user":
         confirmNewUser($uname, $name, $email, $url, $user_avatar, $user_icq, $user_occ, $user_from, $user_intrest, $user_sig, $user_viewemail, $user_aim, $user_yim, $user_msnm, $pass, $vpass);
         break;

    case "finish":
         finishNewUser($uname, $name, $email, $url, $user_avatar, $user_icq, $user_occ, $user_from, $user_intrest, $user_sig, $user_viewemail, $user_aim, $user_yim, $user_msnm, $pass);
         break;

    case "mailpasswd":
         mail_password($uname, $code);
         break;

    case "userinfo":
         userinfo($uname, $bypass);
         break;

    case "login":
         login($uname, $pass);
         break;

    case "dummy":
         Header("Location: user.php?");
         break;

    case "edituser":
         edituser();
         break;

    case "saveuser":
         global $user, $cookie;
         cookiedecode($user);
         global $HTTP_GET_VARS;
         if ($HTTP_GET_VARS[user]=="") {
            $past = time()-300;
            mysql_query("DELETE FROM session WHERE time < $past");
            $result = mysql_query("SELECT time FROM session WHERE username='$cookie[1]'");
            if ($row = mysql_fetch_array($result)) {
               saveuser($uid, $name, $uname, $email, $femail, $url, $pass, $vpass, $bio, $user_avatar, $user_icq, $user_occ, $user_from, $user_intrest, $user_sig, $user_aim, $user_yim, $user_msnm, $attach);
            } else {
               Header("Location: user.php?");
            }
         } else {
            Header("Location: user.php?");
         }
         break;

    case "edithome":
         edithome();
         break;

    case "chgtheme":
         chgtheme();
         break;

    case "savehome":
         savehome($uid, $uname, $theme, $storynum, $ublockon, $ublock);
         break;

    case "savetheme":
         savetheme($uid, $theme);
         break;

    case "avatarlist":
         avatarlist();
         break;

    case "editcomm":
         editcomm();
         break;

    case "savecomm":
         savecomm($uid, $uname, $umode, $uorder, $thold, $noscore, $commentmax);
         break;

    case "editjournal":
         editjournal();
         break;

    case "savejournal":
         savejournal($uid, $journal, $datetime);
         break;

    case "forgetpassword":
         ForgetPassword();
         break;

    case "only_newuser":
         global $CloseRegUser;
         if ($CloseRegUser==0) {
            Only_NewUser();
         } else {
            include("header.php");
            include("static/closed.txt");
            include("footer.php");
         }
         break;

    default:
         if (!AutoReg()) { unset($user); }
         main($user);
         break;
}
?>