<?PHP
/************************************************************************/
/* NPDS V : Net Portal Dynamic System !                                 */
/* ===========================                                          */
/*                                                                      */
/* This version name NPDS Copyright (c) 2001-2003 by Philippe Brunier   */
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/
/************************************************************************/
/*  Archivo: cache.class.php                                            */
/*  Autor: Francisco Echarte [patxi@eslomas.com]                        */
/*  Fecha: 2001-08-23  Version: 0.2                                     */
/************************************************************************/
include_once('cache.config.php');
include_once('cache.timings.php');
define ("LOCK_EX",2);
define ("LOCK_UN",3);

class cacheManager{
   var $request_uri;
   var $query_string;
   var $php_self;
   var $genereting_output;

   function cacheManager(){
      global $CACHE_CONFIG;

      $this->genereting_output = 0;
      if (!empty($_SERVER) && isset($_SERVER['REQUEST_URI'])) {
         $this->request_uri=$_SERVER['REQUEST_URI'];
      } else {
         $this->request_uri=getenv('REQUEST_URI');
      }
      if (!empty($_SERVER) && isset($_SERVER['QUERY_STRING'])) {
         $this->query_string=$_SERVER['QUERY_STRING'];
      } else {
         $this->query_string=getenv('QUERY_STRING');
      }
      if (!empty($_SERVER) && isset($_SERVER['PHP_SELF'])) {
         $this->php_self=basename($_SERVER['PHP_SELF']);
      } else {
         $this->php_self=basename($GLOBALS[PHP_SELF]);
      }
      if ($CACHE_CONFIG['run_cleanup'] == 1)
         $this->cacheCleanup();
   }

   function startCachingPage(){
      global $CACHE_TIMINGS, $CACHE_CONFIG, $CACHE_QUERYS;

      if ($CACHE_TIMINGS[$this->php_self] > 0 && ($this->query_string == '' || ereg($CACHE_QUERYS[$this->php_self], $this->query_string)) ) {
         $cached_page = $this->checkCache($this->request_uri,$CACHE_TIMINGS[$this->php_self]);
         if ($cached_page != '') {
            echo $cached_page;
            global $npds_sc;
            $npds_sc=true;
            $this->logVisit($this->request_uri, 'HIT');
            if ($CACHE_CONFIG['exit'] == 1) { exit; }
         } else {
            ob_start();
            $this->genereting_output = 1;
            $this->logVisit($this->request_uri, 'MISS');
         }
      } else {
         $this->logVisit($this->request_uri, 'EXCL');
         $this->genereting_output = -1;
      }
   }

   function endCachingPage(){
      global $CACHE_CONFIG;

      if ($this->genereting_output == 1) {
         $output = ob_get_contents();
         ob_end_clean();
         $this->insertIntoCache($output, $this->request_uri);
      }
   }

   function checkCache($request,$refresh){
      global $CACHE_CONFIG;
      global $user;
      if (isset($user)) {
         $cookie = explode(":", base64_decode($user));
      }

      $filename = $CACHE_CONFIG['data_dir'].$cookie[1].md5($request);
      if (file_exists($filename)) {
         if (filemtime($filename) > time()-$refresh) {
            $data = fread($fp = fopen($filename, 'r'), filesize($filename));
            fclose($fp);
            return($data);
         } else
            return("");
      } else {
         return("");
      }
   }

   function insertIntoCache($content, $request){
      global $CACHE_CONFIG;
      global $user;
      if (isset($user)) {
         $cookie = explode(":", base64_decode($user));
      }

      $content .= "\n<!-- CACHED : ".date('Y/m/d : H:i:s')." by NPDS-SuperCache -->\n";
      $nombre = $CACHE_CONFIG['data_dir'].$cookie[1].md5($request);
      if ($fp = fopen($nombre, 'w')) {
         flock($fp, LOCK_EX);
         fwrite($fp,$content);
         flock($fp, LOCK_UN);
         fclose($fp);
      }
      echo $content;
      global $npds_sc;
      $npds_sc=false;
   }

   function logVisit($request, $type) {
      global $CACHE_CONFIG;

      if (!$CACHE_CONFIG['save_stats']) return;
      $logfile = $CACHE_CONFIG['data_dir'].'stats.log';
      $fp = fopen($logfile, 'a');
      flock($fp, LOCK_EX);
      fseek($fp, filesize($logfile));
          $salida = sprintf("%-10s %-74s %-4s\r\n",time(),$request,$type);
          fwrite($fp, $salida);
      flock($fp, LOCK_UN);
      fclose($fp);
   }

   function cacheCleanup(){
      global $CACHE_CONFIG;

      srand((double)microtime()*1000000);
      $num = rand(1,100);
      if ($num <= $CACHE_CONFIG['cleanup_freq']) {
         $dh = opendir($CACHE_CONFIG['data_dir']);
         while ($filename = readdir($dh)) {
            if ($filename === '.' OR $filename === '..') continue;
            if (filemtime($CACHE_CONFIG['data_dir'].$filename) < time() - $CACHE_CONFIG['max_age'])
               unlink($CACHE_CONFIG['data_dir'].$filename);
         }
      }
   }

   function UsercacheCleanup(){
      global $CACHE_CONFIG;
      global $user;

      if (isset($user)) {
         $cookie = explode(":", base64_decode($user));
      }

      $dh = opendir($CACHE_CONFIG['data_dir']);
      while($filename = readdir($dh)){
         if ($filename === '.' OR $filename === '..') continue;
            // Le fichier appartient-il  l'utilisateur connect ?
            if (substr($filename,0,strlen($cookie[1]))==$cookie[1]) {
               // Le calcul md5 fournit une chaine de 32 chars donc si ce n'est pas 32 c'est que c'est un homonyme ...
               if (strlen(substr($filename,strlen($cookie[1])))==32) {
                  unlink($CACHE_CONFIG['data_dir'].$filename);
               }
            }
      }
   }

   function startCachingBlock($Xblock){
      global $CACHE_TIMINGS, $CACHE_CONFIG, $CACHE_QUERYS;
      if ($CACHE_TIMINGS[$Xblock] > 0) {
         $cached_page = $this->checkCache($Xblock,$CACHE_TIMINGS[$Xblock]);
         if ($cached_page != '') {
            echo $cached_page;
            $this->logVisit($Xblock, 'HIT');
            if ($CACHE_CONFIG['exit'] == 1) { exit; }
         } else {
            ob_start();
            $this->genereting_output = 1;
            $this->logVisit($Xblock, 'MISS');
         }
      } else {
         $this->genereting_output = -1;
         $this->logVisit($Xblock, 'NO-CACHE');
      }
   }

   function endCachingBlock($Xblock){
      global $CACHE_CONFIG;

      if ($this->genereting_output == 1) {
         $output = ob_get_contents();
         ob_end_clean();
         $this->insertIntoCache($output, $Xblock);
      }
   }
}
?>