<?PHP
/************************************************************************/
/* AUTO-DOC for NPDS V  / Net Portal Dynamic System !                   */
/*                                                                      */
/* This version name NPDS Copyright (c) 2002-2003 by Philippe Brunier   */
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/*********************************************************************************************************************************/
/* AutoDoc permet de de lire le contenu d'un fichier php et d'extraire la documentation intgre (sous forme de commentaire php) */
/* Le format d'une ligne AutoDoc de documentation doit-tre :                                                                    */
/*    #autodoc La_documentation_de_la_fonction                                                                                   */
/*    par exemple : #autodoc !date! : Date du jour en Javascript (le : entre le nom du meta-mot ou de la fonction et             */
/*                  son explication est OBLIGATOIRE)                                                                             */
/*    mais aussi #autodoc: pour faire un saut de ligne HTML dans votre documentation (<BR>)                                      */
/*                                                                                                                               */
/* Autodoc assure aussi la selection d'un ensemble cohrent dans un fichier via #autodoc:<paragraphe> ... #autodoc:</paragraphe> */
/* Le mainfile.php est un bon exemple (extraction des fonctions de type BLOCS)                                                   */
/*                                                                                                                               */
/* Meta_Lang utilise ce formalisme et vous pouvez donc extraire la documentation de meta_lang.php via :                          */
/* autodoc.php?fichier=modules/meta-lang/meta_lang.php ou via un include ("autodoc.php") en spcifiant la variable $fichier      */
/*********************************************************************************************************************************/
function autodoc($fichier, $paragraphe) {
   $fcontents = file($fichier);
   echo "<table cellspacing=\"2\" cellpadding=\"2\" BORDER=\"0\" width=\"100%\">";
   while ( list($line_num, $line)=each($fcontents) ) {
      if ($paragraphe!="") {
         if (strstr($line,"#autodoc:<$paragraphe>")) {
            $line="";
            $pasfin=true;
         }
         if (strstr($line,"#autodoc:</$paragraphe>")) {
            $line="";
            $pasfin=false;
         }
      } else {
         $pasfin=true;
      }
      if (!strstr($line,"#autodoc !votre_meta-mot!")) {
         $line=trim($line);
         if ((strstr($line,"#autodoc")) and ($pasfin)) {
            $posX=strpos($line,":");
            $morceau1=trim(substr($line,strpos($line,"#autodoc")+8,$posX-8));
            $morceau2=rtrim(substr($line,$posX+1));
            if ($morceau1=="" AND $morceau2=="") {$rowcolor="#FFFFFF";} else {$rowcolor="#F0F0F0";}
            echo "<tr bgcolor=$rowcolor><td nowrap align=left><font size=1 face=\"Tahoma,Arial\"><b>$morceau1</b></FONT>&nbsp;</td><td><font size=1 face=\"Tahoma,Arial\">$morceau2</FONT>&nbsp;</td></TR>";
         } else if ((strstr($line,"# autodoc")) and ($pasfin)) {
            $posX=strpos($line,":");
            $morceau1=ltrim(substr($line,strpos($line,"# autodoc")+9,$posX-9));
            $morceau2=rtrim(substr($line,$posX+1));
            if ($morceau1=="" AND $morceau2=="") {$rowcolor="#FFFFFF";} else {$rowcolor="#F0F0F0";}
            echo "<tr bgcolor=$rowcolor><td nowrap align=left><font size=1 face=\"Tahoma,Arial\"><b>$morceau1</b></FONT>&nbsp;</td><td><font size=1 face=\"Tahoma,Arial\">$morceau2</FONT>&nbsp;</td></TR>";
         }
      }
   }
   echo "</TABLE><P align=right><font size=1 face=\"Tahoma, Arial\">AutoDoc pour <a href=http://www.npds.org>NPDS</a></font></p>";
}

autodoc($fichier,$paragraphe);
?>