<?PHP
/************************************************************************/
/* NPDS V : Net Portal Dynamic System !                                 */
/*                                                                      */
/* Base on pda Addon by Christopher Bradford (csb@wpsf.com)             */
/*                                                                      */
/* This version name NPDS Copyright (c) 2001-2003 by Philippe Brunier   */
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/

/************************************************************************/
/* Important Infos : The use of Javascript with Mod_Gzip activate on an */
/* Apache (or other Web Server) can cause some error with older         */
/* implementation of Netscape (4.6, 4.6.1, 4.7, 4.7.5). The principal   */
/* javascript error is : "illegal caracter sent in line 1 ... 9".       */
/*                                                                      */
/* The solution : Exclude push.php of the mod_gzip configuration with   */
/* the following directive : mod_gzip_item_exclude      file \push.php$ */
/************************************************************************/

########################################################################################################
# General Push Infos Addon Options
# $push_url           : the URL from the Web site where push module is (for ex : "http://www.npds.org")
# $push_largeur       : Width of Menu block (ex : 120 pixel or "90%")
# $push_br            : After the Faq Menu put a html tag (for ex : "<br>")
# $push_largeur_suite : Width of "seconf page" block (ex : 200 pixel or "90%")
# $push_news_limit    : Number of news show
# $push_member_col    : Number of columm for member's list (1 to n)
# $push_member_limit  : Number of member show on each first page (default max=29)
# $push_titre         : Title of the block ("Npds Push Addon")
# $push_logo          : Logo (gif or jpg)
# $push_view_perpage  : Number of Web links per page (2 or more)
# $push_orderby       : ASCendind or DESCending orderby trigger for Web links ("ASC" or "DESC")
# $follow_links       : Follow <A Href ... Link in this module (True or False)
#######################################################################################################
$push_url="http://www.npds.org";
$push_largeur="100%";
$push_br="";
$push_largeur_suite="100%";
$push_news_limit=10;
$push_member_col=3;
$push_member_limit=9;
$push_titre="NPDS 5.0";
$push_logo="images/pushlogo.gif";
$push_view_perpage=6;
$push_orderby="ASC";
$follow_links=true;

// For NPDS SuperCache Config (or other SuperCache implementation)
$CACHE_TIMINGS['push.php'] = 4*3600; // default 4*3600 secondes = 4 Hours
$CACHE_QUERYS['push.php'] = "^";  // Don't modify this line !

function push_header($operation) {
   global $push_largeur, $push_largeur_suite, $push_titre, $push_logo;
   global $bgcolor5, $bgcolor2, $textcolor1, $site_font;
   if ($operation=="suite") {$push_largeur=$push_largeur_suite;}

   $temp  ="<table width=$push_largeur border=1 cellspacing=0 cellpadding=0 bordercolor=#000000>";
   $temp .="<tr><td width=100%>";
   $temp .="<table width=100% bgcolor=$bgcolor5 border=0 cellspacing=0 cellpadding=2>";
   $temp .="<tr>";
   $push_titre=str_replace("'","\'",$push_titre);
   $temp .="<td bgcolor=$bgcolor2 width=100%><FONT color=$textcolor1 size=1 face=$site_font><center><b>".htmlspecialchars($push_titre)."</b></center></FONT></TD>";
   if ($push_logo!="") {
      $temp .="</TR><tr><td width=100% background=\"$push_logo\">";
   } else {
      $temp .="</TR><tr><td width=100%>";
   }
   echo "document.write('$temp');\n";
}

function push_footer() {
   $temp="</TD></TR></TABLE></TD></TR></TABLE>";
   echo "document.write('$temp');\n";
}
?>